#! /bin/sh

debug=no

echo ""
echo "  ============ begin opengl/x11 configuration ============="
echo ""

rm -f cfg*

fatality=0

# figure out directories to compile and load with OpenGL/GLX
if test -z "$NO_XLIB"; then
  # directory list is from autoconf, except openwin promoted near top
  gllist=" \
    /usr/local/include"

  cat >cfg.c <<EOF
#include <GL/glx.h>
#include <GL/gl.h>
#ifdef TEST_IF_MESA
#ifndef MESA
#error this is not Mesa
#endif
#endif
static int attr[] = {
  GLX_RGBA, GLX_DOUBLEBUFFER, GLX_RED_SIZE, 1, GLX_GREEN_SIZE, 1,
  GLX_BLUE_SIZE, 1, None };
int main(int argc, char *argv[])
{
  Display *dpy= XOpenDisplay("nosuchserver:0.0");
  XVisualInfo *vi= glXChooseVisual(dpy, DefaultScreen(dpy), attr);
  GLXContext cx= glXCreateContext(dpy, vi, 0, GL_TRUE);
  Window win= XCreateSimpleWindow(dpy, RootWindow(dpy, vi->screen),
                                  0,0, 100,100, 4, 0, 0);
  glXMakeCurrent(dpy, win, cx);
  glClearColor(1,1,0,1);
  glClear(GL_COLOR_BUFFER_BIT);
  glFlush();
  XCloseDisplay(dpy);
  return 0;
}
EOF
  xfound=no
  glinc=$GLINC
  gllib=$GLLIB
  if $CC $CFLAGS $glinc $XINC -c cfg.c >cfg.10a 2>&1; then
    xfound=yes
  else
    for d in $gllist; do
      if test -r $d/GL/glx.h; then
        glinc=-I$d
        if $CC $CFLAGS $glinc $XINC -c cfg.c >cfg.10b 2>&1; then
	  xfound=yes
          gllib=`echo -L$d | sed s/include/lib/`
          if test $debug = no; then rm -f cfg.10a; fi
        fi
        break
      fi
    done
    if test $xfound = no; then
      echo "FATAL unable to find GL includes (opengl/x11) $glinc"
      fatality=1
    fi
  fi
  if test -z "$XINC"; then
    gincs=$glinc
  else
    gincs="$glinc $XINC"
  fi
  if test $xfound = yes; then
    if $CC $CFLAGS -DTEST_IF_MESA $gincs -c cfg.c >/dev/null 2>&1; then
      gll=-lMesaGL
    else
      gll=-lGL
    fi
    args="$CFLAGS $gincs $LDFLAGS -o cfg cfg.c $XLIB"
    xlibs="$XLIB -lX11"
    xlibm="$xlibs $MATHLIB"
    glibs="$XLIB $gll -lXext -lX11"
    if $CC $args $glibs $MATHLIB >cfg.10c 2>&1; then
      xfound=both
    elif test -n "$gllib" && $CC $args $gllib $gll $xlibm >cfg.10c 2>&1; then
      glibs="$gllib $gll $xlibs"
      xfound=both
    else
      glibs=$xlibs
      gllist=`echo $gllist | sed s/include/lib/g`
      for d in $gllist; do
	xall=`echo $d/libX11*`
        if test "$xall" != $d/'libX11*'; then
          gllib=-L$d
          if $CC $args $gllib $gll $xlibm >cfg.10d 2>&1; then
            glibs="$gllib $gll $xlibs"
	    xfound=both
            if test $debug = no; then rm -f cfg.10c; fi
          fi
          break
        fi
      done
    fi
  else
    glibs="$XLIB -lX11"
  fi
  if test $xfound = yes; then
    echo "FATAL unable to find GL libraries (opengl/x11) $gllib"
    fatality=1
  else
    echo "found OpenGL, GL headers and GL+X11 libraries"
    echo "  - using GL+X11 header switch ${gincs:-[none]}"
    echo "  - using GL+X11 loader switch ${glibs:-[none]}"
  fi
  echo "GINCS=$gincs" >>../../Make.cfg
  echo "GLIBS=$glibs" >>../../Make.cfg
fi

# clean up, issue warning if compiler gave fishy output
rm -f cfg cfg.c cfg.o
for f in cfg.[0-9]*; do
  if grep ... $f >/dev/null 2>&1; then   # or use test -s $f ?
    echo "WARNING - check compiler message in $f"
  else # remove empty files
    rm -f $f
  fi
done

echo "appended to ../../Make.cfg"
echo ""
echo "  ============= end opengl/x11 configuration =============="

exit $fatality
