/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef STextEdit_h
#define STextEdit_h

#include "swidget/SYuditInput.h"
#include "swidget/SEditor.h"
#include "swidget/STextEditLS.h"
#include "swidget/SEditorIF.h"
#include "swidget/SPanel.h"
#include "swidget/STextView.h"
#include "swidget/SBorder.h"
#include "swidget/SCaret.h"
#include "stoolkit/SString.h"
#include "stoolkit/SProperties.h"
#include "stoolkit/SEvent.h"
#include "stoolkit/SStringVector.h"
#include "stoolkit/SBinVector.h"

class SDClick : public SEventTarget
{
public:
 SDClick(void);
 ~SDClick();

  void              start (unsigned int millisec);
  unsigned int      clickCount;

protected:
  STimer*  timer;
  bool timeout (const SEventSource* s);
};

class STextEdit : public SPanel, public SEditorIF
{
public:
  STextEdit (void);
  STextEdit (const SString& utf8);
  virtual ~STextEdit ();

  void setFocus();
  bool isFocused () const;

  const SDimension& getPreferredSize();

  void addTextEditLS (STextEditLS* ls);
  void removeTextEditLS (STextEditLS* ls);
  void setEditor (const SEditor& editor);

  virtual void setBackground (const SColor& bg);
  virtual void setTextBackground (const SColor& bg);
  void setForeground (const SColor& lrfg, const SColor& rlfg);
  void setCaretForeground (const SColor& lrfg, const SColor& rlfg);

  virtual void lostKeyboardFocus (SWindow* w);
  virtual void lostClipSelection (SWindow* w);
  virtual void gainedKeyboardFocus (SWindow* w);
  virtual void redraw (SWindow *canvas, int x, int y, 
     unsigned int width, unsigned int height);

  virtual void keyPressed (SWindow * w, SKey key, const SString& s,
          bool ctrl, bool shift, bool meta);
  virtual void keyReleased (SWindow * w, SKey key, const SString& s,
          bool ctrl, bool shift, bool meta);
  virtual void buttonPressed (SWindow * w, int button, int x, int y);
  virtual void buttonReleased (SWindow * w, int button, int x, int y);
  virtual void buttonDragged (SWindow * w, int button, int x, int y);

  virtual void resize (const SDimension& size);
  virtual void move (const SLocation& loc);

  void setAlignment (bool align);
  void setMultiline (bool multiline);
  bool isMultiline () const;
  void setLineEndMark (bool lineend);
  bool getLineEndMark () const;

  void scrollVertical (int value, bool notofy);
  void scrollHorizontal (int value, bool notofy);

  virtual void setFont (const SString& font, double fontSize);
  virtual void setFontSize (double size);

  /* This is the implementation of SEditorIF */
  virtual bool clearState();

  virtual void setFont (const SString& font);
  virtual void setInputMethod (const SString& im);

  virtual STextIndex insertText ();
  virtual STextIndex insertText (const SString& str);
  virtual STextIndex insertDirtyText (const SString& str);
  virtual SString eraseText (const STextIndex& till);
  virtual STextIndex getIndexBeforeLineBreak ();
  virtual STextIndex getIndexAfterLineBreak ();

  virtual void pageUp ();
  virtual void pageDown ();

  virtual STextIndex getCaret () const;
  virtual void caretGoTo (const STextIndex& index);
  virtual void caretUp ();
  virtual void caretDown ();
  virtual void caretLeft ();
  virtual void caretRight ();

  virtual void startSelect ();
  virtual void endSelect ();

  virtual void selectText (const STextIndex& till); 
  virtual void selectWord ();
  virtual void selectLine ();
  virtual void deselectText ();
  virtual SString eraseSelectedText ();
  virtual STextIndex getSelectedIndex (bool hi);

  virtual SString backspace ();
  virtual SString erase ();

  virtual void setDirection (char lr);
  virtual bool changeDirection (char lr);

  virtual char getDirection () const;
  virtual void focusOut ();
  virtual void setEditable (bool editable);
  virtual bool isEditable () const;
  virtual bool isSelecting() const;

  virtual void directInsert (const SGlyph& g, STextIndex* i);
  virtual SString getText (const STextIndex& from, const STextIndex& till);
  void setUnderlineColor (const SColor& c);
  virtual void clear();
  void setText (const SString& text);

  SString getText ();
  bool undo();
  bool redo();
  void setLineBreak (const SString& lineBreak);

  const SStringVector& getHistory();
  void putHistory (const SString& str);
  void setHistorySize (unsigned int siz);
  void historyUp ();
  void historyDown ();
  void historyEnd ();
  bool find(const SString& str);
  bool replace(const SString& orig, const SString& str);

  const SGlyph* glyphAt(const STextIndex & ti);
  /* new text through editor */
  void insertEditorText (const SString& text);

protected:
  unsigned int historySize;
  unsigned int currentHistorySize;
  SStringVector      history;

  SDClick    clicks;
  bool       focused;
  bool       editable;
  bool       selecting;
  STextIndex startSelection;
  STextIndex endSelection;

  void clipSelection ();
  void setCaretLocationVisible ();
  void setCaretVisibleVertical();
  void setCaretVisibleHorizontal();

  void       moveCaret (bool updateColumn=true);
  SCaret     caret;
  SBorder    border;
  STextView  textView;

  /* This is from SSliderListener */
  virtual void valueChanged (SSlidable* slidable, SSlideType type);

  /* This is from component */
  virtual SSlidable* setSliderListener (SSliderListener* l);

private:

  SString          imWaiting;
  SSlidable        slidable;
  SSliderListener* sliderListener;

  SYuditInput* yuditInput;
  void         notifySlider ();
  void         fireTextChanged (); 
  void         fireCaretMoved (); 
  void         redraw ();
  SBinVector<STextEditLS*> listeners;

  SEditor  editor;
  SProperties  getProperties ();
  void clip (bool on);
  unsigned int column; /* this is to align up-down movements of cursor. */
};

#endif /* STextEdit_h */
