/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <stoolkit/SIO.h>
#include <stdio.h>

int
main(int argc, char* argv[])
{
  SDir dir;
  if (!dir.exists())
  {
    fprintf (stderr, "Directory %*.*s does not exist.\r\n",SSARGS(dir.getName()));
    return (1);
  }
  if (!dir.readable())
  {
    fprintf (stderr, "Directory %*.*s not readable.\r\n",SSARGS(dir.getName()));
    return (1);
  }
  printf ("Directory %*.*s\r\n",SSARGS(dir.getName()));
  SStringVector files = dir.list("*.cpp");
  SStringVector dirs = dir.list(SDir::SE_DIR);
  SString fl = files.join (" ");
  SString dl = dirs.join (" ");
  printf ("Files:    \r\n%*.*s\r\n", SSARGS(fl)); 
  printf ("Directories:\r\n%*.*s\r\n", SSARGS(dl));
  return 0;
}
