-- 
-- Zabbix
-- Copyright (C) 2000,2001,2002,2003,2004 Alexei Vladishev
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--

--
-- Dumping data for table `config`
--

INSERT INTO config VALUES (1,365,365,600,'1-5,00:00-24:00',7);

--
-- Dumping data for table `media_type`
--

INSERT INTO media_type VALUES (1,0,'Email','localhost','localhost','zabbix@localhost','','','','');
INSERT INTO media_type VALUES (2,2,'SMS','localhost','localhost','zabbix@localhost','','/dev/ttyS0','','');
INSERT INTO media_type VALUES (3,3,'Jabber','localhost','localhost','zabbix@localhost','','/dev/ttyS0','zabbix@jabber.org','');

--
-- Dumping data for table `users`
--

INSERT INTO users VALUES (1,'Admin','Zabbix','Administrator','d41d8cd98f00b204e9800998ecf8427e','',900,'en_gb',30,3);
INSERT INTO users VALUES (2,'guest','Default','User','d41d8cd98f00b204e9800998ecf8427e','',900,'en_gb',30,1);

--
-- Dumping data for table `usrgrp`
--

INSERT INTO usrgrp VALUES (1,'UNIX administrators');
INSERT INTO usrgrp VALUES (2,'Database administrators');
INSERT INTO usrgrp VALUES (3,'Network administrators');
INSERT INTO usrgrp VALUES (4,'Security specialists');
INSERT INTO usrgrp VALUES (5,'WEB administrators');
INSERT INTO usrgrp VALUES (6,'Head of IT department');
INSERT INTO usrgrp VALUES (7,'Zabbix administrators');
INSERT INTO usrgrp VALUES (8,'Guests');

--
-- Dumping data for table `users_groups`
--

INSERT INTO users_groups VALUES (1,7,1);
INSERT INTO users_groups VALUES (2,8,2);

--
-- Dumping data for table `rights`
--

-- INSERT INTO rights VALUES (1,1,0,0,0);
-- INSERT INTO rights VALUES (2,1,0,0,0);
-- INSERT INTO rights VALUES (3,2,0,0,0);

--
-- Dumping data for table hosts
--

INSERT INTO hosts VALUES (10001,'Template_Linux','',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10002,'Template_Windows','',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10003,'Template_App_MySQL','',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10004,'Template_Standalone','',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10007,'Template_SNMPv2_Device','',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10008,'Template_FreeBSD','Template_FreeBSD',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10009,'Template_OpenBSD','Template_OpenBSD',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10010,'Template_Tru64','Template_Tru64',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10011,'Template_Netware','Template_Netware',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10012,'Template_AIX','Template_AIX',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10013,'Template_HPUX','Template_HPUX',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10014,'Template_MacOS_X','Template_MacOS_X',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10015,'Template_Solaris','Template_Solaris',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10016,'Template_SNMPv1_Device','',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10017,'ZABBIX Server','',1,'127.0.0.1',10050,1,0,'',0,0);
INSERT INTO hosts VALUES (10018,'Template_Cisco_PIX_525','',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10019,'Template_Dell_PowerConnect_6248','',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10020,'Template_APC_Battery','',0,'0.0.0.0',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10021,'Template_HP_InsightManager','',0,'127.0.0.1',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10022,'Template_Dell_OpenManage','',0,'0.0.0.0',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10023,'Template_Cisco_PIX','',0,'',10050,3,0,'',0,0);
INSERT INTO hosts VALUES (10024,'Template_Dell_PowerEdge','',0,'0.0.0.0',10050,3,0,'',0,0);

--
-- Dumping data for table `hosts_templates`
--

insert into hosts_templates values (1,10017,10001);

--
-- Dumping data for table `applications`
--

INSERT INTO applications VALUES (1,10001,'OS',0);
INSERT INTO applications VALUES (2,10001,'Services',0);
INSERT INTO applications VALUES (5,10001,'Filesystem',0);
INSERT INTO applications VALUES (7,10001,'Network',0);
INSERT INTO applications VALUES (9,10001,'Processes',0);
INSERT INTO applications VALUES (11,10001,'Log files',0);
INSERT INTO applications VALUES (13,10001,'CPU',0);
INSERT INTO applications VALUES (15,10001,'Memory',0);
INSERT INTO applications VALUES (17,10001,'Performance',0);
INSERT INTO applications VALUES (19,10001,'Availability',0);
INSERT INTO applications VALUES (21,10001,'General',0);
INSERT INTO applications VALUES (23,10001,'Integrity',0);
INSERT INTO applications VALUES (25,10002,'Availability',0);
INSERT INTO applications VALUES (27,10002,'CPU',0);
INSERT INTO applications VALUES (29,10002,'Filesystem',0);
INSERT INTO applications VALUES (31,10002,'General',0);
INSERT INTO applications VALUES (33,10002,'Integrity',0);
INSERT INTO applications VALUES (35,10002,'Memory',0);
INSERT INTO applications VALUES (37,10002,'Network',0);
INSERT INTO applications VALUES (39,10002,'OS',0);
INSERT INTO applications VALUES (41,10002,'Performance',0);
INSERT INTO applications VALUES (43,10002,'Processes',0);
INSERT INTO applications VALUES (45,10002,'Services',0);
INSERT INTO applications VALUES (47,10008,'General',0);
INSERT INTO applications VALUES (48,10008,'Processes',0);
INSERT INTO applications VALUES (49,10008,'Log files',0);
INSERT INTO applications VALUES (50,10008,'OS',0);
INSERT INTO applications VALUES (51,10008,'Network',0);
INSERT INTO applications VALUES (52,10008,'Performance',0);
INSERT INTO applications VALUES (53,10008,'Services',0);
INSERT INTO applications VALUES (54,10008,'CPU',0);
INSERT INTO applications VALUES (55,10008,'Availability',0);
INSERT INTO applications VALUES (56,10008,'Filesystem',0);
INSERT INTO applications VALUES (57,10008,'Integrity',0);
INSERT INTO applications VALUES (58,10008,'Memory',0);
INSERT INTO applications VALUES (59,10009,'General',0);
INSERT INTO applications VALUES (60,10009,'Processes',0);
INSERT INTO applications VALUES (61,10009,'Log files',0);
INSERT INTO applications VALUES (62,10009,'OS',0);
INSERT INTO applications VALUES (63,10009,'Network',0);
INSERT INTO applications VALUES (64,10009,'Performance',0);
INSERT INTO applications VALUES (65,10009,'Services',0);
INSERT INTO applications VALUES (66,10009,'CPU',0);
INSERT INTO applications VALUES (67,10009,'Availability',0);
INSERT INTO applications VALUES (68,10009,'Filesystem',0);
INSERT INTO applications VALUES (69,10009,'Integrity',0);
INSERT INTO applications VALUES (70,10009,'Memory',0);
INSERT INTO applications VALUES (71,10010,'General',0);
INSERT INTO applications VALUES (72,10010,'Processes',0);
INSERT INTO applications VALUES (73,10010,'Log files',0);
INSERT INTO applications VALUES (74,10010,'OS',0);
INSERT INTO applications VALUES (75,10010,'Network',0);
INSERT INTO applications VALUES (76,10010,'Performance',0);
INSERT INTO applications VALUES (77,10010,'Services',0);
INSERT INTO applications VALUES (78,10010,'CPU',0);
INSERT INTO applications VALUES (79,10010,'Availability',0);
INSERT INTO applications VALUES (80,10010,'Filesystem',0);
INSERT INTO applications VALUES (81,10010,'Integrity',0);
INSERT INTO applications VALUES (82,10010,'Memory',0);
INSERT INTO applications VALUES (83,10011,'General',0);
INSERT INTO applications VALUES (84,10011,'Processes',0);
INSERT INTO applications VALUES (85,10011,'Log files',0);
INSERT INTO applications VALUES (86,10011,'OS',0);
INSERT INTO applications VALUES (87,10011,'Network',0);
INSERT INTO applications VALUES (88,10011,'Performance',0);
INSERT INTO applications VALUES (89,10011,'Services',0);
INSERT INTO applications VALUES (90,10011,'CPU',0);
INSERT INTO applications VALUES (91,10011,'Availability',0);
INSERT INTO applications VALUES (92,10011,'Filesystem',0);
INSERT INTO applications VALUES (93,10011,'Integrity',0);
INSERT INTO applications VALUES (94,10011,'Memory',0);
INSERT INTO applications VALUES (95,10012,'General',0);
INSERT INTO applications VALUES (96,10012,'Processes',0);
INSERT INTO applications VALUES (97,10012,'Log files',0);
INSERT INTO applications VALUES (98,10012,'OS',0);
INSERT INTO applications VALUES (99,10012,'Network',0);
INSERT INTO applications VALUES (100,10012,'Performance',0);
INSERT INTO applications VALUES (101,10012,'Services',0);
INSERT INTO applications VALUES (102,10012,'CPU',0);
INSERT INTO applications VALUES (103,10012,'Availability',0);
INSERT INTO applications VALUES (104,10012,'Filesystem',0);
INSERT INTO applications VALUES (105,10012,'Integrity',0);
INSERT INTO applications VALUES (106,10012,'Memory',0);
INSERT INTO applications VALUES (107,10013,'General',0);
INSERT INTO applications VALUES (108,10013,'Processes',0);
INSERT INTO applications VALUES (109,10013,'Log files',0);
INSERT INTO applications VALUES (110,10013,'OS',0);
INSERT INTO applications VALUES (111,10013,'Network',0);
INSERT INTO applications VALUES (112,10013,'Performance',0);
INSERT INTO applications VALUES (113,10013,'Services',0);
INSERT INTO applications VALUES (114,10013,'CPU',0);
INSERT INTO applications VALUES (115,10013,'Availability',0);
INSERT INTO applications VALUES (116,10013,'Filesystem',0);
INSERT INTO applications VALUES (117,10013,'Integrity',0);
INSERT INTO applications VALUES (118,10013,'Memory',0);
INSERT INTO applications VALUES (119,10014,'General',0);
INSERT INTO applications VALUES (120,10014,'Processes',0);
INSERT INTO applications VALUES (121,10014,'Log files',0);
INSERT INTO applications VALUES (122,10014,'OS',0);
INSERT INTO applications VALUES (123,10014,'Network',0);
INSERT INTO applications VALUES (124,10014,'Performance',0);
INSERT INTO applications VALUES (125,10014,'Services',0);
INSERT INTO applications VALUES (126,10014,'CPU',0);
INSERT INTO applications VALUES (127,10014,'Availability',0);
INSERT INTO applications VALUES (128,10014,'Filesystem',0);
INSERT INTO applications VALUES (129,10014,'Integrity',0);
INSERT INTO applications VALUES (130,10014,'Memory',0);
INSERT INTO applications VALUES (131,10015,'General',0);
INSERT INTO applications VALUES (132,10015,'Processes',0);
INSERT INTO applications VALUES (133,10015,'Log files',0);
INSERT INTO applications VALUES (134,10015,'OS',0);
INSERT INTO applications VALUES (135,10015,'Network',0);
INSERT INTO applications VALUES (136,10015,'Performance',0);
INSERT INTO applications VALUES (137,10015,'Services',0);
INSERT INTO applications VALUES (138,10015,'CPU',0);
INSERT INTO applications VALUES (139,10015,'Availability',0);
INSERT INTO applications VALUES (140,10015,'Filesystem',0);
INSERT INTO applications VALUES (141,10015,'Integrity',0);
INSERT INTO applications VALUES (142,10015,'Memory',0);

INSERT INTO applications VALUES (143,10017,'Availability',19);
INSERT INTO applications VALUES (144,10017,'CPU',13);
INSERT INTO applications VALUES (145,10017,'Filesystem',5);
INSERT INTO applications VALUES (146,10017,'General',21);
INSERT INTO applications VALUES (147,10017,'Integrity',23);
INSERT INTO applications VALUES (148,10017,'Log files',11);
INSERT INTO applications VALUES (149,10017,'Memory',15);
INSERT INTO applications VALUES (150,10017,'Network',7);
INSERT INTO applications VALUES (151,10017,'OS',1);
INSERT INTO applications VALUES (152,10017,'Performance',17);
INSERT INTO applications VALUES (153,10017,'Processes',9);
INSERT INTO applications VALUES (154,10017,'Services',2);

--
-- Dumping data for table `mappings`
--


INSERT INTO mappings VALUES (1,1,'0','Down');
INSERT INTO mappings VALUES (2,1,'1','Up');
INSERT INTO mappings VALUES (3,2,'0','Up');
INSERT INTO mappings VALUES (4,2,'2','Unreachable');
INSERT INTO mappings VALUES (5,3,'0','Running');
INSERT INTO mappings VALUES (6,3,'1','Paused');
INSERT INTO mappings VALUES (7,3,'3','Pause pending');
INSERT INTO mappings VALUES (8,3,'4','Continue pending');
INSERT INTO mappings VALUES (9,3,'5','Stop pending');
INSERT INTO mappings VALUES (10,3,'6','Stopped');
INSERT INTO mappings VALUES (11,3,'7','Unknown');
INSERT INTO mappings VALUES (12,3,'255','No such service');

--
-- Dumping data for table valuemaps
--

INSERT INTO valuemaps VALUES (4,'APC Battery Replacement Status');
INSERT INTO valuemaps VALUES (5,'APC Battery Status');
INSERT INTO valuemaps VALUES (7,'Dell Open Manage System Status');
INSERT INTO valuemaps VALUES (2,'Host status');
INSERT INTO valuemaps VALUES (6,'HP Insight System Status');
INSERT INTO valuemaps VALUES (1,'Service state');
INSERT INTO valuemaps VALUES (3,'Windows service state');

--
-- Dumping data for table `groups`
--

INSERT INTO groups VALUES (2,'Linux servers');
INSERT INTO groups VALUES (1,'Templates');
INSERT INTO groups VALUES (3,'Windows servers');
INSERT INTO groups VALUES (4,'ZABBIX Servers');

--
-- Dumping data for table hosts_groups
--

INSERT INTO hosts_groups VALUES (1,10001,1);
INSERT INTO hosts_groups VALUES (2,10002,1);
INSERT INTO hosts_groups VALUES (3,10003,1);
INSERT INTO hosts_groups VALUES (4,10004,1);
INSERT INTO hosts_groups VALUES (5,10007,1);
INSERT INTO hosts_groups VALUES (6,10017,4);
INSERT INTO hosts_groups VALUES (7,10018,1);
INSERT INTO hosts_groups VALUES (8,10019,1);
INSERT INTO hosts_groups VALUES (9,10020,1);
INSERT INTO hosts_groups VALUES (10,10021,1);
INSERT INTO hosts_groups VALUES (11,10022,1);
INSERT INTO hosts_groups VALUES (12,10024,1);

--
-- Dumping data for table `help_items`
--


insert into help_items values (3,'icmpping','Checks if server is accessible by ICMP ping	0 - ICMP ping fails 1 - ICMP ping successful	One of zabbix_server processes performs ICMP pings once per PingerFrequency seconds.');
insert into help_items values (3,'icmppingsec','Return ICMP ping response time	Number of seconds Example: 0.02');
insert into help_items values (3,'ftp&lt;,port&gt;','Checks if FTP server is running and accepting connections	0 - FTP server is down 1 - FTP server is running');
insert into help_items values (3,'http&lt;,port&gt;','Checks if HTTP (WEB) server is running and accepting connections	0 - HTTP server is down 1 - HTTP server is running');
insert into help_items values (3,'imap&lt;,port&gt;','Checks if IMAP server is running and accepting connections	0 - IMAP server is down 1 - IMAP server is running');
insert into help_items values (3,'nntp&lt;,port&gt;','Checks if NNTP server is running and accepting connections	0 - NNTP server is down 1 - NNTP server is running');
insert into help_items values (3,'pop&lt;,port&gt;','Checks if POP server is running and accepting connections	0 - POP server is down 1 - POP server is running');
insert into help_items values (3,'smtp&lt;,port&gt;','Checks if SMTP server is running and accepting connections	0 - SMTP server is down 1 - SMTP server is running');
insert into help_items values (3,'ssh&lt;,port&gt;','Checks if SSH server is running and accepting connections	0 - SSH server is down 1 - SSH server is running');
insert into help_items values (3,'tcp,port','Checks if TCP service is running and accepting connections on port	0 - the serivce on the por t is down 1 - the service is running');
insert into help_items values (3,'ftp_perf&lt;,port&gt;','Checks if FTP server is running and accepting connections	0 - FTP server is down Otherwise, number of milliseconds spent connecting to FTP server');
insert into help_items values (3,'http_perf&lt;,port&gt;','Checks if HTTP (WEB) server is running and accepting connections	0 - HTTP server is down Otherwise, number of milliseconds spent connecting to HTTP server');
insert into help_items values (3,'imap_perf&lt;,port&gt;','Checks if IMAP server is running and accepting connections	0 - IMAP server is down Otherwise, number of milliseconds spent connecting to IMAP server');
insert into help_items values (3,'nntp_perf&lt;,port&gt;','Checks if NNTP server is running and accepting connections	0 - NNTP server is down Otherwise, number of milliseconds spent connecting to NNTP server');
insert into help_items values (3,'pop_perf&lt;,port&gt;','Checks if POP server is running and accepting connections	0 - POP server is down Otherwise, number of milliseconds spent connecting to POP server');
insert into help_items values (3,'smtp_perf&lt;,port&gt;','Checks if SMTP server is running and accepting connections	0 - SMTP server is down Otherwise, number of milliseconds spent connecting to SMTP server');
insert into help_items values (3,'ssh_perf&lt;,port&gt;','Checks if SSH server is running and accepting connections	0 - SSH server is down Otherwise, number of milliseconds spent connecting to SSH server');

insert into help_items values (5,'zabbix[history]','Number of values stored in table HISTORY');
insert into help_items values (5,'zabbix[history_str]','Number of values stored in table HISTORY_STR');
insert into help_items values (5,'zabbix[items]','Number of items in ZABBIX database');
insert into help_items values (5,'zabbix[items_unsupported]','Number of unsupported items in ZABBIX database');
insert into help_items values (5,'zabbix[log]','Stores warning and error messages generated by ZABBIX server.');
insert into help_items values (5,'zabbix[queue]','Number of items in the queue');
insert into help_items values (5,'zabbix[trends]','Number of values stored in table TRENDS');
insert into help_items values (5,'zabbix[triggers]','Number of triggers in ZABBIX database');

insert into help_items values (8,'grpfunc(&lt;Group&gt;,&lt;Key&gt;,&lt;func&gt;,&lt;param&gt;)','Aggregate checks do not require any agent running on a host being monitored. ZABBIX server collects aggregate information by doing direct database queries. See ZABBIX Manual.');

insert into help_items values(0,'agent.ping','Check the agent usability. Always return 1. Can be used as a TCP ping.');
insert into help_items values(0,'agent.version','Version of zabbix_agent(d) running on monitored host. String value. Example of returned value: 1.1');
insert into help_items values(0,'kernel.maxfiles','Maximum number of opened files supported by OS.');
insert into help_items values(0,'kernel.maxproc','Maximum number of processes supported by OS.');
insert into help_items values(0,'net.if.collisions[if]','Out-of-window collision. Collisions count.');
insert into help_items values(0,'net.if.in[if &lt;,mode&gt;]','Network interface input statistic. Integer value. If mode is missing bytes is used.');
insert into help_items values(0,'net.if.out[if &lt;,mode&gt;]','Network interface output statistic. Integer value. If mode is missing bytes is used.');
insert into help_items values(0,'net.tcp.dns[ip, zone]','Checks if DNS service is up. 0 - DNS is down, 1 - DNS is up.');
insert into help_items values(0,'net.tcp.listen[port]','Checks if this port is in LISTEN state. 0 - it is not, 1 - it is in LISTEN state.');
insert into help_items values(0,'net.tcp.port[&lt;ip&gt;, port]','Check, if it is possible to make TCP connection to the port number. 0 - cannot connect, 1 - can connect. IP address is optional. If ip is missing, 127.0.0.1 is used. Example: net.tcp.port[,80]');
insert into help_items values(0,'net.tcp.service[service &lt;,ip&gt; &lt;,port&gt;]','Check if service server is running and accepting connections. 0 - service is down, 1 - service is running. If ip is missing 127.0.0.1 is used. If port number is missing, default service port is used. Example: net.tcp.service[ftp,,45].');
insert into help_items values(0,'net.tcp.service.perf[service &lt;,ip&gt; &lt;,port&gt;]','Check performance of service server. 0 - service server is down, sec - number of seconds spent on connection to the service server. If ip is missing 127.0.0.1 is used.  If port number is missing, default service port is used.');
insert into help_items values(0,'proc.mem[&lt;name&gt; &lt;,user&gt; &lt;,mode&gt;]','Memory used of process with name name running under user user. Memory used by processes. Process name, user and mode is optional. If name or user is missing all processes will be calculated. If mode is missing sum is used.  Examples: proc.mem[,root]');
insert into help_items values(0,'proc.num[&lt;name&gt; &lt;,user&gt; &lt;,state&gt;]','Number of processes with name name running under user user having state state. Process name, user and state are optional. Example: proc.num[,root]');
insert into help_items values(0,'system.cpu.intr','Device interrupts.');
insert into help_items values(0,'system.cpu.load[&lt;cpu&gt; &lt;,mode&gt;]','CPU(s) load. Processor load. The cpu and mode are optional. If cpu is missing all is used. If mode is missing avg1 is used. Note that this is not percentage.');
insert into help_items values(0,'system.cpu.switches','Context switches.');
insert into help_items values(0,'system.cpu.util[&lt;cpu&gt; &lt;,type&gt; &lt;,mode&gt;]','CPU(s) utilisation. Processor load in percents. The cpu, type and mode are optional. If cpu is missing all is used.  If type is missing user is used. If mode is missing avg1 is used.');
insert into help_items values(0,'system.hostname','Return host name. String value. Example of returned value: www.zabbix.com');
insert into help_items values(0,'system.localtime','System local time. Time in seconds.');
insert into help_items values(0,'system.swap.in[&lt;swap&gt; &lt;,type&gt;]','Swap in. If type is count - swapins is returned. If type is pages - pages swapped in is returned.	If swap is missing all is used.');
insert into help_items values(0,'system.swap.out[&lt;swap&gt; &lt;,type&gt;]','Swap out. If type is count - swapouts is returned. If type is pages - pages swapped in is returned.  If swap is missing all is used.');
insert into help_items values(0,'system.swap.size[&lt;swap&gt; &lt;,mode&gt;]','Swap space. Number of bytes. If swap is missing all is used. If mode is missing free is used.');
insert into help_items values(0,'system.uname','Returns detailed host information. String value');
insert into help_items values(0,'system.uptime','System uptime in seconds.');
insert into help_items values(0,'system.users.num','Number of users connected. Command who is used on agent side.');
insert into help_items values(0,'vfs.dev.read[device &lt;,type&gt; &lt;,mode&gt;]','Device read statistics.');
insert into help_items values(0,'vfs.dev.write[device &lt;,type&gt; &lt;,mode&gt;]','Device write statistics.');
insert into help_items values(0,'vfs.file.cksum[file]','Calculate check sum of a given file. Check sum of the file calculate by standard algorithm used by UNIX utility cksum.	Example: vfs.file.cksum[/etc/passwd]');
insert into help_items values(0,'vfs.file.exists[file]','Check file existance. 0 - file does not exists, 1 - file exists');
insert into help_items values(0,'vfs.file.md5sum[file]','Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/etc/zabbix/zabbix_agentd.conf]');
insert into help_items values(0,'vfs.file.regexp[file, user]','');
insert into help_items values(0,'vfs.file.regmatch[file, user]','');
insert into help_items values(0,'vfs.file.size[file]','Size of a given file. Size in bytes. File must have read permissions for user zabbix. Example: vfs.file.size[/var/log/syslog]');
insert into help_items values(0,'vfs.file.time[file&lt;, mode&gt;]','File time information. Number of seconds.	The mode is optional. If mode is missing modify is used.');
insert into help_items values(0,'vfs.fs.inode[fs &lt;,mode&gt;]','Number of inodes for a given volume. If mode is missing total is used.');
insert into help_items values(0,'vfs.fs.size[fs &lt;,mode&gt;]','Calculate disk space for a given volume. Disk space in KB. If mode is missing total is used.  In case of mounted volume, unused disk space for local file system is returned. Example: vfs.fs.size[/tmp,free].');
insert into help_items values(0,'vm.memory.size[&lt;mode&gt;]','Amount of memory size in bytes. If mode is missing total is used.');

--
-- Dumping data for table items
--

INSERT INTO items VALUES (10001,0,'','',161,10001,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10002,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10003,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10004,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10005,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10006,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10007,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10008,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10009,0,'','',161,10001,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10010,0,'','',161,10001,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10011,0,'','',161,10001,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10012,0,'','',161,10001,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10013,0,'','',161,10001,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10014,0,'','',161,10001,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10015,0,'','',161,10001,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10016,0,'','',161,10001,'Number of users connected','system.users.num',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10017,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10018,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10019,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10020,0,'','',161,10001,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10021,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10022,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10023,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10024,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10025,0,'','',161,10001,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10026,0,'','',161,10001,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10027,0,'','',161,10001,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10028,0,'','',161,10001,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10029,0,'','',161,10001,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10030,0,'','',161,10001,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10031,0,'','',161,10001,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10032,0,'','',161,10001,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10033,0,'','',161,10001,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10036,0,'','',161,10001,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10037,0,'','',161,10001,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10038,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10039,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10040,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10046,0,'','',161,10001,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10047,0,'','',161,10001,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10048,0,'','',161,10001,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10049,0,'','',161,10001,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10050,0,'','',161,10001,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10051,0,'','',161,10001,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10052,0,'','',161,10001,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10053,0,'','',161,10001,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10055,0,'','',161,10001,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10056,0,'','',161,10001,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10057,0,'','',161,10001,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10058,0,'','',161,10001,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10059,0,'','',161,10001,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10060,0,'','',161,10001,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10061,0,'','',161,10001,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,2,'','');
INSERT INTO items VALUES (10062,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10063,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10064,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10065,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10066,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10067,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10068,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10069,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10070,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10071,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10072,0,'','',161,10001,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10075,0,'','',161,10001,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10078,0,'','',161,10001,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10081,0,'','',161,10001,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10084,0,'','',161,10001,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10087,0,'','',161,10001,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10090,0,'','',161,10002,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10091,0,'','',161,10002,'Free disk space on $1','vfs.fs.size[c:,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (10098,0,'','',161,10002,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10099,0,'','',161,10002,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10100,0,'','',161,10002,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10101,0,'','',161,10002,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10102,0,'','',161,10002,'Number of running processes','system[procrunning]',30,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10103,0,'','',161,10002,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10104,0,'','',161,10002,'Size of $1','vfs.file.size[c:\\msdos.sys]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10106,0,'','',161,10002,'Checksum of $1','vfs.file.cksum[c:\\autoexec.bat]',600,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10109,0,'','',161,10002,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10114,0,'','',161,10002,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,0,'','uptime',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10115,0,'','',161,10002,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10119,0,'','',161,10002,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10137,0,'','',161,10002,'Number of running processes apache','proc_cnt[httpd]',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10147,0,'','',161,10002,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10148,0,'','',161,10002,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10150,0,'','',161,10002,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,2,'','');
INSERT INTO items VALUES (10156,0,'','',161,10002,'Total disk space on $1','vfs.fs.size[c:,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10200,0,'','',161,10003,'MySQL is alive','mysql[ping]',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10201,0,'','',161,10003,'MySQL uptime','mysql[uptime]',60,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10202,0,'','',161,10003,'MySQL number of threads','mysql[threads]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10203,0,'','',161,10003,'MySQL queries per second','mysql[qps]',60,7,365,0,NULL,NULL,NULL,0,0,'','qps',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10204,0,'','',161,10003,'MySQL number of slow queries','mysql[slowqueries]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10205,0,'','',161,10003,'MySQL version','version[mysql]',600,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10298,3,'','',161,10004,'Email (SMTP) server is running','smtp',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10299,3,'','',161,10004,'FTP server is running','ftp',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10300,3,'','',161,10004,'SSH server is running','ssh',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10303,3,'','',161,10004,'POP3 server is running','pop',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10304,3,'','',161,10004,'IMAP server is running','imap',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10313,3,'','',161,10004,'News (NNTP) server is running','nntp',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10327,3,'','',161,10004,'WEB (HTTP) server is running','http',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','');
INSERT INTO items VALUES (10357,0,'','',161,10002,'Checksum of $1','vfs.file.cksum[c:\\config.sys]',600,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10358,0,'','',161,10002,'Free disk space on $1','vfs.fs.size[d:,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (10359,0,'','',161,10002,'Total disk space on $1','vfs.fs.size[d:,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10412,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10413,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10414,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,0,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10415,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10416,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10417,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (10418,0,'','',161,10001,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10419,0,'','',161,10001,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (10420,0,'','',161,10001,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17001,4,'public','1.3.6.1.2.1.1.5.0',161,10007,'sysName','sysName',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17002,4,'public','1.3.6.1.4.1.9.2.1.112.0',161,10007,'lenvSerialNumber','lenvSerialNumber',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17003,4,'public','1.3.6.1.4.1.9.2.1.47.0',161,10007,'lmemBufferNoMem','lmemBufferNoMem',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17004,4,'public','1.3.6.1.4.1.9.2.1.56.0',161,10007,'lcpuPercentBusy','lcpuPercentBusy',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17005,4,'public','1.3.6.1.4.1.9.2.1.108.0',161,10007,'lenvFirmVersion','lenvFirmVersion',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17006,4,'public','1.3.6.1.4.1.9.2.1.46.0',161,10007,'lmemBufferFail','lmemBufferFail',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17007,4,'public','1.3.6.1.4.1.9.2.1.8.0',161,10007,'lmemFreeMem','lmemFreeMem',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17008,4,'public','1.3.6.1.4.1.9.2.1.1.0',161,10007,'lmemRomID','lmemRomID',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17009,4,'public','1.3.6.1.2.1.2.2.1.2.1',161,10007,'ifDescr1','ifDescr1',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17010,4,'public','1.3.6.1.2.1.2.2.1.2.2',161,10007,'ifDescr2','ifDescr2',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17011,4,'public','1.3.6.1.2.1.2.2.1.2.3',161,10007,'ifDescr3','ifDescr3',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17012,4,'public','1.3.6.1.2.1.2.2.1.2.4',161,10007,'ifDescr4','ifDescr4',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17013,4,'public','1.3.6.1.2.1.2.2.1.2.5',161,10007,'ifDescr5','ifDescr5',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17014,4,'public','1.3.6.1.2.1.2.2.1.2.6',161,10007,'ifDescr6','ifDescr6',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17015,4,'public','1.3.6.1.2.1.2.2.1.2.7',161,10007,'ifDescr7','ifDescr7',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17016,4,'public','1.3.6.1.2.1.2.2.1.2.8',161,10007,'ifDescr8','ifDescr8',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17017,4,'public','1.3.6.1.2.1.2.2.1.2.9',161,10007,'ifDescr9','ifDescr9',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17018,4,'public','1.3.6.1.2.1.2.2.1.2.10',161,10007,'ifDescr10','ifDescr10',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17019,4,'public','1.3.6.1.2.1.2.2.1.2.11',161,10007,'ifDescr11','ifDescr11',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17020,4,'public','1.3.6.1.2.1.2.2.1.2.12',161,10007,'ifDescr12','ifDescr12',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17021,4,'public','1.3.6.1.2.1.2.2.1.2.13',161,10007,'ifDescr13','ifDescr13',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17022,4,'public','1.3.6.1.2.1.2.2.1.2.14',161,10007,'ifDescr14','ifDescr14',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17023,4,'public','1.3.6.1.2.1.2.2.1.2.15',161,10007,'ifDescr15','ifDescr15',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17024,4,'public','1.3.6.1.2.1.2.2.1.2.16',161,10007,'ifDescr16','ifDescr16',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17025,4,'public','1.3.6.1.2.1.2.2.1.2.17',161,10007,'ifDescr17','ifDescr17',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17026,4,'public','1.3.6.1.2.1.2.2.1.2.18',161,10007,'ifDescr18','ifDescr18',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17027,4,'public','1.3.6.1.2.1.2.2.1.2.19',161,10007,'ifDescr19','ifDescr19',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17028,4,'public','1.3.6.1.2.1.2.2.1.2.20',161,10007,'ifDescr20','ifDescr20',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17029,4,'public','1.3.6.1.2.1.2.2.1.2.21',161,10007,'ifDescr21','ifDescr21',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17030,4,'public','1.3.6.1.2.1.2.2.1.2.22',161,10007,'ifDescr22','ifDescr22',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17031,4,'public','1.3.6.1.2.1.2.2.1.2.23',161,10007,'ifDescr23','ifDescr23',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17032,4,'public','1.3.6.1.2.1.2.2.1.2.24',161,10007,'ifDescr24','ifDescr24',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17033,4,'public','1.3.6.1.2.1.2.2.1.2.25',161,10007,'ifDescr25','ifDescr25',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17034,4,'public','1.3.6.1.2.1.2.2.1.2.26',161,10007,'ifDescr26','ifDescr26',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17035,4,'public','1.3.6.1.2.1.2.2.1.2.27',161,10007,'ifDescr27','ifDescr27',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17036,4,'public','1.3.6.1.2.1.2.2.1.2.28',161,10007,'ifDescr28','ifDescr28',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17037,4,'public','1.3.6.1.2.1.2.2.1.2.29',161,10007,'ifDescr29','ifDescr29',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17038,4,'public','1.3.6.1.2.1.2.2.1.2.30',161,10007,'ifDescr30','ifDescr30',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17039,4,'public','1.3.6.1.2.1.2.2.1.2.31',161,10007,'ifDescr31','ifDescr31',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17040,4,'public','1.3.6.1.2.1.2.2.1.2.32',161,10007,'ifDescr32','ifDescr32',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17041,4,'public','1.3.6.1.2.1.2.2.1.2.33',161,10007,'ifDescr33','ifDescr33',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17042,4,'public','1.3.6.1.2.1.2.2.1.2.34',161,10007,'ifDescr34','ifDescr34',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17043,4,'public','1.3.6.1.2.1.2.2.1.2.35',161,10007,'ifDescr35','ifDescr35',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17044,4,'public','1.3.6.1.2.1.2.2.1.2.36',161,10007,'ifDescr36','ifDescr36',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17045,4,'public','1.3.6.1.2.1.2.2.1.2.37',161,10007,'ifDescr37','ifDescr37',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17046,4,'public','1.3.6.1.2.1.2.2.1.2.38',161,10007,'ifDescr38','ifDescr38',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17047,4,'public','1.3.6.1.2.1.2.2.1.2.39',161,10007,'ifDescr39','ifDescr39',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17048,4,'public','1.3.6.1.2.1.2.2.1.2.40',161,10007,'ifDescr40','ifDescr40',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17049,4,'public','1.3.6.1.2.1.2.2.1.2.41',161,10007,'ifDescr41','ifDescr41',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17050,4,'public','1.3.6.1.2.1.2.2.1.2.42',161,10007,'ifDescr42','ifDescr42',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17051,4,'public','1.3.6.1.2.1.2.2.1.2.43',161,10007,'ifDescr43','ifDescr43',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17052,4,'public','1.3.6.1.2.1.2.2.1.2.44',161,10007,'ifDescr44','ifDescr44',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17053,4,'public','1.3.6.1.2.1.2.2.1.2.45',161,10007,'ifDescr45','ifDescr45',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17054,4,'public','1.3.6.1.2.1.2.2.1.2.46',161,10007,'ifDescr46','ifDescr46',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17055,4,'public','1.3.6.1.2.1.2.2.1.2.47',161,10007,'ifDescr47','ifDescr47',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17056,4,'public','1.3.6.1.2.1.2.2.1.2.48',161,10007,'ifDescr48','ifDescr48',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17057,4,'public','1.3.6.1.2.1.2.2.1.2.49',161,10007,'ifDescr49','ifDescr49',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17058,4,'public','1.3.6.1.2.1.2.2.1.2.50',161,10007,'ifDescr50','ifDescr50',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17059,4,'public','1.3.6.1.2.1.2.2.1.2.51',161,10007,'ifDescr51','ifDescr51',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17060,4,'public','1.3.6.1.2.1.2.2.1.10.1',161,10007,'ifInOctets1','ifInOctets1',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17061,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10007,'ifInOctets2','ifInOctets2',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17062,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10007,'ifInOctets3','ifInOctets3',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17063,4,'public','1.3.6.1.2.1.2.2.1.10.4',161,10007,'ifInOctets4','ifInOctets4',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17064,4,'public','1.3.6.1.2.1.2.2.1.10.5',161,10007,'ifInOctets5','ifInOctets5',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17065,4,'public','1.3.6.1.2.1.2.2.1.10.6',161,10007,'ifInOctets6','ifInOctets6',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17066,4,'public','1.3.6.1.2.1.2.2.1.10.7',161,10007,'ifInOctets7','ifInOctets7',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17067,4,'public','1.3.6.1.2.1.2.2.1.10.8',161,10007,'ifInOctets8','ifInOctets8',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17068,4,'public','1.3.6.1.2.1.2.2.1.10.9',161,10007,'ifInOctets9','ifInOctets9',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17069,4,'public','1.3.6.1.2.1.2.2.1.10.10',161,10007,'ifInOctets10','ifInOctets10',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17070,4,'public','1.3.6.1.2.1.2.2.1.10.11',161,10007,'ifInOctets11','ifInOctets11',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17071,4,'public','1.3.6.1.2.1.2.2.1.10.12',161,10007,'ifInOctets12','ifInOctets12',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17072,4,'public','1.3.6.1.2.1.2.2.1.10.13',161,10007,'ifInOctets13','ifInOctets13',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17073,4,'public','1.3.6.1.2.1.2.2.1.10.14',161,10007,'ifInOctets14','ifInOctets14',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17074,4,'public','1.3.6.1.2.1.2.2.1.10.15',161,10007,'ifInOctets15','ifInOctets15',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17075,4,'public','1.3.6.1.2.1.2.2.1.10.16',161,10007,'ifInOctets16','ifInOctets16',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17076,4,'public','1.3.6.1.2.1.2.2.1.10.17',161,10007,'ifInOctets17','ifInOctets17',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17077,4,'public','1.3.6.1.2.1.2.2.1.10.18',161,10007,'ifInOctets18','ifInOctets18',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17078,4,'public','1.3.6.1.2.1.2.2.1.10.19',161,10007,'ifInOctets19','ifInOctets19',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17079,4,'public','1.3.6.1.2.1.2.2.1.10.20',161,10007,'ifInOctets20','ifInOctets20',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17080,4,'public','1.3.6.1.2.1.2.2.1.10.21',161,10007,'ifInOctets21','ifInOctets21',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17081,4,'public','1.3.6.1.2.1.2.2.1.10.22',161,10007,'ifInOctets22','ifInOctets22',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17082,4,'public','1.3.6.1.2.1.2.2.1.10.23',161,10007,'ifInOctets23','ifInOctets23',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17083,4,'public','1.3.6.1.2.1.2.2.1.10.24',161,10007,'ifInOctets24','ifInOctets24',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17084,4,'public','1.3.6.1.2.1.2.2.1.10.25',161,10007,'ifInOctets25','ifInOctets25',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17085,4,'public','1.3.6.1.2.1.2.2.1.10.26',161,10007,'ifInOctets26','ifInOctets26',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17086,4,'public','1.3.6.1.2.1.2.2.1.10.27',161,10007,'ifInOctets27','ifInOctets27',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17087,4,'public','1.3.6.1.2.1.2.2.1.10.28',161,10007,'ifInOctets28','ifInOctets28',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17088,4,'public','1.3.6.1.2.1.2.2.1.10.29',161,10007,'ifInOctets29','ifInOctets29',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17089,4,'public','1.3.6.1.2.1.2.2.1.10.30',161,10007,'ifInOctets30','ifInOctets30',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17090,4,'public','1.3.6.1.2.1.2.2.1.10.31',161,10007,'ifInOctets31','ifInOctets31',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17091,4,'public','1.3.6.1.2.1.2.2.1.10.32',161,10007,'ifInOctets32','ifInOctets32',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17092,4,'public','1.3.6.1.2.1.2.2.1.10.33',161,10007,'ifInOctets33','ifInOctets33',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17093,4,'public','1.3.6.1.2.1.2.2.1.10.34',161,10007,'ifInOctets34','ifInOctets34',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17094,4,'public','1.3.6.1.2.1.2.2.1.10.35',161,10007,'ifInOctets35','ifInOctets35',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17095,4,'public','1.3.6.1.2.1.2.2.1.10.36',161,10007,'ifInOctets36','ifInOctets36',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17096,4,'public','1.3.6.1.2.1.2.2.1.10.37',161,10007,'ifInOctets37','ifInOctets37',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17097,4,'public','1.3.6.1.2.1.2.2.1.10.38',161,10007,'ifInOctets38','ifInOctets38',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17098,4,'public','1.3.6.1.2.1.2.2.1.10.39',161,10007,'ifInOctets39','ifInOctets39',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17099,4,'public','1.3.6.1.2.1.2.2.1.10.40',161,10007,'ifInOctets40','ifInOctets40',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17100,4,'public','1.3.6.1.2.1.2.2.1.10.41',161,10007,'ifInOctets41','ifInOctets41',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17101,4,'public','1.3.6.1.2.1.2.2.1.10.42',161,10007,'ifInOctets42','ifInOctets42',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17102,4,'public','1.3.6.1.2.1.2.2.1.10.43',161,10007,'ifInOctets43','ifInOctets43',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17103,4,'public','1.3.6.1.2.1.2.2.1.10.44',161,10007,'ifInOctets44','ifInOctets44',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17104,4,'public','1.3.6.1.2.1.2.2.1.10.45',161,10007,'ifInOctets45','ifInOctets45',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17105,4,'public','1.3.6.1.2.1.2.2.1.10.46',161,10007,'ifInOctets46','ifInOctets46',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17106,4,'public','1.3.6.1.2.1.2.2.1.10.47',161,10007,'ifInOctets47','ifInOctets47',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17107,4,'public','1.3.6.1.2.1.2.2.1.10.48',161,10007,'ifInOctets48','ifInOctets48',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17108,4,'public','1.3.6.1.2.1.2.2.1.10.49',161,10007,'ifInOctets49','ifInOctets49',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17109,4,'public','1.3.6.1.2.1.2.2.1.10.50',161,10007,'ifInOctets50','ifInOctets50',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17110,4,'public','1.3.6.1.2.1.2.2.1.10.51',161,10007,'ifInOctets51','ifInOctets51',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17111,4,'public','1.3.6.1.2.1.2.2.1.16.1',161,10007,'ifOutOctets1','ifOutOctets1',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17112,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10007,'ifOutOctets2','ifOutOctets2',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17113,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10007,'ifOutOctets3','ifOutOctets3',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17114,4,'public','1.3.6.1.2.1.2.2.1.16.4',161,10007,'ifOutOctets4','ifOutOctets4',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17115,4,'public','1.3.6.1.2.1.2.2.1.16.5',161,10007,'ifOutOctets5','ifOutOctets5',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17116,4,'public','1.3.6.1.2.1.2.2.1.16.6',161,10007,'ifOutOctets6','ifOutOctets6',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17117,4,'public','1.3.6.1.2.1.2.2.1.16.7',161,10007,'ifOutOctets7','ifOutOctets7',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17118,4,'public','1.3.6.1.2.1.2.2.1.16.8',161,10007,'ifOutOctets8','ifOutOctets8',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17119,4,'public','1.3.6.1.2.1.2.2.1.16.9',161,10007,'ifOutOctets9','ifOutOctets9',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17120,4,'public','1.3.6.1.2.1.2.2.1.16.10',161,10007,'ifOutOctets10','ifOutOctets10',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17121,4,'public','1.3.6.1.2.1.2.2.1.16.11',161,10007,'ifOutOctets11','ifOutOctets11',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17122,4,'public','1.3.6.1.2.1.2.2.1.16.12',161,10007,'ifOutOctets12','ifOutOctets12',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17123,4,'public','1.3.6.1.2.1.2.2.1.16.13',161,10007,'ifOutOctets13','ifOutOctets13',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17124,4,'public','1.3.6.1.2.1.2.2.1.16.14',161,10007,'ifOutOctets14','ifOutOctets14',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17125,4,'public','1.3.6.1.2.1.2.2.1.16.15',161,10007,'ifOutOctets15','ifOutOctets15',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17126,4,'public','1.3.6.1.2.1.2.2.1.16.16',161,10007,'ifOutOctets16','ifOutOctets16',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17127,4,'public','1.3.6.1.2.1.2.2.1.16.17',161,10007,'ifOutOctets17','ifOutOctets17',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17128,4,'public','1.3.6.1.2.1.2.2.1.16.18',161,10007,'ifOutOctets18','ifOutOctets18',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17129,4,'public','1.3.6.1.2.1.2.2.1.16.19',161,10007,'ifOutOctets19','ifOutOctets19',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17130,4,'public','1.3.6.1.2.1.2.2.1.16.20',161,10007,'ifOutOctets20','ifOutOctets20',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17131,4,'public','1.3.6.1.2.1.2.2.1.16.21',161,10007,'ifOutOctets21','ifOutOctets21',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17132,4,'public','1.3.6.1.2.1.2.2.1.16.22',161,10007,'ifOutOctets22','ifOutOctets22',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17133,4,'public','1.3.6.1.2.1.2.2.1.16.23',161,10007,'ifOutOctets23','ifOutOctets23',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17134,4,'public','1.3.6.1.2.1.2.2.1.16.24',161,10007,'ifOutOctets24','ifOutOctets24',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17135,4,'public','1.3.6.1.2.1.2.2.1.16.25',161,10007,'ifOutOctets25','ifOutOctets25',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17136,4,'public','1.3.6.1.2.1.2.2.1.16.26',161,10007,'ifOutOctets26','ifOutOctets26',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17137,4,'public','1.3.6.1.2.1.2.2.1.16.27',161,10007,'ifOutOctets27','ifOutOctets27',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17138,4,'public','1.3.6.1.2.1.2.2.1.16.28',161,10007,'ifOutOctets28','ifOutOctets28',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17139,4,'public','1.3.6.1.2.1.2.2.1.16.29',161,10007,'ifOutOctets29','ifOutOctets29',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17140,4,'public','1.3.6.1.2.1.2.2.1.16.30',161,10007,'ifOutOctets30','ifOutOctets30',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17141,4,'public','1.3.6.1.2.1.2.2.1.16.31',161,10007,'ifOutOctets31','ifOutOctets31',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17142,4,'public','1.3.6.1.2.1.2.2.1.16.32',161,10007,'ifOutOctets32','ifOutOctets32',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17143,4,'public','1.3.6.1.2.1.2.2.1.16.33',161,10007,'ifOutOctets33','ifOutOctets33',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17144,4,'public','1.3.6.1.2.1.2.2.1.16.34',161,10007,'ifOutOctets34','ifOutOctets34',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17145,4,'public','1.3.6.1.2.1.2.2.1.16.35',161,10007,'ifOutOctets35','ifOutOctets35',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17146,4,'public','1.3.6.1.2.1.2.2.1.16.36',161,10007,'ifOutOctets36','ifOutOctets36',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17147,4,'public','1.3.6.1.2.1.2.2.1.16.37',161,10007,'ifOutOctets37','ifOutOctets37',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17148,4,'public','1.3.6.1.2.1.2.2.1.16.38',161,10007,'ifOutOctets38','ifOutOctets38',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17149,4,'public','1.3.6.1.2.1.2.2.1.16.39',161,10007,'ifOutOctets39','ifOutOctets39',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17150,4,'public','1.3.6.1.2.1.2.2.1.16.40',161,10007,'ifOutOctets40','ifOutOctets40',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17151,4,'public','1.3.6.1.2.1.2.2.1.16.41',161,10007,'ifOutOctets41','ifOutOctets41',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17152,4,'public','1.3.6.1.2.1.2.2.1.16.42',161,10007,'ifOutOctets42','ifOutOctets42',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17153,4,'public','1.3.6.1.2.1.2.2.1.16.43',161,10007,'ifOutOctets43','ifOutOctets43',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17154,4,'public','1.3.6.1.2.1.2.2.1.16.44',161,10007,'ifOutOctets44','ifOutOctets44',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17155,4,'public','1.3.6.1.2.1.2.2.1.16.45',161,10007,'ifOutOctets45','ifOutOctets45',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17156,4,'public','1.3.6.1.2.1.2.2.1.16.46',161,10007,'ifOutOctets46','ifOutOctets46',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17157,4,'public','1.3.6.1.2.1.2.2.1.16.47',161,10007,'ifOutOctets47','ifOutOctets47',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17158,4,'public','1.3.6.1.2.1.2.2.1.16.48',161,10007,'ifOutOctets48','ifOutOctets48',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17159,4,'public','1.3.6.1.2.1.2.2.1.16.49',161,10007,'ifOutOctets49','ifOutOctets49',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17160,4,'public','1.3.6.1.2.1.2.2.1.16.50',161,10007,'ifOutOctets50','ifOutOctets50',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17161,4,'public','1.3.6.1.2.1.2.2.1.16.51',161,10007,'ifOutOctets51','ifOutOctets51',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17162,4,'public','1.3.6.1.2.1.4.1.0',161,10007,'ipForwarding','ipForwarding',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17163,4,'public','1.3.6.1.2.1.4.2.0',161,10007,'ipDefaultTTL','ipDefaultTTL',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17164,4,'public','1.3.6.1.2.1.4.3.0',161,10007,'ipInReceives','ipInReceives',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17165,4,'public','1.3.6.1.2.1.4.4.0',161,10007,'ipInHdrErrors','ipInHdrErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17166,4,'public','1.3.6.1.2.1.4.5.0',161,10007,'ipInAddrErrors','ipInAddrErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17167,4,'public','1.3.6.1.2.1.4.6.0',161,10007,'ipInForwDatagrams','ipInForwDatagrams',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17168,4,'public','1.3.6.1.2.1.4.7.0',161,10007,'ipInUnknownProtos','ipInUnknownProtos',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17169,4,'public','1.3.6.1.2.1.4.8.0',161,10007,'ipInDiscards','ipInDiscards',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17170,4,'public','1.3.6.1.2.1.4.9.0',161,10007,'ipInDelivers','ipInDelivers',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17171,4,'public','1.3.6.1.2.1.4.10.0',161,10007,'ipOutRequests','ipOutRequests',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17172,4,'public','1.3.6.1.2.1.4.11.0',161,10007,'ipOutDiscards','ipOutDiscards',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17173,4,'public','1.3.6.1.2.1.4.12.0',161,10007,'ipOutNoRoutes','ipOutNoRoutes',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17174,4,'public','1.3.6.1.2.1.4.13.0',161,10007,'ipReasmTimeout','ipReasmTimeout',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17175,4,'public','1.3.6.1.2.1.4.14.0',161,10007,'ipReasmReqds','ipReasmReqds',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17176,4,'public','1.3.6.1.2.1.4.15.0',161,10007,'ipReasmOKs','ipReasmOKs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17177,4,'public','1.3.6.1.2.1.4.16.0',161,10007,'ipReasmFails','ipReasmFails',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17178,4,'public','1.3.6.1.2.1.4.17.0',161,10007,'ipFragOKs','ipFragOKs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17179,4,'public','1.3.6.1.2.1.4.18.0',161,10007,'ipFragFails','ipFragFails',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17180,4,'public','1.3.6.1.2.1.4.19.0',161,10007,'ipFragCreates','ipFragCreates',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17181,4,'public','1.3.6.1.2.1.4.23.0',161,10007,'ipRoutingDiscards','ipRoutingDiscards',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17182,4,'public','1.3.6.1.2.1.5.1.0',161,10007,'icmpInMsgs','icmpInMsgs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17183,4,'public','1.3.6.1.2.1.5.2.0',161,10007,'icmpInErrors','icmpInErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17184,4,'public','1.3.6.1.2.1.5.3.0',161,10007,'icmpInDestUnreachs','icmpInDestUnreachs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17185,4,'public','1.3.6.1.2.1.5.4.0',161,10007,'icmpInTimeExcds','icmpInTimeExcds',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17186,4,'public','1.3.6.1.2.1.5.5.0',161,10007,'icmpInParmProbs','icmpInParmProbs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17187,4,'public','1.3.6.1.2.1.5.6.0',161,10007,'icmpInSrcQuenchs','icmpInSrcQuenchs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17188,4,'public','1.3.6.1.2.1.5.7.0',161,10007,'icmpInRedirects','icmpInRedirects',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17189,4,'public','1.3.6.1.2.1.5.8.0',161,10007,'icmpInEchos','icmpInEchos',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17190,4,'public','1.3.6.1.2.1.5.9.0',161,10007,'icmpInEchoReps','icmpInEchoReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17191,4,'public','1.3.6.1.2.1.5.10.0',161,10007,'icmpInTimestamps','icmpInTimestamps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17192,4,'public','1.3.6.1.2.1.5.11.0',161,10007,'icmpInTimestampReps','icmpInTimestampReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17193,4,'public','1.3.6.1.2.1.5.12.0',161,10007,'icmpInAddrMasks','icmpInAddrMasks',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17194,4,'public','1.3.6.1.2.1.5.13.0',161,10007,'icmpInAddrMaskReps','icmpInAddrMaskReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17195,4,'public','1.3.6.1.2.1.5.14.0',161,10007,'icmpOutMsgs','icmpOutMsgs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17196,4,'public','1.3.6.1.2.1.5.15.0',161,10007,'icmpOutErrors','icmpOutErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17197,4,'public','1.3.6.1.2.1.5.16.0',161,10007,'icmpOutDesUnreachs','icmpOutDesUnreachs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17198,4,'public','1.3.6.1.2.1.5.17.0',161,10007,'icmpOutTimeExcds','icmpOutTimeExcds',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17199,4,'public','1.3.6.1.2.1.5.18.0',161,10007,'icmpOutParmProbs','icmpOutParmProbs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17200,4,'public','1.3.6.1.2.1.5.19.0',161,10007,'icmpOutSrcQuenchs','icmpOutSrcQuenchs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17202,4,'public','1.3.6.1.2.1.5.21.0',161,10007,'icmpOutEchos','icmpOutEchos',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17203,4,'public','1.3.6.1.2.1.5.22.0',161,10007,'icmpOutEchoReps','icmpOutEchoReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17204,4,'public','1.3.6.1.2.1.5.23.0',161,10007,'icmpOutTimestamps','icmpOutTimestamps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17205,4,'public','1.3.6.1.2.1.5.24.0',161,10007,'icmpOutTimestampReps','icmpOutTimestampReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17206,4,'public','1.3.6.1.2.1.5.25.0',161,10007,'icmpOutAddrMasks','icmpOutAddrMasks',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17207,4,'public','1.3.6.1.2.1.5.26.0',161,10007,'icmpOutAddrMaskReps','icmpOutAddrMaskReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17208,4,'public','1.3.6.1.2.1.5.20.0',161,10007,'icmpOutRedirects','icmpOutRedirects',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','');
INSERT INTO items VALUES (17318,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Host boot time','system.boottime',300,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17320,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17322,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17324,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17326,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17328,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17330,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17332,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17334,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17336,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17338,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17340,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17342,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17344,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17346,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17348,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17350,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free swap space in %','system.swap.size[,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17352,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Host local time','system.localtime',30,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17354,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17356,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17358,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17360,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17362,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'CPU $2 time ($3)','system.cpu.util[,wait,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17371,3,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10004,'ICMP ping','icmpping',30,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,1,'','');
INSERT INTO items VALUES (17373,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10001,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17397,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10002,'Service state of DHCP client ($1)','service_state[Dhcp]',30,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,3,'','');
INSERT INTO items VALUES (17399,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10002,'Number of threads','perf_counter[\\System\\threads]',30,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17401,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10002,'File read bytes per second','perf_counter[\\System\\File Read Bytes/sec]',30,90,365,0,NULL,NULL,NULL,0,0,'','Bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17403,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10002,'File write bytes per second','perf_counter[\\System\\File Write Bytes/sec]',30,90,365,0,NULL,NULL,NULL,0,0,'','Bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17405,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10002,'Average disk read queue length','perf_counter[\\Physical Disk(_Total)\\Avg. Disk Read Queue Length]',30,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17409,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10002,'Average disk read queue length','perf_counter[\\PhysicalDisk(_Total)\\Avg. Disk Read QUeue Length]',30,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17411,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10002,'Average disk write queue length','perf_counter[\\PhysicalDisk(_Total)\\Avg. Disk Write Queue Length]',30,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17412,0,'','',161,10008,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17413,0,'','',161,10008,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17414,0,'','',161,10008,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17415,0,'','',161,10008,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17416,0,'','',161,10008,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17417,0,'','',161,10008,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17418,0,'','',161,10008,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17419,0,'','',161,10008,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17420,0,'','',161,10008,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17421,0,'','',161,10008,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17422,0,'','',161,10008,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17423,0,'','',161,10008,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17424,0,'','',161,10008,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17425,0,'','',161,10008,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17426,0,'','',161,10008,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17427,0,'','',161,10008,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17428,0,'','',161,10008,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17429,0,'','',161,10008,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17430,0,'','',161,10008,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17431,0,'','',161,10008,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17432,0,'','',161,10008,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17433,0,'','',161,10008,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17434,0,'','',161,10008,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17435,0,'','',161,10008,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17436,0,'','',161,10008,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17437,0,'','',161,10008,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17438,0,'','',161,10008,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17439,0,'','',161,10008,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17440,0,'','',161,10008,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17441,0,'','',161,10008,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17442,0,'','',161,10008,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','');
INSERT INTO items VALUES (17443,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Host boot time','system.boottime',300,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17444,0,'','',161,10008,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17445,0,'','',161,10008,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17446,0,'','',161,10008,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17447,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17448,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17449,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17450,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17451,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'CPU $2 time ($3)','system.cpu.util[,wait,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17452,0,'','',161,10008,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17453,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Host local time','system.localtime',30,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17454,0,'','',161,10008,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17455,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free swap space in %','system.swap.size[,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17456,0,'','',161,10008,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17457,0,'','',161,10008,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17458,0,'','',161,10008,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17459,0,'','',161,10008,'Number of users connected','system.users.num',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17460,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17461,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17462,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17463,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17464,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17465,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17466,0,'','',161,10008,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17467,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17468,0,'','',161,10008,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17469,0,'','',161,10008,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17470,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17471,0,'','',161,10008,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17472,0,'','',161,10008,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17473,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17474,0,'','',161,10008,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17475,0,'','',161,10008,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17476,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17477,0,'','',161,10008,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17478,0,'','',161,10008,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17479,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17480,0,'','',161,10008,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17481,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17482,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17483,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17484,0,'','',161,10008,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17485,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17486,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17487,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17488,0,'','',161,10008,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17489,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17490,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17491,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17492,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17493,0,'','',161,10008,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17494,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17495,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17496,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17497,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17498,0,'','',161,10008,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17499,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17500,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17501,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17502,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17503,0,'','',161,10008,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17504,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17505,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17506,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17507,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10008,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17508,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,0,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17509,0,'','',161,10008,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17510,0,'','',161,10008,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17511,0,'','',161,10008,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17512,0,'','',161,10008,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17513,0,'','',161,10008,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17514,0,'','',161,10009,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17515,0,'','',161,10009,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17516,0,'','',161,10009,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17517,0,'','',161,10009,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17518,0,'','',161,10009,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17519,0,'','',161,10009,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17520,0,'','',161,10009,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17521,0,'','',161,10009,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17522,0,'','',161,10009,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17523,0,'','',161,10009,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17524,0,'','',161,10009,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17525,0,'','',161,10009,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17526,0,'','',161,10009,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17527,0,'','',161,10009,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17528,0,'','',161,10009,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17529,0,'','',161,10009,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17530,0,'','',161,10009,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17531,0,'','',161,10009,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17532,0,'','',161,10009,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17533,0,'','',161,10009,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17534,0,'','',161,10009,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17535,0,'','',161,10009,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17536,0,'','',161,10009,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17537,0,'','',161,10009,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17538,0,'','',161,10009,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17539,0,'','',161,10009,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17540,0,'','',161,10009,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17541,0,'','',161,10009,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17542,0,'','',161,10009,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17543,0,'','',161,10009,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17544,0,'','',161,10009,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','');
INSERT INTO items VALUES (17545,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Host boot time','system.boottime',300,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17546,0,'','',161,10009,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17547,0,'','',161,10009,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17548,0,'','',161,10009,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17549,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17550,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17551,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17552,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17553,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'CPU $2 time ($3)','system.cpu.util[,wait,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17554,0,'','',161,10009,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17555,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Host local time','system.localtime',30,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17556,0,'','',161,10009,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17557,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free swap space in %','system.swap.size[,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17558,0,'','',161,10009,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17559,0,'','',161,10009,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17560,0,'','',161,10009,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17561,0,'','',161,10009,'Number of users connected','system.users.num',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17562,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17563,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17564,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17565,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17566,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17567,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17568,0,'','',161,10009,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17569,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17570,0,'','',161,10009,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17571,0,'','',161,10009,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17572,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17573,0,'','',161,10009,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17574,0,'','',161,10009,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17575,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17576,0,'','',161,10009,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17577,0,'','',161,10009,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17578,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17579,0,'','',161,10009,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17580,0,'','',161,10009,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17581,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17582,0,'','',161,10009,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17583,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17584,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17585,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17586,0,'','',161,10009,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17587,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17588,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17589,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17590,0,'','',161,10009,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17591,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17592,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17593,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17594,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17595,0,'','',161,10009,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17596,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17597,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17598,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17599,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17600,0,'','',161,10009,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17601,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17602,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17603,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17604,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17605,0,'','',161,10009,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17606,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17607,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17608,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17609,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10009,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17610,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,0,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17611,0,'','',161,10009,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17612,0,'','',161,10009,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17613,0,'','',161,10009,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17614,0,'','',161,10009,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17615,0,'','',161,10009,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17616,0,'','',161,10010,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17617,0,'','',161,10010,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17618,0,'','',161,10010,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17619,0,'','',161,10010,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17620,0,'','',161,10010,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17621,0,'','',161,10010,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17622,0,'','',161,10010,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17623,0,'','',161,10010,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17624,0,'','',161,10010,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17625,0,'','',161,10010,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17626,0,'','',161,10010,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17627,0,'','',161,10010,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17628,0,'','',161,10010,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17629,0,'','',161,10010,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17630,0,'','',161,10010,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17631,0,'','',161,10010,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17632,0,'','',161,10010,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17633,0,'','',161,10010,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17634,0,'','',161,10010,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17635,0,'','',161,10010,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17636,0,'','',161,10010,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17637,0,'','',161,10010,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17638,0,'','',161,10010,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17639,0,'','',161,10010,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17640,0,'','',161,10010,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17641,0,'','',161,10010,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17642,0,'','',161,10010,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17643,0,'','',161,10010,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17644,0,'','',161,10010,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17645,0,'','',161,10010,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17646,0,'','',161,10010,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','');
INSERT INTO items VALUES (17647,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Host boot time','system.boottime',300,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17648,0,'','',161,10010,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17649,0,'','',161,10010,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17650,0,'','',161,10010,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17651,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17652,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17653,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17654,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17655,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'CPU $2 time ($3)','system.cpu.util[,wait,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17656,0,'','',161,10010,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17657,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Host local time','system.localtime',30,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17658,0,'','',161,10010,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17659,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free swap space in %','system.swap.size[,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17660,0,'','',161,10010,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17661,0,'','',161,10010,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17662,0,'','',161,10010,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17663,0,'','',161,10010,'Number of users connected','system.users.num',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17664,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17665,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17666,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17667,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17668,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17669,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17670,0,'','',161,10010,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17671,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17672,0,'','',161,10010,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17673,0,'','',161,10010,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17674,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17675,0,'','',161,10010,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17676,0,'','',161,10010,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17677,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17678,0,'','',161,10010,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17679,0,'','',161,10010,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17680,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17681,0,'','',161,10010,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17682,0,'','',161,10010,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17683,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17684,0,'','',161,10010,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17685,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17686,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17687,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17688,0,'','',161,10010,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17689,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17690,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17691,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17692,0,'','',161,10010,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17693,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17694,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17695,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17696,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17697,0,'','',161,10010,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17698,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17699,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17700,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17701,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17702,0,'','',161,10010,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17703,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17704,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17705,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17706,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17707,0,'','',161,10010,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17708,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17709,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17710,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17711,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10010,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17712,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,0,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17713,0,'','',161,10010,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17714,0,'','',161,10010,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17715,0,'','',161,10010,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17716,0,'','',161,10010,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17717,0,'','',161,10010,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17718,0,'','',161,10011,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17719,0,'','',161,10011,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17720,0,'','',161,10011,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17721,0,'','',161,10011,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17722,0,'','',161,10011,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17723,0,'','',161,10011,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17724,0,'','',161,10011,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17725,0,'','',161,10011,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17726,0,'','',161,10011,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17727,0,'','',161,10011,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17728,0,'','',161,10011,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17729,0,'','',161,10011,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17730,0,'','',161,10011,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17731,0,'','',161,10011,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17732,0,'','',161,10011,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17733,0,'','',161,10011,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17734,0,'','',161,10011,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17735,0,'','',161,10011,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17736,0,'','',161,10011,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17737,0,'','',161,10011,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17738,0,'','',161,10011,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17739,0,'','',161,10011,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17740,0,'','',161,10011,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17741,0,'','',161,10011,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17742,0,'','',161,10011,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17743,0,'','',161,10011,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17744,0,'','',161,10011,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17745,0,'','',161,10011,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17746,0,'','',161,10011,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17747,0,'','',161,10011,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17748,0,'','',161,10011,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','');
INSERT INTO items VALUES (17749,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Host boot time','system.boottime',300,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17750,0,'','',161,10011,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17751,0,'','',161,10011,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17752,0,'','',161,10011,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17753,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17754,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17755,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17756,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17757,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'CPU $2 time ($3)','system.cpu.util[,wait,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17758,0,'','',161,10011,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17759,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Host local time','system.localtime',30,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17760,0,'','',161,10011,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17761,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free swap space in %','system.swap.size[,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17762,0,'','',161,10011,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17763,0,'','',161,10011,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17764,0,'','',161,10011,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17765,0,'','',161,10011,'Number of users connected','system.users.num',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17766,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17767,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17768,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17769,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17770,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17771,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17772,0,'','',161,10011,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17773,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17774,0,'','',161,10011,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17775,0,'','',161,10011,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17776,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17777,0,'','',161,10011,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17778,0,'','',161,10011,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17779,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17780,0,'','',161,10011,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17781,0,'','',161,10011,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17782,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17783,0,'','',161,10011,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17784,0,'','',161,10011,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17785,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17786,0,'','',161,10011,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17787,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17788,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17789,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17790,0,'','',161,10011,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17791,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17792,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17793,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17794,0,'','',161,10011,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17795,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17796,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17797,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17798,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17799,0,'','',161,10011,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17800,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17801,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17802,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17803,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17804,0,'','',161,10011,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17805,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17806,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17807,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17808,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17809,0,'','',161,10011,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17810,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17811,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17812,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17813,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10011,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17814,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,0,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17815,0,'','',161,10011,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17816,0,'','',161,10011,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17817,0,'','',161,10011,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17818,0,'','',161,10011,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17819,0,'','',161,10011,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17820,0,'','',161,10012,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17821,0,'','',161,10012,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17822,0,'','',161,10012,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17823,0,'','',161,10012,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17824,0,'','',161,10012,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17825,0,'','',161,10012,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17826,0,'','',161,10012,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17827,0,'','',161,10012,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17828,0,'','',161,10012,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17829,0,'','',161,10012,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17830,0,'','',161,10012,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17831,0,'','',161,10012,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17832,0,'','',161,10012,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17833,0,'','',161,10012,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17834,0,'','',161,10012,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17835,0,'','',161,10012,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17836,0,'','',161,10012,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17837,0,'','',161,10012,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17838,0,'','',161,10012,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17839,0,'','',161,10012,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17840,0,'','',161,10012,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17841,0,'','',161,10012,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17842,0,'','',161,10012,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17843,0,'','',161,10012,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17844,0,'','',161,10012,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17845,0,'','',161,10012,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17846,0,'','',161,10012,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17847,0,'','',161,10012,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17848,0,'','',161,10012,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17849,0,'','',161,10012,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17850,0,'','',161,10012,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','');
INSERT INTO items VALUES (17851,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Host boot time','system.boottime',300,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17852,0,'','',161,10012,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17853,0,'','',161,10012,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17854,0,'','',161,10012,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17855,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17856,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17857,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17858,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17859,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'CPU $2 time ($3)','system.cpu.util[,wait,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17860,0,'','',161,10012,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17861,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Host local time','system.localtime',30,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17862,0,'','',161,10012,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17863,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free swap space in %','system.swap.size[,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17864,0,'','',161,10012,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17865,0,'','',161,10012,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17866,0,'','',161,10012,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17867,0,'','',161,10012,'Number of users connected','system.users.num',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17868,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17869,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17870,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17871,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17872,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17873,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17874,0,'','',161,10012,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17875,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17876,0,'','',161,10012,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17877,0,'','',161,10012,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17878,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17879,0,'','',161,10012,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17880,0,'','',161,10012,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17881,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17882,0,'','',161,10012,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17883,0,'','',161,10012,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17884,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17885,0,'','',161,10012,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17886,0,'','',161,10012,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17887,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17888,0,'','',161,10012,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17889,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17890,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17891,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17892,0,'','',161,10012,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17893,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17894,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17895,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17896,0,'','',161,10012,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17897,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17898,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17899,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17900,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17901,0,'','',161,10012,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17902,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17903,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17904,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17905,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17906,0,'','',161,10012,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17907,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17908,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17909,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17910,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17911,0,'','',161,10012,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17912,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17913,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17914,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17915,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10012,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17916,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,0,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17917,0,'','',161,10012,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17918,0,'','',161,10012,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17919,0,'','',161,10012,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17920,0,'','',161,10012,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17921,0,'','',161,10012,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17922,0,'','',161,10013,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17923,0,'','',161,10013,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17924,0,'','',161,10013,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17925,0,'','',161,10013,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17926,0,'','',161,10013,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17927,0,'','',161,10013,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17928,0,'','',161,10013,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17929,0,'','',161,10013,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17930,0,'','',161,10013,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17931,0,'','',161,10013,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17932,0,'','',161,10013,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17933,0,'','',161,10013,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17934,0,'','',161,10013,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17935,0,'','',161,10013,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17936,0,'','',161,10013,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17937,0,'','',161,10013,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17938,0,'','',161,10013,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17939,0,'','',161,10013,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (17940,0,'','',161,10013,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17941,0,'','',161,10013,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17942,0,'','',161,10013,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17943,0,'','',161,10013,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17944,0,'','',161,10013,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17945,0,'','',161,10013,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17946,0,'','',161,10013,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17947,0,'','',161,10013,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17948,0,'','',161,10013,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17949,0,'','',161,10013,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17950,0,'','',161,10013,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17951,0,'','',161,10013,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17952,0,'','',161,10013,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','');
INSERT INTO items VALUES (17953,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Host boot time','system.boottime',300,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17954,0,'','',161,10013,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17955,0,'','',161,10013,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17956,0,'','',161,10013,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17957,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17958,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17959,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17960,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17961,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'CPU $2 time ($3)','system.cpu.util[,wait,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17962,0,'','',161,10013,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17963,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Host local time','system.localtime',30,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17964,0,'','',161,10013,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17965,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free swap space in %','system.swap.size[,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17966,0,'','',161,10013,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17967,0,'','',161,10013,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17968,0,'','',161,10013,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17969,0,'','',161,10013,'Number of users connected','system.users.num',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17970,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17971,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17972,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17973,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17974,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17975,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17976,0,'','',161,10013,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17977,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17978,0,'','',161,10013,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17979,0,'','',161,10013,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17980,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17981,0,'','',161,10013,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17982,0,'','',161,10013,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17983,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17984,0,'','',161,10013,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17985,0,'','',161,10013,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17986,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17987,0,'','',161,10013,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17988,0,'','',161,10013,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17989,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17990,0,'','',161,10013,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (17991,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17992,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17993,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17994,0,'','',161,10013,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17995,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17996,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17997,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (17998,0,'','',161,10013,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (17999,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18000,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18001,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18002,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18003,0,'','',161,10013,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18004,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18005,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18006,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18007,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18008,0,'','',161,10013,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18009,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18010,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18011,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18012,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18013,0,'','',161,10013,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18014,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18015,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18016,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18017,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10013,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18018,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,0,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18019,0,'','',161,10013,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18020,0,'','',161,10013,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18021,0,'','',161,10013,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18022,0,'','',161,10013,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18023,0,'','',161,10013,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18024,0,'','',161,10014,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18025,0,'','',161,10014,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18026,0,'','',161,10014,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18027,0,'','',161,10014,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18028,0,'','',161,10014,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18029,0,'','',161,10014,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18030,0,'','',161,10014,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18031,0,'','',161,10014,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18032,0,'','',161,10014,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18033,0,'','',161,10014,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18034,0,'','',161,10014,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18035,0,'','',161,10014,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18036,0,'','',161,10014,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18037,0,'','',161,10014,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18038,0,'','',161,10014,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18039,0,'','',161,10014,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18040,0,'','',161,10014,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18041,0,'','',161,10014,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18042,0,'','',161,10014,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18043,0,'','',161,10014,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18044,0,'','',161,10014,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18045,0,'','',161,10014,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18046,0,'','',161,10014,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18047,0,'','',161,10014,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18048,0,'','',161,10014,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18049,0,'','',161,10014,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18050,0,'','',161,10014,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18051,0,'','',161,10014,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18052,0,'','',161,10014,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18053,0,'','',161,10014,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18054,0,'','',161,10014,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','');
INSERT INTO items VALUES (18055,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Host boot time','system.boottime',300,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18056,0,'','',161,10014,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18057,0,'','',161,10014,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18058,0,'','',161,10014,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18059,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18060,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18061,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18062,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18063,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'CPU $2 time ($3)','system.cpu.util[,wait,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18064,0,'','',161,10014,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18065,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Host local time','system.localtime',30,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18066,0,'','',161,10014,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18067,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free swap space in %','system.swap.size[,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18068,0,'','',161,10014,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18069,0,'','',161,10014,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18070,0,'','',161,10014,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18071,0,'','',161,10014,'Number of users connected','system.users.num',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18072,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18073,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18074,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18075,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18076,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18077,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18078,0,'','',161,10014,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18079,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18080,0,'','',161,10014,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18081,0,'','',161,10014,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18082,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18083,0,'','',161,10014,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18084,0,'','',161,10014,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18085,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18086,0,'','',161,10014,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18087,0,'','',161,10014,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18088,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18089,0,'','',161,10014,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18090,0,'','',161,10014,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18091,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18092,0,'','',161,10014,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18093,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18094,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18095,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18096,0,'','',161,10014,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18097,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18098,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18099,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18100,0,'','',161,10014,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18101,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18102,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18103,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18104,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18105,0,'','',161,10014,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18106,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18107,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18108,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18109,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18110,0,'','',161,10014,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18111,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18112,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18113,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18114,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18115,0,'','',161,10014,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18116,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18117,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18118,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18119,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10014,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18120,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,0,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18121,0,'','',161,10014,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18122,0,'','',161,10014,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18123,0,'','',161,10014,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18124,0,'','',161,10014,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18125,0,'','',161,10014,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18126,0,'','',161,10015,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18127,0,'','',161,10015,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18128,0,'','',161,10015,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18129,0,'','',161,10015,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18130,0,'','',161,10015,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18131,0,'','',161,10015,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18132,0,'','',161,10015,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18133,0,'','',161,10015,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18134,0,'','',161,10015,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18135,0,'','',161,10015,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18136,0,'','',161,10015,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18137,0,'','',161,10015,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18138,0,'','',161,10015,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18139,0,'','',161,10015,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18140,0,'','',161,10015,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18141,0,'','',161,10015,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18142,0,'','',161,10015,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18143,0,'','',161,10015,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','');
INSERT INTO items VALUES (18144,0,'','',161,10015,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18145,0,'','',161,10015,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18146,0,'','',161,10015,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18147,0,'','',161,10015,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18148,0,'','',161,10015,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18149,0,'','',161,10015,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18150,0,'','',161,10015,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18151,0,'','',161,10015,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18152,0,'','',161,10015,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18153,0,'','',161,10015,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18154,0,'','',161,10015,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18155,0,'','',161,10015,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18156,0,'','',161,10015,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','');
INSERT INTO items VALUES (18157,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Host boot time','system.boottime',300,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18158,0,'','',161,10015,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18159,0,'','',161,10015,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18160,0,'','',161,10015,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18161,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18162,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18163,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18164,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18165,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'CPU $2 time ($3)','system.cpu.util[,wait,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18166,0,'','',161,10015,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18167,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Host local time','system.localtime',30,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18168,0,'','',161,10015,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18169,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free swap space in %','system.swap.size[,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18170,0,'','',161,10015,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18171,0,'','',161,10015,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18172,0,'','',161,10015,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18173,0,'','',161,10015,'Number of users connected','system.users.num',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18174,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18175,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18176,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18177,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18178,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18179,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18180,0,'','',161,10015,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18181,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18182,0,'','',161,10015,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18183,0,'','',161,10015,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18184,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18185,0,'','',161,10015,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18186,0,'','',161,10015,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18187,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18188,0,'','',161,10015,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18189,0,'','',161,10015,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18190,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18191,0,'','',161,10015,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18192,0,'','',161,10015,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18193,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18194,0,'','',161,10015,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18195,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18196,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18197,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18198,0,'','',161,10015,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18199,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18200,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18201,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18202,0,'','',161,10015,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18203,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18204,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18205,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18206,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18207,0,'','',161,10015,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18208,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18209,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18210,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18211,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18212,0,'','',161,10015,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18213,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18214,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18215,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18216,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18217,0,'','',161,10015,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18218,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18219,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18220,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18221,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10015,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18222,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,0,'','B',1,0,NULL,'',0,'','','1024','',0,'',0,0,'','');
INSERT INTO items VALUES (18223,0,'','',161,10015,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18224,0,'','',161,10015,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18225,0,'','',161,10015,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18226,0,'','',161,10015,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18227,0,'','',161,10015,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18228,1,'public','1.3.6.1.2.1.5.13.0',161,10016,'icmpInAddrMaskReps','icmpInAddrMaskReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18229,1,'public','1.3.6.1.2.1.5.12.0',161,10016,'icmpInAddrMasks','icmpInAddrMasks',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18230,1,'public','1.3.6.1.2.1.5.3.0',161,10016,'icmpInDestUnreachs','icmpInDestUnreachs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18231,1,'public','1.3.6.1.2.1.5.9.0',161,10016,'icmpInEchoReps','icmpInEchoReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18232,1,'public','1.3.6.1.2.1.5.8.0',161,10016,'icmpInEchos','icmpInEchos',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18233,1,'public','1.3.6.1.2.1.5.2.0',161,10016,'icmpInErrors','icmpInErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18234,1,'public','1.3.6.1.2.1.5.1.0',161,10016,'icmpInMsgs','icmpInMsgs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18235,1,'public','1.3.6.1.2.1.5.5.0',161,10016,'icmpInParmProbs','icmpInParmProbs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18236,1,'public','1.3.6.1.2.1.5.7.0',161,10016,'icmpInRedirects','icmpInRedirects',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18237,1,'public','1.3.6.1.2.1.5.6.0',161,10016,'icmpInSrcQuenchs','icmpInSrcQuenchs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18238,1,'public','1.3.6.1.2.1.5.4.0',161,10016,'icmpInTimeExcds','icmpInTimeExcds',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18239,1,'public','1.3.6.1.2.1.5.11.0',161,10016,'icmpInTimestampReps','icmpInTimestampReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18240,1,'public','1.3.6.1.2.1.5.10.0',161,10016,'icmpInTimestamps','icmpInTimestamps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18241,1,'public','1.3.6.1.2.1.5.26.0',161,10016,'icmpOutAddrMaskReps','icmpOutAddrMaskReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18242,1,'public','1.3.6.1.2.1.5.25.0',161,10016,'icmpOutAddrMasks','icmpOutAddrMasks',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18243,1,'public','1.3.6.1.2.1.5.16.0',161,10016,'icmpOutDesUnreachs','icmpOutDesUnreachs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18244,1,'public','1.3.6.1.2.1.5.22.0',161,10016,'icmpOutEchoReps','icmpOutEchoReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18245,1,'public','1.3.6.1.2.1.5.21.0',161,10016,'icmpOutEchos','icmpOutEchos',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18246,1,'public','1.3.6.1.2.1.5.15.0',161,10016,'icmpOutErrors','icmpOutErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18247,1,'public','1.3.6.1.2.1.5.14.0',161,10016,'icmpOutMsgs','icmpOutMsgs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18248,1,'public','1.3.6.1.2.1.5.18.0',161,10016,'icmpOutParmProbs','icmpOutParmProbs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18249,1,'public','1.3.6.1.2.1.5.20.0',161,10016,'icmpOutRedirects','icmpOutRedirects',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18250,1,'public','1.3.6.1.2.1.5.19.0',161,10016,'icmpOutSrcQuenchs','icmpOutSrcQuenchs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18251,1,'public','1.3.6.1.2.1.5.17.0',161,10016,'icmpOutTimeExcds','icmpOutTimeExcds',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18252,1,'public','1.3.6.1.2.1.5.24.0',161,10016,'icmpOutTimestampReps','icmpOutTimestampReps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18253,1,'public','1.3.6.1.2.1.5.23.0',161,10016,'icmpOutTimestamps','icmpOutTimestamps',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18254,1,'public','1.3.6.1.2.1.2.2.1.2.1',161,10016,'ifDescr1','ifDescr1',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18255,1,'public','1.3.6.1.2.1.2.2.1.2.10',161,10016,'ifDescr10','ifDescr10',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18256,1,'public','1.3.6.1.2.1.2.2.1.2.11',161,10016,'ifDescr11','ifDescr11',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18257,1,'public','1.3.6.1.2.1.2.2.1.2.12',161,10016,'ifDescr12','ifDescr12',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18258,1,'public','1.3.6.1.2.1.2.2.1.2.13',161,10016,'ifDescr13','ifDescr13',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18259,1,'public','1.3.6.1.2.1.2.2.1.2.14',161,10016,'ifDescr14','ifDescr14',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18260,1,'public','1.3.6.1.2.1.2.2.1.2.15',161,10016,'ifDescr15','ifDescr15',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18261,1,'public','1.3.6.1.2.1.2.2.1.2.16',161,10016,'ifDescr16','ifDescr16',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18262,1,'public','1.3.6.1.2.1.2.2.1.2.17',161,10016,'ifDescr17','ifDescr17',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18263,1,'public','1.3.6.1.2.1.2.2.1.2.18',161,10016,'ifDescr18','ifDescr18',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18264,1,'public','1.3.6.1.2.1.2.2.1.2.19',161,10016,'ifDescr19','ifDescr19',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18265,1,'public','1.3.6.1.2.1.2.2.1.2.2',161,10016,'ifDescr2','ifDescr2',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18266,1,'public','1.3.6.1.2.1.2.2.1.2.20',161,10016,'ifDescr20','ifDescr20',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18267,1,'public','1.3.6.1.2.1.2.2.1.2.21',161,10016,'ifDescr21','ifDescr21',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18268,1,'public','1.3.6.1.2.1.2.2.1.2.22',161,10016,'ifDescr22','ifDescr22',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18269,1,'public','1.3.6.1.2.1.2.2.1.2.23',161,10016,'ifDescr23','ifDescr23',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18270,1,'public','1.3.6.1.2.1.2.2.1.2.24',161,10016,'ifDescr24','ifDescr24',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18271,1,'public','1.3.6.1.2.1.2.2.1.2.25',161,10016,'ifDescr25','ifDescr25',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18272,1,'public','1.3.6.1.2.1.2.2.1.2.26',161,10016,'ifDescr26','ifDescr26',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18273,1,'public','1.3.6.1.2.1.2.2.1.2.27',161,10016,'ifDescr27','ifDescr27',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18274,1,'public','1.3.6.1.2.1.2.2.1.2.28',161,10016,'ifDescr28','ifDescr28',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18275,1,'public','1.3.6.1.2.1.2.2.1.2.29',161,10016,'ifDescr29','ifDescr29',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18276,1,'public','1.3.6.1.2.1.2.2.1.2.3',161,10016,'ifDescr3','ifDescr3',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18277,1,'public','1.3.6.1.2.1.2.2.1.2.30',161,10016,'ifDescr30','ifDescr30',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18278,1,'public','1.3.6.1.2.1.2.2.1.2.31',161,10016,'ifDescr31','ifDescr31',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18279,1,'public','1.3.6.1.2.1.2.2.1.2.32',161,10016,'ifDescr32','ifDescr32',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18280,1,'public','1.3.6.1.2.1.2.2.1.2.33',161,10016,'ifDescr33','ifDescr33',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18281,1,'public','1.3.6.1.2.1.2.2.1.2.34',161,10016,'ifDescr34','ifDescr34',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18282,1,'public','1.3.6.1.2.1.2.2.1.2.35',161,10016,'ifDescr35','ifDescr35',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18283,1,'public','1.3.6.1.2.1.2.2.1.2.36',161,10016,'ifDescr36','ifDescr36',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18284,1,'public','1.3.6.1.2.1.2.2.1.2.37',161,10016,'ifDescr37','ifDescr37',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18285,1,'public','1.3.6.1.2.1.2.2.1.2.38',161,10016,'ifDescr38','ifDescr38',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18286,1,'public','1.3.6.1.2.1.2.2.1.2.39',161,10016,'ifDescr39','ifDescr39',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18287,1,'public','1.3.6.1.2.1.2.2.1.2.4',161,10016,'ifDescr4','ifDescr4',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18288,1,'public','1.3.6.1.2.1.2.2.1.2.40',161,10016,'ifDescr40','ifDescr40',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18289,1,'public','1.3.6.1.2.1.2.2.1.2.41',161,10016,'ifDescr41','ifDescr41',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18290,1,'public','1.3.6.1.2.1.2.2.1.2.42',161,10016,'ifDescr42','ifDescr42',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18291,1,'public','1.3.6.1.2.1.2.2.1.2.43',161,10016,'ifDescr43','ifDescr43',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18292,1,'public','1.3.6.1.2.1.2.2.1.2.44',161,10016,'ifDescr44','ifDescr44',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18293,1,'public','1.3.6.1.2.1.2.2.1.2.45',161,10016,'ifDescr45','ifDescr45',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18294,1,'public','1.3.6.1.2.1.2.2.1.2.46',161,10016,'ifDescr46','ifDescr46',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18295,1,'public','1.3.6.1.2.1.2.2.1.2.47',161,10016,'ifDescr47','ifDescr47',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18296,1,'public','1.3.6.1.2.1.2.2.1.2.48',161,10016,'ifDescr48','ifDescr48',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18297,1,'public','1.3.6.1.2.1.2.2.1.2.49',161,10016,'ifDescr49','ifDescr49',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18298,1,'public','1.3.6.1.2.1.2.2.1.2.5',161,10016,'ifDescr5','ifDescr5',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18299,1,'public','1.3.6.1.2.1.2.2.1.2.50',161,10016,'ifDescr50','ifDescr50',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18300,1,'public','1.3.6.1.2.1.2.2.1.2.51',161,10016,'ifDescr51','ifDescr51',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18301,1,'public','1.3.6.1.2.1.2.2.1.2.6',161,10016,'ifDescr6','ifDescr6',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18302,1,'public','1.3.6.1.2.1.2.2.1.2.7',161,10016,'ifDescr7','ifDescr7',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18303,1,'public','1.3.6.1.2.1.2.2.1.2.8',161,10016,'ifDescr8','ifDescr8',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18304,1,'public','1.3.6.1.2.1.2.2.1.2.9',161,10016,'ifDescr9','ifDescr9',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18305,1,'public','1.3.6.1.2.1.2.2.1.10.1',161,10016,'ifInOctets1','ifInOctets1',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18306,1,'public','1.3.6.1.2.1.2.2.1.10.10',161,10016,'ifInOctets10','ifInOctets10',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18307,1,'public','1.3.6.1.2.1.2.2.1.10.11',161,10016,'ifInOctets11','ifInOctets11',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18308,1,'public','1.3.6.1.2.1.2.2.1.10.12',161,10016,'ifInOctets12','ifInOctets12',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18309,1,'public','1.3.6.1.2.1.2.2.1.10.13',161,10016,'ifInOctets13','ifInOctets13',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18310,1,'public','1.3.6.1.2.1.2.2.1.10.14',161,10016,'ifInOctets14','ifInOctets14',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18311,1,'public','1.3.6.1.2.1.2.2.1.10.15',161,10016,'ifInOctets15','ifInOctets15',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18312,1,'public','1.3.6.1.2.1.2.2.1.10.16',161,10016,'ifInOctets16','ifInOctets16',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18313,1,'public','1.3.6.1.2.1.2.2.1.10.17',161,10016,'ifInOctets17','ifInOctets17',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18314,1,'public','1.3.6.1.2.1.2.2.1.10.18',161,10016,'ifInOctets18','ifInOctets18',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18315,1,'public','1.3.6.1.2.1.2.2.1.10.19',161,10016,'ifInOctets19','ifInOctets19',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18316,1,'public','1.3.6.1.2.1.2.2.1.10.2',161,10016,'ifInOctets2','ifInOctets2',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18317,1,'public','1.3.6.1.2.1.2.2.1.10.20',161,10016,'ifInOctets20','ifInOctets20',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18318,1,'public','1.3.6.1.2.1.2.2.1.10.21',161,10016,'ifInOctets21','ifInOctets21',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18319,1,'public','1.3.6.1.2.1.2.2.1.10.22',161,10016,'ifInOctets22','ifInOctets22',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18320,1,'public','1.3.6.1.2.1.2.2.1.10.23',161,10016,'ifInOctets23','ifInOctets23',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18321,1,'public','1.3.6.1.2.1.2.2.1.10.24',161,10016,'ifInOctets24','ifInOctets24',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18322,1,'public','1.3.6.1.2.1.2.2.1.10.25',161,10016,'ifInOctets25','ifInOctets25',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18323,1,'public','1.3.6.1.2.1.2.2.1.10.26',161,10016,'ifInOctets26','ifInOctets26',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18324,1,'public','1.3.6.1.2.1.2.2.1.10.27',161,10016,'ifInOctets27','ifInOctets27',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18325,1,'public','1.3.6.1.2.1.2.2.1.10.28',161,10016,'ifInOctets28','ifInOctets28',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18326,1,'public','1.3.6.1.2.1.2.2.1.10.29',161,10016,'ifInOctets29','ifInOctets29',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18327,1,'public','1.3.6.1.2.1.2.2.1.10.3',161,10016,'ifInOctets3','ifInOctets3',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18328,1,'public','1.3.6.1.2.1.2.2.1.10.30',161,10016,'ifInOctets30','ifInOctets30',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18329,1,'public','1.3.6.1.2.1.2.2.1.10.31',161,10016,'ifInOctets31','ifInOctets31',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18330,1,'public','1.3.6.1.2.1.2.2.1.10.32',161,10016,'ifInOctets32','ifInOctets32',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18331,1,'public','1.3.6.1.2.1.2.2.1.10.33',161,10016,'ifInOctets33','ifInOctets33',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18332,1,'public','1.3.6.1.2.1.2.2.1.10.34',161,10016,'ifInOctets34','ifInOctets34',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18333,1,'public','1.3.6.1.2.1.2.2.1.10.35',161,10016,'ifInOctets35','ifInOctets35',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18334,1,'public','1.3.6.1.2.1.2.2.1.10.36',161,10016,'ifInOctets36','ifInOctets36',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18335,1,'public','1.3.6.1.2.1.2.2.1.10.37',161,10016,'ifInOctets37','ifInOctets37',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18336,1,'public','1.3.6.1.2.1.2.2.1.10.38',161,10016,'ifInOctets38','ifInOctets38',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18337,1,'public','1.3.6.1.2.1.2.2.1.10.39',161,10016,'ifInOctets39','ifInOctets39',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18338,1,'public','1.3.6.1.2.1.2.2.1.10.4',161,10016,'ifInOctets4','ifInOctets4',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18339,1,'public','1.3.6.1.2.1.2.2.1.10.40',161,10016,'ifInOctets40','ifInOctets40',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18340,1,'public','1.3.6.1.2.1.2.2.1.10.41',161,10016,'ifInOctets41','ifInOctets41',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18341,1,'public','1.3.6.1.2.1.2.2.1.10.42',161,10016,'ifInOctets42','ifInOctets42',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18342,1,'public','1.3.6.1.2.1.2.2.1.10.43',161,10016,'ifInOctets43','ifInOctets43',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18343,1,'public','1.3.6.1.2.1.2.2.1.10.44',161,10016,'ifInOctets44','ifInOctets44',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18344,1,'public','1.3.6.1.2.1.2.2.1.10.45',161,10016,'ifInOctets45','ifInOctets45',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18345,1,'public','1.3.6.1.2.1.2.2.1.10.46',161,10016,'ifInOctets46','ifInOctets46',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18346,1,'public','1.3.6.1.2.1.2.2.1.10.47',161,10016,'ifInOctets47','ifInOctets47',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18347,1,'public','1.3.6.1.2.1.2.2.1.10.48',161,10016,'ifInOctets48','ifInOctets48',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18348,1,'public','1.3.6.1.2.1.2.2.1.10.49',161,10016,'ifInOctets49','ifInOctets49',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18349,1,'public','1.3.6.1.2.1.2.2.1.10.5',161,10016,'ifInOctets5','ifInOctets5',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18350,1,'public','1.3.6.1.2.1.2.2.1.10.50',161,10016,'ifInOctets50','ifInOctets50',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18351,1,'public','1.3.6.1.2.1.2.2.1.10.51',161,10016,'ifInOctets51','ifInOctets51',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18352,1,'public','1.3.6.1.2.1.2.2.1.10.6',161,10016,'ifInOctets6','ifInOctets6',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18353,1,'public','1.3.6.1.2.1.2.2.1.10.7',161,10016,'ifInOctets7','ifInOctets7',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18354,1,'public','1.3.6.1.2.1.2.2.1.10.8',161,10016,'ifInOctets8','ifInOctets8',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18355,1,'public','1.3.6.1.2.1.2.2.1.10.9',161,10016,'ifInOctets9','ifInOctets9',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18356,1,'public','1.3.6.1.2.1.2.2.1.16.1',161,10016,'ifOutOctets1','ifOutOctets1',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18357,1,'public','1.3.6.1.2.1.2.2.1.16.10',161,10016,'ifOutOctets10','ifOutOctets10',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18358,1,'public','1.3.6.1.2.1.2.2.1.16.11',161,10016,'ifOutOctets11','ifOutOctets11',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18359,1,'public','1.3.6.1.2.1.2.2.1.16.12',161,10016,'ifOutOctets12','ifOutOctets12',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18360,1,'public','1.3.6.1.2.1.2.2.1.16.13',161,10016,'ifOutOctets13','ifOutOctets13',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18361,1,'public','1.3.6.1.2.1.2.2.1.16.14',161,10016,'ifOutOctets14','ifOutOctets14',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18362,1,'public','1.3.6.1.2.1.2.2.1.16.15',161,10016,'ifOutOctets15','ifOutOctets15',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18363,1,'public','1.3.6.1.2.1.2.2.1.16.16',161,10016,'ifOutOctets16','ifOutOctets16',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18364,1,'public','1.3.6.1.2.1.2.2.1.16.17',161,10016,'ifOutOctets17','ifOutOctets17',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18365,1,'public','1.3.6.1.2.1.2.2.1.16.18',161,10016,'ifOutOctets18','ifOutOctets18',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18366,1,'public','1.3.6.1.2.1.2.2.1.16.19',161,10016,'ifOutOctets19','ifOutOctets19',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18367,1,'public','1.3.6.1.2.1.2.2.1.16.2',161,10016,'ifOutOctets2','ifOutOctets2',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18368,1,'public','1.3.6.1.2.1.2.2.1.16.20',161,10016,'ifOutOctets20','ifOutOctets20',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18369,1,'public','1.3.6.1.2.1.2.2.1.16.21',161,10016,'ifOutOctets21','ifOutOctets21',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18370,1,'public','1.3.6.1.2.1.2.2.1.16.22',161,10016,'ifOutOctets22','ifOutOctets22',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18371,1,'public','1.3.6.1.2.1.2.2.1.16.23',161,10016,'ifOutOctets23','ifOutOctets23',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18372,1,'public','1.3.6.1.2.1.2.2.1.16.24',161,10016,'ifOutOctets24','ifOutOctets24',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18373,1,'public','1.3.6.1.2.1.2.2.1.16.25',161,10016,'ifOutOctets25','ifOutOctets25',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18374,1,'public','1.3.6.1.2.1.2.2.1.16.26',161,10016,'ifOutOctets26','ifOutOctets26',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18375,1,'public','1.3.6.1.2.1.2.2.1.16.27',161,10016,'ifOutOctets27','ifOutOctets27',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18376,1,'public','1.3.6.1.2.1.2.2.1.16.28',161,10016,'ifOutOctets28','ifOutOctets28',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18377,1,'public','1.3.6.1.2.1.2.2.1.16.29',161,10016,'ifOutOctets29','ifOutOctets29',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18378,1,'public','1.3.6.1.2.1.2.2.1.16.3',161,10016,'ifOutOctets3','ifOutOctets3',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18379,1,'public','1.3.6.1.2.1.2.2.1.16.30',161,10016,'ifOutOctets30','ifOutOctets30',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18380,1,'public','1.3.6.1.2.1.2.2.1.16.31',161,10016,'ifOutOctets31','ifOutOctets31',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18381,1,'public','1.3.6.1.2.1.2.2.1.16.32',161,10016,'ifOutOctets32','ifOutOctets32',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18382,1,'public','1.3.6.1.2.1.2.2.1.16.33',161,10016,'ifOutOctets33','ifOutOctets33',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18383,1,'public','1.3.6.1.2.1.2.2.1.16.34',161,10016,'ifOutOctets34','ifOutOctets34',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18384,1,'public','1.3.6.1.2.1.2.2.1.16.35',161,10016,'ifOutOctets35','ifOutOctets35',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18385,1,'public','1.3.6.1.2.1.2.2.1.16.36',161,10016,'ifOutOctets36','ifOutOctets36',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18386,1,'public','1.3.6.1.2.1.2.2.1.16.37',161,10016,'ifOutOctets37','ifOutOctets37',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18387,1,'public','1.3.6.1.2.1.2.2.1.16.38',161,10016,'ifOutOctets38','ifOutOctets38',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18388,1,'public','1.3.6.1.2.1.2.2.1.16.39',161,10016,'ifOutOctets39','ifOutOctets39',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18389,1,'public','1.3.6.1.2.1.2.2.1.16.4',161,10016,'ifOutOctets4','ifOutOctets4',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18390,1,'public','1.3.6.1.2.1.2.2.1.16.40',161,10016,'ifOutOctets40','ifOutOctets40',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18391,1,'public','1.3.6.1.2.1.2.2.1.16.41',161,10016,'ifOutOctets41','ifOutOctets41',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18392,1,'public','1.3.6.1.2.1.2.2.1.16.42',161,10016,'ifOutOctets42','ifOutOctets42',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18393,1,'public','1.3.6.1.2.1.2.2.1.16.43',161,10016,'ifOutOctets43','ifOutOctets43',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18394,1,'public','1.3.6.1.2.1.2.2.1.16.44',161,10016,'ifOutOctets44','ifOutOctets44',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18395,1,'public','1.3.6.1.2.1.2.2.1.16.45',161,10016,'ifOutOctets45','ifOutOctets45',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18396,1,'public','1.3.6.1.2.1.2.2.1.16.46',161,10016,'ifOutOctets46','ifOutOctets46',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18397,1,'public','1.3.6.1.2.1.2.2.1.16.47',161,10016,'ifOutOctets47','ifOutOctets47',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18398,1,'public','1.3.6.1.2.1.2.2.1.16.48',161,10016,'ifOutOctets48','ifOutOctets48',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18399,1,'public','1.3.6.1.2.1.2.2.1.16.49',161,10016,'ifOutOctets49','ifOutOctets49',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18400,1,'public','1.3.6.1.2.1.2.2.1.16.5',161,10016,'ifOutOctets5','ifOutOctets5',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18401,1,'public','1.3.6.1.2.1.2.2.1.16.50',161,10016,'ifOutOctets50','ifOutOctets50',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18402,1,'public','1.3.6.1.2.1.2.2.1.16.51',161,10016,'ifOutOctets51','ifOutOctets51',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18403,1,'public','1.3.6.1.2.1.2.2.1.16.6',161,10016,'ifOutOctets6','ifOutOctets6',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18404,1,'public','1.3.6.1.2.1.2.2.1.16.7',161,10016,'ifOutOctets7','ifOutOctets7',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18405,1,'public','1.3.6.1.2.1.2.2.1.16.8',161,10016,'ifOutOctets8','ifOutOctets8',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18406,1,'public','1.3.6.1.2.1.2.2.1.16.9',161,10016,'ifOutOctets9','ifOutOctets9',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18407,1,'public','1.3.6.1.2.1.4.2.0',161,10016,'ipDefaultTTL','ipDefaultTTL',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18408,1,'public','1.3.6.1.2.1.4.1.0',161,10016,'ipForwarding','ipForwarding',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18409,1,'public','1.3.6.1.2.1.4.19.0',161,10016,'ipFragCreates','ipFragCreates',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18410,1,'public','1.3.6.1.2.1.4.18.0',161,10016,'ipFragFails','ipFragFails',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18411,1,'public','1.3.6.1.2.1.4.17.0',161,10016,'ipFragOKs','ipFragOKs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18412,1,'public','1.3.6.1.2.1.4.5.0',161,10016,'ipInAddrErrors','ipInAddrErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18413,1,'public','1.3.6.1.2.1.4.9.0',161,10016,'ipInDelivers','ipInDelivers',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18414,1,'public','1.3.6.1.2.1.4.8.0',161,10016,'ipInDiscards','ipInDiscards',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18415,1,'public','1.3.6.1.2.1.4.6.0',161,10016,'ipInForwDatagrams','ipInForwDatagrams',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18416,1,'public','1.3.6.1.2.1.4.4.0',161,10016,'ipInHdrErrors','ipInHdrErrors',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18417,1,'public','1.3.6.1.2.1.4.3.0',161,10016,'ipInReceives','ipInReceives',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18418,1,'public','1.3.6.1.2.1.4.7.0',161,10016,'ipInUnknownProtos','ipInUnknownProtos',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18419,1,'public','1.3.6.1.2.1.4.11.0',161,10016,'ipOutDiscards','ipOutDiscards',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18420,1,'public','1.3.6.1.2.1.4.12.0',161,10016,'ipOutNoRoutes','ipOutNoRoutes',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18421,1,'public','1.3.6.1.2.1.4.10.0',161,10016,'ipOutRequests','ipOutRequests',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18422,1,'public','1.3.6.1.2.1.4.16.0',161,10016,'ipReasmFails','ipReasmFails',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18423,1,'public','1.3.6.1.2.1.4.15.0',161,10016,'ipReasmOKs','ipReasmOKs',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18424,1,'public','1.3.6.1.2.1.4.14.0',161,10016,'ipReasmReqds','ipReasmReqds',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18425,1,'public','1.3.6.1.2.1.4.13.0',161,10016,'ipReasmTimeout','ipReasmTimeout',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18426,1,'public','1.3.6.1.2.1.4.23.0',161,10016,'ipRoutingDiscards','ipRoutingDiscards',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18427,1,'public','1.3.6.1.4.1.9.2.1.56.0',161,10016,'lcpuPercentBusy','lcpuPercentBusy',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18428,1,'public','1.3.6.1.4.1.9.2.1.108.0',161,10016,'lenvFirmVersion','lenvFirmVersion',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18429,1,'public','1.3.6.1.4.1.9.2.1.112.0',161,10016,'lenvSerialNumber','lenvSerialNumber',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18430,1,'public','1.3.6.1.4.1.9.2.1.46.0',161,10016,'lmemBufferFail','lmemBufferFail',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18431,1,'public','1.3.6.1.4.1.9.2.1.47.0',161,10016,'lmemBufferNoMem','lmemBufferNoMem',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18432,1,'public','1.3.6.1.4.1.9.2.1.8.0',161,10016,'lmemFreeMem','lmemFreeMem',60,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18433,1,'public','1.3.6.1.4.1.9.2.1.1.0',161,10016,'lmemRomID','lmemRomID',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18434,1,'public','1.3.6.1.2.1.1.5.0',161,10016,'sysName','sysName',60,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','');
INSERT INTO items VALUES (18435,0,'','',161,10017,'Ping to the server (TCP)','agent.ping',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10020,1,'','');
INSERT INTO items VALUES (18436,0,'','',161,10017,'Version of zabbix_agent(d) running','agent.version',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',10059,0,'','');
INSERT INTO items VALUES (18437,0,'','',161,10017,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10015,0,'','');
INSERT INTO items VALUES (18438,0,'','',161,10017,'Maximum number of opened files','kernel.maxfiles',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10056,0,'','');
INSERT INTO items VALUES (18439,0,'','',161,10017,'Maximum number of processes','kernel.maxproc',1800,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10055,0,'','');
INSERT INTO items VALUES (18440,0,'','',161,10017,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10075,0,'','');
INSERT INTO items VALUES (18441,0,'','',161,10017,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10078,0,'','');
INSERT INTO items VALUES (18442,0,'','',161,10017,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10072,0,'','');
INSERT INTO items VALUES (18443,0,'','',161,10017,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10084,0,'','');
INSERT INTO items VALUES (18444,0,'','',161,10017,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10087,0,'','');
INSERT INTO items VALUES (18445,0,'','',161,10017,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,0,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10081,0,'','');
INSERT INTO items VALUES (18446,0,'','',161,10017,'FTP server is running','net.tcp.service[ftp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10032,1,'','');
INSERT INTO items VALUES (18447,0,'','',161,10017,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10060,1,'','');
INSERT INTO items VALUES (18448,0,'','',161,10017,'IMAP server is running','net.tcp.service[imap]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10037,1,'','');
INSERT INTO items VALUES (18449,0,'','',161,10017,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10046,1,'','');
INSERT INTO items VALUES (18450,0,'','',161,10017,'POP3 server is running','net.tcp.service[pop]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10036,1,'','');
INSERT INTO items VALUES (18451,0,'','',161,10017,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10031,1,'','');
INSERT INTO items VALUES (18452,0,'','',161,10017,'SSH server is running','net.tcp.service[ssh]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10033,1,'','');
INSERT INTO items VALUES (18453,0,'','',161,10017,'Number of running processes','proc.num[,,run]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10013,0,'','');
INSERT INTO items VALUES (18454,0,'','',161,10017,'Number of running processes apache','proc.num[httpd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10048,0,'','');
INSERT INTO items VALUES (18455,0,'','',161,10017,'Number of running processes inetd','proc.num[inetd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10047,0,'','');
INSERT INTO items VALUES (18456,0,'','',161,10017,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10049,0,'','');
INSERT INTO items VALUES (18457,0,'','',161,10017,'Number of running processes sshd','proc.num[sshd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10051,0,'','');
INSERT INTO items VALUES (18458,0,'','',161,10017,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10050,0,'','');
INSERT INTO items VALUES (18459,0,'','',161,10017,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10052,0,'','');
INSERT INTO items VALUES (18460,0,'','',161,10017,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10053,0,'','');
INSERT INTO items VALUES (18461,0,'','',161,10017,'Number of processes','proc.num[]',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10009,0,'','');
INSERT INTO items VALUES (18462,0,'','',161,10017,'Temperature of mainboard','sensor[temp1]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',10418,0,'','');
INSERT INTO items VALUES (18463,0,'','',161,10017,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',10419,0,'','');
INSERT INTO items VALUES (18464,0,'','',161,10017,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,0,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',10420,0,'','');
INSERT INTO items VALUES (18465,0,'','',161,10017,'Host status','status',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10061,2,'','');
INSERT INTO items VALUES (18466,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Host boot time','system.boottime',300,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',17318,0,'','');
INSERT INTO items VALUES (18467,0,'','',161,10017,'Processor load15','system.cpu.load[,avg15]',20,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',10012,0,'','');
INSERT INTO items VALUES (18468,0,'','',161,10017,'Processor load','system.cpu.load[,avg1]',5,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',10010,0,'','');
INSERT INTO items VALUES (18469,0,'','',161,10017,'Processor load5','system.cpu.load[,avg5]',10,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',10011,0,'','');
INSERT INTO items VALUES (18470,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',17354,0,'','');
INSERT INTO items VALUES (18471,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',17358,0,'','');
INSERT INTO items VALUES (18472,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',17360,0,'','');
INSERT INTO items VALUES (18473,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',17356,0,'','');
INSERT INTO items VALUES (18474,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'CPU $2 time ($3)','system.cpu.util[,wait,avg1]',10,90,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',17362,0,'','');
INSERT INTO items VALUES (18475,0,'','',161,10017,'Host name','system.hostname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',10057,0,'','');
INSERT INTO items VALUES (18476,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Host local time','system.localtime',30,90,365,0,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',17352,0,'','');
INSERT INTO items VALUES (18477,0,'','',161,10017,'Free swap space','system.swap.size[,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10014,0,'','');
INSERT INTO items VALUES (18478,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free swap space in %','system.swap.size[,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17350,0,'','');
INSERT INTO items VALUES (18479,0,'','',161,10017,'Total swap space','system.swap.size[,total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10030,0,'','');
INSERT INTO items VALUES (18480,0,'','',161,10017,'Host information','system.uname',1800,7,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',10058,0,'','');
INSERT INTO items VALUES (18481,0,'','',161,10017,'Host uptime (in sec)','system.uptime',300,7,365,0,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','0','',0,'',10025,0,'','');
INSERT INTO items VALUES (18482,0,'','',161,10017,'Number of users connected','system.users.num',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10016,0,'','');
INSERT INTO items VALUES (18483,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10017,0,'','');
INSERT INTO items VALUES (18484,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10019,0,'','');
INSERT INTO items VALUES (18485,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10040,0,'','');
INSERT INTO items VALUES (18486,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10039,0,'','');
INSERT INTO items VALUES (18487,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10038,0,'','');
INSERT INTO items VALUES (18488,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10018,0,'','');
INSERT INTO items VALUES (18489,0,'','',161,10017,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10005,0,'','');
INSERT INTO items VALUES (18490,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17330,0,'','');
INSERT INTO items VALUES (18491,0,'','',161,10017,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10062,0,'','');
INSERT INTO items VALUES (18492,0,'','',161,10017,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10022,0,'','');
INSERT INTO items VALUES (18493,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17332,0,'','');
INSERT INTO items VALUES (18494,0,'','',161,10017,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10066,0,'','');
INSERT INTO items VALUES (18495,0,'','',161,10017,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10006,0,'','');
INSERT INTO items VALUES (18496,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17334,0,'','');
INSERT INTO items VALUES (18497,0,'','',161,10017,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10063,0,'','');
INSERT INTO items VALUES (18498,0,'','',161,10017,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10007,0,'','');
INSERT INTO items VALUES (18499,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17336,0,'','');
INSERT INTO items VALUES (18500,0,'','',161,10017,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10064,0,'','');
INSERT INTO items VALUES (18501,0,'','',161,10017,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10008,0,'','');
INSERT INTO items VALUES (18502,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17338,0,'','');
INSERT INTO items VALUES (18503,0,'','',161,10017,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10065,0,'','');
INSERT INTO items VALUES (18504,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10002,0,'','');
INSERT INTO items VALUES (18505,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17322,0,'','');
INSERT INTO items VALUES (18506,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17340,0,'','');
INSERT INTO items VALUES (18507,0,'','',161,10017,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10067,0,'','');
INSERT INTO items VALUES (18508,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10412,0,'','');
INSERT INTO items VALUES (18509,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10021,0,'','');
INSERT INTO items VALUES (18510,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17324,0,'','');
INSERT INTO items VALUES (18511,0,'','',161,10017,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10071,0,'','');
INSERT INTO items VALUES (18512,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10417,0,'','');
INSERT INTO items VALUES (18513,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10024,0,'','');
INSERT INTO items VALUES (18514,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17326,0,'','');
INSERT INTO items VALUES (18515,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17342,0,'','');
INSERT INTO items VALUES (18516,0,'','',161,10017,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10068,0,'','');
INSERT INTO items VALUES (18517,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10413,0,'','');
INSERT INTO items VALUES (18518,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10003,0,'','');
INSERT INTO items VALUES (18519,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17328,0,'','');
INSERT INTO items VALUES (18520,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17344,0,'','');
INSERT INTO items VALUES (18521,0,'','',161,10017,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10069,0,'','');
INSERT INTO items VALUES (18522,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10415,0,'','');
INSERT INTO items VALUES (18523,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10004,0,'','');
INSERT INTO items VALUES (18524,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17320,0,'','');
INSERT INTO items VALUES (18525,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17346,0,'','');
INSERT INTO items VALUES (18526,0,'','',161,10017,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10070,0,'','');
INSERT INTO items VALUES (18527,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10416,0,'','');
INSERT INTO items VALUES (18528,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1024','',0,'',10023,0,'','');
INSERT INTO items VALUES (18529,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17373,0,'','');
INSERT INTO items VALUES (18530,0,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10017,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,0,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17348,0,'','');
INSERT INTO items VALUES (18531,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,0,NULL,NULL,NULL,0,0,'','B',1,0,NULL,'',0,'','','1024','',0,'',10414,0,'','');
INSERT INTO items VALUES (18532,0,'','',161,10017,'Buffers memory','vm.memory.size[buffers]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10028,0,'','');
INSERT INTO items VALUES (18533,0,'','',161,10017,'Cached memory','vm.memory.size[cached]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10029,0,'','');
INSERT INTO items VALUES (18534,0,'','',161,10017,'Free memory','vm.memory.size[free]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10001,0,'','');
INSERT INTO items VALUES (18535,0,'','',161,10017,'Shared memory','vm.memory.size[shared]',30,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10027,0,'','');
INSERT INTO items VALUES (18536,0,'','',161,10017,'Total memory','vm.memory.size[total]',1800,7,365,0,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10026,0,'','');
INSERT INTO items VALUES (18537,4,'public','1.3.6.1.2.1.1.4.0',161,10018,'Contact Name','pix.contact.name',60,365,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18538,4,'public','1.3.6.1.2.1.1.1.0',161,10018,'PIX Firmware Level','pix.firmware.level',60,365,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18539,4,'public','1.3.6.1.2.1.2.2.1.2.2',161,10018,'PIX Interface 2 Description','pix.intf2.description',60,365,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18540,4,'public','1.3.6.1.2.1.31.1.1.1.1.2',161,10018,'PIX Interface 2 Name','pix.intf2.name',60,365,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18541,4,'public','1.3.6.1.2.1.2.2.1.7.2',161,10018,'PIX Interface 2 Admin Status','pix.intf2.status.admin',60,365,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18542,4,'public','1.3.6.1.2.1.2.2.1.8.2',161,10018,'PIX Interface 2 Op Status','pix.intf2.status.operational',60,365,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18543,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10018,'PIX Interface 2 Egress Traffic','pix.intf2.traffic.egress',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18544,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10018,'PIX Interface 2 Egress Traffic (Bps)','pix.intf2.traffic.egress.bps',60,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18545,4,'public','1.3.6.1.2.1.2.2.1.19.2',161,10018,'PIX Interface 2 Egress Discards','pix.intf2.traffic.egress.discards',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18546,4,'public','1.3.6.1.2.1.2.2.1.20.2',161,10018,'PIX Interface 2 Egress Errors','pix.intf2.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18547,4,'public','1.3.6.1.2.1.2.2.1.17.2',161,10018,'PIX Interface 2 Egress Traffic (pkts)','pix.intf2.traffic.egress.packets',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18548,4,'public','1.3.6.1.2.1.2.2.1.17.2',161,10018,'PIX Interface 2 Egress Traffic (pps)','pix.intf2.traffic.egress.pps',60,365,365,0,NULL,NULL,NULL,0,3,'','pps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18549,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10018,'PIX Interface 2 Ingress Traffic','pix.intf2.traffic.ingress',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18550,4,'public','1.3.6.1.2.1.2.2.1.13.2',161,10018,'PIX Interface 2 Ingress Discards','pix.intf2.traffic.ingress.discards',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18551,4,'public','1.3.6.1.2.1.2.2.1.14.2',161,10018,'PIX Interface 2 Ingress Errors','pix.intf2.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18552,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10018,'PIX Interface 2 Ingress Traffic (Bps)','pix.intf2.traffic.ingress.octets',60,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18553,4,'public','1.3.6.1.2.1.2.2.1.11.2',161,10018,'PIX Interface 2 Ingress Traffic (pkts)','pix.intf2.traffic.ingress.packets',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18554,4,'public','1.3.6.1.2.1.2.2.1.11.2',161,10018,'PIX Interface 2 Ingress Traffic (pps)','pix.intf2.traffic.ingress.pps',60,365,365,0,NULL,NULL,NULL,0,3,'','pps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18555,4,'public','1.3.6.1.2.1.2.2.1.2.3',161,10018,'PIX Interface 3 Description','pix.intf3.description',60,365,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18556,4,'public','1.3.6.1.2.1.2.2.1.7.3',161,10018,'PIX Interface 3 Admin Status','pix.intf3.status.admin',60,365,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18557,4,'public','1.3.6.1.2.1.2.2.1.8.3',161,10018,'PIX Interface 3 Op Status','pix.intf3.status.operational',60,365,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18558,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10018,'PIX Interface 3 Egress Traffic','pix.intf3.traffic.egress',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18559,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10018,'PIX Interface 3 Egress Traffic (Bps)','pix.intf3.traffic.egress.bps',60,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18560,4,'public','1.3.6.1.2.1.2.2.1.19.3',161,10018,'PIX Interface 3 Egress Dicards','pix.intf3.traffic.egress.discards',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18561,4,'public','1.3.6.1.2.1.2.2.1.20.2',161,10018,'PIX Interface 3 Egress Errors','pix.intf3.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18562,4,'public','1.3.6.1.2.1.2.2.1.17.3',161,10018,'PIX Interface 3 Egress Traffic (pkts)','pix.intf3.traffic.egress.packets',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18563,4,'public','1.3.6.1.2.1.2.2.1.17.2',161,10018,'PIX Interface 3 Egress Traffic (pps)','pix.intf3.traffic.egress.pps',60,365,365,0,NULL,NULL,NULL,0,3,'','pps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18564,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10018,'PIX Interface 3 Ingress Traffic','pix.intf3.traffic.ingress',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18565,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10018,'PIX Interface 3 Ingress Traffic (Bps)','pix.intf3.traffic.ingress.bps',60,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18566,4,'public','1.3.6.1.2.1.2.2.1.13.2',161,10018,'PIX Interface 3 Ingress Drops','pix.intf3.traffic.ingress.drops',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18567,4,'public','1.3.6.1.2.1.2.2.1.14.2',161,10018,'PIX Interface 3 Ingress Errors','pix.intf3.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18568,4,'public','1.3.6.1.2.1.2.2.1.11.3',161,10018,'PIX Interface 3 Ingress Traffic (pkts)','pix.intf3.traffic.ingress.packets',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18569,4,'public','1.3.6.1.2.1.2.2.1.11.2',161,10018,'PIX Interface 3 Ingress Traffic (pps)','pix.intf3.traffic.ingress.pps',60,365,365,0,NULL,NULL,NULL,0,3,'','pps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18570,4,'public','1.3.6.1.2.1.47.1.1.1.1.11.1',161,10018,'Serial Number','pix.system.serial',60,365,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18571,4,'public','SNMPv2-MIB::snmpInPkts.0',161,10018,'SNMP Packets Input','pix.system.snmp.packets.input',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18572,4,'public','1.3.6.1.2.1.31.1.1.1.18.1',161,10019,'Interface 01 Description','dell.6248.intf1.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18573,4,'public','1.3.6.1.2.1.2.2.1.5.1',161,10019,'Interface 01 Speed','dell.6248.intf1.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18574,4,'public','1.3.6.1.2.1.2.2.1.7.1',161,10019,'Interface 01 Admin Status','dell.6248.intf1.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18575,4,'public','1.3.6.1.2.1.2.2.1.8.1',161,10019,'Interface 01 Op Status','dell.6248.intf1.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18576,4,'public','1.3.6.1.2.1.2.2.1.16.1',161,10019,'Interface 01 Egress Traffic (Bps)','dell.6248.intf1.traffic.egress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18577,4,'public','1.3.6.1.2.1.2.2.1.16.1',161,10019,'Interface 01 Egress Traffic (bytes)','dell.6248.intf1.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18578,4,'public','1.3.6.1.2.1.2.2.1.19.1',161,10019,'Interface 01 Egress Discards','dell.6248.intf1.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18579,4,'public','1.3.6.1.2.1.2.2.1.20.1',161,10019,'Interface 01 Egress Errors','dell.6248.intf1.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18580,4,'public','1.3.6.1.2.1.2.2.1.18.1',161,10019,'Interface 01 Egress Traffic (Non-Unicast)','dell.6248.intf1.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18581,4,'public','1.3.6.1.2.1.2.2.1.17.1',161,10019,'Interface 01 Egress Traffic (Unicast)','dell.6248.intf1.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18582,4,'public','1.3.6.1.2.1.2.2.1.10.1',161,10019,'Interface 01 Ingress Traffic (Bps)','dell.6248.intf1.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18583,4,'public','1.3.6.1.2.1.2.2.1.10.1',161,10019,'Interface 01 Ingress Traffic (bytes)','dell.6248.intf1.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18584,4,'public','1.3.6.1.2.1.2.2.1.13.1',161,10019,'Interface 01 Ingress Discards','dell.6248.intf1.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18585,4,'public','1.3.6.1.2.1.2.2.1.14.1',161,10019,'Interface 01 Ingress Errors','dell.6248.intf1.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18586,4,'public','1.3.6.1.2.1.2.2.1.12.1',161,10019,'Interface 01 Ingress Traffic (Non-Unicast)','dell.6248.intf1.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18587,4,'public','1.3.6.1.2.1.2.2.1.11.1',161,10019,'Interface 01 Ingress Traffic (Unicast)','dell.6248.intf1.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18588,4,'public','1.3.6.1.2.1.31.1.1.1.18.10',161,10019,'Interface 10 Description','dell.6248.intf10.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18589,4,'public','1.3.6.1.2.1.2.2.1.5.10',161,10019,'Interface 10 Speed','dell.6248.intf10.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18590,4,'public','1.3.6.1.2.1.2.2.1.7.10',161,10019,'Interface 10 Admin Status','dell.6248.intf10.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18591,4,'public','1.3.6.1.2.1.2.2.1.8.10',161,10019,'Interface 10 Op Status','dell.6248.intf10.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18592,4,'public','1.3.6.1.2.1.2.2.1.16.10',161,10019,'Interface 10 Egress Traffic (Bps)','dell.6248.intf10.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18593,4,'public','1.3.6.1.2.1.2.2.1.16.10',161,10019,'Interface 10 Egress Traffic (bytes)','dell.6248.intf10.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18594,4,'public','1.3.6.1.2.1.2.2.1.19.10',161,10019,'Interface 10 Egress Discards','dell.6248.intf10.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18595,4,'public','1.3.6.1.2.1.2.2.1.20.10',161,10019,'Interface 10 Egress Errors','dell.6248.intf10.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18596,4,'public','1.3.6.1.2.1.2.2.1.18.10',161,10019,'Interface 10 Egress Traffic (Non-Unicast)','dell.6248.intf10.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18597,4,'public','1.3.6.1.2.1.2.2.1.17.10',161,10019,'Interface 10 Egress Traffic (Unicast)','dell.6248.intf10.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18598,4,'public','1.3.6.1.2.1.2.2.1.10.10',161,10019,'Interface 10 Ingress Traffic (Bps)','dell.6248.intf10.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18599,4,'public','1.3.6.1.2.1.2.2.1.10.10',161,10019,'Interface 10 Ingress Traffic (bytes)','dell.6248.intf10.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18600,4,'public','1.3.6.1.2.1.2.2.1.13.10',161,10019,'Interface 10 Ingress Discards','dell.6248.intf10.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18601,4,'public','1.3.6.1.2.1.2.2.1.14.10',161,10019,'Interface 10 Ingress Errors','dell.6248.intf10.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18602,4,'public','1.3.6.1.2.1.2.2.1.12.10',161,10019,'Interface 10 Ingress Traffic (Non-Unicast)','dell.6248.intf10.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18603,4,'public','1.3.6.1.2.1.2.2.1.11.10',161,10019,'Interface 10 Ingress Traffic (Unicast)','dell.6248.intf10.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18604,4,'public','1.3.6.1.2.1.31.1.1.1.18.11',161,10019,'Interface 11 Description','dell.6248.intf11.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18605,4,'public','1.3.6.1.2.1.2.2.1.5.11',161,10019,'Interface 11 Speed','dell.6248.intf11.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18606,4,'public','1.3.6.1.2.1.2.2.1.7.11',161,10019,'Interface 11 Admin Status','dell.6248.intf11.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18607,4,'public','1.3.6.1.2.1.2.2.1.8.11',161,10019,'Interface 11 Op Status','dell.6248.intf11.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18608,4,'public','1.3.6.1.2.1.2.2.1.16.11',161,10019,'Interface 11 Egress Traffic (Bps)','dell.6248.intf11.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18609,4,'public','1.3.6.1.2.1.2.2.1.16.11',161,10019,'Interface 11 Egress Traffic (bytes)','dell.6248.intf11.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18610,4,'public','1.3.6.1.2.1.2.2.1.19.11',161,10019,'Interface 11 Egress Discards','dell.6248.intf11.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18611,4,'public','1.3.6.1.2.1.2.2.1.20.11',161,10019,'Interface 11 Egress Errors','dell.6248.intf11.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18612,4,'public','1.3.6.1.2.1.2.2.1.18.11',161,10019,'Interface 11 Egress Traffic (Non-Unicast)','dell.6248.intf11.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18613,4,'public','1.3.6.1.2.1.2.2.1.17.11',161,10019,'Interface 11 Egress Traffic (Unicast)','dell.6248.intf11.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18614,4,'public','1.3.6.1.2.1.2.2.1.10.11',161,10019,'Interface 11 Ingress Traffic (Bps)','dell.6248.intf11.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18615,4,'public','1.3.6.1.2.1.2.2.1.10.11',161,10019,'Interface 11 Ingress Traffic (bytes)','dell.6248.intf11.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18616,4,'public','1.3.6.1.2.1.2.2.1.13.11',161,10019,'Interface 11 Ingress Discards','dell.6248.intf11.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18617,4,'public','1.3.6.1.2.1.2.2.1.14.11',161,10019,'Interface 11 Ingress Errors','dell.6248.intf11.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18618,4,'public','1.3.6.1.2.1.2.2.1.12.11',161,10019,'Interface 11 Ingress Traffic (Non-Unicast)','dell.6248.intf11.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18619,4,'public','1.3.6.1.2.1.2.2.1.11.11',161,10019,'Interface 11 Ingress Traffic (Unicast)','dell.6248.intf11.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18620,4,'public','1.3.6.1.2.1.31.1.1.1.18.12',161,10019,'Interface 12 Description','dell.6248.intf12.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18621,4,'public','1.3.6.1.2.1.2.2.1.5.12',161,10019,'Interface 12 Speed','dell.6248.intf12.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18622,4,'public','1.3.6.1.2.1.2.2.1.7.12',161,10019,'Interface 12 Admin Status','dell.6248.intf12.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18623,4,'public','1.3.6.1.2.1.2.2.1.8.12',161,10019,'Interface 12 Op Status','dell.6248.intf12.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18624,4,'public','1.3.6.1.2.1.2.2.1.16.12',161,10019,'Interface 12 Egress Traffic (Bps)','dell.6248.intf12.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18625,4,'public','1.3.6.1.2.1.2.2.1.16.12',161,10019,'Interface 12 Egress Traffic (bytes)','dell.6248.intf12.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18626,4,'public','1.3.6.1.2.1.2.2.1.19.12',161,10019,'Interface 12 Egress Discards','dell.6248.intf12.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18627,4,'public','1.3.6.1.2.1.2.2.1.20.12',161,10019,'Interface 12 Egress Errors','dell.6248.intf12.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18628,4,'public','1.3.6.1.2.1.2.2.1.18.12',161,10019,'Interface 12 Egress Traffic (Non-Unicast)','dell.6248.intf12.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18629,4,'public','1.3.6.1.2.1.2.2.1.17.12',161,10019,'Interface 12 Egress Traffic (Unicast)','dell.6248.intf12.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18630,4,'public','1.3.6.1.2.1.2.2.1.10.12',161,10019,'Interface 12 Ingress Traffic (Bps)','dell.6248.intf12.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18631,4,'public','1.3.6.1.2.1.2.2.1.10.12',161,10019,'Interface 12 Ingress Traffic (bytes)','dell.6248.intf12.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18632,4,'public','1.3.6.1.2.1.2.2.1.13.12',161,10019,'Interface 12 Ingress Discards','dell.6248.intf12.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18633,4,'public','1.3.6.1.2.1.2.2.1.14.12',161,10019,'Interface 12 Ingress Errors','dell.6248.intf12.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18634,4,'public','1.3.6.1.2.1.2.2.1.12.12',161,10019,'Interface 12 Ingress Traffic (Non-Unicast)','dell.6248.intf12.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18635,4,'public','1.3.6.1.2.1.2.2.1.11.12',161,10019,'Interface 12 Ingress Traffic (Unicast)','dell.6248.intf12.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18636,4,'public','1.3.6.1.2.1.31.1.1.1.18.13',161,10019,'Interface 13 Description','dell.6248.intf13.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18637,4,'public','1.3.6.1.2.1.2.2.1.5.13',161,10019,'Interface 13 Speed','dell.6248.intf13.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18638,4,'public','1.3.6.1.2.1.2.2.1.7.13',161,10019,'Interface 13 Admin Status','dell.6248.intf13.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18639,4,'public','1.3.6.1.2.1.2.2.1.8.13',161,10019,'Interface 13 Op Status','dell.6248.intf13.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18640,4,'public','1.3.6.1.2.1.2.2.1.16.13',161,10019,'Interface 13 Egress Traffic (Bps)','dell.6248.intf13.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18641,4,'public','1.3.6.1.2.1.2.2.1.16.13',161,10019,'Interface 13 Egress Traffic (bytes)','dell.6248.intf13.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18642,4,'public','1.3.6.1.2.1.2.2.1.19.13',161,10019,'Interface 13 Egress Discards','dell.6248.intf13.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18643,4,'public','1.3.6.1.2.1.2.2.1.20.13',161,10019,'Interface 13 Egress Errors','dell.6248.intf13.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18644,4,'public','1.3.6.1.2.1.2.2.1.18.13',161,10019,'Interface 13 Egress Traffic (Non-Unicast)','dell.6248.intf13.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18645,4,'public','1.3.6.1.2.1.2.2.1.17.13',161,10019,'Interface 13 Egress Traffic (Unicast)','dell.6248.intf13.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18646,4,'public','1.3.6.1.2.1.2.2.1.10.13',161,10019,'Interface 13 Ingress Traffic (Bps)','dell.6248.intf13.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18647,4,'public','1.3.6.1.2.1.2.2.1.10.13',161,10019,'Interface 13 Ingress Traffic (bytes)','dell.6248.intf13.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18648,4,'public','1.3.6.1.2.1.2.2.1.13.13',161,10019,'Interface 13 Ingress Discards','dell.6248.intf13.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18649,4,'public','1.3.6.1.2.1.2.2.1.14.13',161,10019,'Interface 13 Ingress Errors','dell.6248.intf13.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18650,4,'public','1.3.6.1.2.1.2.2.1.12.13',161,10019,'Interface 13 Ingress Traffic (Non-Unicast)','dell.6248.intf13.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18651,4,'public','1.3.6.1.2.1.2.2.1.11.13',161,10019,'Interface 13 Ingress Traffic (Unicast)','dell.6248.intf13.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18652,4,'public','1.3.6.1.2.1.31.1.1.1.18.14',161,10019,'Interface 14 Description','dell.6248.intf14.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18653,4,'public','1.3.6.1.2.1.2.2.1.5.14',161,10019,'Interface 14 Speed','dell.6248.intf14.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18654,4,'public','1.3.6.1.2.1.2.2.1.7.14',161,10019,'Interface 14 Admin Status','dell.6248.intf14.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18655,4,'public','1.3.6.1.2.1.2.2.1.8.14',161,10019,'Interface 14 Op Status','dell.6248.intf14.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18656,4,'public','1.3.6.1.2.1.2.2.1.16.14',161,10019,'Interface 14 Egress Traffic (Bps)','dell.6248.intf14.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18657,4,'public','1.3.6.1.2.1.2.2.1.16.14',161,10019,'Interface 14 Egress Traffic (bytes)','dell.6248.intf14.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18658,4,'public','1.3.6.1.2.1.2.2.1.19.14',161,10019,'Interface 14 Egress Discards','dell.6248.intf14.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18659,4,'public','1.3.6.1.2.1.2.2.1.20.14',161,10019,'Interface 14 Egress Errors','dell.6248.intf14.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18660,4,'public','1.3.6.1.2.1.2.2.1.18.14',161,10019,'Interface 14 Egress Traffic (Non-Unicast)','dell.6248.intf14.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18661,4,'public','1.3.6.1.2.1.2.2.1.17.14',161,10019,'Interface 14 Egress Traffic (Unicast)','dell.6248.intf14.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18662,4,'public','1.3.6.1.2.1.2.2.1.10.14',161,10019,'Interface 14 Ingress Traffic (Bps)','dell.6248.intf14.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18663,4,'public','1.3.6.1.2.1.2.2.1.10.14',161,10019,'Interface 14 Ingress Traffic (bytes)','dell.6248.intf14.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18664,4,'public','1.3.6.1.2.1.2.2.1.13.14',161,10019,'Interface 14 Ingress Discards','dell.6248.intf14.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18665,4,'public','1.3.6.1.2.1.2.2.1.14.14',161,10019,'Interface 14 Ingress Errors','dell.6248.intf14.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18666,4,'public','1.3.6.1.2.1.2.2.1.12.14',161,10019,'Interface 14 Ingress Traffic (Non-Unicast)','dell.6248.intf14.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18667,4,'public','1.3.6.1.2.1.2.2.1.11.14',161,10019,'Interface 14 Ingress Traffic (Unicast)','dell.6248.intf14.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18668,4,'public','1.3.6.1.2.1.31.1.1.1.18.15',161,10019,'Interface 15 Description','dell.6248.intf15.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18669,4,'public','1.3.6.1.2.1.2.2.1.5.15',161,10019,'Interface 15 Speed','dell.6248.intf15.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18670,4,'public','1.3.6.1.2.1.2.2.1.7.15',161,10019,'Interface 15 Admin Status','dell.6248.intf15.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18671,4,'public','1.3.6.1.2.1.2.2.1.8.15',161,10019,'Interface 15 Op Status','dell.6248.intf15.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18672,4,'public','1.3.6.1.2.1.2.2.1.16.15',161,10019,'Interface 15 Egress Traffic (Bps)','dell.6248.intf15.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18673,4,'public','1.3.6.1.2.1.2.2.1.16.15',161,10019,'Interface 15 Egress Traffic (bytes)','dell.6248.intf15.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18674,4,'public','1.3.6.1.2.1.2.2.1.19.15',161,10019,'Interface 15 Egress Discards','dell.6248.intf15.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18675,4,'public','1.3.6.1.2.1.2.2.1.20.15',161,10019,'Interface 15 Egress Errors','dell.6248.intf15.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18676,4,'public','1.3.6.1.2.1.2.2.1.18.15',161,10019,'Interface 15 Egress Traffic (Non-Unicast)','dell.6248.intf15.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18677,4,'public','1.3.6.1.2.1.2.2.1.17.15',161,10019,'Interface 15 Egress Traffic (Unicast)','dell.6248.intf15.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18678,4,'public','1.3.6.1.2.1.2.2.1.10.15',161,10019,'Interface 15 Ingress Traffic (Bps)','dell.6248.intf15.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18679,4,'public','1.3.6.1.2.1.2.2.1.10.15',161,10019,'Interface 15 Ingress Traffic (bytes)','dell.6248.intf15.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18680,4,'public','1.3.6.1.2.1.2.2.1.13.15',161,10019,'Interface 15 Ingress Discards','dell.6248.intf15.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18681,4,'public','1.3.6.1.2.1.2.2.1.14.15',161,10019,'Interface 15 Ingress Errors','dell.6248.intf15.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18682,4,'public','1.3.6.1.2.1.2.2.1.12.15',161,10019,'Interface 15 Ingress Traffic (Non-Unicast)','dell.6248.intf15.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18683,4,'public','1.3.6.1.2.1.2.2.1.11.15',161,10019,'Interface 15 Ingress Traffic (Unicast)','dell.6248.intf15.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18684,4,'public','1.3.6.1.2.1.31.1.1.1.18.16',161,10019,'Interface 16 Description','dell.6248.intf16.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18685,4,'public','1.3.6.1.2.1.2.2.1.5.16',161,10019,'Interface 16 Speed','dell.6248.intf16.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18686,4,'public','1.3.6.1.2.1.2.2.1.7.16',161,10019,'Interface 16 Admin Status','dell.6248.intf16.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18687,4,'public','1.3.6.1.2.1.2.2.1.8.16',161,10019,'Interface 16 Op Status','dell.6248.intf16.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18688,4,'public','1.3.6.1.2.1.2.2.1.16.16',161,10019,'Interface 16 Egress Traffic (Bps)','dell.6248.intf16.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18689,4,'public','1.3.6.1.2.1.2.2.1.16.16',161,10019,'Interface 16 Egress Traffic (bytes)','dell.6248.intf16.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18690,4,'public','1.3.6.1.2.1.2.2.1.19.16',161,10019,'Interface 16 Egress Discards','dell.6248.intf16.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18691,4,'public','1.3.6.1.2.1.2.2.1.20.16',161,10019,'Interface 16 Egress Errors','dell.6248.intf16.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18692,4,'public','1.3.6.1.2.1.2.2.1.18.16',161,10019,'Interface 16 Egress Traffic (Non-Unicast)','dell.6248.intf16.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18693,4,'public','1.3.6.1.2.1.2.2.1.17.16',161,10019,'Interface 16 Egress Traffic (Unicast)','dell.6248.intf16.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18694,4,'public','1.3.6.1.2.1.2.2.1.10.16',161,10019,'Interface 16 Ingress Traffic (Bps)','dell.6248.intf16.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18695,4,'public','1.3.6.1.2.1.2.2.1.10.16',161,10019,'Interface 16 Ingress Traffic (bytes)','dell.6248.intf16.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18696,4,'public','1.3.6.1.2.1.2.2.1.13.16',161,10019,'Interface 16 Ingress Discards','dell.6248.intf16.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18697,4,'public','1.3.6.1.2.1.2.2.1.14.16',161,10019,'Interface 16 Ingress Errors','dell.6248.intf16.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18698,4,'public','1.3.6.1.2.1.2.2.1.12.16',161,10019,'Interface 16 Ingress Traffic (Non-Unicast)','dell.6248.intf16.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18699,4,'public','1.3.6.1.2.1.2.2.1.11.16',161,10019,'Interface 16 Ingress Traffic (Unicast)','dell.6248.intf16.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18700,4,'public','1.3.6.1.2.1.31.1.1.1.18.17',161,10019,'Interface 17 Description','dell.6248.intf17.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18701,4,'public','1.3.6.1.2.1.2.2.1.5.17',161,10019,'Interface 17 Speed','dell.6248.intf17.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18702,4,'public','1.3.6.1.2.1.2.2.1.7.17',161,10019,'Interface 17 Admin Status','dell.6248.intf17.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18703,4,'public','1.3.6.1.2.1.2.2.1.8.17',161,10019,'Interface 17 Op Status','dell.6248.intf17.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18704,4,'public','1.3.6.1.2.1.2.2.1.16.17',161,10019,'Interface 17 Egress Traffic (Bps)','dell.6248.intf17.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18705,4,'public','1.3.6.1.2.1.2.2.1.16.17',161,10019,'Interface 17 Egress Traffic (bytes)','dell.6248.intf17.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18706,4,'public','1.3.6.1.2.1.2.2.1.19.17',161,10019,'Interface 17 Egress Discards','dell.6248.intf17.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18707,4,'public','1.3.6.1.2.1.2.2.1.20.17',161,10019,'Interface 17 Egress Errors','dell.6248.intf17.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18708,4,'public','1.3.6.1.2.1.2.2.1.18.17',161,10019,'Interface 17 Egress Traffic (Non-Unicast)','dell.6248.intf17.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18709,4,'public','1.3.6.1.2.1.2.2.1.17.17',161,10019,'Interface 17 Egress Traffic (Unicast)','dell.6248.intf17.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18710,4,'public','1.3.6.1.2.1.2.2.1.10.17',161,10019,'Interface 17 Ingress Traffic (Bps)','dell.6248.intf17.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18711,4,'public','1.3.6.1.2.1.2.2.1.10.17',161,10019,'Interface 17 Ingress Traffic (bytes)','dell.6248.intf17.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18712,4,'public','1.3.6.1.2.1.2.2.1.13.17',161,10019,'Interface 17 Ingress Discards','dell.6248.intf17.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18713,4,'public','1.3.6.1.2.1.2.2.1.14.17',161,10019,'Interface 17 Ingress Errors','dell.6248.intf17.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18714,4,'public','1.3.6.1.2.1.2.2.1.12.17',161,10019,'Interface 17 Ingress Traffic (Non-Unicast)','dell.6248.intf17.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18715,4,'public','1.3.6.1.2.1.2.2.1.11.17',161,10019,'Interface 17 Ingress Traffic (Unicast)','dell.6248.intf17.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18716,4,'public','1.3.6.1.2.1.31.1.1.1.18.18',161,10019,'Interface 18 Description','dell.6248.intf18.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18717,4,'public','1.3.6.1.2.1.2.2.1.5.18',161,10019,'Interface 18 Speed','dell.6248.intf18.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18718,4,'public','1.3.6.1.2.1.2.2.1.7.18',161,10019,'Interface 18 Admin Status','dell.6248.intf18.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18719,4,'public','1.3.6.1.2.1.2.2.1.8.18',161,10019,'Interface 18 Op Status','dell.6248.intf18.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18720,4,'public','1.3.6.1.2.1.2.2.1.16.18',161,10019,'Interface 18 Egress Traffic (Bps)','dell.6248.intf18.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18721,4,'public','1.3.6.1.2.1.2.2.1.16.18',161,10019,'Interface 18 Egress Traffic (bytes)','dell.6248.intf18.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18722,4,'public','1.3.6.1.2.1.2.2.1.19.18',161,10019,'Interface 18 Egress Discards','dell.6248.intf18.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18723,4,'public','1.3.6.1.2.1.2.2.1.20.18',161,10019,'Interface 18 Egress Errors','dell.6248.intf18.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18724,4,'public','1.3.6.1.2.1.2.2.1.18.18',161,10019,'Interface 18 Egress Traffic (Non-Unicast)','dell.6248.intf18.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18725,4,'public','1.3.6.1.2.1.2.2.1.17.18',161,10019,'Interface 18 Egress Traffic (Unicast)','dell.6248.intf18.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18726,4,'public','1.3.6.1.2.1.2.2.1.10.18',161,10019,'Interface 18 Ingress Traffic (Bps)','dell.6248.intf18.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18727,4,'public','1.3.6.1.2.1.2.2.1.10.18',161,10019,'Interface 18 Ingress Traffic (bytes)','dell.6248.intf18.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18728,4,'public','1.3.6.1.2.1.2.2.1.13.18',161,10019,'Interface 18 Ingress Discards','dell.6248.intf18.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18729,4,'public','1.3.6.1.2.1.2.2.1.14.18',161,10019,'Interface 18 Ingress Errors','dell.6248.intf18.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18730,4,'public','1.3.6.1.2.1.2.2.1.12.18',161,10019,'Interface 18 Ingress Traffic (Non-Unicast)','dell.6248.intf18.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18731,4,'public','1.3.6.1.2.1.2.2.1.11.18',161,10019,'Interface 18 Ingress Traffic (Unicast)','dell.6248.intf18.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18732,4,'public','1.3.6.1.2.1.31.1.1.1.18.19',161,10019,'Interface 19 Description','dell.6248.intf19.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18733,4,'public','1.3.6.1.2.1.2.2.1.5.19',161,10019,'Interface 19 Speed','dell.6248.intf19.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18734,4,'public','1.3.6.1.2.1.2.2.1.7.19',161,10019,'Interface 19 Admin Status','dell.6248.intf19.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18735,4,'public','1.3.6.1.2.1.2.2.1.8.19',161,10019,'Interface 19 Op Status','dell.6248.intf19.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18736,4,'public','1.3.6.1.2.1.2.2.1.16.19',161,10019,'Interface 19 Egress Traffic (Bps)','dell.6248.intf19.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18737,4,'public','1.3.6.1.2.1.2.2.1.16.19',161,10019,'Interface 19 Egress Traffic (bytes)','dell.6248.intf19.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18738,4,'public','1.3.6.1.2.1.2.2.1.19.19',161,10019,'Interface 19 Egress Discards','dell.6248.intf19.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18739,4,'public','1.3.6.1.2.1.2.2.1.20.19',161,10019,'Interface 19 Egress Errors','dell.6248.intf19.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18740,4,'public','1.3.6.1.2.1.2.2.1.18.19',161,10019,'Interface 19 Egress Traffic (Non-Unicast)','dell.6248.intf19.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18741,4,'public','1.3.6.1.2.1.2.2.1.17.19',161,10019,'Interface 19 Egress Traffic (Unicast)','dell.6248.intf19.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18742,4,'public','1.3.6.1.2.1.2.2.1.10.19',161,10019,'Interface 19 Ingress Traffic (Bps)','dell.6248.intf19.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18743,4,'public','1.3.6.1.2.1.2.2.1.10.19',161,10019,'Interface 19 Ingress Traffic (bytes)','dell.6248.intf19.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18744,4,'public','1.3.6.1.2.1.2.2.1.13.19',161,10019,'Interface 19 Ingress Discards','dell.6248.intf19.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18745,4,'public','1.3.6.1.2.1.2.2.1.14.19',161,10019,'Interface 19 Ingress Errors','dell.6248.intf19.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18746,4,'public','1.3.6.1.2.1.2.2.1.12.19',161,10019,'Interface 19 Ingress Traffic (Non-Unicast)','dell.6248.intf19.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18747,4,'public','1.3.6.1.2.1.2.2.1.11.19',161,10019,'Interface 19 Ingress Traffic (Unicast)','dell.6248.intf19.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18748,4,'public','1.3.6.1.2.1.31.1.1.1.18.2',161,10019,'Interface 02 Description','dell.6248.intf2.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18749,4,'public','1.3.6.1.2.1.2.2.1.5.2',161,10019,'Interface 02 Speed','dell.6248.intf2.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18750,4,'public','1.3.6.1.2.1.2.2.1.7.2',161,10019,'Interface 02 Admin Status','dell.6248.intf2.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18751,4,'public','1.3.6.1.2.1.2.2.1.8.2',161,10019,'Interface 02 Op Status','dell.6248.intf2.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18752,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10019,'Interface 02 Egress Traffic (Bps)','dell.6248.intf2.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18753,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10019,'Interface 02 Egress Traffic (bytes)','dell.6248.intf2.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18754,4,'public','1.3.6.1.2.1.2.2.1.19.2',161,10019,'Interface 02 Egress Discards','dell.6248.intf2.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18755,4,'public','1.3.6.1.2.1.2.2.1.20.2',161,10019,'Interface 02 Egress Errors','dell.6248.intf2.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18756,4,'public','1.3.6.1.2.1.2.2.1.18.2',161,10019,'Interface 02 Egress Traffic (Non-Unicast)','dell.6248.intf2.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18757,4,'public','1.3.6.1.2.1.2.2.1.17.2',161,10019,'Interface 02 Egress Traffic (Unicast)','dell.6248.intf2.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18758,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10019,'Interface 02 Ingress Traffic (Bps)','dell.6248.intf2.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18759,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10019,'Interface 02 Ingress Traffic (bytes)','dell.6248.intf2.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18760,4,'public','1.3.6.1.2.1.2.2.1.13.2',161,10019,'Interface 02 Ingress Discards','dell.6248.intf2.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18761,4,'public','1.3.6.1.2.1.2.2.1.14.2',161,10019,'Interface 02 Ingress Errors','dell.6248.intf2.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18762,4,'public','1.3.6.1.2.1.2.2.1.12.2',161,10019,'Interface 02 Ingress Traffic (Non-Unicast)','dell.6248.intf2.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18763,4,'public','1.3.6.1.2.1.2.2.1.11.2',161,10019,'Interface 02 Ingress Traffic (Unicast)','dell.6248.intf2.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18764,4,'public','1.3.6.1.2.1.31.1.1.1.18.20',161,10019,'Interface 20 Description','dell.6248.intf20.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18765,4,'public','1.3.6.1.2.1.2.2.1.5.20',161,10019,'Interface 20 Speed','dell.6248.intf20.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18766,4,'public','1.3.6.1.2.1.2.2.1.7.20',161,10019,'Interface 20 Admin Status','dell.6248.intf20.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18767,4,'public','1.3.6.1.2.1.2.2.1.8.20',161,10019,'Interface 20 Op Status','dell.6248.intf20.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18768,4,'public','1.3.6.1.2.1.2.2.1.16.20',161,10019,'Interface 20 Egress Traffic (Bps)','dell.6248.intf20.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18769,4,'public','1.3.6.1.2.1.2.2.1.16.20',161,10019,'Interface 20 Egress Traffic (bytes)','dell.6248.intf20.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18770,4,'public','1.3.6.1.2.1.2.2.1.19.20',161,10019,'Interface 20 Egress Discards','dell.6248.intf20.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18771,4,'public','1.3.6.1.2.1.2.2.1.20.20',161,10019,'Interface 20 Egress Errors','dell.6248.intf20.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18772,4,'public','1.3.6.1.2.1.2.2.1.18.20',161,10019,'Interface 20 Egress Traffic (Non-Unicast)','dell.6248.intf20.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18773,4,'public','1.3.6.1.2.1.2.2.1.17.20',161,10019,'Interface 20 Egress Traffic (Unicast)','dell.6248.intf20.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18774,4,'public','1.3.6.1.2.1.2.2.1.10.20',161,10019,'Interface 20 Ingress Traffic (Bps)','dell.6248.intf20.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18775,4,'public','1.3.6.1.2.1.2.2.1.10.20',161,10019,'Interface 20 Ingress Traffic (bytes)','dell.6248.intf20.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18776,4,'public','1.3.6.1.2.1.2.2.1.13.20',161,10019,'Interface 20 Ingress Discards','dell.6248.intf20.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18777,4,'public','1.3.6.1.2.1.2.2.1.14.20',161,10019,'Interface 20 Ingress Errors','dell.6248.intf20.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18778,4,'public','1.3.6.1.2.1.2.2.1.12.20',161,10019,'Interface 20 Ingress Traffic (Non-Unicast)','dell.6248.intf20.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18779,4,'public','1.3.6.1.2.1.2.2.1.11.20',161,10019,'Interface 20 Ingress Traffic (Unicast)','dell.6248.intf20.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18780,4,'public','1.3.6.1.2.1.31.1.1.1.18.21',161,10019,'Interface 21 Description','dell.6248.intf21.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18781,4,'public','1.3.6.1.2.1.2.2.1.5.21',161,10019,'Interface 21 Speed','dell.6248.intf21.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18782,4,'public','1.3.6.1.2.1.2.2.1.7.21',161,10019,'Interface 21 Admin Status','dell.6248.intf21.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18783,4,'public','1.3.6.1.2.1.2.2.1.8.21',161,10019,'Interface 21 Op Status','dell.6248.intf21.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18784,4,'public','1.3.6.1.2.1.2.2.1.16.21',161,10019,'Interface 21 Egress Traffic (Bps)','dell.6248.intf21.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18785,4,'public','1.3.6.1.2.1.2.2.1.16.21',161,10019,'Interface 21 Egress Traffic (bytes)','dell.6248.intf21.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18786,4,'public','1.3.6.1.2.1.2.2.1.19.21',161,10019,'Interface 21 Egress Discards','dell.6248.intf21.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18787,4,'public','1.3.6.1.2.1.2.2.1.20.21',161,10019,'Interface 21 Egress Errors','dell.6248.intf21.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18788,4,'public','1.3.6.1.2.1.2.2.1.18.21',161,10019,'Interface 21 Egress Traffic (Non-Unicast)','dell.6248.intf21.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18789,4,'public','1.3.6.1.2.1.2.2.1.17.21',161,10019,'Interface 21 Egress Traffic (Unicast)','dell.6248.intf21.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18790,4,'public','1.3.6.1.2.1.2.2.1.10.21',161,10019,'Interface 21 Ingress Traffic (Bps)','dell.6248.intf21.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18791,4,'public','1.3.6.1.2.1.2.2.1.10.21',161,10019,'Interface 21 Ingress Traffic (bytes)','dell.6248.intf21.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18792,4,'public','1.3.6.1.2.1.2.2.1.13.21',161,10019,'Interface 21 Ingress Discards','dell.6248.intf21.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18793,4,'public','1.3.6.1.2.1.2.2.1.14.21',161,10019,'Interface 21 Ingress Errors','dell.6248.intf21.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18794,4,'public','1.3.6.1.2.1.2.2.1.12.21',161,10019,'Interface 21 Ingress Traffic (Non-Unicast)','dell.6248.intf21.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18795,4,'public','1.3.6.1.2.1.2.2.1.11.21',161,10019,'Interface 21 Ingress Traffic (Unicast)','dell.6248.intf21.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18796,4,'public','1.3.6.1.2.1.31.1.1.1.18.22',161,10019,'Interface 22 Description','dell.6248.intf22.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18797,4,'public','1.3.6.1.2.1.2.2.1.5.22',161,10019,'Interface 22 Speed','dell.6248.intf22.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18798,4,'public','1.3.6.1.2.1.2.2.1.7.22',161,10019,'Interface 22 Admin Status','dell.6248.intf22.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18799,4,'public','1.3.6.1.2.1.2.2.1.8.22',161,10019,'Interface 22 Op Status','dell.6248.intf22.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18800,4,'public','1.3.6.1.2.1.2.2.1.16.22',161,10019,'Interface 22 Egress Traffic (Bps)','dell.6248.intf22.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18801,4,'public','1.3.6.1.2.1.2.2.1.16.22',161,10019,'Interface 22 Egress Traffic (bytes)','dell.6248.intf22.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18802,4,'public','1.3.6.1.2.1.2.2.1.19.22',161,10019,'Interface 22 Egress Discards','dell.6248.intf22.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18803,4,'public','1.3.6.1.2.1.2.2.1.20.22',161,10019,'Interface 22 Egress Errors','dell.6248.intf22.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18804,4,'public','1.3.6.1.2.1.2.2.1.18.22',161,10019,'Interface 22 Egress Traffic (Non-Unicast)','dell.6248.intf22.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18805,4,'public','1.3.6.1.2.1.2.2.1.17.22',161,10019,'Interface 22 Egress Traffic (Unicast)','dell.6248.intf22.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18806,4,'public','1.3.6.1.2.1.2.2.1.10.22',161,10019,'Interface 22 Ingress Traffic (Bps)','dell.6248.intf22.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18807,4,'public','1.3.6.1.2.1.2.2.1.10.22',161,10019,'Interface 22 Ingress Traffic (bytes)','dell.6248.intf22.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18808,4,'public','1.3.6.1.2.1.2.2.1.13.22',161,10019,'Interface 22 Ingress Discards','dell.6248.intf22.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18809,4,'public','1.3.6.1.2.1.2.2.1.14.22',161,10019,'Interface 22 Ingress Errors','dell.6248.intf22.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18810,4,'public','1.3.6.1.2.1.2.2.1.12.22',161,10019,'Interface 22 Ingress Traffic (Non-Unicast)','dell.6248.intf22.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18811,4,'public','1.3.6.1.2.1.2.2.1.11.22',161,10019,'Interface 22 Ingress Traffic (Unicast)','dell.6248.intf22.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18812,4,'public','1.3.6.1.2.1.31.1.1.1.18.23',161,10019,'Interface 23 Description','dell.6248.intf23.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18813,4,'public','1.3.6.1.2.1.2.2.1.5.23',161,10019,'Interface 23 Speed','dell.6248.intf23.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18814,4,'public','1.3.6.1.2.1.2.2.1.7.23',161,10019,'Interface 23 Admin Status','dell.6248.intf23.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18815,4,'public','1.3.6.1.2.1.2.2.1.8.23',161,10019,'Interface 23 Op Status','dell.6248.intf23.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18816,4,'public','1.3.6.1.2.1.2.2.1.16.23',161,10019,'Interface 23 Egress Traffic (Bps)','dell.6248.intf23.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18817,4,'public','1.3.6.1.2.1.2.2.1.16.23',161,10019,'Interface 23 Egress Traffic (bytes)','dell.6248.intf23.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18818,4,'public','1.3.6.1.2.1.2.2.1.19.23',161,10019,'Interface 23 Egress Discards','dell.6248.intf23.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18819,4,'public','1.3.6.1.2.1.2.2.1.20.23',161,10019,'Interface 23 Egress Errors','dell.6248.intf23.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18820,4,'public','1.3.6.1.2.1.2.2.1.18.23',161,10019,'Interface 23 Egress Traffic (Non-Unicast)','dell.6248.intf23.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18821,4,'public','1.3.6.1.2.1.2.2.1.17.23',161,10019,'Interface 23 Egress Traffic (Unicast)','dell.6248.intf23.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18822,4,'public','1.3.6.1.2.1.2.2.1.10.23',161,10019,'Interface 23 Ingress Traffic (Bps)','dell.6248.intf23.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18823,4,'public','1.3.6.1.2.1.2.2.1.10.23',161,10019,'Interface 23 Ingress Traffic (bytes)','dell.6248.intf23.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18824,4,'public','1.3.6.1.2.1.2.2.1.13.23',161,10019,'Interface 23 Ingress Discards','dell.6248.intf23.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18825,4,'public','1.3.6.1.2.1.2.2.1.14.23',161,10019,'Interface 23 Ingress Errors','dell.6248.intf23.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18826,4,'public','1.3.6.1.2.1.2.2.1.12.23',161,10019,'Interface 23 Ingress Traffic (Non-Unicast)','dell.6248.intf23.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18827,4,'public','1.3.6.1.2.1.2.2.1.11.23',161,10019,'Interface 23 Ingress Traffic (Unicast)','dell.6248.intf23.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18828,4,'public','1.3.6.1.2.1.31.1.1.1.18.24',161,10019,'Interface 24 Description','dell.6248.intf24.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18829,4,'public','1.3.6.1.2.1.2.2.1.5.24',161,10019,'Interface 24 Speed','dell.6248.intf24.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18830,4,'public','1.3.6.1.2.1.2.2.1.7.24',161,10019,'Interface 24 Admin Status','dell.6248.intf24.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18831,4,'public','1.3.6.1.2.1.2.2.1.8.24',161,10019,'Interface 24 Op Status','dell.6248.intf24.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18832,4,'public','1.3.6.1.2.1.2.2.1.16.24',161,10019,'Interface 24 Egress Traffic (Bps)','dell.6248.intf24.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18833,4,'public','1.3.6.1.2.1.2.2.1.16.24',161,10019,'Interface 24 Egress Traffic (bytes)','dell.6248.intf24.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18834,4,'public','1.3.6.1.2.1.2.2.1.19.24',161,10019,'Interface 24 Egress Discards','dell.6248.intf24.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18835,4,'public','1.3.6.1.2.1.2.2.1.20.24',161,10019,'Interface 24 Egress Errors','dell.6248.intf24.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18836,4,'public','1.3.6.1.2.1.2.2.1.18.24',161,10019,'Interface 24 Egress Traffic (Non-Unicast)','dell.6248.intf24.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18837,4,'public','1.3.6.1.2.1.2.2.1.17.24',161,10019,'Interface 24 Egress Traffic (Unicast)','dell.6248.intf24.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18838,4,'public','1.3.6.1.2.1.2.2.1.10.24',161,10019,'Interface 24 Ingress Traffic (Bps)','dell.6248.intf24.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18839,4,'public','1.3.6.1.2.1.2.2.1.10.24',161,10019,'Interface 24 Ingress Traffic (bytes)','dell.6248.intf24.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18840,4,'public','1.3.6.1.2.1.2.2.1.13.24',161,10019,'Interface 24 Ingress Discards','dell.6248.intf24.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18841,4,'public','1.3.6.1.2.1.2.2.1.14.24',161,10019,'Interface 24 Ingress Errors','dell.6248.intf24.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18842,4,'public','1.3.6.1.2.1.2.2.1.12.24',161,10019,'Interface 24 Ingress Traffic (Non-Unicast)','dell.6248.intf24.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18843,4,'public','1.3.6.1.2.1.2.2.1.11.24',161,10019,'Interface 24 Ingress Traffic (Unicast)','dell.6248.intf24.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18844,4,'public','1.3.6.1.2.1.31.1.1.1.18.25',161,10019,'Interface 25 Description','dell.6248.intf25.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18845,4,'public','1.3.6.1.2.1.2.2.1.5.25',161,10019,'Interface 25 Speed','dell.6248.intf25.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18846,4,'public','1.3.6.1.2.1.2.2.1.7.25',161,10019,'Interface 25 Admin Status','dell.6248.intf25.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18847,4,'public','1.3.6.1.2.1.2.2.1.8.25',161,10019,'Interface 25 Op Status','dell.6248.intf25.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18848,4,'public','1.3.6.1.2.1.2.2.1.16.25',161,10019,'Interface 25 Egress Traffic (Bps)','dell.6248.intf25.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18849,4,'public','1.3.6.1.2.1.2.2.1.16.25',161,10019,'Interface 25 Egress Traffic (bytes)','dell.6248.intf25.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18850,4,'public','1.3.6.1.2.1.2.2.1.19.25',161,10019,'Interface 25 Egress Discards','dell.6248.intf25.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18851,4,'public','1.3.6.1.2.1.2.2.1.20.25',161,10019,'Interface 25 Egress Errors','dell.6248.intf25.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18852,4,'public','1.3.6.1.2.1.2.2.1.18.25',161,10019,'Interface 25 Egress Traffic (Non-Unicast)','dell.6248.intf25.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18853,4,'public','1.3.6.1.2.1.2.2.1.17.25',161,10019,'Interface 25 Egress Traffic (Unicast)','dell.6248.intf25.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18854,4,'public','1.3.6.1.2.1.2.2.1.10.25',161,10019,'Interface 25 Ingress Traffic (Bps)','dell.6248.intf25.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18855,4,'public','1.3.6.1.2.1.2.2.1.10.25',161,10019,'Interface 25 Ingress Traffic (bytes)','dell.6248.intf25.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18856,4,'public','1.3.6.1.2.1.2.2.1.13.25',161,10019,'Interface 25 Ingress Discards','dell.6248.intf25.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18857,4,'public','1.3.6.1.2.1.2.2.1.14.25',161,10019,'Interface 25 Ingress Errors','dell.6248.intf25.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18858,4,'public','1.3.6.1.2.1.2.2.1.12.25',161,10019,'Interface 25 Ingress Traffic (Non-Unicast)','dell.6248.intf25.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18859,4,'public','1.3.6.1.2.1.2.2.1.11.25',161,10019,'Interface 25 Ingress Traffic (Unicast)','dell.6248.intf25.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18860,4,'public','1.3.6.1.2.1.31.1.1.1.18.26',161,10019,'Interface 26 Description','dell.6248.intf26.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18861,4,'public','1.3.6.1.2.1.2.2.1.5.26',161,10019,'Interface 26 Speed','dell.6248.intf26.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18862,4,'public','1.3.6.1.2.1.2.2.1.7.26',161,10019,'Interface 26 Admin Status','dell.6248.intf26.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18863,4,'public','1.3.6.1.2.1.2.2.1.8.26',161,10019,'Interface 26 Op Status','dell.6248.intf26.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18864,4,'public','1.3.6.1.2.1.2.2.1.16.26',161,10019,'Interface 26 Egress Traffic (Bps)','dell.6248.intf26.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18865,4,'public','1.3.6.1.2.1.2.2.1.16.26',161,10019,'Interface 26 Egress Traffic (bytes)','dell.6248.intf26.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18866,4,'public','1.3.6.1.2.1.2.2.1.19.26',161,10019,'Interface 26 Egress Discards','dell.6248.intf26.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18867,4,'public','1.3.6.1.2.1.2.2.1.20.26',161,10019,'Interface 26 Egress Errors','dell.6248.intf26.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18868,4,'public','1.3.6.1.2.1.2.2.1.18.26',161,10019,'Interface 26 Egress Traffic (Non-Unicast)','dell.6248.intf26.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18869,4,'public','1.3.6.1.2.1.2.2.1.17.26',161,10019,'Interface 26 Egress Traffic (Unicast)','dell.6248.intf26.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18870,4,'public','1.3.6.1.2.1.2.2.1.10.26',161,10019,'Interface 26 Ingress Traffic (Bps)','dell.6248.intf26.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18871,4,'public','1.3.6.1.2.1.2.2.1.10.26',161,10019,'Interface 26 Ingress Traffic (bytes)','dell.6248.intf26.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18872,4,'public','1.3.6.1.2.1.2.2.1.13.26',161,10019,'Interface 26 Ingress Discards','dell.6248.intf26.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18873,4,'public','1.3.6.1.2.1.2.2.1.14.26',161,10019,'Interface 26 Ingress Errors','dell.6248.intf26.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18874,4,'public','1.3.6.1.2.1.2.2.1.12.26',161,10019,'Interface 26 Ingress Traffic (Non-Unicast)','dell.6248.intf26.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18875,4,'public','1.3.6.1.2.1.2.2.1.11.26',161,10019,'Interface 26 Ingress Traffic (Unicast)','dell.6248.intf26.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18876,4,'public','1.3.6.1.2.1.31.1.1.1.18.27',161,10019,'Interface 27 Description','dell.6248.intf27.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18877,4,'public','1.3.6.1.2.1.2.2.1.5.27',161,10019,'Interface 27 Speed','dell.6248.intf27.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18878,4,'public','1.3.6.1.2.1.2.2.1.7.27',161,10019,'Interface 27 Admin Status','dell.6248.intf27.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18879,4,'public','1.3.6.1.2.1.2.2.1.8.27',161,10019,'Interface 27 Op Status','dell.6248.intf27.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18880,4,'public','1.3.6.1.2.1.2.2.1.16.27',161,10019,'Interface 27 Egress Traffic (Bps)','dell.6248.intf27.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18881,4,'public','1.3.6.1.2.1.2.2.1.16.27',161,10019,'Interface 27 Egress Traffic (bytes)','dell.6248.intf27.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18882,4,'public','1.3.6.1.2.1.2.2.1.19.27',161,10019,'Interface 27 Egress Discards','dell.6248.intf27.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18883,4,'public','1.3.6.1.2.1.2.2.1.20.27',161,10019,'Interface 27 Egress Errors','dell.6248.intf27.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18884,4,'public','1.3.6.1.2.1.2.2.1.18.27',161,10019,'Interface 27 Egress Traffic (Non-Unicast)','dell.6248.intf27.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18885,4,'public','1.3.6.1.2.1.2.2.1.17.27',161,10019,'Interface 27 Egress Traffic (Unicast)','dell.6248.intf27.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18886,4,'public','1.3.6.1.2.1.2.2.1.10.27',161,10019,'Interface 27 Ingress Traffic (Bps)','dell.6248.intf27.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18887,4,'public','1.3.6.1.2.1.2.2.1.10.27',161,10019,'Interface 27 Ingress Traffic (bytes)','dell.6248.intf27.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18888,4,'public','1.3.6.1.2.1.2.2.1.13.27',161,10019,'Interface 27 Ingress Discards','dell.6248.intf27.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18889,4,'public','1.3.6.1.2.1.2.2.1.14.27',161,10019,'Interface 27 Ingress Errors','dell.6248.intf27.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18890,4,'public','1.3.6.1.2.1.2.2.1.12.27',161,10019,'Interface 27 Ingress Traffic (Non-Unicast)','dell.6248.intf27.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18891,4,'public','1.3.6.1.2.1.2.2.1.11.27',161,10019,'Interface 27 Ingress Traffic (Unicast)','dell.6248.intf27.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18892,4,'public','1.3.6.1.2.1.31.1.1.1.18.28',161,10019,'Interface 28 Description','dell.6248.intf28.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18893,4,'public','1.3.6.1.2.1.2.2.1.5.28',161,10019,'Interface 28 Speed','dell.6248.intf28.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18894,4,'public','1.3.6.1.2.1.2.2.1.7.28',161,10019,'Interface 28 Admin Status','dell.6248.intf28.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18895,4,'public','1.3.6.1.2.1.2.2.1.8.28',161,10019,'Interface 28 Op Status','dell.6248.intf28.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18896,4,'public','1.3.6.1.2.1.2.2.1.16.28',161,10019,'Interface 28 Egress Traffic (Bps)','dell.6248.intf28.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18897,4,'public','1.3.6.1.2.1.2.2.1.16.28',161,10019,'Interface 28 Egress Traffic (bytes)','dell.6248.intf28.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18898,4,'public','1.3.6.1.2.1.2.2.1.19.28',161,10019,'Interface 28 Egress Discards','dell.6248.intf28.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18899,4,'public','1.3.6.1.2.1.2.2.1.20.28',161,10019,'Interface 28 Egress Errors','dell.6248.intf28.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18900,4,'public','1.3.6.1.2.1.2.2.1.18.28',161,10019,'Interface 28 Egress Traffic (Non-Unicast)','dell.6248.intf28.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18901,4,'public','1.3.6.1.2.1.2.2.1.17.28',161,10019,'Interface 28 Egress Traffic (Unicast)','dell.6248.intf28.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18902,4,'public','1.3.6.1.2.1.2.2.1.10.28',161,10019,'Interface 28 Ingress Traffic (Bps)','dell.6248.intf28.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18903,4,'public','1.3.6.1.2.1.2.2.1.10.28',161,10019,'Interface 28 Ingress Traffic (bytes)','dell.6248.intf28.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18904,4,'public','1.3.6.1.2.1.2.2.1.13.28',161,10019,'Interface 28 Ingress Discards','dell.6248.intf28.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18905,4,'public','1.3.6.1.2.1.2.2.1.14.28',161,10019,'Interface 28 Ingress Errors','dell.6248.intf28.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18906,4,'public','1.3.6.1.2.1.2.2.1.12.28',161,10019,'Interface 28 Ingress Traffic (Non-Unicast)','dell.6248.intf28.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18907,4,'public','1.3.6.1.2.1.2.2.1.11.28',161,10019,'Interface 28 Ingress Traffic (Unicast)','dell.6248.intf28.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18908,4,'public','1.3.6.1.2.1.31.1.1.1.18.29',161,10019,'Interface 29 Description','dell.6248.intf29.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18909,4,'public','1.3.6.1.2.1.2.2.1.5.29',161,10019,'Interface 29 Speed','dell.6248.intf29.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18910,4,'public','1.3.6.1.2.1.2.2.1.7.29',161,10019,'Interface 29 Admin Status','dell.6248.intf29.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18911,4,'public','1.3.6.1.2.1.2.2.1.8.29',161,10019,'Interface 29 Op Status','dell.6248.intf29.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18912,4,'public','1.3.6.1.2.1.2.2.1.16.29',161,10019,'Interface 29 Egress Traffic (Bps)','dell.6248.intf29.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18913,4,'public','1.3.6.1.2.1.2.2.1.16.29',161,10019,'Interface 29 Egress Traffic (bytes)','dell.6248.intf29.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18914,4,'public','1.3.6.1.2.1.2.2.1.19.29',161,10019,'Interface 29 Egress Discards','dell.6248.intf29.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18915,4,'public','1.3.6.1.2.1.2.2.1.20.29',161,10019,'Interface 29 Egress Errors','dell.6248.intf29.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18916,4,'public','1.3.6.1.2.1.2.2.1.18.29',161,10019,'Interface 29 Egress Traffic (Non-Unicast)','dell.6248.intf29.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18917,4,'public','1.3.6.1.2.1.2.2.1.17.29',161,10019,'Interface 29 Egress Traffic (Unicast)','dell.6248.intf29.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18918,4,'public','1.3.6.1.2.1.2.2.1.10.29',161,10019,'Interface 29 Ingress Traffic (Bps)','dell.6248.intf29.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18919,4,'public','1.3.6.1.2.1.2.2.1.10.29',161,10019,'Interface 29 Ingress Traffic (bytes)','dell.6248.intf29.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18920,4,'public','1.3.6.1.2.1.2.2.1.13.29',161,10019,'Interface 29 Ingress Discards','dell.6248.intf29.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18921,4,'public','1.3.6.1.2.1.2.2.1.14.29',161,10019,'Interface 29 Ingress Errors','dell.6248.intf29.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18922,4,'public','1.3.6.1.2.1.2.2.1.12.29',161,10019,'Interface 29 Ingress Traffic (Non-Unicast)','dell.6248.intf29.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18923,4,'public','1.3.6.1.2.1.2.2.1.11.29',161,10019,'Interface 29 Ingress Traffic (Unicast)','dell.6248.intf29.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18924,4,'public','1.3.6.1.2.1.31.1.1.1.18.3',161,10019,'Interface 03 Description','dell.6248.intf3.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18925,4,'public','1.3.6.1.2.1.2.2.1.5.3',161,10019,'Interface 03 Speed','dell.6248.intf3.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18926,4,'public','1.3.6.1.2.1.2.2.1.7.3',161,10019,'Interface 03 Admin Status','dell.6248.intf3.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18927,4,'public','1.3.6.1.2.1.2.2.1.8.3',161,10019,'Interface 03 Op Status','dell.6248.intf3.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18928,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10019,'Interface 03 Egress Traffic (Bps)','dell.6248.intf3.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18929,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10019,'Interface 03 Egress Traffic (bytes)','dell.6248.intf3.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18930,4,'public','1.3.6.1.2.1.2.2.1.19.3',161,10019,'Interface 03 Egress Discards','dell.6248.intf3.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18931,4,'public','1.3.6.1.2.1.2.2.1.20.3',161,10019,'Interface 03 Egress Errors','dell.6248.intf3.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18932,4,'public','1.3.6.1.2.1.2.2.1.18.3',161,10019,'Interface 03 Egress Traffic (Non-Unicast)','dell.6248.intf3.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18933,4,'public','1.3.6.1.2.1.2.2.1.17.3',161,10019,'Interface 03 Egress Traffic (Unicast)','dell.6248.intf3.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18934,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10019,'Interface 03 Ingress Traffic (Bps)','dell.6248.intf3.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18935,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10019,'Interface 03 Ingress Traffic (bytes)','dell.6248.intf3.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18936,4,'public','1.3.6.1.2.1.2.2.1.13.3',161,10019,'Interface 03 Ingress Discards','dell.6248.intf3.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18937,4,'public','1.3.6.1.2.1.2.2.1.14.3',161,10019,'Interface 03 Ingress Errors','dell.6248.intf3.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18938,4,'public','1.3.6.1.2.1.2.2.1.12.3',161,10019,'Interface 03 Ingress Traffic (Non-Unicast)','dell.6248.intf3.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18939,4,'public','1.3.6.1.2.1.2.2.1.11.3',161,10019,'Interface 03 Ingress Traffic (Unicast)','dell.6248.intf3.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18940,4,'public','1.3.6.1.2.1.31.1.1.1.18.30',161,10019,'Interface 30 Description','dell.6248.intf30.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18941,4,'public','1.3.6.1.2.1.2.2.1.5.30',161,10019,'Interface 30 Speed','dell.6248.intf30.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18942,4,'public','1.3.6.1.2.1.2.2.1.7.30',161,10019,'Interface 30 Admin Status','dell.6248.intf30.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18943,4,'public','1.3.6.1.2.1.2.2.1.8.30',161,10019,'Interface 30 Op Status','dell.6248.intf30.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18944,4,'public','1.3.6.1.2.1.2.2.1.16.30',161,10019,'Interface 30 Egress Traffic (Bps)','dell.6248.intf30.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18945,4,'public','1.3.6.1.2.1.2.2.1.16.30',161,10019,'Interface 30 Egress Traffic (bytes)','dell.6248.intf30.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18946,4,'public','1.3.6.1.2.1.2.2.1.19.30',161,10019,'Interface 30 Egress Discards','dell.6248.intf30.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18947,4,'public','1.3.6.1.2.1.2.2.1.20.30',161,10019,'Interface 30 Egress Errors','dell.6248.intf30.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18948,4,'public','1.3.6.1.2.1.2.2.1.18.30',161,10019,'Interface 30 Egress Traffic (Non-Unicast)','dell.6248.intf30.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18949,4,'public','1.3.6.1.2.1.2.2.1.17.30',161,10019,'Interface 30 Egress Traffic (Unicast)','dell.6248.intf30.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18950,4,'public','1.3.6.1.2.1.2.2.1.10.30',161,10019,'Interface 30 Ingress Traffic (Bps)','dell.6248.intf30.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18951,4,'public','1.3.6.1.2.1.2.2.1.10.30',161,10019,'Interface 30 Ingress Traffic (bytes)','dell.6248.intf30.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18952,4,'public','1.3.6.1.2.1.2.2.1.13.30',161,10019,'Interface 30 Ingress Discards','dell.6248.intf30.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18953,4,'public','1.3.6.1.2.1.2.2.1.14.30',161,10019,'Interface 30 Ingress Errors','dell.6248.intf30.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18954,4,'public','1.3.6.1.2.1.2.2.1.12.30',161,10019,'Interface 30 Ingress Traffic (Non-Unicast)','dell.6248.intf30.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18955,4,'public','1.3.6.1.2.1.2.2.1.11.30',161,10019,'Interface 30 Ingress Traffic (Unicast)','dell.6248.intf30.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18956,4,'public','1.3.6.1.2.1.31.1.1.1.18.31',161,10019,'Interface 31 Description','dell.6248.intf31.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18957,4,'public','1.3.6.1.2.1.2.2.1.5.31',161,10019,'Interface 31 Speed','dell.6248.intf31.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18958,4,'public','1.3.6.1.2.1.2.2.1.7.31',161,10019,'Interface 31 Admin Status','dell.6248.intf31.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18959,4,'public','1.3.6.1.2.1.2.2.1.8.31',161,10019,'Interface 31 Op Status','dell.6248.intf31.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18960,4,'public','1.3.6.1.2.1.2.2.1.16.31',161,10019,'Interface 31 Egress Traffic (Bps)','dell.6248.intf31.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18961,4,'public','1.3.6.1.2.1.2.2.1.16.31',161,10019,'Interface 31 Egress Traffic (bytes)','dell.6248.intf31.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18962,4,'public','1.3.6.1.2.1.2.2.1.19.31',161,10019,'Interface 31 Egress Discards','dell.6248.intf31.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18963,4,'public','1.3.6.1.2.1.2.2.1.20.31',161,10019,'Interface 31 Egress Errors','dell.6248.intf31.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18964,4,'public','1.3.6.1.2.1.2.2.1.18.31',161,10019,'Interface 31 Egress Traffic (Non-Unicast)','dell.6248.intf31.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18965,4,'public','1.3.6.1.2.1.2.2.1.17.31',161,10019,'Interface 31 Egress Traffic (Unicast)','dell.6248.intf31.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18966,4,'public','1.3.6.1.2.1.2.2.1.10.31',161,10019,'Interface 31 Ingress Traffic (Bps)','dell.6248.intf31.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18967,4,'public','1.3.6.1.2.1.2.2.1.10.31',161,10019,'Interface 31 Ingress Traffic (bytes)','dell.6248.intf31.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18968,4,'public','1.3.6.1.2.1.2.2.1.13.31',161,10019,'Interface 31 Ingress Discards','dell.6248.intf31.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18969,4,'public','1.3.6.1.2.1.2.2.1.14.31',161,10019,'Interface 31 Ingress Errors','dell.6248.intf31.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18970,4,'public','1.3.6.1.2.1.2.2.1.12.31',161,10019,'Interface 31 Ingress Traffic (Non-Unicast)','dell.6248.intf31.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18971,4,'public','1.3.6.1.2.1.2.2.1.11.31',161,10019,'Interface 31 Ingress Traffic (Unicast)','dell.6248.intf31.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18972,4,'public','1.3.6.1.2.1.31.1.1.1.18.32',161,10019,'Interface 32 Description','dell.6248.intf32.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18973,4,'public','1.3.6.1.2.1.2.2.1.5.32',161,10019,'Interface 32 Speed','dell.6248.intf32.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18974,4,'public','1.3.6.1.2.1.2.2.1.7.32',161,10019,'Interface 32 Admin Status','dell.6248.intf32.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18975,4,'public','1.3.6.1.2.1.2.2.1.8.32',161,10019,'Interface 32 Op Status','dell.6248.intf32.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18976,4,'public','1.3.6.1.2.1.2.2.1.16.32',161,10019,'Interface 32 Egress Traffic (Bps)','dell.6248.intf32.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18977,4,'public','1.3.6.1.2.1.2.2.1.16.32',161,10019,'Interface 32 Egress Traffic (bytes)','dell.6248.intf32.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18978,4,'public','1.3.6.1.2.1.2.2.1.19.32',161,10019,'Interface 32 Egress Discards','dell.6248.intf32.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18979,4,'public','1.3.6.1.2.1.2.2.1.20.32',161,10019,'Interface 32 Egress Errors','dell.6248.intf32.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18980,4,'public','1.3.6.1.2.1.2.2.1.18.32',161,10019,'Interface 32 Egress Traffic (Non-Unicast)','dell.6248.intf32.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18981,4,'public','1.3.6.1.2.1.2.2.1.17.32',161,10019,'Interface 32 Egress Traffic (Unicast)','dell.6248.intf32.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18982,4,'public','1.3.6.1.2.1.2.2.1.10.32',161,10019,'Interface 32 Ingress Traffic (Bps)','dell.6248.intf32.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18983,4,'public','1.3.6.1.2.1.2.2.1.10.32',161,10019,'Interface 32 Ingress Traffic (bytes)','dell.6248.intf32.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18984,4,'public','1.3.6.1.2.1.2.2.1.13.32',161,10019,'Interface 32 Ingress Discards','dell.6248.intf32.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18985,4,'public','1.3.6.1.2.1.2.2.1.14.32',161,10019,'Interface 32 Ingress Errors','dell.6248.intf32.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18986,4,'public','1.3.6.1.2.1.2.2.1.12.32',161,10019,'Interface 32 Ingress Traffic (Non-Unicast)','dell.6248.intf32.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18987,4,'public','1.3.6.1.2.1.2.2.1.11.32',161,10019,'Interface 32 Ingress Traffic (Unicast)','dell.6248.intf32.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18988,4,'public','1.3.6.1.2.1.31.1.1.1.18.33',161,10019,'Interface 33 Description','dell.6248.intf33.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18989,4,'public','1.3.6.1.2.1.2.2.1.5.33',161,10019,'Interface 33 Speed','dell.6248.intf33.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18990,4,'public','1.3.6.1.2.1.2.2.1.7.33',161,10019,'Interface 33 Admin Status','dell.6248.intf33.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18991,4,'public','1.3.6.1.2.1.2.2.1.8.33',161,10019,'Interface 33 Op Status','dell.6248.intf33.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18992,4,'public','1.3.6.1.2.1.2.2.1.16.33',161,10019,'Interface 33 Egress Traffic (Bps)','dell.6248.intf33.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18993,4,'public','1.3.6.1.2.1.2.2.1.16.33',161,10019,'Interface 33 Egress Traffic (bytes)','dell.6248.intf33.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18994,4,'public','1.3.6.1.2.1.2.2.1.19.33',161,10019,'Interface 33 Egress Discards','dell.6248.intf33.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18995,4,'public','1.3.6.1.2.1.2.2.1.20.33',161,10019,'Interface 33 Egress Errors','dell.6248.intf33.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18996,4,'public','1.3.6.1.2.1.2.2.1.18.33',161,10019,'Interface 33 Egress Traffic (Non-Unicast)','dell.6248.intf33.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18997,4,'public','1.3.6.1.2.1.2.2.1.17.33',161,10019,'Interface 33 Egress Traffic (Unicast)','dell.6248.intf33.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18998,4,'public','1.3.6.1.2.1.2.2.1.10.33',161,10019,'Interface 33 Ingress Traffic (Bps)','dell.6248.intf33.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (18999,4,'public','1.3.6.1.2.1.2.2.1.10.33',161,10019,'Interface 33 Ingress Traffic (bytes)','dell.6248.intf33.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19000,4,'public','1.3.6.1.2.1.2.2.1.13.33',161,10019,'Interface 33 Ingress Discards','dell.6248.intf33.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19001,4,'public','1.3.6.1.2.1.2.2.1.14.33',161,10019,'Interface 33 Ingress Errors','dell.6248.intf33.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19002,4,'public','1.3.6.1.2.1.2.2.1.12.33',161,10019,'Interface 33 Ingress Traffic (Non-Unicast)','dell.6248.intf33.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19003,4,'public','1.3.6.1.2.1.2.2.1.11.33',161,10019,'Interface 33 Ingress Traffic (Unicast)','dell.6248.intf33.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19004,4,'public','1.3.6.1.2.1.31.1.1.1.18.34',161,10019,'Interface 34 Description','dell.6248.intf34.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19005,4,'public','1.3.6.1.2.1.2.2.1.5.34',161,10019,'Interface 34 Speed','dell.6248.intf34.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19006,4,'public','1.3.6.1.2.1.2.2.1.7.34',161,10019,'Interface 34 Admin Status','dell.6248.intf34.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19007,4,'public','1.3.6.1.2.1.2.2.1.8.34',161,10019,'Interface 34 Op Status','dell.6248.intf34.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19008,4,'public','1.3.6.1.2.1.2.2.1.16.34',161,10019,'Interface 34 Egress Traffic (Bps)','dell.6248.intf34.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19009,4,'public','1.3.6.1.2.1.2.2.1.16.34',161,10019,'Interface 34 Egress Traffic (bytes)','dell.6248.intf34.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19010,4,'public','1.3.6.1.2.1.2.2.1.19.34',161,10019,'Interface 34 Egress Discards','dell.6248.intf34.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19011,4,'public','1.3.6.1.2.1.2.2.1.20.34',161,10019,'Interface 34 Egress Errors','dell.6248.intf34.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19012,4,'public','1.3.6.1.2.1.2.2.1.18.34',161,10019,'Interface 34 Egress Traffic (Non-Unicast)','dell.6248.intf34.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19013,4,'public','1.3.6.1.2.1.2.2.1.17.34',161,10019,'Interface 34 Egress Traffic (Unicast)','dell.6248.intf34.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19014,4,'public','1.3.6.1.2.1.2.2.1.10.34',161,10019,'Interface 34 Ingress Traffic (Bps)','dell.6248.intf34.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19015,4,'public','1.3.6.1.2.1.2.2.1.10.34',161,10019,'Interface 34 Ingress Traffic (bytes)','dell.6248.intf34.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19016,4,'public','1.3.6.1.2.1.2.2.1.13.34',161,10019,'Interface 34 Ingress Discards','dell.6248.intf34.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19017,4,'public','1.3.6.1.2.1.2.2.1.14.34',161,10019,'Interface 34 Ingress Errors','dell.6248.intf34.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19018,4,'public','1.3.6.1.2.1.2.2.1.12.34',161,10019,'Interface 34 Ingress Traffic (Non-Unicast)','dell.6248.intf34.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19019,4,'public','1.3.6.1.2.1.2.2.1.11.34',161,10019,'Interface 34 Ingress Traffic (Unicast)','dell.6248.intf34.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19020,4,'public','1.3.6.1.2.1.31.1.1.1.18.35',161,10019,'Interface 35 Description','dell.6248.intf35.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19021,4,'public','1.3.6.1.2.1.2.2.1.5.35',161,10019,'Interface 35 Speed','dell.6248.intf35.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19022,4,'public','1.3.6.1.2.1.2.2.1.7.35',161,10019,'Interface 35 Admin Status','dell.6248.intf35.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19023,4,'public','1.3.6.1.2.1.2.2.1.8.35',161,10019,'Interface 35 Op Status','dell.6248.intf35.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19024,4,'public','1.3.6.1.2.1.2.2.1.16.35',161,10019,'Interface 35 Egress Traffic (Bps)','dell.6248.intf35.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19025,4,'public','1.3.6.1.2.1.2.2.1.16.35',161,10019,'Interface 35 Egress Traffic (bytes)','dell.6248.intf35.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19026,4,'public','1.3.6.1.2.1.2.2.1.19.35',161,10019,'Interface 35 Egress Discards','dell.6248.intf35.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19027,4,'public','1.3.6.1.2.1.2.2.1.20.35',161,10019,'Interface 35 Egress Errors','dell.6248.intf35.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19028,4,'public','1.3.6.1.2.1.2.2.1.18.35',161,10019,'Interface 35 Egress Traffic (Non-Unicast)','dell.6248.intf35.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19029,4,'public','1.3.6.1.2.1.2.2.1.17.35',161,10019,'Interface 35 Egress Traffic (Unicast)','dell.6248.intf35.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19030,4,'public','1.3.6.1.2.1.2.2.1.10.35',161,10019,'Interface 35 Ingress Traffic (Bps)','dell.6248.intf35.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19031,4,'public','1.3.6.1.2.1.2.2.1.10.35',161,10019,'Interface 35 Ingress Traffic (bytes)','dell.6248.intf35.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19032,4,'public','1.3.6.1.2.1.2.2.1.13.35',161,10019,'Interface 35 Ingress Discards','dell.6248.intf35.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19033,4,'public','1.3.6.1.2.1.2.2.1.14.35',161,10019,'Interface 35 Ingress Errors','dell.6248.intf35.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19034,4,'public','1.3.6.1.2.1.2.2.1.12.35',161,10019,'Interface 35 Ingress Traffic (Non-Unicast)','dell.6248.intf35.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19035,4,'public','1.3.6.1.2.1.2.2.1.11.35',161,10019,'Interface 35 Ingress Traffic (Unicast)','dell.6248.intf35.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19036,4,'public','1.3.6.1.2.1.31.1.1.1.18.36',161,10019,'Interface 36 Description','dell.6248.intf36.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19037,4,'public','1.3.6.1.2.1.2.2.1.5.36',161,10019,'Interface 36 Speed','dell.6248.intf36.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19038,4,'public','1.3.6.1.2.1.2.2.1.7.36',161,10019,'Interface 36 Admin Status','dell.6248.intf36.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19039,4,'public','1.3.6.1.2.1.2.2.1.8.36',161,10019,'Interface 36 Op Status','dell.6248.intf36.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19040,4,'public','1.3.6.1.2.1.2.2.1.16.36',161,10019,'Interface 36 Egress Traffic (Bps)','dell.6248.intf36.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19041,4,'public','1.3.6.1.2.1.2.2.1.16.36',161,10019,'Interface 36 Egress Traffic (bytes)','dell.6248.intf36.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19042,4,'public','1.3.6.1.2.1.2.2.1.19.36',161,10019,'Interface 36 Egress Discards','dell.6248.intf36.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19043,4,'public','1.3.6.1.2.1.2.2.1.20.36',161,10019,'Interface 36 Egress Errors','dell.6248.intf36.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19044,4,'public','1.3.6.1.2.1.2.2.1.18.36',161,10019,'Interface 36 Egress Traffic (Non-Unicast)','dell.6248.intf36.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19045,4,'public','1.3.6.1.2.1.2.2.1.17.36',161,10019,'Interface 36 Egress Traffic (Unicast)','dell.6248.intf36.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19046,4,'public','1.3.6.1.2.1.2.2.1.10.36',161,10019,'Interface 36 Ingress Traffic (Bps)','dell.6248.intf36.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19047,4,'public','1.3.6.1.2.1.2.2.1.10.36',161,10019,'Interface 36 Ingress Traffic (bytes)','dell.6248.intf36.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19048,4,'public','1.3.6.1.2.1.2.2.1.13.36',161,10019,'Interface 36 Ingress Discards','dell.6248.intf36.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19049,4,'public','1.3.6.1.2.1.2.2.1.14.36',161,10019,'Interface 36 Ingress Errors','dell.6248.intf36.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19050,4,'public','1.3.6.1.2.1.2.2.1.12.36',161,10019,'Interface 36 Ingress Traffic (Non-Unicast)','dell.6248.intf36.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19051,4,'public','1.3.6.1.2.1.2.2.1.11.36',161,10019,'Interface 36 Ingress Traffic (Unicast)','dell.6248.intf36.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19052,4,'public','1.3.6.1.2.1.31.1.1.1.18.37',161,10019,'Interface 37 Description','dell.6248.intf37.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19053,4,'public','1.3.6.1.2.1.2.2.1.5.37',161,10019,'Interface 37 Speed','dell.6248.intf37.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19054,4,'public','1.3.6.1.2.1.2.2.1.7.37',161,10019,'Interface 37 Admin Status','dell.6248.intf37.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19055,4,'public','1.3.6.1.2.1.2.2.1.8.37',161,10019,'Interface 37 Op Status','dell.6248.intf37.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19056,4,'public','1.3.6.1.2.1.2.2.1.16.37',161,10019,'Interface 37 Egress Traffic (Bps)','dell.6248.intf37.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19057,4,'public','1.3.6.1.2.1.2.2.1.16.37',161,10019,'Interface 37 Egress Traffic (bytes)','dell.6248.intf37.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19058,4,'public','1.3.6.1.2.1.2.2.1.19.37',161,10019,'Interface 37 Egress Discards','dell.6248.intf37.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19059,4,'public','1.3.6.1.2.1.2.2.1.20.37',161,10019,'Interface 37 Egress Errors','dell.6248.intf37.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19060,4,'public','1.3.6.1.2.1.2.2.1.18.37',161,10019,'Interface 37 Egress Traffic (Non-Unicast)','dell.6248.intf37.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19061,4,'public','1.3.6.1.2.1.2.2.1.17.37',161,10019,'Interface 37 Egress Traffic (Unicast)','dell.6248.intf37.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19062,4,'public','1.3.6.1.2.1.2.2.1.10.37',161,10019,'Interface 37 Ingress Traffic (Bps)','dell.6248.intf37.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19063,4,'public','1.3.6.1.2.1.2.2.1.10.37',161,10019,'Interface 37 Ingress Traffic (bytes)','dell.6248.intf37.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19064,4,'public','1.3.6.1.2.1.2.2.1.13.37',161,10019,'Interface 37 Ingress Discards','dell.6248.intf37.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19065,4,'public','1.3.6.1.2.1.2.2.1.14.37',161,10019,'Interface 37 Ingress Errors','dell.6248.intf37.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19066,4,'public','1.3.6.1.2.1.2.2.1.12.37',161,10019,'Interface 37 Ingress Traffic (Non-Unicast)','dell.6248.intf37.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19067,4,'public','1.3.6.1.2.1.2.2.1.11.37',161,10019,'Interface 37 Ingress Traffic (Unicast)','dell.6248.intf37.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19068,4,'public','1.3.6.1.2.1.31.1.1.1.18.38',161,10019,'Interface 38 Description','dell.6248.intf38.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19069,4,'public','1.3.6.1.2.1.2.2.1.5.38',161,10019,'Interface 38 Speed','dell.6248.intf38.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19070,4,'public','1.3.6.1.2.1.2.2.1.7.38',161,10019,'Interface 38 Admin Status','dell.6248.intf38.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19071,4,'public','1.3.6.1.2.1.2.2.1.8.38',161,10019,'Interface 38 Op Status','dell.6248.intf38.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19072,4,'public','1.3.6.1.2.1.2.2.1.16.38',161,10019,'Interface 38 Egress Traffic (Bps)','dell.6248.intf38.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19073,4,'public','1.3.6.1.2.1.2.2.1.16.38',161,10019,'Interface 38 Egress Traffic (bytes)','dell.6248.intf38.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19074,4,'public','1.3.6.1.2.1.2.2.1.19.38',161,10019,'Interface 38 Egress Discards','dell.6248.intf38.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19075,4,'public','1.3.6.1.2.1.2.2.1.20.38',161,10019,'Interface 38 Egress Errors','dell.6248.intf38.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19076,4,'public','1.3.6.1.2.1.2.2.1.18.38',161,10019,'Interface 38 Egress Traffic (Non-Unicast)','dell.6248.intf38.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19077,4,'public','1.3.6.1.2.1.2.2.1.17.38',161,10019,'Interface 38 Egress Traffic (Unicast)','dell.6248.intf38.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19078,4,'public','1.3.6.1.2.1.2.2.1.10.38',161,10019,'Interface 38 Ingress Traffic (Bps)','dell.6248.intf38.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19079,4,'public','1.3.6.1.2.1.2.2.1.10.38',161,10019,'Interface 38 Ingress Traffic (bytes)','dell.6248.intf38.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19080,4,'public','1.3.6.1.2.1.2.2.1.13.38',161,10019,'Interface 38 Ingress Discards','dell.6248.intf38.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19081,4,'public','1.3.6.1.2.1.2.2.1.14.38',161,10019,'Interface 38 Ingress Errors','dell.6248.intf38.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19082,4,'public','1.3.6.1.2.1.2.2.1.12.38',161,10019,'Interface 38 Ingress Traffic (Non-Unicast)','dell.6248.intf38.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19083,4,'public','1.3.6.1.2.1.2.2.1.11.38',161,10019,'Interface 38 Ingress Traffic (Unicast)','dell.6248.intf38.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19084,4,'public','1.3.6.1.2.1.31.1.1.1.18.39',161,10019,'Interface 39 Description','dell.6248.intf39.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19085,4,'public','1.3.6.1.2.1.2.2.1.5.39',161,10019,'Interface 39 Speed','dell.6248.intf39.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19086,4,'public','1.3.6.1.2.1.2.2.1.7.39',161,10019,'Interface 39 Admin Status','dell.6248.intf39.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19087,4,'public','1.3.6.1.2.1.2.2.1.8.39',161,10019,'Interface 39 Op Status','dell.6248.intf39.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19088,4,'public','1.3.6.1.2.1.2.2.1.16.39',161,10019,'Interface 39 Egress Traffic (Bps)','dell.6248.intf39.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19089,4,'public','1.3.6.1.2.1.2.2.1.16.39',161,10019,'Interface 39 Egress Traffic (bytes)','dell.6248.intf39.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19090,4,'public','1.3.6.1.2.1.2.2.1.19.39',161,10019,'Interface 39 Egress Discards','dell.6248.intf39.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19091,4,'public','1.3.6.1.2.1.2.2.1.20.39',161,10019,'Interface 39 Egress Errors','dell.6248.intf39.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19092,4,'public','1.3.6.1.2.1.2.2.1.18.39',161,10019,'Interface 39 Egress Traffic (Non-Unicast)','dell.6248.intf39.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19093,4,'public','1.3.6.1.2.1.2.2.1.17.39',161,10019,'Interface 39 Egress Traffic (Unicast)','dell.6248.intf39.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19094,4,'public','1.3.6.1.2.1.2.2.1.10.39',161,10019,'Interface 39 Ingress Traffic (Bps)','dell.6248.intf39.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19095,4,'public','1.3.6.1.2.1.2.2.1.10.39',161,10019,'Interface 39 Ingress Traffic (bytes)','dell.6248.intf39.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19096,4,'public','1.3.6.1.2.1.2.2.1.13.39',161,10019,'Interface 39 Ingress Discards','dell.6248.intf39.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19097,4,'public','1.3.6.1.2.1.2.2.1.14.39',161,10019,'Interface 39 Ingress Errors','dell.6248.intf39.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19098,4,'public','1.3.6.1.2.1.2.2.1.12.39',161,10019,'Interface 39 Ingress Traffic (Non-Unicast)','dell.6248.intf39.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19099,4,'public','1.3.6.1.2.1.2.2.1.11.39',161,10019,'Interface 39 Ingress Traffic (Unicast)','dell.6248.intf39.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19100,4,'public','1.3.6.1.2.1.31.1.1.1.18.4',161,10019,'Interface 04 Description','dell.6248.intf4.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19101,4,'public','1.3.6.1.2.1.2.2.1.5.4',161,10019,'Interface 04 Speed','dell.6248.intf4.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19102,4,'public','1.3.6.1.2.1.2.2.1.7.4',161,10019,'Interface 04 Admin Status','dell.6248.intf4.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19103,4,'public','1.3.6.1.2.1.2.2.1.8.4',161,10019,'Interface 04 Op Status','dell.6248.intf4.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19104,4,'public','1.3.6.1.2.1.2.2.1.16.4',161,10019,'Interface 04 Egress Traffic (Bps)','dell.6248.intf4.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19105,4,'public','1.3.6.1.2.1.2.2.1.16.4',161,10019,'Interface 04 Egress Traffic (bytes)','dell.6248.intf4.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19106,4,'public','1.3.6.1.2.1.2.2.1.19.4',161,10019,'Interface 04 Egress Discards','dell.6248.intf4.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19107,4,'public','1.3.6.1.2.1.2.2.1.20.4',161,10019,'Interface 04 Egress Errors','dell.6248.intf4.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19108,4,'public','1.3.6.1.2.1.2.2.1.18.4',161,10019,'Interface 04 Egress Traffic (Non-Unicast)','dell.6248.intf4.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19109,4,'public','1.3.6.1.2.1.2.2.1.17.4',161,10019,'Interface 04 Egress Traffic (Unicast)','dell.6248.intf4.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19110,4,'public','1.3.6.1.2.1.2.2.1.10.4',161,10019,'Interface 04 Ingress Traffic (Bps)','dell.6248.intf4.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19111,4,'public','1.3.6.1.2.1.2.2.1.10.4',161,10019,'Interface 04 Ingress Traffic (bytes)','dell.6248.intf4.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19112,4,'public','1.3.6.1.2.1.2.2.1.13.4',161,10019,'Interface 04 Ingress Discards','dell.6248.intf4.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19113,4,'public','1.3.6.1.2.1.2.2.1.14.4',161,10019,'Interface 04 Ingress Errors','dell.6248.intf4.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19114,4,'public','1.3.6.1.2.1.2.2.1.12.4',161,10019,'Interface 04 Ingress Traffic (Non-Unicast)','dell.6248.intf4.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19115,4,'public','1.3.6.1.2.1.2.2.1.11.4',161,10019,'Interface 04 Ingress Traffic (Unicast)','dell.6248.intf4.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19116,4,'public','1.3.6.1.2.1.31.1.1.1.18.40',161,10019,'Interface 40 Description','dell.6248.intf40.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19117,4,'public','1.3.6.1.2.1.2.2.1.5.40',161,10019,'Interface 40 Speed','dell.6248.intf40.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19118,4,'public','1.3.6.1.2.1.2.2.1.7.40',161,10019,'Interface 40 Admin Status','dell.6248.intf40.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19119,4,'public','1.3.6.1.2.1.2.2.1.8.40',161,10019,'Interface 40 Op Status','dell.6248.intf40.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19120,4,'public','1.3.6.1.2.1.2.2.1.16.40',161,10019,'Interface 40 Egress Traffic (Bps)','dell.6248.intf40.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19121,4,'public','1.3.6.1.2.1.2.2.1.16.40',161,10019,'Interface 40 Egress Traffic (bytes)','dell.6248.intf40.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19122,4,'public','1.3.6.1.2.1.2.2.1.19.40',161,10019,'Interface 40 Egress Discards','dell.6248.intf40.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19123,4,'public','1.3.6.1.2.1.2.2.1.20.40',161,10019,'Interface 40 Egress Errors','dell.6248.intf40.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19124,4,'public','1.3.6.1.2.1.2.2.1.18.40',161,10019,'Interface 40 Egress Traffic (Non-Unicast)','dell.6248.intf40.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19125,4,'public','1.3.6.1.2.1.2.2.1.17.40',161,10019,'Interface 40 Egress Traffic (Unicast)','dell.6248.intf40.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19126,4,'public','1.3.6.1.2.1.2.2.1.10.40',161,10019,'Interface 40 Ingress Traffic (Bps)','dell.6248.intf40.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19127,4,'public','1.3.6.1.2.1.2.2.1.10.40',161,10019,'Interface 40 Ingress Traffic (bytes)','dell.6248.intf40.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19128,4,'public','1.3.6.1.2.1.2.2.1.13.40',161,10019,'Interface 40 Ingress Discards','dell.6248.intf40.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19129,4,'public','1.3.6.1.2.1.2.2.1.14.40',161,10019,'Interface 40 Ingress Errors','dell.6248.intf40.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19130,4,'public','1.3.6.1.2.1.2.2.1.12.40',161,10019,'Interface 40 Ingress Traffic (Non-Unicast)','dell.6248.intf40.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19131,4,'public','1.3.6.1.2.1.2.2.1.11.40',161,10019,'Interface 40 Ingress Traffic (Unicast)','dell.6248.intf40.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19132,4,'public','1.3.6.1.2.1.31.1.1.1.18.41',161,10019,'Interface 41 Description','dell.6248.intf41.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19133,4,'public','1.3.6.1.2.1.2.2.1.5.41',161,10019,'Interface 41 Speed','dell.6248.intf41.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19134,4,'public','1.3.6.1.2.1.2.2.1.7.41',161,10019,'Interface 41 Admin Status','dell.6248.intf41.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19135,4,'public','1.3.6.1.2.1.2.2.1.8.41',161,10019,'Interface 41 Op Status','dell.6248.intf41.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19136,4,'public','1.3.6.1.2.1.2.2.1.16.41',161,10019,'Interface 41 Egress Traffic (Bps)','dell.6248.intf41.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19137,4,'public','1.3.6.1.2.1.2.2.1.16.41',161,10019,'Interface 41 Egress Traffic (bytes)','dell.6248.intf41.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19138,4,'public','1.3.6.1.2.1.2.2.1.19.41',161,10019,'Interface 41 Egress Discards','dell.6248.intf41.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19139,4,'public','1.3.6.1.2.1.2.2.1.20.41',161,10019,'Interface 41 Egress Errors','dell.6248.intf41.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19140,4,'public','1.3.6.1.2.1.2.2.1.18.41',161,10019,'Interface 41 Egress Traffic (Non-Unicast)','dell.6248.intf41.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19141,4,'public','1.3.6.1.2.1.2.2.1.17.41',161,10019,'Interface 41 Egress Traffic (Unicast)','dell.6248.intf41.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19142,4,'public','1.3.6.1.2.1.2.2.1.10.41',161,10019,'Interface 41 Ingress Traffic (Bps)','dell.6248.intf41.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19143,4,'public','1.3.6.1.2.1.2.2.1.10.41',161,10019,'Interface 41 Ingress Traffic (bytes)','dell.6248.intf41.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19144,4,'public','1.3.6.1.2.1.2.2.1.13.41',161,10019,'Interface 41 Ingress Discards','dell.6248.intf41.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19145,4,'public','1.3.6.1.2.1.2.2.1.14.41',161,10019,'Interface 41 Ingress Errors','dell.6248.intf41.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19146,4,'public','1.3.6.1.2.1.2.2.1.12.41',161,10019,'Interface 41 Ingress Traffic (Non-Unicast)','dell.6248.intf41.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19147,4,'public','1.3.6.1.2.1.2.2.1.11.41',161,10019,'Interface 41 Ingress Traffic (Unicast)','dell.6248.intf41.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19148,4,'public','1.3.6.1.2.1.31.1.1.1.18.42',161,10019,'Interface 42 Description','dell.6248.intf42.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19149,4,'public','1.3.6.1.2.1.2.2.1.5.42',161,10019,'Interface 42 Speed','dell.6248.intf42.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19150,4,'public','1.3.6.1.2.1.2.2.1.7.42',161,10019,'Interface 42 Admin Status','dell.6248.intf42.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19151,4,'public','1.3.6.1.2.1.2.2.1.8.42',161,10019,'Interface 42 Op Status','dell.6248.intf42.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19152,4,'public','1.3.6.1.2.1.2.2.1.16.42',161,10019,'Interface 42 Egress Traffic (Bps)','dell.6248.intf42.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19153,4,'public','1.3.6.1.2.1.2.2.1.16.42',161,10019,'Interface 42 Egress Traffic (bytes)','dell.6248.intf42.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19154,4,'public','1.3.6.1.2.1.2.2.1.19.42',161,10019,'Interface 42 Egress Discards','dell.6248.intf42.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19155,4,'public','1.3.6.1.2.1.2.2.1.20.42',161,10019,'Interface 42 Egress Errors','dell.6248.intf42.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19156,4,'public','1.3.6.1.2.1.2.2.1.18.42',161,10019,'Interface 42 Egress Traffic (Non-Unicast)','dell.6248.intf42.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19157,4,'public','1.3.6.1.2.1.2.2.1.17.42',161,10019,'Interface 42 Egress Traffic (Unicast)','dell.6248.intf42.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19158,4,'public','1.3.6.1.2.1.2.2.1.10.42',161,10019,'Interface 42 Ingress Traffic (Bps)','dell.6248.intf42.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19159,4,'public','1.3.6.1.2.1.2.2.1.10.42',161,10019,'Interface 42 Ingress Traffic (bytes)','dell.6248.intf42.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19160,4,'public','1.3.6.1.2.1.2.2.1.13.42',161,10019,'Interface 42 Ingress Discards','dell.6248.intf42.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19161,4,'public','1.3.6.1.2.1.2.2.1.14.42',161,10019,'Interface 42 Ingress Errors','dell.6248.intf42.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19162,4,'public','1.3.6.1.2.1.2.2.1.12.42',161,10019,'Interface 42 Ingress Traffic (Non-Unicast)','dell.6248.intf42.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19163,4,'public','1.3.6.1.2.1.2.2.1.11.42',161,10019,'Interface 42 Ingress Traffic (Unicast)','dell.6248.intf42.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19164,4,'public','1.3.6.1.2.1.31.1.1.1.18.43',161,10019,'Interface 43 Description','dell.6248.intf43.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19165,4,'public','1.3.6.1.2.1.2.2.1.5.43',161,10019,'Interface 43 Speed','dell.6248.intf43.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19166,4,'public','1.3.6.1.2.1.2.2.1.7.43',161,10019,'Interface 43 Admin Status','dell.6248.intf43.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19167,4,'public','1.3.6.1.2.1.2.2.1.8.43',161,10019,'Interface 43 Op Status','dell.6248.intf43.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19168,4,'public','1.3.6.1.2.1.2.2.1.16.43',161,10019,'Interface 43 Egress Traffic (Bps)','dell.6248.intf43.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19169,4,'public','1.3.6.1.2.1.2.2.1.16.43',161,10019,'Interface 43 Egress Traffic (bytes)','dell.6248.intf43.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19170,4,'public','1.3.6.1.2.1.2.2.1.19.43',161,10019,'Interface 43 Egress Discards','dell.6248.intf43.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19171,4,'public','1.3.6.1.2.1.2.2.1.20.43',161,10019,'Interface 43 Egress Errors','dell.6248.intf43.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19172,4,'public','1.3.6.1.2.1.2.2.1.18.43',161,10019,'Interface 43 Egress Traffic (Non-Unicast)','dell.6248.intf43.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19173,4,'public','1.3.6.1.2.1.2.2.1.17.43',161,10019,'Interface 43 Egress Traffic (Unicast)','dell.6248.intf43.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19174,4,'public','1.3.6.1.2.1.2.2.1.10.43',161,10019,'Interface 43 Ingress Traffic (Bps)','dell.6248.intf43.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19175,4,'public','1.3.6.1.2.1.2.2.1.10.43',161,10019,'Interface 43 Ingress Traffic (bytes)','dell.6248.intf43.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19176,4,'public','1.3.6.1.2.1.2.2.1.13.43',161,10019,'Interface 43 Ingress Discards','dell.6248.intf43.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19177,4,'public','1.3.6.1.2.1.2.2.1.14.43',161,10019,'Interface 43 Ingress Errors','dell.6248.intf43.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19178,4,'public','1.3.6.1.2.1.2.2.1.12.43',161,10019,'Interface 43 Ingress Traffic (Non-Unicast)','dell.6248.intf43.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19179,4,'public','1.3.6.1.2.1.2.2.1.11.43',161,10019,'Interface 43 Ingress Traffic (Unicast)','dell.6248.intf43.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19180,4,'public','1.3.6.1.2.1.31.1.1.1.18.44',161,10019,'Interface 44 Description','dell.6248.intf44.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19181,4,'public','1.3.6.1.2.1.2.2.1.5.44',161,10019,'Interface 44 Speed','dell.6248.intf44.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19182,4,'public','1.3.6.1.2.1.2.2.1.7.44',161,10019,'Interface 44 Admin Status','dell.6248.intf44.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19183,4,'public','1.3.6.1.2.1.2.2.1.8.44',161,10019,'Interface 44 Op Status','dell.6248.intf44.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19184,4,'public','1.3.6.1.2.1.2.2.1.16.44',161,10019,'Interface 44 Egress Traffic (Bps)','dell.6248.intf44.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19185,4,'public','1.3.6.1.2.1.2.2.1.16.44',161,10019,'Interface 44 Egress Traffic (bytes)','dell.6248.intf44.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19186,4,'public','1.3.6.1.2.1.2.2.1.19.44',161,10019,'Interface 44 Egress Discards','dell.6248.intf44.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19187,4,'public','1.3.6.1.2.1.2.2.1.20.44',161,10019,'Interface 44 Egress Errors','dell.6248.intf44.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19188,4,'public','1.3.6.1.2.1.2.2.1.18.44',161,10019,'Interface 44 Egress Traffic (Non-Unicast)','dell.6248.intf44.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19189,4,'public','1.3.6.1.2.1.2.2.1.17.44',161,10019,'Interface 44 Egress Traffic (Unicast)','dell.6248.intf44.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19190,4,'public','1.3.6.1.2.1.2.2.1.10.44',161,10019,'Interface 44 Ingress Traffic (Bps)','dell.6248.intf44.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19191,4,'public','1.3.6.1.2.1.2.2.1.10.44',161,10019,'Interface 44 Ingress Traffic (bytes)','dell.6248.intf44.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19192,4,'public','1.3.6.1.2.1.2.2.1.13.44',161,10019,'Interface 44 Ingress Discards','dell.6248.intf44.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19193,4,'public','1.3.6.1.2.1.2.2.1.14.44',161,10019,'Interface 44 Ingress Errors','dell.6248.intf44.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19194,4,'public','1.3.6.1.2.1.2.2.1.12.44',161,10019,'Interface 44 Ingress Traffic (Non-Unicast)','dell.6248.intf44.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19195,4,'public','1.3.6.1.2.1.2.2.1.11.44',161,10019,'Interface 44 Ingress Traffic (Unicast)','dell.6248.intf44.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19196,4,'public','1.3.6.1.2.1.31.1.1.1.18.45',161,10019,'Interface 45 Description','dell.6248.intf45.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19197,4,'public','1.3.6.1.2.1.2.2.1.5.45',161,10019,'Interface 45 Speed','dell.6248.intf45.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19198,4,'public','1.3.6.1.2.1.2.2.1.7.45',161,10019,'Interface 45 Admin Status','dell.6248.intf45.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19199,4,'public','1.3.6.1.2.1.2.2.1.8.45',161,10019,'Interface 45 Op Status','dell.6248.intf45.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19200,4,'public','1.3.6.1.2.1.2.2.1.16.45',161,10019,'Interface 45 Egress Traffic (Bps)','dell.6248.intf45.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19201,4,'public','1.3.6.1.2.1.2.2.1.16.45',161,10019,'Interface 45 Egress Traffic (bytes)','dell.6248.intf45.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19202,4,'public','1.3.6.1.2.1.2.2.1.19.45',161,10019,'Interface 45 Egress Discards','dell.6248.intf45.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19203,4,'public','1.3.6.1.2.1.2.2.1.20.45',161,10019,'Interface 45 Egress Errors','dell.6248.intf45.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19204,4,'public','1.3.6.1.2.1.2.2.1.18.45',161,10019,'Interface 45 Egress Traffic (Non-Unicast)','dell.6248.intf45.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19205,4,'public','1.3.6.1.2.1.2.2.1.17.45',161,10019,'Interface 45 Egress Traffic (Unicast)','dell.6248.intf45.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19206,4,'public','1.3.6.1.2.1.2.2.1.10.45',161,10019,'Interface 45 Ingress Traffic (Bps)','dell.6248.intf45.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19207,4,'public','1.3.6.1.2.1.2.2.1.10.45',161,10019,'Interface 45 Ingress Traffic (bytes)','dell.6248.intf45.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19208,4,'public','1.3.6.1.2.1.2.2.1.13.45',161,10019,'Interface 45 Ingress Discards','dell.6248.intf45.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19209,4,'public','1.3.6.1.2.1.2.2.1.14.45',161,10019,'Interface 45 Ingress Errors','dell.6248.intf45.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19210,4,'public','1.3.6.1.2.1.2.2.1.12.45',161,10019,'Interface 45 Ingress Traffic (Non-Unicast)','dell.6248.intf45.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19211,4,'public','1.3.6.1.2.1.2.2.1.11.45',161,10019,'Interface 45 Ingress Traffic (Unicast)','dell.6248.intf45.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19212,4,'public','1.3.6.1.2.1.31.1.1.1.18.46',161,10019,'Interface 46 Description','dell.6248.intf46.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19213,4,'public','1.3.6.1.2.1.2.2.1.5.46',161,10019,'Interface 46 Speed','dell.6248.intf46.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19214,4,'public','1.3.6.1.2.1.2.2.1.7.46',161,10019,'Interface 46 Admin Status','dell.6248.intf46.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19215,4,'public','1.3.6.1.2.1.2.2.1.8.46',161,10019,'Interface 46 Op Status','dell.6248.intf46.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19216,4,'public','1.3.6.1.2.1.2.2.1.16.46',161,10019,'Interface 46 Egress Traffic (Bps)','dell.6248.intf46.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19217,4,'public','1.3.6.1.2.1.2.2.1.16.46',161,10019,'Interface 46 Egress Traffic (bytes)','dell.6248.intf46.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19218,4,'public','1.3.6.1.2.1.2.2.1.19.46',161,10019,'Interface 46 Egress Discards','dell.6248.intf46.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19219,4,'public','1.3.6.1.2.1.2.2.1.20.46',161,10019,'Interface 46 Egress Errors','dell.6248.intf46.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19220,4,'public','1.3.6.1.2.1.2.2.1.18.46',161,10019,'Interface 46 Egress Traffic (Non-Unicast)','dell.6248.intf46.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19221,4,'public','1.3.6.1.2.1.2.2.1.17.46',161,10019,'Interface 46 Egress Traffic (Unicast)','dell.6248.intf46.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19222,4,'public','1.3.6.1.2.1.2.2.1.10.46',161,10019,'Interface 46 Ingress Traffic (Bps)','dell.6248.intf46.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19223,4,'public','1.3.6.1.2.1.2.2.1.10.46',161,10019,'Interface 46 Ingress Traffic (bytes)','dell.6248.intf46.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19224,4,'public','1.3.6.1.2.1.2.2.1.13.46',161,10019,'Interface 46 Ingress Discards','dell.6248.intf46.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19225,4,'public','1.3.6.1.2.1.2.2.1.14.46',161,10019,'Interface 46 Ingress Errors','dell.6248.intf46.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19226,4,'public','1.3.6.1.2.1.2.2.1.12.46',161,10019,'Interface 46 Ingress Traffic (Non-Unicast)','dell.6248.intf46.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19227,4,'public','1.3.6.1.2.1.2.2.1.11.46',161,10019,'Interface 46 Ingress Traffic (Unicast)','dell.6248.intf46.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19228,4,'public','1.3.6.1.2.1.31.1.1.1.18.47',161,10019,'Interface 47 Description','dell.6248.intf47.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19229,4,'public','1.3.6.1.2.1.2.2.1.5.47',161,10019,'Interface 47 Speed','dell.6248.intf47.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19230,4,'public','1.3.6.1.2.1.2.2.1.7.47',161,10019,'Interface 47 Admin Status','dell.6248.intf47.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19231,4,'public','1.3.6.1.2.1.2.2.1.8.47',161,10019,'Interface 47 Op Status','dell.6248.intf47.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19232,4,'public','1.3.6.1.2.1.2.2.1.16.47',161,10019,'Interface 47 Egress Traffic (Bps)','dell.6248.intf47.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19233,4,'public','1.3.6.1.2.1.2.2.1.16.47',161,10019,'Interface 47 Egress Traffic (bytes)','dell.6248.intf47.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19234,4,'public','1.3.6.1.2.1.2.2.1.19.47',161,10019,'Interface 47 Egress Discards','dell.6248.intf47.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19235,4,'public','1.3.6.1.2.1.2.2.1.20.47',161,10019,'Interface 47 Egress Errors','dell.6248.intf47.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19236,4,'public','1.3.6.1.2.1.2.2.1.18.47',161,10019,'Interface 47 Egress Traffic (Non-Unicast)','dell.6248.intf47.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19237,4,'public','1.3.6.1.2.1.2.2.1.17.47',161,10019,'Interface 47 Egress Traffic (Unicast)','dell.6248.intf47.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19238,4,'public','1.3.6.1.2.1.2.2.1.10.47',161,10019,'Interface 47 Ingress Traffic (Bps)','dell.6248.intf47.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19239,4,'public','1.3.6.1.2.1.2.2.1.10.47',161,10019,'Interface 47 Ingress Traffic (bytes)','dell.6248.intf47.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19240,4,'public','1.3.6.1.2.1.2.2.1.13.47',161,10019,'Interface 47 Ingress Discards','dell.6248.intf47.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19241,4,'public','1.3.6.1.2.1.2.2.1.14.47',161,10019,'Interface 47 Ingress Errors','dell.6248.intf47.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19242,4,'public','1.3.6.1.2.1.2.2.1.12.47',161,10019,'Interface 47 Ingress Traffic (Non-Unicast)','dell.6248.intf47.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19243,4,'public','1.3.6.1.2.1.2.2.1.11.47',161,10019,'Interface 47 Ingress Traffic (Unicast)','dell.6248.intf47.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19244,4,'public','1.3.6.1.2.1.31.1.1.1.18.48',161,10019,'Interface 48 Description','dell.6248.intf48.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19245,4,'public','1.3.6.1.2.1.2.2.1.5.48',161,10019,'Interface 48 Speed','dell.6248.intf48.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19246,4,'public','1.3.6.1.2.1.2.2.1.7.48',161,10019,'Interface 48 Admin Status','dell.6248.intf48.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19247,4,'public','1.3.6.1.2.1.2.2.1.8.48',161,10019,'Interface 48 Op Status','dell.6248.intf48.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19248,4,'public','1.3.6.1.2.1.2.2.1.16.48',161,10019,'Interface 48 Egress Traffic (Bps)','dell.6248.intf48.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19249,4,'public','1.3.6.1.2.1.2.2.1.16.48',161,10019,'Interface 48 Egress Traffic (bytes)','dell.6248.intf48.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19250,4,'public','1.3.6.1.2.1.2.2.1.19.48',161,10019,'Interface 48 Egress Discards','dell.6248.intf48.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19251,4,'public','1.3.6.1.2.1.2.2.1.20.48',161,10019,'Interface 48 Egress Errors','dell.6248.intf48.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19252,4,'public','1.3.6.1.2.1.2.2.1.18.48',161,10019,'Interface 48 Egress Traffic (Non-Unicast)','dell.6248.intf48.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19253,4,'public','1.3.6.1.2.1.2.2.1.17.48',161,10019,'Interface 48 Egress Traffic (Unicast)','dell.6248.intf48.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19254,4,'public','1.3.6.1.2.1.2.2.1.10.48',161,10019,'Interface 48 Ingress Traffic (Bps)','dell.6248.intf48.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19255,4,'public','1.3.6.1.2.1.2.2.1.10.48',161,10019,'Interface 48 Ingress Traffic (bytes)','dell.6248.intf48.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19256,4,'public','1.3.6.1.2.1.2.2.1.13.48',161,10019,'Interface 48 Ingress Discards','dell.6248.intf48.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19257,4,'public','1.3.6.1.2.1.2.2.1.14.48',161,10019,'Interface 48 Ingress Errors','dell.6248.intf48.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19258,4,'public','1.3.6.1.2.1.2.2.1.12.48',161,10019,'Interface 48 Ingress Traffic (Non-Unicast)','dell.6248.intf48.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19259,4,'public','1.3.6.1.2.1.2.2.1.11.48',161,10019,'Interface 48 Ingress Traffic (Unicast)','dell.6248.intf48.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19260,4,'public','1.3.6.1.2.1.31.1.1.1.18.49',161,10019,'Interface 49 Description','dell.6248.intf49.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19261,4,'public','1.3.6.1.2.1.2.2.1.5.49',161,10019,'Interface 49 Speed','dell.6248.intf49.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19262,4,'public','1.3.6.1.2.1.2.2.1.7.49',161,10019,'Interface 49 Admin Status','dell.6248.intf49.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19263,4,'public','1.3.6.1.2.1.2.2.1.8.49',161,10019,'Interface 49 Op Status','dell.6248.intf49.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19264,4,'public','1.3.6.1.2.1.2.2.1.16.49',161,10019,'Interface 49 Egress Traffic (Bps)','dell.6248.intf49.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19265,4,'public','1.3.6.1.2.1.2.2.1.16.49',161,10019,'Interface 49 Egress Traffic (bytes)','dell.6248.intf49.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19266,4,'public','1.3.6.1.2.1.2.2.1.19.49',161,10019,'Interface 49 Egress Discards','dell.6248.intf49.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19267,4,'public','1.3.6.1.2.1.2.2.1.20.49',161,10019,'Interface 49 Egress Errors','dell.6248.intf49.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19268,4,'public','1.3.6.1.2.1.2.2.1.18.49',161,10019,'Interface 49 Egress Traffic (Non-Unicast)','dell.6248.intf49.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19269,4,'public','1.3.6.1.2.1.2.2.1.17.49',161,10019,'Interface 49 Egress Traffic (Unicast)','dell.6248.intf49.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19270,4,'public','1.3.6.1.2.1.2.2.1.10.49',161,10019,'Interface 49 Ingress Traffic (Bps)','dell.6248.intf49.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19271,4,'public','1.3.6.1.2.1.2.2.1.10.49',161,10019,'Interface 49 Ingress Traffic (bytes)','dell.6248.intf49.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19272,4,'public','1.3.6.1.2.1.2.2.1.13.49',161,10019,'Interface 49 Ingress Discards','dell.6248.intf49.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19273,4,'public','1.3.6.1.2.1.2.2.1.14.49',161,10019,'Interface 49 Ingress Errors','dell.6248.intf49.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19274,4,'public','1.3.6.1.2.1.2.2.1.12.49',161,10019,'Interface 49 Ingress Traffic (Non-Unicast)','dell.6248.intf49.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19275,4,'public','1.3.6.1.2.1.2.2.1.11.49',161,10019,'Interface 49 Ingress Traffic (Unicast)','dell.6248.intf49.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19276,4,'public','1.3.6.1.2.1.31.1.1.1.18.5',161,10019,'Interface 05 Description','dell.6248.intf5.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19277,4,'public','1.3.6.1.2.1.2.2.1.5.5',161,10019,'Interface 05 Speed','dell.6248.intf5.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19278,4,'public','1.3.6.1.2.1.2.2.1.7.5',161,10019,'Interface 05 Admin Status','dell.6248.intf5.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19279,4,'public','1.3.6.1.2.1.2.2.1.8.5',161,10019,'Interface 05 Op Status','dell.6248.intf5.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19280,4,'public','1.3.6.1.2.1.2.2.1.16.5',161,10019,'Interface 05 Egress Traffic (Bps)','dell.6248.intf5.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19281,4,'public','1.3.6.1.2.1.2.2.1.16.5',161,10019,'Interface 05 Egress Traffic (bytes)','dell.6248.intf5.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19282,4,'public','1.3.6.1.2.1.2.2.1.19.5',161,10019,'Interface 05 Egress Discards','dell.6248.intf5.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19283,4,'public','1.3.6.1.2.1.2.2.1.20.5',161,10019,'Interface 05 Egress Errors','dell.6248.intf5.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19284,4,'public','1.3.6.1.2.1.2.2.1.18.5',161,10019,'Interface 05 Egress Traffic (Non-Unicast)','dell.6248.intf5.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19285,4,'public','1.3.6.1.2.1.2.2.1.17.5',161,10019,'Interface 05 Egress Traffic (Unicast)','dell.6248.intf5.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19286,4,'public','1.3.6.1.2.1.2.2.1.10.5',161,10019,'Interface 05 Ingress Traffic (Bps)','dell.6248.intf5.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19287,4,'public','1.3.6.1.2.1.2.2.1.10.5',161,10019,'Interface 05 Ingress Traffic (bytes)','dell.6248.intf5.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19288,4,'public','1.3.6.1.2.1.2.2.1.13.5',161,10019,'Interface 05 Ingress Discards','dell.6248.intf5.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19289,4,'public','1.3.6.1.2.1.2.2.1.14.5',161,10019,'Interface 05 Ingress Errors','dell.6248.intf5.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19290,4,'public','1.3.6.1.2.1.2.2.1.12.5',161,10019,'Interface 05 Ingress Traffic (Non-Unicast)','dell.6248.intf5.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19291,4,'public','1.3.6.1.2.1.2.2.1.11.5',161,10019,'Interface 05 Ingress Traffic (Unicast)','dell.6248.intf5.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19292,4,'public','1.3.6.1.2.1.31.1.1.1.18.50',161,10019,'Interface 50 Description','dell.6248.intf50.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19293,4,'public','1.3.6.1.2.1.2.2.1.5.50',161,10019,'Interface 50 Speed','dell.6248.intf50.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19294,4,'public','1.3.6.1.2.1.2.2.1.7.50',161,10019,'Interface 50 Admin Status','dell.6248.intf50.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19295,4,'public','1.3.6.1.2.1.2.2.1.8.50',161,10019,'Interface 50 Op Status','dell.6248.intf50.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19296,4,'public','1.3.6.1.2.1.2.2.1.16.50',161,10019,'Interface 50 Egress Traffic (Bps)','dell.6248.intf50.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19297,4,'public','1.3.6.1.2.1.2.2.1.16.50',161,10019,'Interface 50 Egress Traffic (bytes)','dell.6248.intf50.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19298,4,'public','1.3.6.1.2.1.2.2.1.19.50',161,10019,'Interface 50 Egress Discards','dell.6248.intf50.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19299,4,'public','1.3.6.1.2.1.2.2.1.20.50',161,10019,'Interface 50 Egress Errors','dell.6248.intf50.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19300,4,'public','1.3.6.1.2.1.2.2.1.18.50',161,10019,'Interface 50 Egress Traffic (Non-Unicast)','dell.6248.intf50.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19301,4,'public','1.3.6.1.2.1.2.2.1.17.50',161,10019,'Interface 50 Egress Traffic (Unicast)','dell.6248.intf50.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19302,4,'public','1.3.6.1.2.1.2.2.1.10.50',161,10019,'Interface 50 Ingress Traffic (Bps)','dell.6248.intf50.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19303,4,'public','1.3.6.1.2.1.2.2.1.10.50',161,10019,'Interface 50 Ingress Traffic (bytes)','dell.6248.intf50.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19304,4,'public','1.3.6.1.2.1.2.2.1.13.50',161,10019,'Interface 50 Ingress Discards','dell.6248.intf50.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19305,4,'public','1.3.6.1.2.1.2.2.1.14.50',161,10019,'Interface 50 Ingress Errors','dell.6248.intf50.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19306,4,'public','1.3.6.1.2.1.2.2.1.12.50',161,10019,'Interface 50 Ingress Traffic (Non-Unicast)','dell.6248.intf50.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19307,4,'public','1.3.6.1.2.1.2.2.1.11.50',161,10019,'Interface 50 Ingress Traffic (Unicast)','dell.6248.intf50.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19308,4,'public','1.3.6.1.2.1.31.1.1.1.18.51',161,10019,'Interface 51 Description','dell.6248.intf51.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19309,4,'public','1.3.6.1.2.1.2.2.1.5.51',161,10019,'Interface 51 Speed','dell.6248.intf51.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19310,4,'public','1.3.6.1.2.1.2.2.1.7.51',161,10019,'Interface 51 Admin Status','dell.6248.intf51.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19311,4,'public','1.3.6.1.2.1.2.2.1.8.51',161,10019,'Interface 51 Op Status','dell.6248.intf51.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19312,4,'public','1.3.6.1.2.1.2.2.1.16.51',161,10019,'Interface 51 Egress Traffic (Bps)','dell.6248.intf51.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19313,4,'public','1.3.6.1.2.1.2.2.1.16.51',161,10019,'Interface 51 Egress Traffic (bytes)','dell.6248.intf51.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19314,4,'public','1.3.6.1.2.1.2.2.1.19.51',161,10019,'Interface 51 Egress Discards','dell.6248.intf51.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19315,4,'public','1.3.6.1.2.1.2.2.1.20.51',161,10019,'Interface 51 Egress Errors','dell.6248.intf51.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19316,4,'public','1.3.6.1.2.1.2.2.1.18.51',161,10019,'Interface 51 Egress Traffic (Non-Unicast)','dell.6248.intf51.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19317,4,'public','1.3.6.1.2.1.2.2.1.17.51',161,10019,'Interface 51 Egress Traffic (Unicast)','dell.6248.intf51.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19318,4,'public','1.3.6.1.2.1.2.2.1.10.51',161,10019,'Interface 51 Ingress Traffic (Bps)','dell.6248.intf51.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19319,4,'public','1.3.6.1.2.1.2.2.1.10.51',161,10019,'Interface 51 Ingress Traffic (bytes)','dell.6248.intf51.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19320,4,'public','1.3.6.1.2.1.2.2.1.13.51',161,10019,'Interface 51 Ingress Discards','dell.6248.intf51.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19321,4,'public','1.3.6.1.2.1.2.2.1.14.51',161,10019,'Interface 51 Ingress Errors','dell.6248.intf51.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19322,4,'public','1.3.6.1.2.1.2.2.1.12.51',161,10019,'Interface 51 Ingress Traffic (Non-Unicast)','dell.6248.intf51.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19323,4,'public','1.3.6.1.2.1.2.2.1.11.51',161,10019,'Interface 51 Ingress Traffic (Unicast)','dell.6248.intf51.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19324,4,'public','1.3.6.1.2.1.31.1.1.1.18.52',161,10019,'Interface 52 Description','dell.6248.intf52.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19325,4,'public','1.3.6.1.2.1.2.2.1.5.52',161,10019,'Interface 52 Speed','dell.6248.intf52.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19326,4,'public','1.3.6.1.2.1.2.2.1.7.52',161,10019,'Interface 52 Admin Status','dell.6248.intf52.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19327,4,'public','1.3.6.1.2.1.2.2.1.8.52',161,10019,'Interface 52 Op Status','dell.6248.intf52.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19328,4,'public','1.3.6.1.2.1.2.2.1.16.52',161,10019,'Interface 52 Egress Traffic (Bps)','dell.6248.intf52.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19329,4,'public','1.3.6.1.2.1.2.2.1.16.52',161,10019,'Interface 52 Egress Traffic (bytes)','dell.6248.intf52.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19330,4,'public','1.3.6.1.2.1.2.2.1.19.52',161,10019,'Interface 52 Egress Discards','dell.6248.intf52.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19331,4,'public','1.3.6.1.2.1.2.2.1.20.52',161,10019,'Interface 52 Egress Errors','dell.6248.intf52.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19332,4,'public','1.3.6.1.2.1.2.2.1.18.52',161,10019,'Interface 52 Egress Traffic (Non-Unicast)','dell.6248.intf52.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19333,4,'public','1.3.6.1.2.1.2.2.1.17.52',161,10019,'Interface 52 Egress Traffic (Unicast)','dell.6248.intf52.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19334,4,'public','1.3.6.1.2.1.2.2.1.10.52',161,10019,'Interface 52 Ingress Traffic (Bps)','dell.6248.intf52.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19335,4,'public','1.3.6.1.2.1.2.2.1.10.52',161,10019,'Interface 52 Ingress Traffic (bytes)','dell.6248.intf52.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19336,4,'public','1.3.6.1.2.1.2.2.1.13.52',161,10019,'Interface 52 Ingress Discards','dell.6248.intf52.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19337,4,'public','1.3.6.1.2.1.2.2.1.14.52',161,10019,'Interface 52 Ingress Errors','dell.6248.intf52.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19338,4,'public','1.3.6.1.2.1.2.2.1.12.52',161,10019,'Interface 52 Ingress Traffic (Non-Unicast)','dell.6248.intf52.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19339,4,'public','1.3.6.1.2.1.2.2.1.11.52',161,10019,'Interface 52 Ingress Traffic (Unicast)','dell.6248.intf52.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19340,4,'public','1.3.6.1.2.1.31.1.1.1.18.6',161,10019,'Interface 06 Description','dell.6248.intf6.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19341,4,'public','1.3.6.1.2.1.2.2.1.5.6',161,10019,'Interface 06 Speed','dell.6248.intf6.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19342,4,'public','1.3.6.1.2.1.2.2.1.7.6',161,10019,'Interface 06 Admin Status','dell.6248.intf6.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19343,4,'public','1.3.6.1.2.1.2.2.1.8.6',161,10019,'Interface 06 Op Status','dell.6248.intf6.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19344,4,'public','1.3.6.1.2.1.2.2.1.16.6',161,10019,'Interface 06 Egress Traffic (Bps)','dell.6248.intf6.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19345,4,'public','1.3.6.1.2.1.2.2.1.16.6',161,10019,'Interface 06 Egress Traffic (bytes)','dell.6248.intf6.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19346,4,'public','1.3.6.1.2.1.2.2.1.19.6',161,10019,'Interface 06 Egress Discards','dell.6248.intf6.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19347,4,'public','1.3.6.1.2.1.2.2.1.20.6',161,10019,'Interface 06 Egress Errors','dell.6248.intf6.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19348,4,'public','1.3.6.1.2.1.2.2.1.18.6',161,10019,'Interface 06 Egress Traffic (Non-Unicast)','dell.6248.intf6.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19349,4,'public','1.3.6.1.2.1.2.2.1.17.6',161,10019,'Interface 06 Egress Traffic (Unicast)','dell.6248.intf6.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19350,4,'public','1.3.6.1.2.1.2.2.1.10.6',161,10019,'Interface 06 Ingress Traffic (Bps)','dell.6248.intf6.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19351,4,'public','1.3.6.1.2.1.2.2.1.10.6',161,10019,'Interface 06 Ingress Traffic (bytes)','dell.6248.intf6.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19352,4,'public','1.3.6.1.2.1.2.2.1.13.6',161,10019,'Interface 06 Ingress Discards','dell.6248.intf6.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19353,4,'public','1.3.6.1.2.1.2.2.1.14.6',161,10019,'Interface 06 Ingress Errors','dell.6248.intf6.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19354,4,'public','1.3.6.1.2.1.2.2.1.12.6',161,10019,'Interface 06 Ingress Traffic (Non-Unicast)','dell.6248.intf6.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19355,4,'public','1.3.6.1.2.1.2.2.1.11.6',161,10019,'Interface 06 Ingress Traffic (Unicast)','dell.6248.intf6.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19356,4,'public','1.3.6.1.2.1.31.1.1.1.18.7',161,10019,'Interface 07 Description','dell.6248.intf7.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19357,4,'public','1.3.6.1.2.1.2.2.1.5.7',161,10019,'Interface 07 Speed','dell.6248.intf7.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19358,4,'public','1.3.6.1.2.1.2.2.1.7.7',161,10019,'Interface 07 Admin Status','dell.6248.intf7.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19359,4,'public','1.3.6.1.2.1.2.2.1.8.7',161,10019,'Interface 07 Op Status','dell.6248.intf7.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19360,4,'public','1.3.6.1.2.1.2.2.1.16.7',161,10019,'Interface 07 Egress Traffic (Bps)','dell.6248.intf7.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19361,4,'public','1.3.6.1.2.1.2.2.1.16.7',161,10019,'Interface 07 Egress Traffic (bytes)','dell.6248.intf7.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19362,4,'public','1.3.6.1.2.1.2.2.1.19.7',161,10019,'Interface 07 Egress Discards','dell.6248.intf7.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19363,4,'public','1.3.6.1.2.1.2.2.1.20.7',161,10019,'Interface 07 Egress Errors','dell.6248.intf7.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19364,4,'public','1.3.6.1.2.1.2.2.1.18.7',161,10019,'Interface 07 Egress Traffic (Non-Unicast)','dell.6248.intf7.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19365,4,'public','1.3.6.1.2.1.2.2.1.17.7',161,10019,'Interface 07 Egress Traffic (Unicast)','dell.6248.intf7.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19366,4,'public','1.3.6.1.2.1.2.2.1.10.7',161,10019,'Interface 07 Ingress Traffic (Bps)','dell.6248.intf7.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19367,4,'public','1.3.6.1.2.1.2.2.1.10.7',161,10019,'Interface 07 Ingress Traffic (bytes)','dell.6248.intf7.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19368,4,'public','1.3.6.1.2.1.2.2.1.13.7',161,10019,'Interface 07 Ingress Discards','dell.6248.intf7.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19369,4,'public','1.3.6.1.2.1.2.2.1.14.7',161,10019,'Interface 07 Ingress Errors','dell.6248.intf7.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19370,4,'public','1.3.6.1.2.1.2.2.1.12.7',161,10019,'Interface 07 Ingress Traffic (Non-Unicast)','dell.6248.intf7.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19371,4,'public','1.3.6.1.2.1.2.2.1.11.7',161,10019,'Interface 07 Ingress Traffic (Unicast)','dell.6248.intf7.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19372,4,'public','1.3.6.1.2.1.31.1.1.1.18.8',161,10019,'Interface 08 Description','dell.6248.intf8.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19373,4,'public','1.3.6.1.2.1.2.2.1.5.8',161,10019,'Interface 08 Speed','dell.6248.intf8.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19374,4,'public','1.3.6.1.2.1.2.2.1.7.8',161,10019,'Interface 08 Admin Status','dell.6248.intf8.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19375,4,'public','1.3.6.1.2.1.2.2.1.8.8',161,10019,'Interface 08 Op Status','dell.6248.intf8.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19376,4,'public','1.3.6.1.2.1.2.2.1.16.8',161,10019,'Interface 08 Egress Traffic (Bps)','dell.6248.intf8.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19377,4,'public','1.3.6.1.2.1.2.2.1.16.8',161,10019,'Interface 08 Egress Traffic (bytes)','dell.6248.intf8.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19378,4,'public','1.3.6.1.2.1.2.2.1.19.8',161,10019,'Interface 08 Egress Discards','dell.6248.intf8.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19379,4,'public','1.3.6.1.2.1.2.2.1.20.8',161,10019,'Interface 08 Egress Errors','dell.6248.intf8.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19380,4,'public','1.3.6.1.2.1.2.2.1.18.8',161,10019,'Interface 08 Egress Traffic (Non-Unicast)','dell.6248.intf8.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19381,4,'public','1.3.6.1.2.1.2.2.1.17.8',161,10019,'Interface 08 Egress Traffic (Unicast)','dell.6248.intf8.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19382,4,'public','1.3.6.1.2.1.2.2.1.10.8',161,10019,'Interface 08 Ingress Traffic (Bps)','dell.6248.intf8.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19383,4,'public','1.3.6.1.2.1.2.2.1.10.8',161,10019,'Interface 08 Ingress Traffic (bytes)','dell.6248.intf8.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19384,4,'public','1.3.6.1.2.1.2.2.1.13.8',161,10019,'Interface 08 Ingress Discards','dell.6248.intf8.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19385,4,'public','1.3.6.1.2.1.2.2.1.14.8',161,10019,'Interface 08 Ingress Errors','dell.6248.intf8.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19386,4,'public','1.3.6.1.2.1.2.2.1.12.8',161,10019,'Interface 08 Ingress Traffic (Non-Unicast)','dell.6248.intf8.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19387,4,'public','1.3.6.1.2.1.2.2.1.11.8',161,10019,'Interface 08 Ingress Traffic (Unicast)','dell.6248.intf8.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19388,4,'public','1.3.6.1.2.1.31.1.1.1.18.9',161,10019,'Interface 09 Description','dell.6248.intf9.description',120,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19389,4,'public','1.3.6.1.2.1.2.2.1.5.9',161,10019,'Interface 09 Speed','dell.6248.intf9.speed',90,90,365,0,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19390,4,'public','1.3.6.1.2.1.2.2.1.7.9',161,10019,'Interface 09 Admin Status','dell.6248.intf9.status.admin',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19391,4,'public','1.3.6.1.2.1.2.2.1.8.9',161,10019,'Interface 09 Op Status','dell.6248.intf9.status.operational',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19392,4,'public','1.3.6.1.2.1.2.2.1.16.9',161,10019,'Interface 09 Egress Traffic (Bps)','dell.6248.intf9.traffic.egress.Bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19393,4,'public','1.3.6.1.2.1.2.2.1.16.9',161,10019,'Interface 09 Egress Traffic (bytes)','dell.6248.intf9.traffic.egress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19394,4,'public','1.3.6.1.2.1.2.2.1.19.9',161,10019,'Interface 09 Egress Discards','dell.6248.intf9.traffic.egress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19395,4,'public','1.3.6.1.2.1.2.2.1.20.9',161,10019,'Interface 09 Egress Errors','dell.6248.intf9.traffic.egress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19396,4,'public','1.3.6.1.2.1.2.2.1.18.9',161,10019,'Interface 09 Egress Traffic (Non-Unicast)','dell.6248.intf9.traffic.egress.nonunicast',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19397,4,'public','1.3.6.1.2.1.2.2.1.17.9',161,10019,'Interface 09 Egress Traffic (Unicast)','dell.6248.intf9.traffic.egress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19398,4,'public','1.3.6.1.2.1.2.2.1.10.9',161,10019,'Interface 09 Ingress Traffic (Bps)','dell.6248.intf9.traffic.ingress.bps',10,365,365,0,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19399,4,'public','1.3.6.1.2.1.2.2.1.10.9',161,10019,'Interface 09 Ingress Traffic (bytes)','dell.6248.intf9.traffic.ingress.bytes',60,365,365,0,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19400,4,'public','1.3.6.1.2.1.2.2.1.13.9',161,10019,'Interface 09 Ingress Discards','dell.6248.intf9.traffic.ingress.discards',60,90,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19401,4,'public','1.3.6.1.2.1.2.2.1.14.9',161,10019,'Interface 09 Ingress Errors','dell.6248.intf9.traffic.ingress.errors',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19402,4,'public','1.3.6.1.2.1.2.2.1.12.9',161,10019,'Interface 09 Ingress Traffic (Non-Unicast)','dell.6248.intf9.traffic.ingress.nonunicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19403,4,'public','1.3.6.1.2.1.2.2.1.11.9',161,10019,'Interface 09 Ingress Traffic (Unicast)','dell.6248.intf9.traffic.ingress.unicast',60,365,365,0,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19404,1,'public','.1.3.6.1.4.1.318.1.1.1.2.2.2.0',161,10020,'APC: Battery Temperature','upsAdvBatteryTemperature',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19405,1,'public','.1.3.6.1.4.1.318.1.1.1.4.2.4.0',161,10020,'APC: Load Current (Amps)','upsAdvOutputCurrent',30,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0.01','',0,'',0,0,'','');
INSERT INTO items VALUES (19406,1,'public','.1.3.6.1.4.1.318.1.1.1.4.2.3.0',161,10020,'APC: Output Load (%)','upsAdvOutputLoad',30,7,365,0,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0.01','',0,'',0,0,'','');
INSERT INTO items VALUES (19407,1,'public','.1.3.6.1.4.1.318.1.1.1.2.2.4.0',161,10020,'APC: Replace Battery Indicator','upsAdvReplaceBatteryIndicator',600,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,4,'','');
INSERT INTO items VALUES (19408,1,'public','.1.3.6.1.4.1.318.1.1.1.2.2.3.0',161,10020,'APC: Run Time Remaining','upsAdvRunTimeRemaining',30,7,365,0,NULL,NULL,NULL,0,3,'','s',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','');
INSERT INTO items VALUES (19409,1,'public','.1.3.6.1.4.1.318.1.1.1.2.1.1.0',161,10020,'APC: Battery Status','upsBasicBatteryStatus',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,5,'','');
INSERT INTO items VALUES (19410,1,'public','.1.3.6.1.4.1.318.1.1.1.2.1.2.0',161,10020,'APC: Time On Battery','upsBasicBatteryTimeOnBattery',30,7,365,0,NULL,NULL,NULL,0,3,'','s',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','');
INSERT INTO items VALUES (19411,4,'public','.1.3.6.1.4.1.232.3.2.2.1.1.6.0',161,10021,'HW: Disk Controller 1 Status','HPcontrollerRollupStatus.1',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19412,4,'public','.1.3.6.1.4.1.232.3.2.2.1.1.6.1',161,10021,'HW: Disk Controller 2 Status','HPcontrollerRollupStatus.2',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19413,4,'public','.1.3.6.1.4.1.232.3.2.3.1.1.11.0.1',161,10021,'HW: Logical Disk 0.1 Status','HPenclosureRollupStatus0.1',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19414,4,'public','.1.3.6.1.4.1.232.3.2.3.1.1.11.0.2',161,10021,'HW: Logical Disk 0.2 Status','HPenclosureRollupStatus0.2',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19415,4,'public','.1.3.6.1.4.1.232.3.2.3.1.1.11.1.1',161,10021,'HW: Logical Disk 1.1 Status','HPenclosureRollupStatus1.1',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19416,4,'public','.1.3.6.1.4.1.232.3.2.3.1.1.11.1.2',161,10021,'HW: Logical Disk 1.2 Status','HPenclosureRollupStatus1.2',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19417,4,'public','.1.3.6.1.4.1.232.2.1.3.0',161,10021,'HW: Chassis Status','HPsystemStateChassisStatus',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19418,4,'public','.1.3.6.1.4.1.232.6.2.6.1.0',161,10021,'HW: Fan Unit Status','HPsystemStateCoolingUnitStatusCombined',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19419,4,'public','.1.3.6.1.4.1.232.6.1.3.0',161,10021,'HW: Global System Status','HPsystemStateGlobalSystemStatus',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19420,4,'public','.1.3.6.1.4.1.232.6.2.14.4.0',161,10021,'HW: Memory Status','HPsystemStateMemoryDeviceStatusCombined',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19421,4,'public','.1.3.6.1.4.1.232.6.2.9.1.0',161,10021,'HW: Power Supply Status','HPsystemStatePowerSupplyStatusCombined',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19422,4,'public','.1.3.6.1.4.1.232.6.2.6.3.0',161,10021,'HW: Temperature Status','HPsystemStateTemperatureStatusCombined',240,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','');
INSERT INTO items VALUES (19423,1,'public','.1.3.6.1.4.1.674.10893.1.20.130.1.1.37.1',161,10022,'OM: Disk Controller 1 Status','controllerRollupStatus.1',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19424,1,'public','.1.3.6.1.4.1.674.10893.1.20.130.1.1.37.2',161,10022,'OM: Disk Controller 2 Status','controllerRollupStatus.2',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19425,1,'public','.1.3.6.1.4.1.674.10893.1.20.130.3.1.23.1',161,10022,'OM: Disk Enclosure 1 Status','enclosureRollupStatus.1',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19426,1,'public','.1.3.6.1.4.1.674.10893.1.20.130.3.1.23.2',161,10022,'OM: Disk Enclosure 2 Status','enclosureRollupStatus.2',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19427,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.30.1',161,10022,'OM: Chassis Intrusion Status','systemStateChassisIntrusionStatusCombined',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19428,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.4.1',161,10022,'OM: Chassis Status','systemStateChassisStatus',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19429,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.21.1',161,10022,'OM: Fan Status','systemStateCoolingDeviceStatusCombined',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19430,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.44.1',161,10022,'OM: Fan Unit Status','systemStateCoolingUnitStatusCombined',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19431,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.41.1',161,10022,'OM: Event Log Status','systemStateEventLogStatusCombined',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19432,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.2.1',161,10022,'OM: Global System Status','systemStateGlobalSystemStatus',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19433,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.27.1',161,10022,'OM: Memory Status','systemStateMemoryDeviceStatusCombined',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19434,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.9.1',161,10022,'OM: Power Supply Status','systemStatePowerSupplyStatusCombined',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19435,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.50.1',161,10022,'OM: Processor Status','systemStateProcessorDeviceStatusCombined',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19436,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.24.1',161,10022,'OM: Temperature Status','systemStateTeperatureStatusCombined',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19437,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.12.1',161,10022,'OM: Voltage Status','systemStateVoltageStatusCombined',30,7,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','');
INSERT INTO items VALUES (19438,1,'public','.1.3.6.1.4.1.9.9.147.1.2.2.2.1.5.40.6',161,10023,'Connections','Connections',60,90,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19439,1,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10023,'Available Free Processor Memory','FreeProcMem',60,90,365,0,NULL,NULL,NULL,0,3,'','b',0,0,NULL,'',0,'','','8','',0,'',0,0,'','');
INSERT INTO items VALUES (19440,1,'public','.1.3.6.1.2.1.1.1.0',161,10023,'Host_Infomation','Host_Infomation',3600,90,365,0,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19441,3,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10023,'Ping Check','icmpping',30,30,365,0,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','');
INSERT INTO items VALUES (19442,1,'public','.1.3.6.1.2.1.2.2.1.10.2',161,10023,'Inside ifInBytes','Inside_ifInBytes',60,90,365,0,NULL,NULL,NULL,0,0,'','b',1,1,NULL,'',0,'','','8','',0,'',0,0,'','');
INSERT INTO items VALUES (19443,1,'public','.1.3.6.1.2.1.2.2.1.16.2',161,10023,'Inside ifOutBytes','Inside_ifOutBytes',60,90,365,0,NULL,NULL,NULL,0,0,'','b',1,1,NULL,'',0,'','','8','',0,'',0,0,'','');
INSERT INTO items VALUES (19444,1,'public','.1.3.6.1.2.1.2.2.1.10.1',161,10023,'Outside ifInBytes','Outside_ifInBytes',60,90,365,0,NULL,NULL,NULL,0,0,'','b',1,1,NULL,'',0,'','','8','',0,'',0,0,'','');
INSERT INTO items VALUES (19445,1,'public','.1.3.6.1.2.1.2.2.1.16.1',161,10023,'Outside ifOutBytes','Outside_ifOutBytes',60,90,365,0,NULL,NULL,NULL,0,0,'','b',1,1,NULL,'',0,'','','8','',0,'',0,0,'','');
INSERT INTO items VALUES (19446,1,'public','.1.3.6.1.2.1.1.3.0',161,10023,'Uptime','Uptime',30,90,365,0,NULL,NULL,NULL,0,3,'','s',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','');
INSERT INTO items VALUES (19447,1,'public','..1.3.6.1.4.1.674.10892.1.700.20.1.6.1.5',161,10024,'Back plain temperature','dell_bp_temp',60,7,365,0,NULL,NULL,NULL,0,0,'','C',1,0,NULL,'',0,'','','.1','',0,'',0,0,'','');
INSERT INTO items VALUES (19448,1,'public','.1.3.6.1.4.1.674.10892.1.700.20.1.6.1.1',161,10024,'Main board temperature','dell_mb_temp',60,7,365,0,NULL,NULL,NULL,0,0,'','C',1,0,NULL,'',0,'','','.1','',0,'',0,0,'','');

--
-- Dumping data for table triggers
--

INSERT INTO triggers VALUES (10001,'{10211}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10002,'{11277}<10','Low free disk space on {HOSTNAME} volume /','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10004,'{11285}<10','Low free disk space on {HOSTNAME} volume /usr','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10005,'{11289}<10','Low number of free inodes on {HOSTNAME} volume /','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10006,'{11293}<10','Low number of free inodes on {HOSTNAME} volume /opt','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10007,'{11297}<10','Low number of free inodes on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10008,'{11295}<10','Low number of free inodes on {HOSTNAME} volume /usr','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10010,'{10010}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10011,'{10234}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10012,'{10212}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10013,'{10013}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10014,'{10197}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','',0);
INSERT INTO triggers VALUES (10015,'{10201}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','',0);
INSERT INTO triggers VALUES (10016,'{10199}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10017,'{11279}<10','Low free disk space on {HOSTNAME} volume /home','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10018,'{11291}<10','Low number of free inodes on {HOSTNAME} volume /home','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10019,'{11287}<10','Low free disk space on {HOSTNAME} volume /var','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10020,'{11281}<10','Low free disk space on {HOSTNAME} volume /opt','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10021,'{10196}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10022,'{10205}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10023,'{10206}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10024,'{10229}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10027,'{10227}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10028,'{10209}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10029,'{10200}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10030,'{10030}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10031,'{10198}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10032,'{10226}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10033,'{10210}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10034,'{10202}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10035,'{10225}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10036,'{10231}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10037,'{10230}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10038,'{10237}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10039,'{10238}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10041,'{10204}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10042,'{10203}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10043,'{10208}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10044,'{10207}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10045,'{10235}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10046,'{10236}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10047,'{10228}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10048,'{10048}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10049,'{10241}<10000','Low free disk space on {HOSTNAME} volume c:','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10056,'{10056}>300','Too many processes on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10057,'{10057}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10058,'{10058}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10059,'{10059}<100000','Lack of free swap space on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10061,'{10240}>0','c:\\autoexec.bat has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10068,'{10068}<600','{HOSTNAME} has just been restarted','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10081,'{10081}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10091,'{10091}>0','Host information was changed on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10092,'{10243}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,1,0,0,'','',0);
INSERT INTO triggers VALUES (10094,'{10094}=2','Server {HOSTNAME} is unreachable','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10163,'{11263}#1','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10164,'{11265}#1','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10165,'{11273}#1','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10168,'{11271}#1','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10169,'{11267}#1','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10173,'{11269}#1','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10187,'{11275}#1','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (10189,'{11283}<10','Low free disk space on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10190,'{10233}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','',0);
INSERT INTO triggers VALUES (10191,'{10242}<10000','Low free disk space on {HOSTNAME} volume d:','',0,2,3,0,0,'','',0);
INSERT INTO triggers VALUES (12001,'{11001}=1','sysName on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12002,'{11002}=1','lenvSerialNumber on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12003,'{11003}>0','lmemBufferNoMem on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12004,'{11004}>75','lcpuPercentBusy on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12005,'{11005}=1','lenvFirmVersion on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12006,'{11006}>0','lmemBufferFail on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12007,'{11007}<10240','lmemFreeMem on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12008,'{11008}=1','lmemRomID on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12009,'{11009}=1','ifDescr1 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12010,'{11010}=1','ifDescr2 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12011,'{11011}=1','ifDescr3 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12012,'{11012}=1','ifDescr4 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12013,'{11013}=1','ifDescr5 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12014,'{11014}=1','ifDescr6 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12015,'{11015}=1','ifDescr7 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12016,'{11016}=1','ifDescr8 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12017,'{11017}=1','ifDescr9 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12018,'{11018}=1','ifDescr10 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12019,'{11019}=1','ifDescr11 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12020,'{11020}=1','ifDescr12 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12021,'{11021}=1','ifDescr13 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12022,'{11022}=1','ifDescr14 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12023,'{11023}=1','ifDescr15 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12024,'{11024}=1','ifDescr16 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12025,'{11025}=1','ifDescr17 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12026,'{11026}=1','ifDescr18 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12027,'{11027}=1','ifDescr19 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12028,'{11028}=1','ifDescr20 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12029,'{11029}=1','ifDescr21 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12030,'{11030}=1','ifDescr22 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12031,'{11031}=1','ifDescr23 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12032,'{11032}=1','ifDescr24 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12033,'{11033}=1','ifDescr25 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12034,'{11034}=1','ifDescr26 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12035,'{11035}=1','ifDescr27 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12036,'{11036}=1','ifDescr28 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12037,'{11037}=1','ifDescr29 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12038,'{11038}=1','ifDescr30 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12039,'{11039}=1','ifDescr31 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12040,'{11040}=1','ifDescr32 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12041,'{11041}=1','ifDescr33 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12042,'{11042}=1','ifDescr34 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12043,'{11043}=1','ifDescr35 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12044,'{11044}=1','ifDescr36 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12045,'{11045}=1','ifDescr37 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12046,'{11046}=1','ifDescr38 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12047,'{11047}=1','ifDescr39 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12048,'{11048}=1','ifDescr40 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12049,'{11049}=1','ifDescr41 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12050,'{11050}=1','ifDescr42 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12051,'{11051}=1','ifDescr43 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12052,'{11052}=1','ifDescr44 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12053,'{11053}=1','ifDescr45 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12054,'{11054}=1','ifDescr46 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12055,'{11055}=1','ifDescr47 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12056,'{11056}=1','ifDescr48 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12057,'{11057}=1','ifDescr49 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12058,'{11058}=1','ifDescr50 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12059,'{11059}=1','ifDescr51 on {HOSTNAME} has Changed','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12060,'{11060}>150000','ifInOctets1 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12061,'{11061}>150000','ifInOctets2 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12062,'{11062}>150000','ifInOctets3 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12063,'{11063}>150000','ifInOctets4 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12064,'{11064}>150000','ifInOctets5 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12065,'{11065}>150000','ifInOctets6 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12066,'{11066}>150000','ifInOctets7 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12067,'{11067}>150000','ifInOctets8 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12068,'{11068}>150000','ifInOctets9 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12069,'{11069}>150000','ifInOctets10 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12070,'{11070}>150000','ifInOctets11 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12071,'{11071}>150000','ifInOctets12 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12072,'{11072}>150000','ifInOctets13 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12073,'{11073}>150000','ifInOctets14 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12074,'{11074}>150000','ifInOctets15 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12075,'{11075}>150000','ifInOctets16 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12076,'{11076}>150000','ifInOctets17 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12077,'{11077}>150000','ifInOctets18 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12078,'{11078}>150000','ifInOctets19 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12079,'{11079}>150000','ifInOctets20 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12080,'{11080}>150000','ifInOctets21 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12081,'{11081}>150000','ifInOctets22 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12082,'{11082}>150000','ifInOctets23 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12083,'{11083}>150000','ifInOctets24 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12084,'{11084}>150000','ifInOctets25 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12085,'{11085}>150000','ifInOctets26 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12086,'{11086}>150000','ifInOctets27 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12087,'{11087}>150000','ifInOctets28 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12088,'{11088}>150000','ifInOctets29 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12089,'{11089}>150000','ifInOctets30 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12090,'{11090}>150000','ifInOctets31 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12091,'{11091}>150000','ifInOctets32 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12092,'{11092}>150000','ifInOctets33 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12093,'{11093}>150000','ifInOctets34 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12094,'{11094}>150000','ifInOctets35 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12095,'{11095}>150000','ifInOctets36 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12096,'{11096}>150000','ifInOctets37 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12097,'{11097}>150000','ifInOctets38 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12098,'{11098}>150000','ifInOctets39 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12099,'{11099}>150000','ifInOctets40 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12100,'{11100}>150000','ifInOctets41 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12101,'{11101}>150000','ifInOctets42 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12102,'{11102}>150000','ifInOctets43 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12103,'{11103}>150000','ifInOctets44 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12104,'{11104}>150000','ifInOctets45 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12105,'{11105}>150000','ifInOctets46 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12106,'{11106}>150000','ifInOctets47 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12107,'{11107}>150000','ifInOctets48 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12108,'{11108}>150000','ifInOctets49 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12109,'{11109}>150000','ifInOctets50 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12110,'{11110}>150000','ifInOctets51 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12111,'{11111}>150000','ifOutOctets1 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12112,'{11112}>150000','ifOutOctets2 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12113,'{11113}>150000','ifOutOctets3 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12114,'{11114}>150000','ifOutOctets4 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12115,'{11115}>150000','ifOutOctets5 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12116,'{11116}>150000','ifOutOctets6 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12117,'{11117}>150000','ifOutOctets7 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12118,'{11118}>150000','ifOutOctets8 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12119,'{11119}>150000','ifOutOctets9 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12120,'{11120}>150000','ifOutOctets10 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12121,'{11121}>150000','ifOutOctets11 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12122,'{11122}>150000','ifOutOctets12 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12123,'{11123}>150000','ifOutOctets13 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12124,'{11124}>150000','ifOutOctets14 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12125,'{11125}>150000','ifOutOctets15 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12126,'{11126}>150000','ifOutOctets16 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12127,'{11127}>150000','ifOutOctets17 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12128,'{11128}>150000','ifOutOctets18 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12129,'{11129}>150000','ifOutOctets19 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12130,'{11130}>150000','ifOutOctets20 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12131,'{11131}>150000','ifOutOctets21 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12132,'{11132}>150000','ifOutOctets22 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12133,'{11133}>150000','ifOutOctets23 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12134,'{11134}>150000','ifOutOctets24 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12135,'{11135}>150000','ifOutOctets25 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12136,'{11136}>150000','ifOutOctets26 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12137,'{11137}>150000','ifOutOctets27 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12138,'{11138}>150000','ifOutOctets28 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12139,'{11139}>150000','ifOutOctets29 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12140,'{11140}>150000','ifOutOctets30 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12141,'{11141}>150000','ifOutOctets31 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12142,'{11142}>150000','ifOutOctets32 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12143,'{11143}>150000','ifOutOctets33 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12144,'{11144}>150000','ifOutOctets34 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12145,'{11145}>150000','ifOutOctets35 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12146,'{11146}>150000','ifOutOctets36 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12147,'{11147}>150000','ifOutOctets37 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12148,'{11148}>150000','ifOutOctets38 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12149,'{11149}>150000','ifOutOctets39 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12150,'{11150}>150000','ifOutOctets40 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12151,'{11151}>150000','ifOutOctets41 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12152,'{11152}>150000','ifOutOctets42 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12153,'{11153}>150000','ifOutOctets43 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12154,'{11154}>150000','ifOutOctets44 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12155,'{11155}>150000','ifOutOctets45 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12156,'{11156}>150000','ifOutOctets46 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12157,'{11157}>150000','ifOutOctets47 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12158,'{11158}>150000','ifOutOctets48 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12159,'{11159}>150000','ifOutOctets49 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12160,'{11160}>150000','ifOutOctets50 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12161,'{11161}>150000','ifOutOctets51 on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12162,'{11162}=0','ipForwarding on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12163,'{11163}>255','ipDefaultTTL on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12164,'{11164}>150000','ipInReceives on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12165,'{11165}>0','ipInHdrErrors on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12166,'{11166}>0','ipInAddrErrors on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12167,'{11167}>150000','ipInForwDatagrams on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12168,'{11168}>0','ipInUnknownProtos on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12169,'{11169}>0','ipInDiscards on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12170,'{11170}>150000','ipInDelivers on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12171,'{11171}>150000','ipOutRequests on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12172,'{11172}>0','ipOutDiscards on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12173,'{11173}>0','ipOutNoRoutes on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12174,'{11174}>0','ipReasmTimeout on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12175,'{11175}>150000','ipReasmReqds on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12176,'{11176}>150000','ipReasmOKs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12177,'{11177}>0','ipReasmFails on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12178,'{11178}>150000','ipFragOKs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12179,'{11179}>0','ipFragFails on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12180,'{11180}>150000','ipFragCreates on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12181,'{11181}>0','ipRoutingDiscards on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12182,'{11182}>150000','icmpInMsgs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12183,'{11183}>0','icmpInErrors on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12184,'{11184}>0','icmpInDestUnreachs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12185,'{11185}>1000','icmpInTimeExcds on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12186,'{11186}>0','icmpInParmProbs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12187,'{11187}>0','icmpInSrcQuenchs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12188,'{11188}>150000','icmpInRedirects on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12189,'{11189}>100','icmpInEchos on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12190,'{11190}>100','icmpInEchoReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12191,'{11191}>100','icmpInTimestamps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12192,'{11192}>100','icmpInTimestampReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12193,'{11193}>100','icmpInAddrMasks on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12194,'{11194}>100','icmpInAddrMaskReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12195,'{11195}>150000','icmpOutMsgs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12196,'{11196}>0','icmpOutErrors on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12197,'{11197}>0','icmpOutDesUnreachs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12198,'{11198}>1000','icmpOutTimeExcds on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12199,'{11199}>0','icmpOutParmProbs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12200,'{11200}>0','icmpOutSrcQuenchs on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12201,'{11201}>150000','icmpOutRedirects on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12202,'{11202}>100','icmpOutEchos on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12203,'{11203}>100','icmpOutEchoReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12204,'{11204}>100','icmpOutTimestamps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12205,'{11205}>100','icmpOutTimestampReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12206,'{11206}>100','icmpOutAddrMasks on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12207,'{11207}>100','icmpOutAddrMaskReps on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12208,'{11208}>1000','icmpOutRedirects on {HOSTNAME} is too High','',0,1,3,0,0,' ','',0);
INSERT INTO triggers VALUES (12209,'{11298}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12210,'{11299}<10','Low free disk space on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12211,'{11300}<10','Low free disk space on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12212,'{11301}<10','Low number of free inodes on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12213,'{11302}<10','Low number of free inodes on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12214,'{11303}<10','Low number of free inodes on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12215,'{11304}<10','Low number of free inodes on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12216,'{11305}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12217,'{11306}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12218,'{11307}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12219,'{11308}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12220,'{11309}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12221,'{11310}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12222,'{11311}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12223,'{11312}<10','Low free disk space on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12224,'{11313}<10','Low number of free inodes on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12225,'{11314}<10','Low free disk space on {HOSTNAME} volume /var','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12226,'{11315}<10','Low free disk space on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12227,'{11316}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12228,'{11317}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12229,'{11318}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12230,'{11319}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12231,'{11320}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12232,'{11321}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12233,'{11322}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12234,'{11323}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12235,'{11324}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12236,'{11325}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12237,'{11326}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12238,'{11327}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12239,'{11328}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12240,'{11329}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12241,'{11330}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12242,'{11331}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12243,'{11332}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12244,'{11333}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12245,'{11334}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12246,'{11335}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12247,'{11336}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12248,'{11337}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12249,'{11338}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12250,'{11339}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12251,'{11340}<10','Low free disk space on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12252,'{11341}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12253,'{11342}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12254,'{11343}<10','Low free disk space on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12255,'{11344}<10','Low free disk space on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12256,'{11345}<10','Low number of free inodes on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12257,'{11346}<10','Low number of free inodes on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12258,'{11347}<10','Low number of free inodes on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12259,'{11348}<10','Low number of free inodes on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12260,'{11349}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12261,'{11350}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12262,'{11351}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12263,'{11352}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12264,'{11353}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12265,'{11354}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12266,'{11355}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12267,'{11356}<10','Low free disk space on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12268,'{11357}<10','Low number of free inodes on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12269,'{11358}<10','Low free disk space on {HOSTNAME} volume /var','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12270,'{11359}<10','Low free disk space on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12271,'{11360}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12272,'{11361}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12273,'{11362}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12274,'{11363}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12275,'{11364}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12276,'{11365}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12277,'{11366}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12278,'{11367}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12279,'{11368}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12280,'{11369}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12281,'{11370}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12282,'{11371}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12283,'{11372}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12284,'{11373}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12285,'{11374}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12286,'{11375}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12287,'{11376}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12288,'{11377}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12289,'{11378}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12290,'{11379}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12291,'{11380}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12292,'{11381}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12293,'{11382}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12294,'{11383}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12295,'{11384}<10','Low free disk space on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12296,'{11385}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12297,'{11386}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12298,'{11387}<10','Low free disk space on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12299,'{11388}<10','Low free disk space on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12300,'{11389}<10','Low number of free inodes on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12301,'{11390}<10','Low number of free inodes on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12302,'{11391}<10','Low number of free inodes on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12303,'{11392}<10','Low number of free inodes on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12304,'{11393}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12305,'{11394}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12306,'{11395}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12307,'{11396}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12308,'{11397}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12309,'{11398}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12310,'{11399}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12311,'{11400}<10','Low free disk space on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12312,'{11401}<10','Low number of free inodes on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12313,'{11402}<10','Low free disk space on {HOSTNAME} volume /var','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12314,'{11403}<10','Low free disk space on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12315,'{11404}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12316,'{11405}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12317,'{11406}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12318,'{11407}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12319,'{11408}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12320,'{11409}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12321,'{11410}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12322,'{11411}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12323,'{11412}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12324,'{11413}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12325,'{11414}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12326,'{11415}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12327,'{11416}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12328,'{11417}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12329,'{11418}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12330,'{11419}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12331,'{11420}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12332,'{11421}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12333,'{11422}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12334,'{11423}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12335,'{11424}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12336,'{11425}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12337,'{11426}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12338,'{11427}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12339,'{11428}<10','Low free disk space on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12340,'{11429}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12341,'{11430}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12342,'{11431}<10','Low free disk space on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12343,'{11432}<10','Low free disk space on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12344,'{11433}<10','Low number of free inodes on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12345,'{11434}<10','Low number of free inodes on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12346,'{11435}<10','Low number of free inodes on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12347,'{11436}<10','Low number of free inodes on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12348,'{11437}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12349,'{11438}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12350,'{11439}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12351,'{11440}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12352,'{11441}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12353,'{11442}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12354,'{11443}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12355,'{11444}<10','Low free disk space on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12356,'{11445}<10','Low number of free inodes on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12357,'{11446}<10','Low free disk space on {HOSTNAME} volume /var','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12358,'{11447}<10','Low free disk space on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12359,'{11448}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12360,'{11449}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12361,'{11450}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12362,'{11451}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12363,'{11452}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12364,'{11453}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12365,'{11454}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12366,'{11455}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12367,'{11456}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12368,'{11457}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12369,'{11458}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12370,'{11459}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12371,'{11460}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12372,'{11461}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12373,'{11462}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12374,'{11463}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12375,'{11464}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12376,'{11465}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12377,'{11466}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12378,'{11467}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12379,'{11468}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12380,'{11469}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12381,'{11470}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12382,'{11471}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12383,'{11472}<10','Low free disk space on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12384,'{11473}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12385,'{11474}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12386,'{11475}<10','Low free disk space on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12387,'{11476}<10','Low free disk space on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12388,'{11477}<10','Low number of free inodes on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12389,'{11478}<10','Low number of free inodes on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12390,'{11479}<10','Low number of free inodes on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12391,'{11480}<10','Low number of free inodes on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12392,'{11481}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12393,'{11482}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12394,'{11483}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12395,'{11484}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12396,'{11485}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12397,'{11486}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12398,'{11487}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12399,'{11488}<10','Low free disk space on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12400,'{11489}<10','Low number of free inodes on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12401,'{11490}<10','Low free disk space on {HOSTNAME} volume /var','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12402,'{11491}<10','Low free disk space on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12403,'{11492}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12404,'{11493}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12405,'{11494}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12406,'{11495}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12407,'{11496}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12408,'{11497}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12409,'{11498}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12410,'{11499}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12411,'{11500}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12412,'{11501}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12413,'{11502}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12414,'{11503}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12415,'{11504}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12416,'{11505}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12417,'{11506}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12418,'{11507}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12419,'{11508}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12420,'{11509}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12421,'{11510}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12422,'{11511}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12423,'{11512}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12424,'{11513}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12425,'{11514}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12426,'{11515}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12427,'{11516}<10','Low free disk space on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12428,'{11517}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12429,'{11518}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12430,'{11519}<10','Low free disk space on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12431,'{11520}<10','Low free disk space on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12432,'{11521}<10','Low number of free inodes on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12433,'{11522}<10','Low number of free inodes on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12434,'{11523}<10','Low number of free inodes on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12435,'{11524}<10','Low number of free inodes on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12436,'{11525}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12437,'{11526}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12438,'{11527}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12439,'{11528}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12440,'{11529}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12441,'{11530}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12442,'{11531}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12443,'{11532}<10','Low free disk space on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12444,'{11533}<10','Low number of free inodes on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12445,'{11534}<10','Low free disk space on {HOSTNAME} volume /var','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12446,'{11535}<10','Low free disk space on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12447,'{11536}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12448,'{11537}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12449,'{11538}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12450,'{11539}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12451,'{11540}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12452,'{11541}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12453,'{11542}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12454,'{11543}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12455,'{11544}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12456,'{11545}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12457,'{11546}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12458,'{11547}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12459,'{11548}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12460,'{11549}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12461,'{11550}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12462,'{11551}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12463,'{11552}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12464,'{11553}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12465,'{11554}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12466,'{11555}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12467,'{11556}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12468,'{11557}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12469,'{11558}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12470,'{11559}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12471,'{11560}<10','Low free disk space on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12472,'{11561}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12473,'{11562}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12474,'{11563}<10','Low free disk space on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12475,'{11564}<10','Low free disk space on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12476,'{11565}<10','Low number of free inodes on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12477,'{11566}<10','Low number of free inodes on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12478,'{11567}<10','Low number of free inodes on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12479,'{11568}<10','Low number of free inodes on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12480,'{11569}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12481,'{11570}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12482,'{11571}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12483,'{11572}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12484,'{11573}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12485,'{11574}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12486,'{11575}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12487,'{11576}<10','Low free disk space on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12488,'{11577}<10','Low number of free inodes on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12489,'{11578}<10','Low free disk space on {HOSTNAME} volume /var','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12490,'{11579}<10','Low free disk space on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12491,'{11580}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12492,'{11581}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12493,'{11582}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12494,'{11583}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12495,'{11584}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12496,'{11585}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12497,'{11586}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12498,'{11587}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12499,'{11588}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12500,'{11589}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12501,'{11590}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12502,'{11591}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12503,'{11592}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12504,'{11593}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12505,'{11594}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12506,'{11595}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12507,'{11596}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12508,'{11597}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12509,'{11598}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12510,'{11599}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12511,'{11600}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12512,'{11601}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12513,'{11602}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12514,'{11603}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12515,'{11604}<10','Low free disk space on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12516,'{11605}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12517,'{11606}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12518,'{11607}<10','Low free disk space on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12519,'{11608}<10','Low free disk space on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12520,'{11609}<10','Low number of free inodes on {HOSTNAME} volume /','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12521,'{11610}<10','Low number of free inodes on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12522,'{11611}<10','Low number of free inodes on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12523,'{11612}<10','Low number of free inodes on {HOSTNAME} volume /usr','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12524,'{11613}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12525,'{11614}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12526,'{11615}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12527,'{11616}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12528,'{11617}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12529,'{11618}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12530,'{11619}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12531,'{11620}<10','Low free disk space on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12532,'{11621}<10','Low number of free inodes on {HOSTNAME} volume /home','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12533,'{11622}<10','Low free disk space on {HOSTNAME} volume /var','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12534,'{11623}<10','Low free disk space on {HOSTNAME} volume /opt','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12535,'{11624}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12536,'{11625}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12537,'{11626}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12538,'{11627}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12539,'{11628}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12540,'{11629}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12541,'{11630}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12542,'{11631}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12543,'{11632}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12544,'{11633}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12545,'{11634}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12546,'{11635}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12547,'{11636}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12548,'{11637}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12549,'{11638}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12550,'{11639}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12551,'{11640}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12552,'{11641}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12553,'{11642}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12554,'{11643}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12555,'{11644}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12556,'{11645}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12557,'{11646}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12558,'{11647}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12559,'{11648}<10','Low free disk space on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12560,'{11649}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12561,'{11650}=1','sysName on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12562,'{11651}=1','lenvSerialNumber on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12563,'{11652}>0','lmemBufferNoMem on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12564,'{11653}>75','lcpuPercentBusy on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12565,'{11654}=1','lenvFirmVersion on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12566,'{11655}>0','lmemBufferFail on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12567,'{11656}<10240','lmemFreeMem on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12568,'{11657}=1','lmemRomID on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12569,'{11658}=1','ifDescr1 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12570,'{11659}=1','ifDescr2 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12571,'{11660}=1','ifDescr3 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12572,'{11661}=1','ifDescr4 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12573,'{11662}=1','ifDescr5 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12574,'{11663}=1','ifDescr6 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12575,'{11664}=1','ifDescr7 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12576,'{11665}=1','ifDescr8 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12577,'{11666}=1','ifDescr9 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12578,'{11667}=1','ifDescr10 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12579,'{11668}=1','ifDescr11 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12580,'{11669}=1','ifDescr12 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12581,'{11670}=1','ifDescr13 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12582,'{11671}=1','ifDescr14 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12583,'{11672}=1','ifDescr15 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12584,'{11673}=1','ifDescr16 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12585,'{11674}=1','ifDescr17 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12586,'{11675}=1','ifDescr18 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12587,'{11676}=1','ifDescr19 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12588,'{11677}=1','ifDescr20 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12589,'{11678}=1','ifDescr21 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12590,'{11679}=1','ifDescr22 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12591,'{11680}=1','ifDescr23 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12592,'{11681}=1','ifDescr24 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12593,'{11682}=1','ifDescr25 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12594,'{11683}=1','ifDescr26 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12595,'{11684}=1','ifDescr27 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12596,'{11685}=1','ifDescr28 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12597,'{11686}=1','ifDescr29 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12598,'{11687}=1','ifDescr30 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12599,'{11688}=1','ifDescr31 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12600,'{11689}=1','ifDescr32 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12601,'{11690}=1','ifDescr33 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12602,'{11691}=1','ifDescr34 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12603,'{11692}=1','ifDescr35 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12604,'{11693}=1','ifDescr36 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12605,'{11694}=1','ifDescr37 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12606,'{11695}=1','ifDescr38 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12607,'{11696}=1','ifDescr39 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12608,'{11697}=1','ifDescr40 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12609,'{11698}=1','ifDescr41 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12610,'{11699}=1','ifDescr42 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12611,'{11700}=1','ifDescr43 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12612,'{11701}=1','ifDescr44 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12613,'{11702}=1','ifDescr45 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12614,'{11703}=1','ifDescr46 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12615,'{11704}=1','ifDescr47 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12616,'{11705}=1','ifDescr48 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12617,'{11706}=1','ifDescr49 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12618,'{11707}=1','ifDescr50 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12619,'{11708}=1','ifDescr51 on {HOSTNAME} has Changed','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12620,'{11709}>150000','ifInOctets1 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12621,'{11710}>150000','ifInOctets2 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12622,'{11711}>150000','ifInOctets3 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12623,'{11712}>150000','ifInOctets4 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12624,'{11713}>150000','ifInOctets5 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12625,'{11714}>150000','ifInOctets6 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12626,'{11715}>150000','ifInOctets7 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12627,'{11716}>150000','ifInOctets8 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12628,'{11717}>150000','ifInOctets9 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12629,'{11718}>150000','ifInOctets10 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12630,'{11719}>150000','ifInOctets11 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12631,'{11720}>150000','ifInOctets12 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12632,'{11721}>150000','ifInOctets13 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12633,'{11722}>150000','ifInOctets14 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12634,'{11723}>150000','ifInOctets15 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12635,'{11724}>150000','ifInOctets16 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12636,'{11725}>150000','ifInOctets17 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12637,'{11726}>150000','ifInOctets18 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12638,'{11727}>150000','ifInOctets19 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12639,'{11728}>150000','ifInOctets20 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12640,'{11729}>150000','ifInOctets21 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12641,'{11730}>150000','ifInOctets22 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12642,'{11731}>150000','ifInOctets23 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12643,'{11732}>150000','ifInOctets24 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12644,'{11733}>150000','ifInOctets25 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12645,'{11734}>150000','ifInOctets26 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12646,'{11735}>150000','ifInOctets27 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12647,'{11736}>150000','ifInOctets28 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12648,'{11737}>150000','ifInOctets29 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12649,'{11738}>150000','ifInOctets30 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12650,'{11739}>150000','ifInOctets31 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12651,'{11740}>150000','ifInOctets32 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12652,'{11741}>150000','ifInOctets33 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12653,'{11742}>150000','ifInOctets34 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12654,'{11743}>150000','ifInOctets35 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12655,'{11744}>150000','ifInOctets36 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12656,'{11745}>150000','ifInOctets37 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12657,'{11746}>150000','ifInOctets38 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12658,'{11747}>150000','ifInOctets39 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12659,'{11748}>150000','ifInOctets40 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12660,'{11749}>150000','ifInOctets41 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12661,'{11750}>150000','ifInOctets42 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12662,'{11751}>150000','ifInOctets43 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12663,'{11752}>150000','ifInOctets44 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12664,'{11753}>150000','ifInOctets45 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12665,'{11754}>150000','ifInOctets46 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12666,'{11755}>150000','ifInOctets47 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12667,'{11756}>150000','ifInOctets48 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12668,'{11757}>150000','ifInOctets49 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12669,'{11758}>150000','ifInOctets50 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12670,'{11759}>150000','ifInOctets51 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12671,'{11760}>150000','ifOutOctets1 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12672,'{11761}>150000','ifOutOctets2 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12673,'{11762}>150000','ifOutOctets3 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12674,'{11763}>150000','ifOutOctets4 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12675,'{11764}>150000','ifOutOctets5 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12676,'{11765}>150000','ifOutOctets6 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12677,'{11766}>150000','ifOutOctets7 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12678,'{11767}>150000','ifOutOctets8 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12679,'{11768}>150000','ifOutOctets9 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12680,'{11769}>150000','ifOutOctets10 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12681,'{11770}>150000','ifOutOctets11 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12682,'{11771}>150000','ifOutOctets12 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12683,'{11772}>150000','ifOutOctets13 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12684,'{11773}>150000','ifOutOctets14 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12685,'{11774}>150000','ifOutOctets15 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12686,'{11775}>150000','ifOutOctets16 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12687,'{11776}>150000','ifOutOctets17 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12688,'{11777}>150000','ifOutOctets18 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12689,'{11778}>150000','ifOutOctets19 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12690,'{11779}>150000','ifOutOctets20 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12691,'{11780}>150000','ifOutOctets21 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12692,'{11781}>150000','ifOutOctets22 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12693,'{11782}>150000','ifOutOctets23 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12694,'{11783}>150000','ifOutOctets24 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12695,'{11784}>150000','ifOutOctets25 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12696,'{11785}>150000','ifOutOctets26 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12697,'{11786}>150000','ifOutOctets27 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12698,'{11787}>150000','ifOutOctets28 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12699,'{11788}>150000','ifOutOctets29 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12700,'{11789}>150000','ifOutOctets30 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12701,'{11790}>150000','ifOutOctets31 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12702,'{11791}>150000','ifOutOctets32 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12703,'{11792}>150000','ifOutOctets33 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12704,'{11793}>150000','ifOutOctets34 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12705,'{11794}>150000','ifOutOctets35 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12706,'{11795}>150000','ifOutOctets36 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12707,'{11796}>150000','ifOutOctets37 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12708,'{11797}>150000','ifOutOctets38 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12709,'{11798}>150000','ifOutOctets39 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12710,'{11799}>150000','ifOutOctets40 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12711,'{11800}>150000','ifOutOctets41 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12712,'{11801}>150000','ifOutOctets42 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12713,'{11802}>150000','ifOutOctets43 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12714,'{11803}>150000','ifOutOctets44 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12715,'{11804}>150000','ifOutOctets45 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12716,'{11805}>150000','ifOutOctets46 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12717,'{11806}>150000','ifOutOctets47 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12718,'{11807}>150000','ifOutOctets48 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12719,'{11808}>150000','ifOutOctets49 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12720,'{11809}>150000','ifOutOctets50 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12721,'{11810}>150000','ifOutOctets51 on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12722,'{11811}=0','ipForwarding on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12723,'{11812}>255','ipDefaultTTL on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12724,'{11813}>150000','ipInReceives on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12725,'{11814}>0','ipInHdrErrors on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12726,'{11815}>0','ipInAddrErrors on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12727,'{11816}>150000','ipInForwDatagrams on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12728,'{11817}>0','ipInUnknownProtos on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12729,'{11818}>0','ipInDiscards on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12730,'{11819}>150000','ipInDelivers on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12731,'{11820}>150000','ipOutRequests on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12732,'{11821}>0','ipOutDiscards on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12733,'{11822}>0','ipOutNoRoutes on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12734,'{11823}>0','ipReasmTimeout on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12735,'{11824}>150000','ipReasmReqds on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12736,'{11825}>150000','ipReasmOKs on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12737,'{11826}>0','ipReasmFails on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12738,'{11827}>150000','ipFragOKs on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12739,'{11828}>0','ipFragFails on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12740,'{11829}>150000','ipFragCreates on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12741,'{11830}>0','ipRoutingDiscards on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12742,'{11831}>150000','icmpInMsgs on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12743,'{11832}>0','icmpInErrors on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12744,'{11833}>0','icmpInDestUnreachs on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12745,'{11834}>1000','icmpInTimeExcds on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12746,'{11835}>0','icmpInParmProbs on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12747,'{11836}>0','icmpInSrcQuenchs on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12748,'{11837}>150000','icmpInRedirects on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12749,'{11838}>100','icmpInEchos on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12750,'{11839}>100','icmpInEchoReps on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12751,'{11840}>100','icmpInTimestamps on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12752,'{11841}>100','icmpInTimestampReps on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12753,'{11842}>100','icmpInAddrMasks on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12754,'{11843}>100','icmpInAddrMaskReps on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12755,'{11844}>150000','icmpOutMsgs on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12756,'{11845}>0','icmpOutErrors on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12757,'{11846}>0','icmpOutDesUnreachs on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12758,'{11847}>1000','icmpOutTimeExcds on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12759,'{11848}>0','icmpOutParmProbs on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12760,'{11849}>0','icmpOutSrcQuenchs on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12761,'{11850}>100','icmpOutEchos on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12762,'{11851}>100','icmpOutEchoReps on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12763,'{11852}>100','icmpOutTimestamps on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12764,'{11853}>100','icmpOutTimestampReps on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12765,'{11854}>100','icmpOutAddrMasks on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12766,'{11855}>100','icmpOutAddrMaskReps on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12767,'{11856}>1000','icmpOutRedirects on {HOSTNAME} is too High','',0,2,3,0,0,' ','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12768,'{11857}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','',0,2,3,0,0,'','',10045);
INSERT INTO triggers VALUES (12769,'{11858}<512','Configured max number of opened files is too low on {HOSTNAME}','',0,2,1,0,0,'','',10042);
INSERT INTO triggers VALUES (12770,'{11859}<256','Configured max number of processes is too low on {HOSTNAME}','',0,2,1,0,0,'','',10041);
INSERT INTO triggers VALUES (12771,'{11860}=0','FTP server is down on {HOSTNAME}','',0,2,3,0,0,'','',10023);
INSERT INTO triggers VALUES (12772,'{11861}=0','WEB (HTTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',10046);
INSERT INTO triggers VALUES (12773,'{11862}=0','IMAP server is down on {HOSTNAME}','',0,2,3,0,0,'','',10028);
INSERT INTO triggers VALUES (12774,'{11863}=0','News (NNTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',10032);
INSERT INTO triggers VALUES (12775,'{11864}=0','POP3 server is down on {HOSTNAME}','',0,2,3,0,0,'','',10027);
INSERT INTO triggers VALUES (12776,'{11865}=0','Email (SMTP) server is down on {HOSTNAME}','',0,2,3,0,0,'','',10022);
INSERT INTO triggers VALUES (12777,'{11866}=0','SSH server is down on {HOSTNAME}','',0,2,3,0,0,'','',10024);
INSERT INTO triggers VALUES (12778,'{11867}>10','Too many processes running on {HOSTNAME}','',0,2,3,0,0,'','',10011);
INSERT INTO triggers VALUES (12779,'{11868}<1','Apache is not running on {HOSTNAME}','',0,2,3,0,0,'','',10034);
INSERT INTO triggers VALUES (12780,'{11869}<1','Inetd is not running on {HOSTNAME}','',0,2,3,0,0,'','',10033);
INSERT INTO triggers VALUES (12781,'{11870}<1','Mysql is not running on {HOSTNAME}','',0,2,3,0,0,'','',10035);
INSERT INTO triggers VALUES (12782,'{11871}<1','Sshd is not running on {HOSTNAME}','',0,2,3,0,0,'','',10037);
INSERT INTO triggers VALUES (12783,'{11872}<1','Syslogd is not running on {HOSTNAME}','',0,2,3,0,0,'','',10036);
INSERT INTO triggers VALUES (12784,'{11873}<1','Zabbix_agentd is not running on {HOSTNAME}','',0,2,3,0,0,'','',10038);
INSERT INTO triggers VALUES (12785,'{11874}<1','Zabbix_server is not running on {HOSTNAME}','',0,2,3,0,0,'','',10039);
INSERT INTO triggers VALUES (12786,'{11875}>300','Too many processes on {HOSTNAME}','',0,2,4,0,0,'','',10190);
INSERT INTO triggers VALUES (12787,'{11876}=2','Server {HOSTNAME} is unreachable','',0,2,4,0,0,'','',10047);
INSERT INTO triggers VALUES (12788,'{11877}>5','Processor load is too high on {HOSTNAME}','',0,2,3,0,0,'','',10010);
INSERT INTO triggers VALUES (12789,'{11878}>0','Hostname was changed on {HOSTNAME}','',0,2,1,0,0,'','',10043);
INSERT INTO triggers VALUES (12790,'{11879}<100000','Lack of free swap space on {HOSTNAME}','',0,2,4,0,0,'','',10012);
INSERT INTO triggers VALUES (12791,'{11880}>0','Host information was changed on {HOSTNAME}','',0,2,1,0,0,'','',10044);
INSERT INTO triggers VALUES (12792,'{11881}<600','{HOSTNAME} has just been restarted','',0,2,1,0,0,'','',10021);
INSERT INTO triggers VALUES (12793,'{11882}>50','Too may users connected on server {HOSTNAME}','',0,2,3,0,0,'','',10013);
INSERT INTO triggers VALUES (12794,'{11883}>0','/etc/inetd.conf has been changed on server {HOSTNAME}','',0,2,2,0,0,'','',10014);
INSERT INTO triggers VALUES (12795,'{11884}>0','/etc/passwd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',10016);
INSERT INTO triggers VALUES (12796,'{11885}>0','/etc/services has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',10031);
INSERT INTO triggers VALUES (12797,'{11886}>0','/usr/bin/ssh has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',10030);
INSERT INTO triggers VALUES (12798,'{11887}>0','/usr/sbin/sshd has been changed on server {HOSTNAME}','',0,2,3,0,0,'','',10029);
INSERT INTO triggers VALUES (12799,'{11888}>0','/vmlinuz has been changed on server {HOSTNAME}','',0,2,2,0,0,'','',10015);
INSERT INTO triggers VALUES (12800,'{11889}<10','Low number of free inodes on {HOSTNAME} volume /','',0,2,4,0,0,'','',10005);
INSERT INTO triggers VALUES (12801,'{11890}<10','Low number of free inodes on {HOSTNAME} volume /home','',0,2,4,0,0,'','',10018);
INSERT INTO triggers VALUES (12802,'{11891}<10','Low number of free inodes on {HOSTNAME} volume /opt','',0,2,4,0,0,'','',10006);
INSERT INTO triggers VALUES (12803,'{11892}<10','Low number of free inodes on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','',10007);
INSERT INTO triggers VALUES (12804,'{11893}<10','Low number of free inodes on {HOSTNAME} volume /usr','',0,2,4,0,0,'','',10008);
INSERT INTO triggers VALUES (12805,'{11894}<10','Low free disk space on {HOSTNAME} volume /','',0,2,4,0,0,'','',10002);
INSERT INTO triggers VALUES (12806,'{11895}<10','Low free disk space on {HOSTNAME} volume /home','',0,2,4,0,0,'','',10017);
INSERT INTO triggers VALUES (12807,'{11896}<10','Low free disk space on {HOSTNAME} volume /opt','',0,2,4,0,0,'','',10020);
INSERT INTO triggers VALUES (12808,'{11897}<10','Low free disk space on {HOSTNAME} volume /tmp','',0,2,4,0,0,'','',10189);
INSERT INTO triggers VALUES (12809,'{11898}<10','Low free disk space on {HOSTNAME} volume /usr','',0,2,4,0,0,'','',10004);
INSERT INTO triggers VALUES (12810,'{11899}<10','Low free disk space on {HOSTNAME} volume /var','',0,2,4,0,0,'','',10019);
INSERT INTO triggers VALUES (12811,'{11900}<10000','Lack of free memory on server {HOSTNAME}','',0,2,3,0,0,'','',10001);
INSERT INTO triggers VALUES (12812,'{11901}>40','APC: High Battery Temperature - {HOSTNAME}','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12813,'{11902}#2','APC: Loss of Input Power - {HOSTNAME}','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12814,'{11903}#1','APC: Replace Battery - {HOSTNAME}','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12815,'{11904}<5','APC: Run Time Remaining Critical Level - {HOSTNAME}','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12816,'{11905}<10','APC: Run Time Remaining Low - {HOSTNAME}','',0,2,4,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12817,'{11907}>90','APC: Output Load Too High - {HOSTNAME}','',0,2,2,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12818,'{11908}>2','HW: Chassis Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12819,'{11909}>2','HW: Fan Unit Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12820,'{11910}>2','HW: Global System Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12821,'{11911}>2','HW: Memory Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12822,'{11912}>2','HW: Power Supply Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12823,'{11913}>2','HW: Disk Controller 1 Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12824,'{11918}>2','HW: Disk Enclosure 1 Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12825,'{11915}>2','HW: Disk Controller 2 Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12826,'{11919}>2','HW: Disk Enclosure 2 Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12827,'{11917}>2','HW: Temperature Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12828,'{11922}>4','OM: Chassis Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12829,'{11923}>4','OM: Chassis Intrusion','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12830,'{11925}>4','OM: Fan Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12831,'{11927}>4','OM: Fan Unit Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12832,'{11929}>4','OM: Event Log Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12833,'{11931}>4','OM: Global System Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12834,'{11933}>4','OM: Memory Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12835,'{11935}>4','OM: Power Supply Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12836,'{11937}>4','OM: Processor Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12837,'{11939}>4','OM: Temperature Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12838,'{11941}>4','OM: Voltage Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12839,'{11943}>4','OM: Disk Controller 1 Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12840,'{11945}>4','OM: Disk Enclosure 1 Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12841,'{11947}>4','OM: Disk Controller 2 Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12842,'{11949}>4','OM: Disk Enclosure 2 Status','',0,2,5,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12843,'{11950}=0','Ping Check','',0,2,3,0,0,'','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12844,'{11951}>47','Server Temperature Max Failure Threshold','',0,2,4,0,0,'The internal chassis temperature of the server is above 47 degrees Celsius or 116.6 degrees Fahrenheit.  This exceeds Dell specifications.','Trigger just added. No status update so far.',0);
INSERT INTO triggers VALUES (12845,'{11952}>42','Server Temperature Max Waring Threshold','',0,2,2,0,0,'The internal chassis temperature of the server is above 42 degrees Celsius or 107.6 degrees Fahrenheit.','Trigger just added. No status update so far.',0);

--
-- Dumping data for table functions
--

INSERT INTO functions VALUES (10010,10010,10010,NULL,'last','0');
INSERT INTO functions VALUES (10013,10016,10013,NULL,'last','0');
INSERT INTO functions VALUES (10030,10039,10030,NULL,'diff','0');
INSERT INTO functions VALUES (10048,10090,10048,NULL,'last','0');
INSERT INTO functions VALUES (10056,10098,10056,NULL,'last','0');
INSERT INTO functions VALUES (10057,10099,10057,NULL,'last','0');
INSERT INTO functions VALUES (10058,10102,10058,NULL,'last','0');
INSERT INTO functions VALUES (10059,10103,10059,NULL,'last','0');
INSERT INTO functions VALUES (10068,10114,10068,NULL,'last','0');
INSERT INTO functions VALUES (10081,10137,10081,NULL,'last','0');
INSERT INTO functions VALUES (10091,10147,10091,NULL,'diff','0');
INSERT INTO functions VALUES (10094,10150,10094,NULL,'last','0');
INSERT INTO functions VALUES (10196,10025,10021,NULL,'last','0');
INSERT INTO functions VALUES (10197,10017,10014,NULL,'diff','0');
INSERT INTO functions VALUES (10198,10040,10031,NULL,'diff','0');
INSERT INTO functions VALUES (10199,10019,10016,NULL,'diff','0');
INSERT INTO functions VALUES (10200,10038,10029,NULL,'diff','0');
INSERT INTO functions VALUES (10201,10018,10015,NULL,'diff','0');
INSERT INTO functions VALUES (10202,10048,10034,NULL,'last','0');
INSERT INTO functions VALUES (10203,10056,10042,NULL,'last','0');
INSERT INTO functions VALUES (10204,10055,10041,NULL,'last','0');
INSERT INTO functions VALUES (10205,10031,10022,NULL,'last','0');
INSERT INTO functions VALUES (10206,10032,10023,NULL,'last','0');
INSERT INTO functions VALUES (10207,10058,10044,NULL,'diff','0');
INSERT INTO functions VALUES (10208,10057,10043,NULL,'diff','0');
INSERT INTO functions VALUES (10209,10037,10028,NULL,'last','0');
INSERT INTO functions VALUES (10210,10047,10033,NULL,'last','0');
INSERT INTO functions VALUES (10211,10001,10001,NULL,'last','0');
INSERT INTO functions VALUES (10212,10014,10012,NULL,'last','0');
INSERT INTO functions VALUES (10225,10049,10035,NULL,'last','0');
INSERT INTO functions VALUES (10226,10046,10032,NULL,'last','0');
INSERT INTO functions VALUES (10227,10036,10027,NULL,'last','0');
INSERT INTO functions VALUES (10228,10061,10047,NULL,'last','0');
INSERT INTO functions VALUES (10229,10033,10024,NULL,'last','0');
INSERT INTO functions VALUES (10230,10051,10037,NULL,'last','0');
INSERT INTO functions VALUES (10231,10050,10036,NULL,'last','0');
INSERT INTO functions VALUES (10233,10009,10190,NULL,'last','0');
INSERT INTO functions VALUES (10234,10013,10011,NULL,'last','0');
INSERT INTO functions VALUES (10235,10059,10045,NULL,'diff','0');
INSERT INTO functions VALUES (10236,10060,10046,NULL,'last','0');
INSERT INTO functions VALUES (10237,10052,10038,NULL,'last','0');
INSERT INTO functions VALUES (10238,10053,10039,NULL,'last','0');
INSERT INTO functions VALUES (10240,10106,10061,NULL,'diff','0');
INSERT INTO functions VALUES (10241,10091,10049,NULL,'last','0');
INSERT INTO functions VALUES (10242,10358,10191,NULL,'last','0');
INSERT INTO functions VALUES (10243,10148,10092,NULL,'diff','0');
INSERT INTO functions VALUES (11001,17001,12001,NULL,'diff','0');
INSERT INTO functions VALUES (11002,17002,12002,NULL,'diff','0');
INSERT INTO functions VALUES (11003,17003,12003,NULL,'delta','0');
INSERT INTO functions VALUES (11004,17004,12004,NULL,'delta','0');
INSERT INTO functions VALUES (11005,17005,12005,NULL,'diff','0');
INSERT INTO functions VALUES (11006,17006,12006,NULL,'delta','0');
INSERT INTO functions VALUES (11007,17007,12007,NULL,'delta','0');
INSERT INTO functions VALUES (11008,17008,12008,NULL,'diff','0');
INSERT INTO functions VALUES (11009,17009,12009,NULL,'diff','0');
INSERT INTO functions VALUES (11010,17010,12010,NULL,'diff','0');
INSERT INTO functions VALUES (11011,17011,12011,NULL,'diff','0');
INSERT INTO functions VALUES (11012,17012,12012,NULL,'diff','0');
INSERT INTO functions VALUES (11013,17013,12013,NULL,'diff','0');
INSERT INTO functions VALUES (11014,17014,12014,NULL,'diff','0');
INSERT INTO functions VALUES (11015,17015,12015,NULL,'diff','0');
INSERT INTO functions VALUES (11016,17016,12016,NULL,'diff','0');
INSERT INTO functions VALUES (11017,17017,12017,NULL,'diff','0');
INSERT INTO functions VALUES (11018,17018,12018,NULL,'diff','0');
INSERT INTO functions VALUES (11019,17019,12019,NULL,'diff','0');
INSERT INTO functions VALUES (11020,17020,12020,NULL,'diff','0');
INSERT INTO functions VALUES (11021,17021,12021,NULL,'diff','0');
INSERT INTO functions VALUES (11022,17022,12022,NULL,'diff','0');
INSERT INTO functions VALUES (11023,17023,12023,NULL,'diff','0');
INSERT INTO functions VALUES (11024,17024,12024,NULL,'diff','0');
INSERT INTO functions VALUES (11025,17025,12025,NULL,'diff','0');
INSERT INTO functions VALUES (11026,17026,12026,NULL,'diff','0');
INSERT INTO functions VALUES (11027,17027,12027,NULL,'diff','0');
INSERT INTO functions VALUES (11028,17028,12028,NULL,'diff','0');
INSERT INTO functions VALUES (11029,17029,12029,NULL,'diff','0');
INSERT INTO functions VALUES (11030,17030,12030,NULL,'diff','0');
INSERT INTO functions VALUES (11031,17031,12031,NULL,'diff','0');
INSERT INTO functions VALUES (11032,17032,12032,NULL,'diff','0');
INSERT INTO functions VALUES (11033,17033,12033,NULL,'diff','0');
INSERT INTO functions VALUES (11034,17034,12034,NULL,'diff','0');
INSERT INTO functions VALUES (11035,17035,12035,NULL,'diff','0');
INSERT INTO functions VALUES (11036,17036,12036,NULL,'diff','0');
INSERT INTO functions VALUES (11037,17037,12037,NULL,'diff','0');
INSERT INTO functions VALUES (11038,17038,12038,NULL,'diff','0');
INSERT INTO functions VALUES (11039,17039,12039,NULL,'diff','0');
INSERT INTO functions VALUES (11040,17040,12040,NULL,'diff','0');
INSERT INTO functions VALUES (11041,17041,12041,NULL,'diff','0');
INSERT INTO functions VALUES (11042,17042,12042,NULL,'diff','0');
INSERT INTO functions VALUES (11043,17043,12043,NULL,'diff','0');
INSERT INTO functions VALUES (11044,17044,12044,NULL,'diff','0');
INSERT INTO functions VALUES (11045,17045,12045,NULL,'diff','0');
INSERT INTO functions VALUES (11046,17046,12046,NULL,'diff','0');
INSERT INTO functions VALUES (11047,17047,12047,NULL,'diff','0');
INSERT INTO functions VALUES (11048,17048,12048,NULL,'diff','0');
INSERT INTO functions VALUES (11049,17049,12049,NULL,'diff','0');
INSERT INTO functions VALUES (11050,17050,12050,NULL,'diff','0');
INSERT INTO functions VALUES (11051,17051,12051,NULL,'diff','0');
INSERT INTO functions VALUES (11052,17052,12052,NULL,'diff','0');
INSERT INTO functions VALUES (11053,17053,12053,NULL,'diff','0');
INSERT INTO functions VALUES (11054,17054,12054,NULL,'diff','0');
INSERT INTO functions VALUES (11055,17055,12055,NULL,'diff','0');
INSERT INTO functions VALUES (11056,17056,12056,NULL,'diff','0');
INSERT INTO functions VALUES (11057,17057,12057,NULL,'diff','0');
INSERT INTO functions VALUES (11058,17058,12058,NULL,'diff','0');
INSERT INTO functions VALUES (11059,17059,12059,NULL,'diff','0');
INSERT INTO functions VALUES (11060,17060,12060,NULL,'delta','0');
INSERT INTO functions VALUES (11061,17061,12061,NULL,'delta','0');
INSERT INTO functions VALUES (11062,17062,12062,NULL,'delta','0');
INSERT INTO functions VALUES (11063,17063,12063,NULL,'delta','0');
INSERT INTO functions VALUES (11064,17064,12064,NULL,'delta','0');
INSERT INTO functions VALUES (11065,17065,12065,NULL,'delta','0');
INSERT INTO functions VALUES (11066,17066,12066,NULL,'delta','0');
INSERT INTO functions VALUES (11067,17067,12067,NULL,'delta','0');
INSERT INTO functions VALUES (11068,17068,12068,NULL,'delta','0');
INSERT INTO functions VALUES (11069,17069,12069,NULL,'delta','0');
INSERT INTO functions VALUES (11070,17070,12070,NULL,'delta','0');
INSERT INTO functions VALUES (11071,17071,12071,NULL,'delta','0');
INSERT INTO functions VALUES (11072,17072,12072,NULL,'delta','0');
INSERT INTO functions VALUES (11073,17073,12073,NULL,'delta','0');
INSERT INTO functions VALUES (11074,17074,12074,NULL,'delta','0');
INSERT INTO functions VALUES (11075,17075,12075,NULL,'delta','0');
INSERT INTO functions VALUES (11076,17076,12076,NULL,'delta','0');
INSERT INTO functions VALUES (11077,17077,12077,NULL,'delta','0');
INSERT INTO functions VALUES (11078,17078,12078,NULL,'delta','0');
INSERT INTO functions VALUES (11079,17079,12079,NULL,'delta','0');
INSERT INTO functions VALUES (11080,17080,12080,NULL,'delta','0');
INSERT INTO functions VALUES (11081,17081,12081,NULL,'delta','0');
INSERT INTO functions VALUES (11082,17082,12082,NULL,'delta','0');
INSERT INTO functions VALUES (11083,17083,12083,NULL,'delta','0');
INSERT INTO functions VALUES (11084,17084,12084,NULL,'delta','0');
INSERT INTO functions VALUES (11085,17085,12085,NULL,'delta','0');
INSERT INTO functions VALUES (11086,17086,12086,NULL,'delta','0');
INSERT INTO functions VALUES (11087,17087,12087,NULL,'delta','0');
INSERT INTO functions VALUES (11088,17088,12088,NULL,'delta','0');
INSERT INTO functions VALUES (11089,17089,12089,NULL,'delta','0');
INSERT INTO functions VALUES (11090,17090,12090,NULL,'delta','0');
INSERT INTO functions VALUES (11091,17091,12091,NULL,'delta','0');
INSERT INTO functions VALUES (11092,17092,12092,NULL,'delta','0');
INSERT INTO functions VALUES (11093,17093,12093,NULL,'delta','0');
INSERT INTO functions VALUES (11094,17094,12094,NULL,'delta','0');
INSERT INTO functions VALUES (11095,17095,12095,NULL,'delta','0');
INSERT INTO functions VALUES (11096,17096,12096,NULL,'delta','0');
INSERT INTO functions VALUES (11097,17097,12097,NULL,'delta','0');
INSERT INTO functions VALUES (11098,17098,12098,NULL,'delta','0');
INSERT INTO functions VALUES (11099,17099,12099,NULL,'delta','0');
INSERT INTO functions VALUES (11100,17100,12100,NULL,'delta','0');
INSERT INTO functions VALUES (11101,17101,12101,NULL,'delta','0');
INSERT INTO functions VALUES (11102,17102,12102,NULL,'delta','0');
INSERT INTO functions VALUES (11103,17103,12103,NULL,'delta','0');
INSERT INTO functions VALUES (11104,17104,12104,NULL,'delta','0');
INSERT INTO functions VALUES (11105,17105,12105,NULL,'delta','0');
INSERT INTO functions VALUES (11106,17106,12106,NULL,'delta','0');
INSERT INTO functions VALUES (11107,17107,12107,NULL,'delta','0');
INSERT INTO functions VALUES (11108,17108,12108,NULL,'delta','0');
INSERT INTO functions VALUES (11109,17109,12109,NULL,'delta','0');
INSERT INTO functions VALUES (11110,17110,12110,NULL,'delta','0');
INSERT INTO functions VALUES (11111,17111,12111,NULL,'delta','0');
INSERT INTO functions VALUES (11112,17112,12112,NULL,'delta','0');
INSERT INTO functions VALUES (11113,17113,12113,NULL,'delta','0');
INSERT INTO functions VALUES (11114,17114,12114,NULL,'delta','0');
INSERT INTO functions VALUES (11115,17115,12115,NULL,'delta','0');
INSERT INTO functions VALUES (11116,17116,12116,NULL,'delta','0');
INSERT INTO functions VALUES (11117,17117,12117,NULL,'delta','0');
INSERT INTO functions VALUES (11118,17118,12118,NULL,'delta','0');
INSERT INTO functions VALUES (11119,17119,12119,NULL,'delta','0');
INSERT INTO functions VALUES (11120,17120,12120,NULL,'delta','0');
INSERT INTO functions VALUES (11121,17121,12121,NULL,'delta','0');
INSERT INTO functions VALUES (11122,17122,12122,NULL,'delta','0');
INSERT INTO functions VALUES (11123,17123,12123,NULL,'delta','0');
INSERT INTO functions VALUES (11124,17124,12124,NULL,'delta','0');
INSERT INTO functions VALUES (11125,17125,12125,NULL,'delta','0');
INSERT INTO functions VALUES (11126,17126,12126,NULL,'delta','0');
INSERT INTO functions VALUES (11127,17127,12127,NULL,'delta','0');
INSERT INTO functions VALUES (11128,17128,12128,NULL,'delta','0');
INSERT INTO functions VALUES (11129,17129,12129,NULL,'delta','0');
INSERT INTO functions VALUES (11130,17130,12130,NULL,'delta','0');
INSERT INTO functions VALUES (11131,17131,12131,NULL,'delta','0');
INSERT INTO functions VALUES (11132,17132,12132,NULL,'delta','0');
INSERT INTO functions VALUES (11133,17133,12133,NULL,'delta','0');
INSERT INTO functions VALUES (11134,17134,12134,NULL,'delta','0');
INSERT INTO functions VALUES (11135,17135,12135,NULL,'delta','0');
INSERT INTO functions VALUES (11136,17136,12136,NULL,'delta','0');
INSERT INTO functions VALUES (11137,17137,12137,NULL,'delta','0');
INSERT INTO functions VALUES (11138,17138,12138,NULL,'delta','0');
INSERT INTO functions VALUES (11139,17139,12139,NULL,'delta','0');
INSERT INTO functions VALUES (11140,17140,12140,NULL,'delta','0');
INSERT INTO functions VALUES (11141,17141,12141,NULL,'delta','0');
INSERT INTO functions VALUES (11142,17142,12142,NULL,'delta','0');
INSERT INTO functions VALUES (11143,17143,12143,NULL,'delta','0');
INSERT INTO functions VALUES (11144,17144,12144,NULL,'delta','0');
INSERT INTO functions VALUES (11145,17145,12145,NULL,'delta','0');
INSERT INTO functions VALUES (11146,17146,12146,NULL,'delta','0');
INSERT INTO functions VALUES (11147,17147,12147,NULL,'delta','0');
INSERT INTO functions VALUES (11148,17148,12148,NULL,'delta','0');
INSERT INTO functions VALUES (11149,17149,12149,NULL,'delta','0');
INSERT INTO functions VALUES (11150,17150,12150,NULL,'delta','0');
INSERT INTO functions VALUES (11151,17151,12151,NULL,'delta','0');
INSERT INTO functions VALUES (11152,17152,12152,NULL,'delta','0');
INSERT INTO functions VALUES (11153,17153,12153,NULL,'delta','0');
INSERT INTO functions VALUES (11154,17154,12154,NULL,'delta','0');
INSERT INTO functions VALUES (11155,17155,12155,NULL,'delta','0');
INSERT INTO functions VALUES (11156,17156,12156,NULL,'delta','0');
INSERT INTO functions VALUES (11157,17157,12157,NULL,'delta','0');
INSERT INTO functions VALUES (11158,17158,12158,NULL,'delta','0');
INSERT INTO functions VALUES (11159,17159,12159,NULL,'delta','0');
INSERT INTO functions VALUES (11160,17160,12160,NULL,'delta','0');
INSERT INTO functions VALUES (11161,17161,12161,NULL,'delta','0');
INSERT INTO functions VALUES (11162,17162,12162,NULL,'last','0');
INSERT INTO functions VALUES (11163,17163,12163,NULL,'last','0');
INSERT INTO functions VALUES (11164,17164,12164,NULL,'delta','0');
INSERT INTO functions VALUES (11165,17165,12165,NULL,'delta','0');
INSERT INTO functions VALUES (11166,17166,12166,NULL,'delta','0');
INSERT INTO functions VALUES (11167,17167,12167,NULL,'delta','0');
INSERT INTO functions VALUES (11168,17168,12168,NULL,'delta','0');
INSERT INTO functions VALUES (11169,17169,12169,NULL,'delta','0');
INSERT INTO functions VALUES (11170,17170,12170,NULL,'delta','0');
INSERT INTO functions VALUES (11171,17171,12171,NULL,'delta','0');
INSERT INTO functions VALUES (11172,17172,12172,NULL,'delta','0');
INSERT INTO functions VALUES (11173,17173,12173,NULL,'delta','0');
INSERT INTO functions VALUES (11174,17174,12174,NULL,'delta','0');
INSERT INTO functions VALUES (11175,17175,12175,NULL,'delta','0');
INSERT INTO functions VALUES (11176,17176,12176,NULL,'delta','0');
INSERT INTO functions VALUES (11177,17177,12177,NULL,'delta','0');
INSERT INTO functions VALUES (11178,17178,12178,NULL,'delta','0');
INSERT INTO functions VALUES (11179,17179,12179,NULL,'delta','0');
INSERT INTO functions VALUES (11180,17180,12180,NULL,'delta','0');
INSERT INTO functions VALUES (11181,17181,12181,NULL,'delta','0');
INSERT INTO functions VALUES (11182,17182,12182,NULL,'delta','0');
INSERT INTO functions VALUES (11183,17183,12183,NULL,'delta','0');
INSERT INTO functions VALUES (11184,17184,12184,NULL,'delta','0');
INSERT INTO functions VALUES (11185,17185,12185,NULL,'delta','0');
INSERT INTO functions VALUES (11186,17186,12186,NULL,'delta','0');
INSERT INTO functions VALUES (11187,17187,12187,NULL,'delta','0');
INSERT INTO functions VALUES (11188,17188,12188,NULL,'delta','0');
INSERT INTO functions VALUES (11189,17189,12189,NULL,'delta','0');
INSERT INTO functions VALUES (11190,17190,12190,NULL,'delta','0');
INSERT INTO functions VALUES (11191,17191,12191,NULL,'delta','0');
INSERT INTO functions VALUES (11192,17192,12192,NULL,'delta','0');
INSERT INTO functions VALUES (11193,17193,12193,NULL,'delta','0');
INSERT INTO functions VALUES (11194,17194,12194,NULL,'delta','0');
INSERT INTO functions VALUES (11195,17195,12195,NULL,'delta','0');
INSERT INTO functions VALUES (11196,17196,12196,NULL,'delta','0');
INSERT INTO functions VALUES (11197,17197,12197,NULL,'delta','0');
INSERT INTO functions VALUES (11198,17198,12198,NULL,'delta','0');
INSERT INTO functions VALUES (11199,17199,12199,NULL,'delta','0');
INSERT INTO functions VALUES (11200,17200,12200,NULL,'delta','0');
INSERT INTO functions VALUES (11201,17201,12201,NULL,'delta','0');
INSERT INTO functions VALUES (11202,17202,12202,NULL,'delta','0');
INSERT INTO functions VALUES (11203,17203,12203,NULL,'delta','0');
INSERT INTO functions VALUES (11204,17204,12204,NULL,'delta','0');
INSERT INTO functions VALUES (11205,17205,12205,NULL,'delta','0');
INSERT INTO functions VALUES (11206,17206,12206,NULL,'delta','0');
INSERT INTO functions VALUES (11207,17207,12207,NULL,'delta','0');
INSERT INTO functions VALUES (11208,17208,12208,NULL,'delta','0');
INSERT INTO functions VALUES (11263,10298,10163,NULL,'last','0');
INSERT INTO functions VALUES (11265,10299,10164,NULL,'last','0');
INSERT INTO functions VALUES (11267,10304,10169,NULL,'last','0');
INSERT INTO functions VALUES (11269,10313,10173,NULL,'last','0');
INSERT INTO functions VALUES (11271,10303,10168,NULL,'last','0');
INSERT INTO functions VALUES (11273,10300,10165,NULL,'last','0');
INSERT INTO functions VALUES (11275,10327,10187,NULL,'last','0');
INSERT INTO functions VALUES (11277,17322,10002,NULL,'last','0');
INSERT INTO functions VALUES (11279,17324,10017,NULL,'last','0');
INSERT INTO functions VALUES (11281,17326,10020,NULL,'last','0');
INSERT INTO functions VALUES (11283,17328,10189,NULL,'last','0');
INSERT INTO functions VALUES (11285,17320,10004,NULL,'last','0');
INSERT INTO functions VALUES (11287,17373,10019,NULL,'last','0');
INSERT INTO functions VALUES (11289,17330,10005,NULL,'last','0');
INSERT INTO functions VALUES (11291,17332,10018,NULL,'last','0');
INSERT INTO functions VALUES (11293,17334,10006,NULL,'last','0');
INSERT INTO functions VALUES (11295,17338,10008,NULL,'last','0');
INSERT INTO functions VALUES (11297,17336,10007,NULL,'last','0');
INSERT INTO functions VALUES (11298,17511,12209,NULL,'last','0');
INSERT INTO functions VALUES (11299,17482,12210,NULL,'last','0');
INSERT INTO functions VALUES (11300,17501,12211,NULL,'last','0');
INSERT INTO functions VALUES (11301,17467,12212,NULL,'last','0');
INSERT INTO functions VALUES (11302,17473,12213,NULL,'last','0');
INSERT INTO functions VALUES (11303,17476,12214,NULL,'last','0');
INSERT INTO functions VALUES (11304,17479,12215,NULL,'last','0');
INSERT INTO functions VALUES (11305,17445,12216,NULL,'last','0');
INSERT INTO functions VALUES (11306,17430,12217,NULL,'last','0');
INSERT INTO functions VALUES (11307,17454,12218,NULL,'last','0');
INSERT INTO functions VALUES (11308,17459,12219,NULL,'last','0');
INSERT INTO functions VALUES (11309,17460,12220,NULL,'diff','0');
INSERT INTO functions VALUES (11310,17465,12221,NULL,'diff','0');
INSERT INTO functions VALUES (11311,17461,12222,NULL,'diff','0');
INSERT INTO functions VALUES (11312,17487,12223,NULL,'last','0');
INSERT INTO functions VALUES (11313,17470,12224,NULL,'last','0');
INSERT INTO functions VALUES (11314,17506,12225,NULL,'last','0');
INSERT INTO functions VALUES (11315,17491,12226,NULL,'last','0');
INSERT INTO functions VALUES (11316,17458,12227,NULL,'last','0');
INSERT INTO functions VALUES (11317,17428,12228,NULL,'last','0');
INSERT INTO functions VALUES (11318,17423,12229,NULL,'last','0');
INSERT INTO functions VALUES (11319,17429,12230,NULL,'last','0');
INSERT INTO functions VALUES (11320,17427,12231,NULL,'last','0');
INSERT INTO functions VALUES (11321,17425,12232,NULL,'last','0');
INSERT INTO functions VALUES (11322,17464,12233,NULL,'diff','0');
INSERT INTO functions VALUES (11323,17463,12234,NULL,'diff','0');
INSERT INTO functions VALUES (11324,17462,12235,NULL,'diff','0');
INSERT INTO functions VALUES (11325,17426,12236,NULL,'last','0');
INSERT INTO functions VALUES (11326,17432,12237,NULL,'last','0');
INSERT INTO functions VALUES (11327,17431,12238,NULL,'last','0');
INSERT INTO functions VALUES (11328,17433,12239,NULL,'last','0');
INSERT INTO functions VALUES (11329,17435,12240,NULL,'last','0');
INSERT INTO functions VALUES (11330,17434,12241,NULL,'last','0');
INSERT INTO functions VALUES (11331,17436,12242,NULL,'last','0');
INSERT INTO functions VALUES (11332,17437,12243,NULL,'last','0');
INSERT INTO functions VALUES (11333,17416,12244,NULL,'last','0');
INSERT INTO functions VALUES (11334,17415,12245,NULL,'last','0');
INSERT INTO functions VALUES (11335,17452,12246,NULL,'diff','0');
INSERT INTO functions VALUES (11336,17457,12247,NULL,'diff','0');
INSERT INTO functions VALUES (11337,17413,12248,NULL,'diff','0');
INSERT INTO functions VALUES (11338,17424,12249,NULL,'last','0');
INSERT INTO functions VALUES (11339,17442,12250,NULL,'last','0');
INSERT INTO functions VALUES (11340,17496,12251,NULL,'last','0');
INSERT INTO functions VALUES (11341,17438,12252,NULL,'last','0');
INSERT INTO functions VALUES (11342,17613,12253,NULL,'last','0');
INSERT INTO functions VALUES (11343,17584,12254,NULL,'last','0');
INSERT INTO functions VALUES (11344,17603,12255,NULL,'last','0');
INSERT INTO functions VALUES (11345,17569,12256,NULL,'last','0');
INSERT INTO functions VALUES (11346,17575,12257,NULL,'last','0');
INSERT INTO functions VALUES (11347,17578,12258,NULL,'last','0');
INSERT INTO functions VALUES (11348,17581,12259,NULL,'last','0');
INSERT INTO functions VALUES (11349,17547,12260,NULL,'last','0');
INSERT INTO functions VALUES (11350,17532,12261,NULL,'last','0');
INSERT INTO functions VALUES (11351,17556,12262,NULL,'last','0');
INSERT INTO functions VALUES (11352,17561,12263,NULL,'last','0');
INSERT INTO functions VALUES (11353,17562,12264,NULL,'diff','0');
INSERT INTO functions VALUES (11354,17567,12265,NULL,'diff','0');
INSERT INTO functions VALUES (11355,17563,12266,NULL,'diff','0');
INSERT INTO functions VALUES (11356,17589,12267,NULL,'last','0');
INSERT INTO functions VALUES (11357,17572,12268,NULL,'last','0');
INSERT INTO functions VALUES (11358,17608,12269,NULL,'last','0');
INSERT INTO functions VALUES (11359,17593,12270,NULL,'last','0');
INSERT INTO functions VALUES (11360,17560,12271,NULL,'last','0');
INSERT INTO functions VALUES (11361,17530,12272,NULL,'last','0');
INSERT INTO functions VALUES (11362,17525,12273,NULL,'last','0');
INSERT INTO functions VALUES (11363,17531,12274,NULL,'last','0');
INSERT INTO functions VALUES (11364,17529,12275,NULL,'last','0');
INSERT INTO functions VALUES (11365,17527,12276,NULL,'last','0');
INSERT INTO functions VALUES (11366,17566,12277,NULL,'diff','0');
INSERT INTO functions VALUES (11367,17565,12278,NULL,'diff','0');
INSERT INTO functions VALUES (11368,17564,12279,NULL,'diff','0');
INSERT INTO functions VALUES (11369,17528,12280,NULL,'last','0');
INSERT INTO functions VALUES (11370,17534,12281,NULL,'last','0');
INSERT INTO functions VALUES (11371,17533,12282,NULL,'last','0');
INSERT INTO functions VALUES (11372,17535,12283,NULL,'last','0');
INSERT INTO functions VALUES (11373,17537,12284,NULL,'last','0');
INSERT INTO functions VALUES (11374,17536,12285,NULL,'last','0');
INSERT INTO functions VALUES (11375,17538,12286,NULL,'last','0');
INSERT INTO functions VALUES (11376,17539,12287,NULL,'last','0');
INSERT INTO functions VALUES (11377,17518,12288,NULL,'last','0');
INSERT INTO functions VALUES (11378,17517,12289,NULL,'last','0');
INSERT INTO functions VALUES (11379,17554,12290,NULL,'diff','0');
INSERT INTO functions VALUES (11380,17559,12291,NULL,'diff','0');
INSERT INTO functions VALUES (11381,17515,12292,NULL,'diff','0');
INSERT INTO functions VALUES (11382,17526,12293,NULL,'last','0');
INSERT INTO functions VALUES (11383,17544,12294,NULL,'last','0');
INSERT INTO functions VALUES (11384,17598,12295,NULL,'last','0');
INSERT INTO functions VALUES (11385,17540,12296,NULL,'last','0');
INSERT INTO functions VALUES (11386,17715,12297,NULL,'last','0');
INSERT INTO functions VALUES (11387,17686,12298,NULL,'last','0');
INSERT INTO functions VALUES (11388,17705,12299,NULL,'last','0');
INSERT INTO functions VALUES (11389,17671,12300,NULL,'last','0');
INSERT INTO functions VALUES (11390,17677,12301,NULL,'last','0');
INSERT INTO functions VALUES (11391,17680,12302,NULL,'last','0');
INSERT INTO functions VALUES (11392,17683,12303,NULL,'last','0');
INSERT INTO functions VALUES (11393,17649,12304,NULL,'last','0');
INSERT INTO functions VALUES (11394,17634,12305,NULL,'last','0');
INSERT INTO functions VALUES (11395,17658,12306,NULL,'last','0');
INSERT INTO functions VALUES (11396,17663,12307,NULL,'last','0');
INSERT INTO functions VALUES (11397,17664,12308,NULL,'diff','0');
INSERT INTO functions VALUES (11398,17669,12309,NULL,'diff','0');
INSERT INTO functions VALUES (11399,17665,12310,NULL,'diff','0');
INSERT INTO functions VALUES (11400,17691,12311,NULL,'last','0');
INSERT INTO functions VALUES (11401,17674,12312,NULL,'last','0');
INSERT INTO functions VALUES (11402,17710,12313,NULL,'last','0');
INSERT INTO functions VALUES (11403,17695,12314,NULL,'last','0');
INSERT INTO functions VALUES (11404,17662,12315,NULL,'last','0');
INSERT INTO functions VALUES (11405,17632,12316,NULL,'last','0');
INSERT INTO functions VALUES (11406,17627,12317,NULL,'last','0');
INSERT INTO functions VALUES (11407,17633,12318,NULL,'last','0');
INSERT INTO functions VALUES (11408,17631,12319,NULL,'last','0');
INSERT INTO functions VALUES (11409,17629,12320,NULL,'last','0');
INSERT INTO functions VALUES (11410,17668,12321,NULL,'diff','0');
INSERT INTO functions VALUES (11411,17667,12322,NULL,'diff','0');
INSERT INTO functions VALUES (11412,17666,12323,NULL,'diff','0');
INSERT INTO functions VALUES (11413,17630,12324,NULL,'last','0');
INSERT INTO functions VALUES (11414,17636,12325,NULL,'last','0');
INSERT INTO functions VALUES (11415,17635,12326,NULL,'last','0');
INSERT INTO functions VALUES (11416,17637,12327,NULL,'last','0');
INSERT INTO functions VALUES (11417,17639,12328,NULL,'last','0');
INSERT INTO functions VALUES (11418,17638,12329,NULL,'last','0');
INSERT INTO functions VALUES (11419,17640,12330,NULL,'last','0');
INSERT INTO functions VALUES (11420,17641,12331,NULL,'last','0');
INSERT INTO functions VALUES (11421,17620,12332,NULL,'last','0');
INSERT INTO functions VALUES (11422,17619,12333,NULL,'last','0');
INSERT INTO functions VALUES (11423,17656,12334,NULL,'diff','0');
INSERT INTO functions VALUES (11424,17661,12335,NULL,'diff','0');
INSERT INTO functions VALUES (11425,17617,12336,NULL,'diff','0');
INSERT INTO functions VALUES (11426,17628,12337,NULL,'last','0');
INSERT INTO functions VALUES (11427,17646,12338,NULL,'last','0');
INSERT INTO functions VALUES (11428,17700,12339,NULL,'last','0');
INSERT INTO functions VALUES (11429,17642,12340,NULL,'last','0');
INSERT INTO functions VALUES (11430,17817,12341,NULL,'last','0');
INSERT INTO functions VALUES (11431,17788,12342,NULL,'last','0');
INSERT INTO functions VALUES (11432,17807,12343,NULL,'last','0');
INSERT INTO functions VALUES (11433,17773,12344,NULL,'last','0');
INSERT INTO functions VALUES (11434,17779,12345,NULL,'last','0');
INSERT INTO functions VALUES (11435,17782,12346,NULL,'last','0');
INSERT INTO functions VALUES (11436,17785,12347,NULL,'last','0');
INSERT INTO functions VALUES (11437,17751,12348,NULL,'last','0');
INSERT INTO functions VALUES (11438,17736,12349,NULL,'last','0');
INSERT INTO functions VALUES (11439,17760,12350,NULL,'last','0');
INSERT INTO functions VALUES (11440,17765,12351,NULL,'last','0');
INSERT INTO functions VALUES (11441,17766,12352,NULL,'diff','0');
INSERT INTO functions VALUES (11442,17771,12353,NULL,'diff','0');
INSERT INTO functions VALUES (11443,17767,12354,NULL,'diff','0');
INSERT INTO functions VALUES (11444,17793,12355,NULL,'last','0');
INSERT INTO functions VALUES (11445,17776,12356,NULL,'last','0');
INSERT INTO functions VALUES (11446,17812,12357,NULL,'last','0');
INSERT INTO functions VALUES (11447,17797,12358,NULL,'last','0');
INSERT INTO functions VALUES (11448,17764,12359,NULL,'last','0');
INSERT INTO functions VALUES (11449,17734,12360,NULL,'last','0');
INSERT INTO functions VALUES (11450,17729,12361,NULL,'last','0');
INSERT INTO functions VALUES (11451,17735,12362,NULL,'last','0');
INSERT INTO functions VALUES (11452,17733,12363,NULL,'last','0');
INSERT INTO functions VALUES (11453,17731,12364,NULL,'last','0');
INSERT INTO functions VALUES (11454,17770,12365,NULL,'diff','0');
INSERT INTO functions VALUES (11455,17769,12366,NULL,'diff','0');
INSERT INTO functions VALUES (11456,17768,12367,NULL,'diff','0');
INSERT INTO functions VALUES (11457,17732,12368,NULL,'last','0');
INSERT INTO functions VALUES (11458,17738,12369,NULL,'last','0');
INSERT INTO functions VALUES (11459,17737,12370,NULL,'last','0');
INSERT INTO functions VALUES (11460,17739,12371,NULL,'last','0');
INSERT INTO functions VALUES (11461,17741,12372,NULL,'last','0');
INSERT INTO functions VALUES (11462,17740,12373,NULL,'last','0');
INSERT INTO functions VALUES (11463,17742,12374,NULL,'last','0');
INSERT INTO functions VALUES (11464,17743,12375,NULL,'last','0');
INSERT INTO functions VALUES (11465,17722,12376,NULL,'last','0');
INSERT INTO functions VALUES (11466,17721,12377,NULL,'last','0');
INSERT INTO functions VALUES (11467,17758,12378,NULL,'diff','0');
INSERT INTO functions VALUES (11468,17763,12379,NULL,'diff','0');
INSERT INTO functions VALUES (11469,17719,12380,NULL,'diff','0');
INSERT INTO functions VALUES (11470,17730,12381,NULL,'last','0');
INSERT INTO functions VALUES (11471,17748,12382,NULL,'last','0');
INSERT INTO functions VALUES (11472,17802,12383,NULL,'last','0');
INSERT INTO functions VALUES (11473,17744,12384,NULL,'last','0');
INSERT INTO functions VALUES (11474,17919,12385,NULL,'last','0');
INSERT INTO functions VALUES (11475,17890,12386,NULL,'last','0');
INSERT INTO functions VALUES (11476,17909,12387,NULL,'last','0');
INSERT INTO functions VALUES (11477,17875,12388,NULL,'last','0');
INSERT INTO functions VALUES (11478,17881,12389,NULL,'last','0');
INSERT INTO functions VALUES (11479,17884,12390,NULL,'last','0');
INSERT INTO functions VALUES (11480,17887,12391,NULL,'last','0');
INSERT INTO functions VALUES (11481,17853,12392,NULL,'last','0');
INSERT INTO functions VALUES (11482,17838,12393,NULL,'last','0');
INSERT INTO functions VALUES (11483,17862,12394,NULL,'last','0');
INSERT INTO functions VALUES (11484,17867,12395,NULL,'last','0');
INSERT INTO functions VALUES (11485,17868,12396,NULL,'diff','0');
INSERT INTO functions VALUES (11486,17873,12397,NULL,'diff','0');
INSERT INTO functions VALUES (11487,17869,12398,NULL,'diff','0');
INSERT INTO functions VALUES (11488,17895,12399,NULL,'last','0');
INSERT INTO functions VALUES (11489,17878,12400,NULL,'last','0');
INSERT INTO functions VALUES (11490,17914,12401,NULL,'last','0');
INSERT INTO functions VALUES (11491,17899,12402,NULL,'last','0');
INSERT INTO functions VALUES (11492,17866,12403,NULL,'last','0');
INSERT INTO functions VALUES (11493,17836,12404,NULL,'last','0');
INSERT INTO functions VALUES (11494,17831,12405,NULL,'last','0');
INSERT INTO functions VALUES (11495,17837,12406,NULL,'last','0');
INSERT INTO functions VALUES (11496,17835,12407,NULL,'last','0');
INSERT INTO functions VALUES (11497,17833,12408,NULL,'last','0');
INSERT INTO functions VALUES (11498,17872,12409,NULL,'diff','0');
INSERT INTO functions VALUES (11499,17871,12410,NULL,'diff','0');
INSERT INTO functions VALUES (11500,17870,12411,NULL,'diff','0');
INSERT INTO functions VALUES (11501,17834,12412,NULL,'last','0');
INSERT INTO functions VALUES (11502,17840,12413,NULL,'last','0');
INSERT INTO functions VALUES (11503,17839,12414,NULL,'last','0');
INSERT INTO functions VALUES (11504,17841,12415,NULL,'last','0');
INSERT INTO functions VALUES (11505,17843,12416,NULL,'last','0');
INSERT INTO functions VALUES (11506,17842,12417,NULL,'last','0');
INSERT INTO functions VALUES (11507,17844,12418,NULL,'last','0');
INSERT INTO functions VALUES (11508,17845,12419,NULL,'last','0');
INSERT INTO functions VALUES (11509,17824,12420,NULL,'last','0');
INSERT INTO functions VALUES (11510,17823,12421,NULL,'last','0');
INSERT INTO functions VALUES (11511,17860,12422,NULL,'diff','0');
INSERT INTO functions VALUES (11512,17865,12423,NULL,'diff','0');
INSERT INTO functions VALUES (11513,17821,12424,NULL,'diff','0');
INSERT INTO functions VALUES (11514,17832,12425,NULL,'last','0');
INSERT INTO functions VALUES (11515,17850,12426,NULL,'last','0');
INSERT INTO functions VALUES (11516,17904,12427,NULL,'last','0');
INSERT INTO functions VALUES (11517,17846,12428,NULL,'last','0');
INSERT INTO functions VALUES (11518,18021,12429,NULL,'last','0');
INSERT INTO functions VALUES (11519,17992,12430,NULL,'last','0');
INSERT INTO functions VALUES (11520,18011,12431,NULL,'last','0');
INSERT INTO functions VALUES (11521,17977,12432,NULL,'last','0');
INSERT INTO functions VALUES (11522,17983,12433,NULL,'last','0');
INSERT INTO functions VALUES (11523,17986,12434,NULL,'last','0');
INSERT INTO functions VALUES (11524,17989,12435,NULL,'last','0');
INSERT INTO functions VALUES (11525,17955,12436,NULL,'last','0');
INSERT INTO functions VALUES (11526,17940,12437,NULL,'last','0');
INSERT INTO functions VALUES (11527,17964,12438,NULL,'last','0');
INSERT INTO functions VALUES (11528,17969,12439,NULL,'last','0');
INSERT INTO functions VALUES (11529,17970,12440,NULL,'diff','0');
INSERT INTO functions VALUES (11530,17975,12441,NULL,'diff','0');
INSERT INTO functions VALUES (11531,17971,12442,NULL,'diff','0');
INSERT INTO functions VALUES (11532,17997,12443,NULL,'last','0');
INSERT INTO functions VALUES (11533,17980,12444,NULL,'last','0');
INSERT INTO functions VALUES (11534,18016,12445,NULL,'last','0');
INSERT INTO functions VALUES (11535,18001,12446,NULL,'last','0');
INSERT INTO functions VALUES (11536,17968,12447,NULL,'last','0');
INSERT INTO functions VALUES (11537,17938,12448,NULL,'last','0');
INSERT INTO functions VALUES (11538,17933,12449,NULL,'last','0');
INSERT INTO functions VALUES (11539,17939,12450,NULL,'last','0');
INSERT INTO functions VALUES (11540,17937,12451,NULL,'last','0');
INSERT INTO functions VALUES (11541,17935,12452,NULL,'last','0');
INSERT INTO functions VALUES (11542,17974,12453,NULL,'diff','0');
INSERT INTO functions VALUES (11543,17973,12454,NULL,'diff','0');
INSERT INTO functions VALUES (11544,17972,12455,NULL,'diff','0');
INSERT INTO functions VALUES (11545,17936,12456,NULL,'last','0');
INSERT INTO functions VALUES (11546,17942,12457,NULL,'last','0');
INSERT INTO functions VALUES (11547,17941,12458,NULL,'last','0');
INSERT INTO functions VALUES (11548,17943,12459,NULL,'last','0');
INSERT INTO functions VALUES (11549,17945,12460,NULL,'last','0');
INSERT INTO functions VALUES (11550,17944,12461,NULL,'last','0');
INSERT INTO functions VALUES (11551,17946,12462,NULL,'last','0');
INSERT INTO functions VALUES (11552,17947,12463,NULL,'last','0');
INSERT INTO functions VALUES (11553,17926,12464,NULL,'last','0');
INSERT INTO functions VALUES (11554,17925,12465,NULL,'last','0');
INSERT INTO functions VALUES (11555,17962,12466,NULL,'diff','0');
INSERT INTO functions VALUES (11556,17967,12467,NULL,'diff','0');
INSERT INTO functions VALUES (11557,17923,12468,NULL,'diff','0');
INSERT INTO functions VALUES (11558,17934,12469,NULL,'last','0');
INSERT INTO functions VALUES (11559,17952,12470,NULL,'last','0');
INSERT INTO functions VALUES (11560,18006,12471,NULL,'last','0');
INSERT INTO functions VALUES (11561,17948,12472,NULL,'last','0');
INSERT INTO functions VALUES (11562,18123,12473,NULL,'last','0');
INSERT INTO functions VALUES (11563,18094,12474,NULL,'last','0');
INSERT INTO functions VALUES (11564,18113,12475,NULL,'last','0');
INSERT INTO functions VALUES (11565,18079,12476,NULL,'last','0');
INSERT INTO functions VALUES (11566,18085,12477,NULL,'last','0');
INSERT INTO functions VALUES (11567,18088,12478,NULL,'last','0');
INSERT INTO functions VALUES (11568,18091,12479,NULL,'last','0');
INSERT INTO functions VALUES (11569,18057,12480,NULL,'last','0');
INSERT INTO functions VALUES (11570,18042,12481,NULL,'last','0');
INSERT INTO functions VALUES (11571,18066,12482,NULL,'last','0');
INSERT INTO functions VALUES (11572,18071,12483,NULL,'last','0');
INSERT INTO functions VALUES (11573,18072,12484,NULL,'diff','0');
INSERT INTO functions VALUES (11574,18077,12485,NULL,'diff','0');
INSERT INTO functions VALUES (11575,18073,12486,NULL,'diff','0');
INSERT INTO functions VALUES (11576,18099,12487,NULL,'last','0');
INSERT INTO functions VALUES (11577,18082,12488,NULL,'last','0');
INSERT INTO functions VALUES (11578,18118,12489,NULL,'last','0');
INSERT INTO functions VALUES (11579,18103,12490,NULL,'last','0');
INSERT INTO functions VALUES (11580,18070,12491,NULL,'last','0');
INSERT INTO functions VALUES (11581,18040,12492,NULL,'last','0');
INSERT INTO functions VALUES (11582,18035,12493,NULL,'last','0');
INSERT INTO functions VALUES (11583,18041,12494,NULL,'last','0');
INSERT INTO functions VALUES (11584,18039,12495,NULL,'last','0');
INSERT INTO functions VALUES (11585,18037,12496,NULL,'last','0');
INSERT INTO functions VALUES (11586,18076,12497,NULL,'diff','0');
INSERT INTO functions VALUES (11587,18075,12498,NULL,'diff','0');
INSERT INTO functions VALUES (11588,18074,12499,NULL,'diff','0');
INSERT INTO functions VALUES (11589,18038,12500,NULL,'last','0');
INSERT INTO functions VALUES (11590,18044,12501,NULL,'last','0');
INSERT INTO functions VALUES (11591,18043,12502,NULL,'last','0');
INSERT INTO functions VALUES (11592,18045,12503,NULL,'last','0');
INSERT INTO functions VALUES (11593,18047,12504,NULL,'last','0');
INSERT INTO functions VALUES (11594,18046,12505,NULL,'last','0');
INSERT INTO functions VALUES (11595,18048,12506,NULL,'last','0');
INSERT INTO functions VALUES (11596,18049,12507,NULL,'last','0');
INSERT INTO functions VALUES (11597,18028,12508,NULL,'last','0');
INSERT INTO functions VALUES (11598,18027,12509,NULL,'last','0');
INSERT INTO functions VALUES (11599,18064,12510,NULL,'diff','0');
INSERT INTO functions VALUES (11600,18069,12511,NULL,'diff','0');
INSERT INTO functions VALUES (11601,18025,12512,NULL,'diff','0');
INSERT INTO functions VALUES (11602,18036,12513,NULL,'last','0');
INSERT INTO functions VALUES (11603,18054,12514,NULL,'last','0');
INSERT INTO functions VALUES (11604,18108,12515,NULL,'last','0');
INSERT INTO functions VALUES (11605,18050,12516,NULL,'last','0');
INSERT INTO functions VALUES (11606,18225,12517,NULL,'last','0');
INSERT INTO functions VALUES (11607,18196,12518,NULL,'last','0');
INSERT INTO functions VALUES (11608,18215,12519,NULL,'last','0');
INSERT INTO functions VALUES (11609,18181,12520,NULL,'last','0');
INSERT INTO functions VALUES (11610,18187,12521,NULL,'last','0');
INSERT INTO functions VALUES (11611,18190,12522,NULL,'last','0');
INSERT INTO functions VALUES (11612,18193,12523,NULL,'last','0');
INSERT INTO functions VALUES (11613,18159,12524,NULL,'last','0');
INSERT INTO functions VALUES (11614,18144,12525,NULL,'last','0');
INSERT INTO functions VALUES (11615,18168,12526,NULL,'last','0');
INSERT INTO functions VALUES (11616,18173,12527,NULL,'last','0');
INSERT INTO functions VALUES (11617,18174,12528,NULL,'diff','0');
INSERT INTO functions VALUES (11618,18179,12529,NULL,'diff','0');
INSERT INTO functions VALUES (11619,18175,12530,NULL,'diff','0');
INSERT INTO functions VALUES (11620,18201,12531,NULL,'last','0');
INSERT INTO functions VALUES (11621,18184,12532,NULL,'last','0');
INSERT INTO functions VALUES (11622,18220,12533,NULL,'last','0');
INSERT INTO functions VALUES (11623,18205,12534,NULL,'last','0');
INSERT INTO functions VALUES (11624,18172,12535,NULL,'last','0');
INSERT INTO functions VALUES (11625,18142,12536,NULL,'last','0');
INSERT INTO functions VALUES (11626,18137,12537,NULL,'last','0');
INSERT INTO functions VALUES (11627,18143,12538,NULL,'last','0');
INSERT INTO functions VALUES (11628,18141,12539,NULL,'last','0');
INSERT INTO functions VALUES (11629,18139,12540,NULL,'last','0');
INSERT INTO functions VALUES (11630,18178,12541,NULL,'diff','0');
INSERT INTO functions VALUES (11631,18177,12542,NULL,'diff','0');
INSERT INTO functions VALUES (11632,18176,12543,NULL,'diff','0');
INSERT INTO functions VALUES (11633,18140,12544,NULL,'last','0');
INSERT INTO functions VALUES (11634,18146,12545,NULL,'last','0');
INSERT INTO functions VALUES (11635,18145,12546,NULL,'last','0');
INSERT INTO functions VALUES (11636,18147,12547,NULL,'last','0');
INSERT INTO functions VALUES (11637,18149,12548,NULL,'last','0');
INSERT INTO functions VALUES (11638,18148,12549,NULL,'last','0');
INSERT INTO functions VALUES (11639,18150,12550,NULL,'last','0');
INSERT INTO functions VALUES (11640,18151,12551,NULL,'last','0');
INSERT INTO functions VALUES (11641,18130,12552,NULL,'last','0');
INSERT INTO functions VALUES (11642,18129,12553,NULL,'last','0');
INSERT INTO functions VALUES (11643,18166,12554,NULL,'diff','0');
INSERT INTO functions VALUES (11644,18171,12555,NULL,'diff','0');
INSERT INTO functions VALUES (11645,18127,12556,NULL,'diff','0');
INSERT INTO functions VALUES (11646,18138,12557,NULL,'last','0');
INSERT INTO functions VALUES (11647,18156,12558,NULL,'last','0');
INSERT INTO functions VALUES (11648,18210,12559,NULL,'last','0');
INSERT INTO functions VALUES (11649,18152,12560,NULL,'last','0');
INSERT INTO functions VALUES (11650,18434,12561,NULL,'diff','0');
INSERT INTO functions VALUES (11651,18429,12562,NULL,'diff','0');
INSERT INTO functions VALUES (11652,18431,12563,NULL,'delta','0');
INSERT INTO functions VALUES (11653,18427,12564,NULL,'delta','0');
INSERT INTO functions VALUES (11654,18428,12565,NULL,'diff','0');
INSERT INTO functions VALUES (11655,18430,12566,NULL,'delta','0');
INSERT INTO functions VALUES (11656,18432,12567,NULL,'delta','0');
INSERT INTO functions VALUES (11657,18433,12568,NULL,'diff','0');
INSERT INTO functions VALUES (11658,18254,12569,NULL,'diff','0');
INSERT INTO functions VALUES (11659,18265,12570,NULL,'diff','0');
INSERT INTO functions VALUES (11660,18276,12571,NULL,'diff','0');
INSERT INTO functions VALUES (11661,18287,12572,NULL,'diff','0');
INSERT INTO functions VALUES (11662,18298,12573,NULL,'diff','0');
INSERT INTO functions VALUES (11663,18301,12574,NULL,'diff','0');
INSERT INTO functions VALUES (11664,18302,12575,NULL,'diff','0');
INSERT INTO functions VALUES (11665,18303,12576,NULL,'diff','0');
INSERT INTO functions VALUES (11666,18304,12577,NULL,'diff','0');
INSERT INTO functions VALUES (11667,18255,12578,NULL,'diff','0');
INSERT INTO functions VALUES (11668,18256,12579,NULL,'diff','0');
INSERT INTO functions VALUES (11669,18257,12580,NULL,'diff','0');
INSERT INTO functions VALUES (11670,18258,12581,NULL,'diff','0');
INSERT INTO functions VALUES (11671,18259,12582,NULL,'diff','0');
INSERT INTO functions VALUES (11672,18260,12583,NULL,'diff','0');
INSERT INTO functions VALUES (11673,18261,12584,NULL,'diff','0');
INSERT INTO functions VALUES (11674,18262,12585,NULL,'diff','0');
INSERT INTO functions VALUES (11675,18263,12586,NULL,'diff','0');
INSERT INTO functions VALUES (11676,18264,12587,NULL,'diff','0');
INSERT INTO functions VALUES (11677,18266,12588,NULL,'diff','0');
INSERT INTO functions VALUES (11678,18267,12589,NULL,'diff','0');
INSERT INTO functions VALUES (11679,18268,12590,NULL,'diff','0');
INSERT INTO functions VALUES (11680,18269,12591,NULL,'diff','0');
INSERT INTO functions VALUES (11681,18270,12592,NULL,'diff','0');
INSERT INTO functions VALUES (11682,18271,12593,NULL,'diff','0');
INSERT INTO functions VALUES (11683,18272,12594,NULL,'diff','0');
INSERT INTO functions VALUES (11684,18273,12595,NULL,'diff','0');
INSERT INTO functions VALUES (11685,18274,12596,NULL,'diff','0');
INSERT INTO functions VALUES (11686,18275,12597,NULL,'diff','0');
INSERT INTO functions VALUES (11687,18277,12598,NULL,'diff','0');
INSERT INTO functions VALUES (11688,18278,12599,NULL,'diff','0');
INSERT INTO functions VALUES (11689,18279,12600,NULL,'diff','0');
INSERT INTO functions VALUES (11690,18280,12601,NULL,'diff','0');
INSERT INTO functions VALUES (11691,18281,12602,NULL,'diff','0');
INSERT INTO functions VALUES (11692,18282,12603,NULL,'diff','0');
INSERT INTO functions VALUES (11693,18283,12604,NULL,'diff','0');
INSERT INTO functions VALUES (11694,18284,12605,NULL,'diff','0');
INSERT INTO functions VALUES (11695,18285,12606,NULL,'diff','0');
INSERT INTO functions VALUES (11696,18286,12607,NULL,'diff','0');
INSERT INTO functions VALUES (11697,18288,12608,NULL,'diff','0');
INSERT INTO functions VALUES (11698,18289,12609,NULL,'diff','0');
INSERT INTO functions VALUES (11699,18290,12610,NULL,'diff','0');
INSERT INTO functions VALUES (11700,18291,12611,NULL,'diff','0');
INSERT INTO functions VALUES (11701,18292,12612,NULL,'diff','0');
INSERT INTO functions VALUES (11702,18293,12613,NULL,'diff','0');
INSERT INTO functions VALUES (11703,18294,12614,NULL,'diff','0');
INSERT INTO functions VALUES (11704,18295,12615,NULL,'diff','0');
INSERT INTO functions VALUES (11705,18296,12616,NULL,'diff','0');
INSERT INTO functions VALUES (11706,18297,12617,NULL,'diff','0');
INSERT INTO functions VALUES (11707,18299,12618,NULL,'diff','0');
INSERT INTO functions VALUES (11708,18300,12619,NULL,'diff','0');
INSERT INTO functions VALUES (11709,18305,12620,NULL,'delta','0');
INSERT INTO functions VALUES (11710,18316,12621,NULL,'delta','0');
INSERT INTO functions VALUES (11711,18327,12622,NULL,'delta','0');
INSERT INTO functions VALUES (11712,18338,12623,NULL,'delta','0');
INSERT INTO functions VALUES (11713,18349,12624,NULL,'delta','0');
INSERT INTO functions VALUES (11714,18352,12625,NULL,'delta','0');
INSERT INTO functions VALUES (11715,18353,12626,NULL,'delta','0');
INSERT INTO functions VALUES (11716,18354,12627,NULL,'delta','0');
INSERT INTO functions VALUES (11717,18355,12628,NULL,'delta','0');
INSERT INTO functions VALUES (11718,18306,12629,NULL,'delta','0');
INSERT INTO functions VALUES (11719,18307,12630,NULL,'delta','0');
INSERT INTO functions VALUES (11720,18308,12631,NULL,'delta','0');
INSERT INTO functions VALUES (11721,18309,12632,NULL,'delta','0');
INSERT INTO functions VALUES (11722,18310,12633,NULL,'delta','0');
INSERT INTO functions VALUES (11723,18311,12634,NULL,'delta','0');
INSERT INTO functions VALUES (11724,18312,12635,NULL,'delta','0');
INSERT INTO functions VALUES (11725,18313,12636,NULL,'delta','0');
INSERT INTO functions VALUES (11726,18314,12637,NULL,'delta','0');
INSERT INTO functions VALUES (11727,18315,12638,NULL,'delta','0');
INSERT INTO functions VALUES (11728,18317,12639,NULL,'delta','0');
INSERT INTO functions VALUES (11729,18318,12640,NULL,'delta','0');
INSERT INTO functions VALUES (11730,18319,12641,NULL,'delta','0');
INSERT INTO functions VALUES (11731,18320,12642,NULL,'delta','0');
INSERT INTO functions VALUES (11732,18321,12643,NULL,'delta','0');
INSERT INTO functions VALUES (11733,18322,12644,NULL,'delta','0');
INSERT INTO functions VALUES (11734,18323,12645,NULL,'delta','0');
INSERT INTO functions VALUES (11735,18324,12646,NULL,'delta','0');
INSERT INTO functions VALUES (11736,18325,12647,NULL,'delta','0');
INSERT INTO functions VALUES (11737,18326,12648,NULL,'delta','0');
INSERT INTO functions VALUES (11738,18328,12649,NULL,'delta','0');
INSERT INTO functions VALUES (11739,18329,12650,NULL,'delta','0');
INSERT INTO functions VALUES (11740,18330,12651,NULL,'delta','0');
INSERT INTO functions VALUES (11741,18331,12652,NULL,'delta','0');
INSERT INTO functions VALUES (11742,18332,12653,NULL,'delta','0');
INSERT INTO functions VALUES (11743,18333,12654,NULL,'delta','0');
INSERT INTO functions VALUES (11744,18334,12655,NULL,'delta','0');
INSERT INTO functions VALUES (11745,18335,12656,NULL,'delta','0');
INSERT INTO functions VALUES (11746,18336,12657,NULL,'delta','0');
INSERT INTO functions VALUES (11747,18337,12658,NULL,'delta','0');
INSERT INTO functions VALUES (11748,18339,12659,NULL,'delta','0');
INSERT INTO functions VALUES (11749,18340,12660,NULL,'delta','0');
INSERT INTO functions VALUES (11750,18341,12661,NULL,'delta','0');
INSERT INTO functions VALUES (11751,18342,12662,NULL,'delta','0');
INSERT INTO functions VALUES (11752,18343,12663,NULL,'delta','0');
INSERT INTO functions VALUES (11753,18344,12664,NULL,'delta','0');
INSERT INTO functions VALUES (11754,18345,12665,NULL,'delta','0');
INSERT INTO functions VALUES (11755,18346,12666,NULL,'delta','0');
INSERT INTO functions VALUES (11756,18347,12667,NULL,'delta','0');
INSERT INTO functions VALUES (11757,18348,12668,NULL,'delta','0');
INSERT INTO functions VALUES (11758,18350,12669,NULL,'delta','0');
INSERT INTO functions VALUES (11759,18351,12670,NULL,'delta','0');
INSERT INTO functions VALUES (11760,18356,12671,NULL,'delta','0');
INSERT INTO functions VALUES (11761,18367,12672,NULL,'delta','0');
INSERT INTO functions VALUES (11762,18378,12673,NULL,'delta','0');
INSERT INTO functions VALUES (11763,18389,12674,NULL,'delta','0');
INSERT INTO functions VALUES (11764,18400,12675,NULL,'delta','0');
INSERT INTO functions VALUES (11765,18403,12676,NULL,'delta','0');
INSERT INTO functions VALUES (11766,18404,12677,NULL,'delta','0');
INSERT INTO functions VALUES (11767,18405,12678,NULL,'delta','0');
INSERT INTO functions VALUES (11768,18406,12679,NULL,'delta','0');
INSERT INTO functions VALUES (11769,18357,12680,NULL,'delta','0');
INSERT INTO functions VALUES (11770,18358,12681,NULL,'delta','0');
INSERT INTO functions VALUES (11771,18359,12682,NULL,'delta','0');
INSERT INTO functions VALUES (11772,18360,12683,NULL,'delta','0');
INSERT INTO functions VALUES (11773,18361,12684,NULL,'delta','0');
INSERT INTO functions VALUES (11774,18362,12685,NULL,'delta','0');
INSERT INTO functions VALUES (11775,18363,12686,NULL,'delta','0');
INSERT INTO functions VALUES (11776,18364,12687,NULL,'delta','0');
INSERT INTO functions VALUES (11777,18365,12688,NULL,'delta','0');
INSERT INTO functions VALUES (11778,18366,12689,NULL,'delta','0');
INSERT INTO functions VALUES (11779,18368,12690,NULL,'delta','0');
INSERT INTO functions VALUES (11780,18369,12691,NULL,'delta','0');
INSERT INTO functions VALUES (11781,18370,12692,NULL,'delta','0');
INSERT INTO functions VALUES (11782,18371,12693,NULL,'delta','0');
INSERT INTO functions VALUES (11783,18372,12694,NULL,'delta','0');
INSERT INTO functions VALUES (11784,18373,12695,NULL,'delta','0');
INSERT INTO functions VALUES (11785,18374,12696,NULL,'delta','0');
INSERT INTO functions VALUES (11786,18375,12697,NULL,'delta','0');
INSERT INTO functions VALUES (11787,18376,12698,NULL,'delta','0');
INSERT INTO functions VALUES (11788,18377,12699,NULL,'delta','0');
INSERT INTO functions VALUES (11789,18379,12700,NULL,'delta','0');
INSERT INTO functions VALUES (11790,18380,12701,NULL,'delta','0');
INSERT INTO functions VALUES (11791,18381,12702,NULL,'delta','0');
INSERT INTO functions VALUES (11792,18382,12703,NULL,'delta','0');
INSERT INTO functions VALUES (11793,18383,12704,NULL,'delta','0');
INSERT INTO functions VALUES (11794,18384,12705,NULL,'delta','0');
INSERT INTO functions VALUES (11795,18385,12706,NULL,'delta','0');
INSERT INTO functions VALUES (11796,18386,12707,NULL,'delta','0');
INSERT INTO functions VALUES (11797,18387,12708,NULL,'delta','0');
INSERT INTO functions VALUES (11798,18388,12709,NULL,'delta','0');
INSERT INTO functions VALUES (11799,18390,12710,NULL,'delta','0');
INSERT INTO functions VALUES (11800,18391,12711,NULL,'delta','0');
INSERT INTO functions VALUES (11801,18392,12712,NULL,'delta','0');
INSERT INTO functions VALUES (11802,18393,12713,NULL,'delta','0');
INSERT INTO functions VALUES (11803,18394,12714,NULL,'delta','0');
INSERT INTO functions VALUES (11804,18395,12715,NULL,'delta','0');
INSERT INTO functions VALUES (11805,18396,12716,NULL,'delta','0');
INSERT INTO functions VALUES (11806,18397,12717,NULL,'delta','0');
INSERT INTO functions VALUES (11807,18398,12718,NULL,'delta','0');
INSERT INTO functions VALUES (11808,18399,12719,NULL,'delta','0');
INSERT INTO functions VALUES (11809,18401,12720,NULL,'delta','0');
INSERT INTO functions VALUES (11810,18402,12721,NULL,'delta','0');
INSERT INTO functions VALUES (11811,18408,12722,NULL,'last','0');
INSERT INTO functions VALUES (11812,18407,12723,NULL,'last','0');
INSERT INTO functions VALUES (11813,18417,12724,NULL,'delta','0');
INSERT INTO functions VALUES (11814,18416,12725,NULL,'delta','0');
INSERT INTO functions VALUES (11815,18412,12726,NULL,'delta','0');
INSERT INTO functions VALUES (11816,18415,12727,NULL,'delta','0');
INSERT INTO functions VALUES (11817,18418,12728,NULL,'delta','0');
INSERT INTO functions VALUES (11818,18414,12729,NULL,'delta','0');
INSERT INTO functions VALUES (11819,18413,12730,NULL,'delta','0');
INSERT INTO functions VALUES (11820,18421,12731,NULL,'delta','0');
INSERT INTO functions VALUES (11821,18419,12732,NULL,'delta','0');
INSERT INTO functions VALUES (11822,18420,12733,NULL,'delta','0');
INSERT INTO functions VALUES (11823,18425,12734,NULL,'delta','0');
INSERT INTO functions VALUES (11824,18424,12735,NULL,'delta','0');
INSERT INTO functions VALUES (11825,18423,12736,NULL,'delta','0');
INSERT INTO functions VALUES (11826,18422,12737,NULL,'delta','0');
INSERT INTO functions VALUES (11827,18411,12738,NULL,'delta','0');
INSERT INTO functions VALUES (11828,18410,12739,NULL,'delta','0');
INSERT INTO functions VALUES (11829,18409,12740,NULL,'delta','0');
INSERT INTO functions VALUES (11830,18426,12741,NULL,'delta','0');
INSERT INTO functions VALUES (11831,18234,12742,NULL,'delta','0');
INSERT INTO functions VALUES (11832,18233,12743,NULL,'delta','0');
INSERT INTO functions VALUES (11833,18230,12744,NULL,'delta','0');
INSERT INTO functions VALUES (11834,18238,12745,NULL,'delta','0');
INSERT INTO functions VALUES (11835,18235,12746,NULL,'delta','0');
INSERT INTO functions VALUES (11836,18237,12747,NULL,'delta','0');
INSERT INTO functions VALUES (11837,18236,12748,NULL,'delta','0');
INSERT INTO functions VALUES (11838,18232,12749,NULL,'delta','0');
INSERT INTO functions VALUES (11839,18231,12750,NULL,'delta','0');
INSERT INTO functions VALUES (11840,18240,12751,NULL,'delta','0');
INSERT INTO functions VALUES (11841,18239,12752,NULL,'delta','0');
INSERT INTO functions VALUES (11842,18229,12753,NULL,'delta','0');
INSERT INTO functions VALUES (11843,18228,12754,NULL,'delta','0');
INSERT INTO functions VALUES (11844,18247,12755,NULL,'delta','0');
INSERT INTO functions VALUES (11845,18246,12756,NULL,'delta','0');
INSERT INTO functions VALUES (11846,18243,12757,NULL,'delta','0');
INSERT INTO functions VALUES (11847,18251,12758,NULL,'delta','0');
INSERT INTO functions VALUES (11848,18248,12759,NULL,'delta','0');
INSERT INTO functions VALUES (11849,18250,12760,NULL,'delta','0');
INSERT INTO functions VALUES (11850,18245,12761,NULL,'delta','0');
INSERT INTO functions VALUES (11851,18244,12762,NULL,'delta','0');
INSERT INTO functions VALUES (11852,18253,12763,NULL,'delta','0');
INSERT INTO functions VALUES (11853,18252,12764,NULL,'delta','0');
INSERT INTO functions VALUES (11854,18242,12765,NULL,'delta','0');
INSERT INTO functions VALUES (11855,18241,12766,NULL,'delta','0');
INSERT INTO functions VALUES (11856,18249,12767,NULL,'delta','0');
INSERT INTO functions VALUES (11857,18436,12768,NULL,'diff','0');
INSERT INTO functions VALUES (11858,18438,12769,NULL,'last','0');
INSERT INTO functions VALUES (11859,18439,12770,NULL,'last','0');
INSERT INTO functions VALUES (11860,18446,12771,NULL,'last','0');
INSERT INTO functions VALUES (11861,18447,12772,NULL,'last','0');
INSERT INTO functions VALUES (11862,18448,12773,NULL,'last','0');
INSERT INTO functions VALUES (11863,18449,12774,NULL,'last','0');
INSERT INTO functions VALUES (11864,18450,12775,NULL,'last','0');
INSERT INTO functions VALUES (11865,18451,12776,NULL,'last','0');
INSERT INTO functions VALUES (11866,18452,12777,NULL,'last','0');
INSERT INTO functions VALUES (11867,18453,12778,NULL,'last','0');
INSERT INTO functions VALUES (11868,18454,12779,NULL,'last','0');
INSERT INTO functions VALUES (11869,18455,12780,NULL,'last','0');
INSERT INTO functions VALUES (11870,18456,12781,NULL,'last','0');
INSERT INTO functions VALUES (11871,18457,12782,NULL,'last','0');
INSERT INTO functions VALUES (11872,18458,12783,NULL,'last','0');
INSERT INTO functions VALUES (11873,18459,12784,NULL,'last','0');
INSERT INTO functions VALUES (11874,18460,12785,NULL,'last','0');
INSERT INTO functions VALUES (11875,18461,12786,NULL,'last','0');
INSERT INTO functions VALUES (11876,18465,12787,NULL,'last','0');
INSERT INTO functions VALUES (11877,18468,12788,NULL,'last','0');
INSERT INTO functions VALUES (11878,18475,12789,NULL,'diff','0');
INSERT INTO functions VALUES (11879,18477,12790,NULL,'last','0');
INSERT INTO functions VALUES (11880,18480,12791,NULL,'diff','0');
INSERT INTO functions VALUES (11881,18481,12792,NULL,'last','0');
INSERT INTO functions VALUES (11882,18482,12793,NULL,'last','0');
INSERT INTO functions VALUES (11883,18483,12794,NULL,'diff','0');
INSERT INTO functions VALUES (11884,18484,12795,NULL,'diff','0');
INSERT INTO functions VALUES (11885,18485,12796,NULL,'diff','0');
INSERT INTO functions VALUES (11886,18486,12797,NULL,'diff','0');
INSERT INTO functions VALUES (11887,18487,12798,NULL,'diff','0');
INSERT INTO functions VALUES (11888,18488,12799,NULL,'diff','0');
INSERT INTO functions VALUES (11889,18490,12800,NULL,'last','0');
INSERT INTO functions VALUES (11890,18493,12801,NULL,'last','0');
INSERT INTO functions VALUES (11891,18496,12802,NULL,'last','0');
INSERT INTO functions VALUES (11892,18499,12803,NULL,'last','0');
INSERT INTO functions VALUES (11893,18502,12804,NULL,'last','0');
INSERT INTO functions VALUES (11894,18505,12805,NULL,'last','0');
INSERT INTO functions VALUES (11895,18510,12806,NULL,'last','0');
INSERT INTO functions VALUES (11896,18514,12807,NULL,'last','0');
INSERT INTO functions VALUES (11897,18519,12808,NULL,'last','0');
INSERT INTO functions VALUES (11898,18524,12809,NULL,'last','0');
INSERT INTO functions VALUES (11899,18529,12810,NULL,'last','0');
INSERT INTO functions VALUES (11900,18534,12811,NULL,'last','0');
INSERT INTO functions VALUES (11901,19404,12812,NULL,'last','0');
INSERT INTO functions VALUES (11902,19409,12813,NULL,'last','0');
INSERT INTO functions VALUES (11903,19407,12814,NULL,'last','0');
INSERT INTO functions VALUES (11904,19408,12815,NULL,'last','0');
INSERT INTO functions VALUES (11905,19408,12816,NULL,'last','0');
INSERT INTO functions VALUES (11907,19406,12817,NULL,'last','0');
INSERT INTO functions VALUES (11908,19417,12818,NULL,'last','0');
INSERT INTO functions VALUES (11909,19418,12819,NULL,'last','0');
INSERT INTO functions VALUES (11910,19419,12820,NULL,'last','0');
INSERT INTO functions VALUES (11911,19420,12821,NULL,'last','0');
INSERT INTO functions VALUES (11912,19421,12822,NULL,'last','0');
INSERT INTO functions VALUES (11913,19411,12823,NULL,'last','0');
INSERT INTO functions VALUES (11915,19412,12825,NULL,'last','0');
INSERT INTO functions VALUES (11917,19422,12827,NULL,'last','0');
INSERT INTO functions VALUES (11918,19413,12824,NULL,'last','0');
INSERT INTO functions VALUES (11919,19414,12826,NULL,'last','0');
INSERT INTO functions VALUES (11922,19428,12828,NULL,'last','0');
INSERT INTO functions VALUES (11923,19427,12829,NULL,'last','0');
INSERT INTO functions VALUES (11925,19429,12830,NULL,'last','0');
INSERT INTO functions VALUES (11927,19430,12831,NULL,'last','0');
INSERT INTO functions VALUES (11929,19431,12832,NULL,'last','0');
INSERT INTO functions VALUES (11931,19432,12833,NULL,'last','0');
INSERT INTO functions VALUES (11933,19433,12834,NULL,'last','0');
INSERT INTO functions VALUES (11935,19434,12835,NULL,'last','0');
INSERT INTO functions VALUES (11937,19435,12836,NULL,'last','0');
INSERT INTO functions VALUES (11939,19436,12837,NULL,'last','0');
INSERT INTO functions VALUES (11941,19437,12838,NULL,'last','0');
INSERT INTO functions VALUES (11943,19423,12839,NULL,'last','0');
INSERT INTO functions VALUES (11945,19425,12840,NULL,'last','0');
INSERT INTO functions VALUES (11947,19424,12841,NULL,'last','0');
INSERT INTO functions VALUES (11949,19426,12842,NULL,'last','0');
INSERT INTO functions VALUES (11950,19441,12843,NULL,'last','0');
INSERT INTO functions VALUES (11951,19448,12844,NULL,'avg','300');
INSERT INTO functions VALUES (11952,19448,12845,NULL,'avg','120');

--
-- Dumping data for table `items_applications`
--

INSERT INTO items_applications VALUES (138,1,10016);
INSERT INTO items_applications VALUES (694,1,10025);
INSERT INTO items_applications VALUES (636,1,10055);
INSERT INTO items_applications VALUES (634,1,10056);
INSERT INTO items_applications VALUES (448,1,10057);
INSERT INTO items_applications VALUES (444,1,10058);
INSERT INTO items_applications VALUES (734,1,10061);
INSERT INTO items_applications VALUES (186,1,10418);
INSERT INTO items_applications VALUES (182,1,10419);
INSERT INTO items_applications VALUES (184,1,10420);
INSERT INTO items_applications VALUES (646,1,17318);
INSERT INTO items_applications VALUES (642,1,17352);
INSERT INTO items_applications VALUES (716,2,10031);
INSERT INTO items_applications VALUES (718,2,10032);
INSERT INTO items_applications VALUES (726,2,10033);
INSERT INTO items_applications VALUES (724,2,10036);
INSERT INTO items_applications VALUES (720,2,10037);
INSERT INTO items_applications VALUES (722,2,10046);
INSERT INTO items_applications VALUES (730,2,10060);
INSERT INTO items_applications VALUES (740,5,10002);
INSERT INTO items_applications VALUES (752,5,10003);
INSERT INTO items_applications VALUES (756,5,10004);
INSERT INTO items_applications VALUES (272,5,10005);
INSERT INTO items_applications VALUES (280,5,10006);
INSERT INTO items_applications VALUES (284,5,10007);
INSERT INTO items_applications VALUES (288,5,10008);
INSERT INTO items_applications VALUES (744,5,10021);
INSERT INTO items_applications VALUES (276,5,10022);
INSERT INTO items_applications VALUES (760,5,10023);
INSERT INTO items_applications VALUES (748,5,10024);
INSERT INTO items_applications VALUES (312,5,10062);
INSERT INTO items_applications VALUES (320,5,10063);
INSERT INTO items_applications VALUES (324,5,10064);
INSERT INTO items_applications VALUES (328,5,10065);
INSERT INTO items_applications VALUES (316,5,10066);
INSERT INTO items_applications VALUES (698,5,10067);
INSERT INTO items_applications VALUES (706,5,10068);
INSERT INTO items_applications VALUES (710,5,10069);
INSERT INTO items_applications VALUES (714,5,10070);
INSERT INTO items_applications VALUES (702,5,10071);
INSERT INTO items_applications VALUES (764,5,10412);
INSERT INTO items_applications VALUES (772,5,10413);
INSERT INTO items_applications VALUES (784,5,10414);
INSERT INTO items_applications VALUES (776,5,10415);
INSERT INTO items_applications VALUES (780,5,10416);
INSERT INTO items_applications VALUES (768,5,10417);
INSERT INTO items_applications VALUES (512,5,17320);
INSERT INTO items_applications VALUES (514,5,17322);
INSERT INTO items_applications VALUES (518,5,17324);
INSERT INTO items_applications VALUES (522,5,17326);
INSERT INTO items_applications VALUES (526,5,17328);
INSERT INTO items_applications VALUES (530,5,17330);
INSERT INTO items_applications VALUES (534,5,17332);
INSERT INTO items_applications VALUES (538,5,17334);
INSERT INTO items_applications VALUES (542,5,17336);
INSERT INTO items_applications VALUES (546,5,17338);
INSERT INTO items_applications VALUES (550,5,17340);
INSERT INTO items_applications VALUES (554,5,17342);
INSERT INTO items_applications VALUES (558,5,17344);
INSERT INTO items_applications VALUES (562,5,17346);
INSERT INTO items_applications VALUES (566,5,17348);
INSERT INTO items_applications VALUES (570,5,17350);
INSERT INTO items_applications VALUES (786,5,17373);
INSERT INTO items_applications VALUES (611,7,10072);
INSERT INTO items_applications VALUES (607,7,10075);
INSERT INTO items_applications VALUES (627,7,10078);
INSERT INTO items_applications VALUES (623,7,10081);
INSERT INTO items_applications VALUES (619,7,10084);
INSERT INTO items_applications VALUES (631,7,10087);
INSERT INTO items_applications VALUES (600,9,10009);
INSERT INTO items_applications VALUES (804,9,10013);
INSERT INTO items_applications VALUES (796,9,10047);
INSERT INTO items_applications VALUES (794,9,10048);
INSERT INTO items_applications VALUES (798,9,10049);
INSERT INTO items_applications VALUES (802,9,10050);
INSERT INTO items_applications VALUES (800,9,10051);
INSERT INTO items_applications VALUES (790,9,10052);
INSERT INTO items_applications VALUES (792,9,10053);
INSERT INTO items_applications VALUES (220,9,10059);
INSERT INTO items_applications VALUES (178,11,10015);
INSERT INTO items_applications VALUES (587,13,10010);
INSERT INTO items_applications VALUES (595,13,10011);
INSERT INTO items_applications VALUES (591,13,10012);
INSERT INTO items_applications VALUES (689,13,17354);
INSERT INTO items_applications VALUES (671,13,17356);
INSERT INTO items_applications VALUES (675,13,17358);
INSERT INTO items_applications VALUES (679,13,17360);
INSERT INTO items_applications VALUES (683,13,17362);
INSERT INTO items_applications VALUES (236,15,10001);
INSERT INTO items_applications VALUES (244,15,10026);
INSERT INTO items_applications VALUES (240,15,10027);
INSERT INTO items_applications VALUES (650,15,10028);
INSERT INTO items_applications VALUES (232,15,10029);
INSERT INTO items_applications VALUES (588,17,10010);
INSERT INTO items_applications VALUES (596,17,10011);
INSERT INTO items_applications VALUES (592,17,10012);
INSERT INTO items_applications VALUES (612,17,10072);
INSERT INTO items_applications VALUES (608,17,10075);
INSERT INTO items_applications VALUES (628,17,10078);
INSERT INTO items_applications VALUES (624,17,10081);
INSERT INTO items_applications VALUES (620,17,10084);
INSERT INTO items_applications VALUES (632,17,10087);
INSERT INTO items_applications VALUES (690,17,17354);
INSERT INTO items_applications VALUES (672,17,17356);
INSERT INTO items_applications VALUES (676,17,17358);
INSERT INTO items_applications VALUES (680,17,17360);
INSERT INTO items_applications VALUES (684,17,17362);
INSERT INTO items_applications VALUES (235,19,10001);
INSERT INTO items_applications VALUES (739,19,10002);
INSERT INTO items_applications VALUES (751,19,10003);
INSERT INTO items_applications VALUES (755,19,10004);
INSERT INTO items_applications VALUES (271,19,10005);
INSERT INTO items_applications VALUES (279,19,10006);
INSERT INTO items_applications VALUES (283,19,10007);
INSERT INTO items_applications VALUES (287,19,10008);
INSERT INTO items_applications VALUES (604,19,10014);
INSERT INTO items_applications VALUES (743,19,10021);
INSERT INTO items_applications VALUES (275,19,10022);
INSERT INTO items_applications VALUES (759,19,10023);
INSERT INTO items_applications VALUES (747,19,10024);
INSERT INTO items_applications VALUES (243,19,10026);
INSERT INTO items_applications VALUES (239,19,10027);
INSERT INTO items_applications VALUES (649,19,10028);
INSERT INTO items_applications VALUES (231,19,10029);
INSERT INTO items_applications VALUES (602,19,10030);
INSERT INTO items_applications VALUES (311,19,10062);
INSERT INTO items_applications VALUES (319,19,10063);
INSERT INTO items_applications VALUES (323,19,10064);
INSERT INTO items_applications VALUES (327,19,10065);
INSERT INTO items_applications VALUES (315,19,10066);
INSERT INTO items_applications VALUES (697,19,10067);
INSERT INTO items_applications VALUES (705,19,10068);
INSERT INTO items_applications VALUES (709,19,10069);
INSERT INTO items_applications VALUES (713,19,10070);
INSERT INTO items_applications VALUES (701,19,10071);
INSERT INTO items_applications VALUES (763,19,10412);
INSERT INTO items_applications VALUES (771,19,10413);
INSERT INTO items_applications VALUES (783,19,10414);
INSERT INTO items_applications VALUES (775,19,10415);
INSERT INTO items_applications VALUES (779,19,10416);
INSERT INTO items_applications VALUES (767,19,10417);
INSERT INTO items_applications VALUES (511,19,17320);
INSERT INTO items_applications VALUES (513,19,17322);
INSERT INTO items_applications VALUES (517,19,17324);
INSERT INTO items_applications VALUES (521,19,17326);
INSERT INTO items_applications VALUES (525,19,17328);
INSERT INTO items_applications VALUES (529,19,17330);
INSERT INTO items_applications VALUES (533,19,17332);
INSERT INTO items_applications VALUES (537,19,17334);
INSERT INTO items_applications VALUES (541,19,17336);
INSERT INTO items_applications VALUES (545,19,17338);
INSERT INTO items_applications VALUES (549,19,17340);
INSERT INTO items_applications VALUES (553,19,17342);
INSERT INTO items_applications VALUES (557,19,17344);
INSERT INTO items_applications VALUES (561,19,17346);
INSERT INTO items_applications VALUES (565,19,17348);
INSERT INTO items_applications VALUES (569,19,17350);
INSERT INTO items_applications VALUES (785,19,17373);
INSERT INTO items_applications VALUES (736,21,10020);
INSERT INTO items_applications VALUES (693,21,10025);
INSERT INTO items_applications VALUES (447,21,10057);
INSERT INTO items_applications VALUES (443,21,10058);
INSERT INTO items_applications VALUES (733,21,10061);
INSERT INTO items_applications VALUES (854,21,10109);
INSERT INTO items_applications VALUES (856,21,10148);
INSERT INTO items_applications VALUES (645,21,17318);
INSERT INTO items_applications VALUES (641,21,17352);
INSERT INTO items_applications VALUES (652,23,10017);
INSERT INTO items_applications VALUES (660,23,10018);
INSERT INTO items_applications VALUES (654,23,10019);
INSERT INTO items_applications VALUES (662,23,10038);
INSERT INTO items_applications VALUES (658,23,10039);
INSERT INTO items_applications VALUES (656,23,10040);
INSERT INTO items_applications VALUES (835,25,10090);
INSERT INTO items_applications VALUES (807,25,10091);
INSERT INTO items_applications VALUES (848,25,10103);
INSERT INTO items_applications VALUES (839,25,10115);
INSERT INTO items_applications VALUES (850,25,10119);
INSERT INTO items_applications VALUES (815,25,10156);
INSERT INTO items_applications VALUES (811,25,10358);
INSERT INTO items_applications VALUES (819,25,10359);
INSERT INTO items_applications VALUES (823,27,10099);
INSERT INTO items_applications VALUES (831,27,10100);
INSERT INTO items_applications VALUES (827,27,10101);
INSERT INTO items_applications VALUES (808,29,10091);
INSERT INTO items_applications VALUES (816,29,10156);
INSERT INTO items_applications VALUES (812,29,10358);
INSERT INTO items_applications VALUES (820,29,10359);
INSERT INTO items_applications VALUES (872,29,17401);
INSERT INTO items_applications VALUES (878,29,17403);
INSERT INTO items_applications VALUES (890,29,17405);
INSERT INTO items_applications VALUES (899,29,17409);
INSERT INTO items_applications VALUES (905,29,17411);
INSERT INTO items_applications VALUES (846,31,10114);
INSERT INTO items_applications VALUES (842,31,10147);
INSERT INTO items_applications VALUES (844,31,10150);
INSERT INTO items_applications VALUES (862,33,10104);
INSERT INTO items_applications VALUES (858,33,10106);
INSERT INTO items_applications VALUES (860,33,10357);
INSERT INTO items_applications VALUES (836,35,10090);
INSERT INTO items_applications VALUES (840,35,10115);
INSERT INTO items_applications VALUES (891,37,17405);
INSERT INTO items_applications VALUES (900,37,17409);
INSERT INTO items_applications VALUES (906,37,17411);
INSERT INTO items_applications VALUES (870,39,17399);
INSERT INTO items_applications VALUES (873,39,17401);
INSERT INTO items_applications VALUES (879,39,17403);
INSERT INTO items_applications VALUES (824,41,10099);
INSERT INTO items_applications VALUES (832,41,10100);
INSERT INTO items_applications VALUES (828,41,10101);
INSERT INTO items_applications VALUES (874,41,17401);
INSERT INTO items_applications VALUES (880,41,17403);
INSERT INTO items_applications VALUES (892,41,17405);
INSERT INTO items_applications VALUES (901,41,17409);
INSERT INTO items_applications VALUES (907,41,17411);
INSERT INTO items_applications VALUES (852,43,10098);
INSERT INTO items_applications VALUES (864,43,10102);
INSERT INTO items_applications VALUES (866,43,10137);
INSERT INTO items_applications VALUES (869,43,17397);
INSERT INTO items_applications VALUES (908,47,17412);
INSERT INTO items_applications VALUES (944,47,17442);
INSERT INTO items_applications VALUES (946,47,17443);
INSERT INTO items_applications VALUES (964,47,17452);
INSERT INTO items_applications VALUES (966,47,17453);
INSERT INTO items_applications VALUES (972,47,17457);
INSERT INTO items_applications VALUES (974,47,17458);
INSERT INTO items_applications VALUES (909,48,17413);
INSERT INTO items_applications VALUES (932,48,17430);
INSERT INTO items_applications VALUES (933,48,17431);
INSERT INTO items_applications VALUES (934,48,17432);
INSERT INTO items_applications VALUES (935,48,17433);
INSERT INTO items_applications VALUES (936,48,17434);
INSERT INTO items_applications VALUES (937,48,17435);
INSERT INTO items_applications VALUES (938,48,17436);
INSERT INTO items_applications VALUES (939,48,17437);
INSERT INTO items_applications VALUES (940,48,17438);
INSERT INTO items_applications VALUES (910,49,17414);
INSERT INTO items_applications VALUES (911,50,17415);
INSERT INTO items_applications VALUES (912,50,17416);
INSERT INTO items_applications VALUES (941,50,17439);
INSERT INTO items_applications VALUES (942,50,17440);
INSERT INTO items_applications VALUES (943,50,17441);
INSERT INTO items_applications VALUES (945,50,17442);
INSERT INTO items_applications VALUES (947,50,17443);
INSERT INTO items_applications VALUES (965,50,17452);
INSERT INTO items_applications VALUES (967,50,17453);
INSERT INTO items_applications VALUES (973,50,17457);
INSERT INTO items_applications VALUES (975,50,17458);
INSERT INTO items_applications VALUES (976,50,17459);
INSERT INTO items_applications VALUES (913,51,17417);
INSERT INTO items_applications VALUES (915,51,17418);
INSERT INTO items_applications VALUES (917,51,17419);
INSERT INTO items_applications VALUES (919,51,17420);
INSERT INTO items_applications VALUES (921,51,17421);
INSERT INTO items_applications VALUES (923,51,17422);
INSERT INTO items_applications VALUES (914,52,17417);
INSERT INTO items_applications VALUES (916,52,17418);
INSERT INTO items_applications VALUES (918,52,17419);
INSERT INTO items_applications VALUES (920,52,17420);
INSERT INTO items_applications VALUES (922,52,17421);
INSERT INTO items_applications VALUES (924,52,17422);
INSERT INTO items_applications VALUES (949,52,17444);
INSERT INTO items_applications VALUES (951,52,17445);
INSERT INTO items_applications VALUES (953,52,17446);
INSERT INTO items_applications VALUES (955,52,17447);
INSERT INTO items_applications VALUES (957,52,17448);
INSERT INTO items_applications VALUES (959,52,17449);
INSERT INTO items_applications VALUES (961,52,17450);
INSERT INTO items_applications VALUES (963,52,17451);
INSERT INTO items_applications VALUES (925,53,17423);
INSERT INTO items_applications VALUES (926,53,17424);
INSERT INTO items_applications VALUES (927,53,17425);
INSERT INTO items_applications VALUES (928,53,17426);
INSERT INTO items_applications VALUES (929,53,17427);
INSERT INTO items_applications VALUES (930,53,17428);
INSERT INTO items_applications VALUES (931,53,17429);
INSERT INTO items_applications VALUES (948,54,17444);
INSERT INTO items_applications VALUES (950,54,17445);
INSERT INTO items_applications VALUES (952,54,17446);
INSERT INTO items_applications VALUES (954,54,17447);
INSERT INTO items_applications VALUES (956,54,17448);
INSERT INTO items_applications VALUES (958,54,17449);
INSERT INTO items_applications VALUES (960,54,17450);
INSERT INTO items_applications VALUES (962,54,17451);
INSERT INTO items_applications VALUES (968,55,17454);
INSERT INTO items_applications VALUES (969,55,17455);
INSERT INTO items_applications VALUES (971,55,17456);
INSERT INTO items_applications VALUES (983,55,17466);
INSERT INTO items_applications VALUES (985,55,17467);
INSERT INTO items_applications VALUES (987,55,17468);
INSERT INTO items_applications VALUES (989,55,17469);
INSERT INTO items_applications VALUES (991,55,17470);
INSERT INTO items_applications VALUES (993,55,17471);
INSERT INTO items_applications VALUES (995,55,17472);
INSERT INTO items_applications VALUES (997,55,17473);
INSERT INTO items_applications VALUES (999,55,17474);
INSERT INTO items_applications VALUES (1001,55,17475);
INSERT INTO items_applications VALUES (1003,55,17476);
INSERT INTO items_applications VALUES (1005,55,17477);
INSERT INTO items_applications VALUES (1007,55,17478);
INSERT INTO items_applications VALUES (1009,55,17479);
INSERT INTO items_applications VALUES (1011,55,17480);
INSERT INTO items_applications VALUES (1013,55,17481);
INSERT INTO items_applications VALUES (1015,55,17482);
INSERT INTO items_applications VALUES (1017,55,17483);
INSERT INTO items_applications VALUES (1019,55,17484);
INSERT INTO items_applications VALUES (1021,55,17485);
INSERT INTO items_applications VALUES (1023,55,17486);
INSERT INTO items_applications VALUES (1025,55,17487);
INSERT INTO items_applications VALUES (1027,55,17488);
INSERT INTO items_applications VALUES (1029,55,17489);
INSERT INTO items_applications VALUES (1031,55,17490);
INSERT INTO items_applications VALUES (1033,55,17491);
INSERT INTO items_applications VALUES (1035,55,17492);
INSERT INTO items_applications VALUES (1037,55,17493);
INSERT INTO items_applications VALUES (1039,55,17494);
INSERT INTO items_applications VALUES (1041,55,17495);
INSERT INTO items_applications VALUES (1043,55,17496);
INSERT INTO items_applications VALUES (1045,55,17497);
INSERT INTO items_applications VALUES (1047,55,17498);
INSERT INTO items_applications VALUES (1049,55,17499);
INSERT INTO items_applications VALUES (1051,55,17500);
INSERT INTO items_applications VALUES (1053,55,17501);
INSERT INTO items_applications VALUES (1055,55,17502);
INSERT INTO items_applications VALUES (1057,55,17503);
INSERT INTO items_applications VALUES (1059,55,17504);
INSERT INTO items_applications VALUES (1061,55,17505);
INSERT INTO items_applications VALUES (1063,55,17506);
INSERT INTO items_applications VALUES (1065,55,17507);
INSERT INTO items_applications VALUES (1067,55,17508);
INSERT INTO items_applications VALUES (1069,55,17509);
INSERT INTO items_applications VALUES (1071,55,17510);
INSERT INTO items_applications VALUES (1073,55,17511);
INSERT INTO items_applications VALUES (1075,55,17512);
INSERT INTO items_applications VALUES (1077,55,17513);
INSERT INTO items_applications VALUES (970,56,17455);
INSERT INTO items_applications VALUES (984,56,17466);
INSERT INTO items_applications VALUES (986,56,17467);
INSERT INTO items_applications VALUES (988,56,17468);
INSERT INTO items_applications VALUES (990,56,17469);
INSERT INTO items_applications VALUES (992,56,17470);
INSERT INTO items_applications VALUES (994,56,17471);
INSERT INTO items_applications VALUES (996,56,17472);
INSERT INTO items_applications VALUES (998,56,17473);
INSERT INTO items_applications VALUES (1000,56,17474);
INSERT INTO items_applications VALUES (1002,56,17475);
INSERT INTO items_applications VALUES (1004,56,17476);
INSERT INTO items_applications VALUES (1006,56,17477);
INSERT INTO items_applications VALUES (1008,56,17478);
INSERT INTO items_applications VALUES (1010,56,17479);
INSERT INTO items_applications VALUES (1012,56,17480);
INSERT INTO items_applications VALUES (1014,56,17481);
INSERT INTO items_applications VALUES (1016,56,17482);
INSERT INTO items_applications VALUES (1018,56,17483);
INSERT INTO items_applications VALUES (1020,56,17484);
INSERT INTO items_applications VALUES (1022,56,17485);
INSERT INTO items_applications VALUES (1024,56,17486);
INSERT INTO items_applications VALUES (1026,56,17487);
INSERT INTO items_applications VALUES (1028,56,17488);
INSERT INTO items_applications VALUES (1030,56,17489);
INSERT INTO items_applications VALUES (1032,56,17490);
INSERT INTO items_applications VALUES (1034,56,17491);
INSERT INTO items_applications VALUES (1036,56,17492);
INSERT INTO items_applications VALUES (1038,56,17493);
INSERT INTO items_applications VALUES (1040,56,17494);
INSERT INTO items_applications VALUES (1042,56,17495);
INSERT INTO items_applications VALUES (1044,56,17496);
INSERT INTO items_applications VALUES (1046,56,17497);
INSERT INTO items_applications VALUES (1048,56,17498);
INSERT INTO items_applications VALUES (1050,56,17499);
INSERT INTO items_applications VALUES (1052,56,17500);
INSERT INTO items_applications VALUES (1054,56,17501);
INSERT INTO items_applications VALUES (1056,56,17502);
INSERT INTO items_applications VALUES (1058,56,17503);
INSERT INTO items_applications VALUES (1060,56,17504);
INSERT INTO items_applications VALUES (1062,56,17505);
INSERT INTO items_applications VALUES (1064,56,17506);
INSERT INTO items_applications VALUES (1066,56,17507);
INSERT INTO items_applications VALUES (1068,56,17508);
INSERT INTO items_applications VALUES (977,57,17460);
INSERT INTO items_applications VALUES (978,57,17461);
INSERT INTO items_applications VALUES (979,57,17462);
INSERT INTO items_applications VALUES (980,57,17463);
INSERT INTO items_applications VALUES (981,57,17464);
INSERT INTO items_applications VALUES (982,57,17465);
INSERT INTO items_applications VALUES (1070,58,17509);
INSERT INTO items_applications VALUES (1072,58,17510);
INSERT INTO items_applications VALUES (1074,58,17511);
INSERT INTO items_applications VALUES (1076,58,17512);
INSERT INTO items_applications VALUES (1078,58,17513);
INSERT INTO items_applications VALUES (1079,59,17514);
INSERT INTO items_applications VALUES (1115,59,17544);
INSERT INTO items_applications VALUES (1117,59,17545);
INSERT INTO items_applications VALUES (1135,59,17554);
INSERT INTO items_applications VALUES (1137,59,17555);
INSERT INTO items_applications VALUES (1143,59,17559);
INSERT INTO items_applications VALUES (1145,59,17560);
INSERT INTO items_applications VALUES (1080,60,17515);
INSERT INTO items_applications VALUES (1103,60,17532);
INSERT INTO items_applications VALUES (1104,60,17533);
INSERT INTO items_applications VALUES (1105,60,17534);
INSERT INTO items_applications VALUES (1106,60,17535);
INSERT INTO items_applications VALUES (1107,60,17536);
INSERT INTO items_applications VALUES (1108,60,17537);
INSERT INTO items_applications VALUES (1109,60,17538);
INSERT INTO items_applications VALUES (1110,60,17539);
INSERT INTO items_applications VALUES (1111,60,17540);
INSERT INTO items_applications VALUES (1081,61,17516);
INSERT INTO items_applications VALUES (1082,62,17517);
INSERT INTO items_applications VALUES (1083,62,17518);
INSERT INTO items_applications VALUES (1112,62,17541);
INSERT INTO items_applications VALUES (1113,62,17542);
INSERT INTO items_applications VALUES (1114,62,17543);
INSERT INTO items_applications VALUES (1116,62,17544);
INSERT INTO items_applications VALUES (1118,62,17545);
INSERT INTO items_applications VALUES (1136,62,17554);
INSERT INTO items_applications VALUES (1138,62,17555);
INSERT INTO items_applications VALUES (1144,62,17559);
INSERT INTO items_applications VALUES (1146,62,17560);
INSERT INTO items_applications VALUES (1147,62,17561);
INSERT INTO items_applications VALUES (1084,63,17519);
INSERT INTO items_applications VALUES (1086,63,17520);
INSERT INTO items_applications VALUES (1088,63,17521);
INSERT INTO items_applications VALUES (1090,63,17522);
INSERT INTO items_applications VALUES (1092,63,17523);
INSERT INTO items_applications VALUES (1094,63,17524);
INSERT INTO items_applications VALUES (1085,64,17519);
INSERT INTO items_applications VALUES (1087,64,17520);
INSERT INTO items_applications VALUES (1089,64,17521);
INSERT INTO items_applications VALUES (1091,64,17522);
INSERT INTO items_applications VALUES (1093,64,17523);
INSERT INTO items_applications VALUES (1095,64,17524);
INSERT INTO items_applications VALUES (1120,64,17546);
INSERT INTO items_applications VALUES (1122,64,17547);
INSERT INTO items_applications VALUES (1124,64,17548);
INSERT INTO items_applications VALUES (1126,64,17549);
INSERT INTO items_applications VALUES (1128,64,17550);
INSERT INTO items_applications VALUES (1130,64,17551);
INSERT INTO items_applications VALUES (1132,64,17552);
INSERT INTO items_applications VALUES (1134,64,17553);
INSERT INTO items_applications VALUES (1096,65,17525);
INSERT INTO items_applications VALUES (1097,65,17526);
INSERT INTO items_applications VALUES (1098,65,17527);
INSERT INTO items_applications VALUES (1099,65,17528);
INSERT INTO items_applications VALUES (1100,65,17529);
INSERT INTO items_applications VALUES (1101,65,17530);
INSERT INTO items_applications VALUES (1102,65,17531);
INSERT INTO items_applications VALUES (1119,66,17546);
INSERT INTO items_applications VALUES (1121,66,17547);
INSERT INTO items_applications VALUES (1123,66,17548);
INSERT INTO items_applications VALUES (1125,66,17549);
INSERT INTO items_applications VALUES (1127,66,17550);
INSERT INTO items_applications VALUES (1129,66,17551);
INSERT INTO items_applications VALUES (1131,66,17552);
INSERT INTO items_applications VALUES (1133,66,17553);
INSERT INTO items_applications VALUES (1139,67,17556);
INSERT INTO items_applications VALUES (1140,67,17557);
INSERT INTO items_applications VALUES (1142,67,17558);
INSERT INTO items_applications VALUES (1154,67,17568);
INSERT INTO items_applications VALUES (1156,67,17569);
INSERT INTO items_applications VALUES (1158,67,17570);
INSERT INTO items_applications VALUES (1160,67,17571);
INSERT INTO items_applications VALUES (1162,67,17572);
INSERT INTO items_applications VALUES (1164,67,17573);
INSERT INTO items_applications VALUES (1166,67,17574);
INSERT INTO items_applications VALUES (1168,67,17575);
INSERT INTO items_applications VALUES (1170,67,17576);
INSERT INTO items_applications VALUES (1172,67,17577);
INSERT INTO items_applications VALUES (1174,67,17578);
INSERT INTO items_applications VALUES (1176,67,17579);
INSERT INTO items_applications VALUES (1178,67,17580);
INSERT INTO items_applications VALUES (1180,67,17581);
INSERT INTO items_applications VALUES (1182,67,17582);
INSERT INTO items_applications VALUES (1184,67,17583);
INSERT INTO items_applications VALUES (1186,67,17584);
INSERT INTO items_applications VALUES (1188,67,17585);
INSERT INTO items_applications VALUES (1190,67,17586);
INSERT INTO items_applications VALUES (1192,67,17587);
INSERT INTO items_applications VALUES (1194,67,17588);
INSERT INTO items_applications VALUES (1196,67,17589);
INSERT INTO items_applications VALUES (1198,67,17590);
INSERT INTO items_applications VALUES (1200,67,17591);
INSERT INTO items_applications VALUES (1202,67,17592);
INSERT INTO items_applications VALUES (1204,67,17593);
INSERT INTO items_applications VALUES (1206,67,17594);
INSERT INTO items_applications VALUES (1208,67,17595);
INSERT INTO items_applications VALUES (1210,67,17596);
INSERT INTO items_applications VALUES (1212,67,17597);
INSERT INTO items_applications VALUES (1214,67,17598);
INSERT INTO items_applications VALUES (1216,67,17599);
INSERT INTO items_applications VALUES (1218,67,17600);
INSERT INTO items_applications VALUES (1220,67,17601);
INSERT INTO items_applications VALUES (1222,67,17602);
INSERT INTO items_applications VALUES (1224,67,17603);
INSERT INTO items_applications VALUES (1226,67,17604);
INSERT INTO items_applications VALUES (1228,67,17605);
INSERT INTO items_applications VALUES (1230,67,17606);
INSERT INTO items_applications VALUES (1232,67,17607);
INSERT INTO items_applications VALUES (1234,67,17608);
INSERT INTO items_applications VALUES (1236,67,17609);
INSERT INTO items_applications VALUES (1238,67,17610);
INSERT INTO items_applications VALUES (1240,67,17611);
INSERT INTO items_applications VALUES (1242,67,17612);
INSERT INTO items_applications VALUES (1244,67,17613);
INSERT INTO items_applications VALUES (1246,67,17614);
INSERT INTO items_applications VALUES (1248,67,17615);
INSERT INTO items_applications VALUES (1141,68,17557);
INSERT INTO items_applications VALUES (1155,68,17568);
INSERT INTO items_applications VALUES (1157,68,17569);
INSERT INTO items_applications VALUES (1159,68,17570);
INSERT INTO items_applications VALUES (1161,68,17571);
INSERT INTO items_applications VALUES (1163,68,17572);
INSERT INTO items_applications VALUES (1165,68,17573);
INSERT INTO items_applications VALUES (1167,68,17574);
INSERT INTO items_applications VALUES (1169,68,17575);
INSERT INTO items_applications VALUES (1171,68,17576);
INSERT INTO items_applications VALUES (1173,68,17577);
INSERT INTO items_applications VALUES (1175,68,17578);
INSERT INTO items_applications VALUES (1177,68,17579);
INSERT INTO items_applications VALUES (1179,68,17580);
INSERT INTO items_applications VALUES (1181,68,17581);
INSERT INTO items_applications VALUES (1183,68,17582);
INSERT INTO items_applications VALUES (1185,68,17583);
INSERT INTO items_applications VALUES (1187,68,17584);
INSERT INTO items_applications VALUES (1189,68,17585);
INSERT INTO items_applications VALUES (1191,68,17586);
INSERT INTO items_applications VALUES (1193,68,17587);
INSERT INTO items_applications VALUES (1195,68,17588);
INSERT INTO items_applications VALUES (1197,68,17589);
INSERT INTO items_applications VALUES (1199,68,17590);
INSERT INTO items_applications VALUES (1201,68,17591);
INSERT INTO items_applications VALUES (1203,68,17592);
INSERT INTO items_applications VALUES (1205,68,17593);
INSERT INTO items_applications VALUES (1207,68,17594);
INSERT INTO items_applications VALUES (1209,68,17595);
INSERT INTO items_applications VALUES (1211,68,17596);
INSERT INTO items_applications VALUES (1213,68,17597);
INSERT INTO items_applications VALUES (1215,68,17598);
INSERT INTO items_applications VALUES (1217,68,17599);
INSERT INTO items_applications VALUES (1219,68,17600);
INSERT INTO items_applications VALUES (1221,68,17601);
INSERT INTO items_applications VALUES (1223,68,17602);
INSERT INTO items_applications VALUES (1225,68,17603);
INSERT INTO items_applications VALUES (1227,68,17604);
INSERT INTO items_applications VALUES (1229,68,17605);
INSERT INTO items_applications VALUES (1231,68,17606);
INSERT INTO items_applications VALUES (1233,68,17607);
INSERT INTO items_applications VALUES (1235,68,17608);
INSERT INTO items_applications VALUES (1237,68,17609);
INSERT INTO items_applications VALUES (1239,68,17610);
INSERT INTO items_applications VALUES (1148,69,17562);
INSERT INTO items_applications VALUES (1149,69,17563);
INSERT INTO items_applications VALUES (1150,69,17564);
INSERT INTO items_applications VALUES (1151,69,17565);
INSERT INTO items_applications VALUES (1152,69,17566);
INSERT INTO items_applications VALUES (1153,69,17567);
INSERT INTO items_applications VALUES (1241,70,17611);
INSERT INTO items_applications VALUES (1243,70,17612);
INSERT INTO items_applications VALUES (1245,70,17613);
INSERT INTO items_applications VALUES (1247,70,17614);
INSERT INTO items_applications VALUES (1249,70,17615);
INSERT INTO items_applications VALUES (1250,71,17616);
INSERT INTO items_applications VALUES (1286,71,17646);
INSERT INTO items_applications VALUES (1288,71,17647);
INSERT INTO items_applications VALUES (1306,71,17656);
INSERT INTO items_applications VALUES (1308,71,17657);
INSERT INTO items_applications VALUES (1314,71,17661);
INSERT INTO items_applications VALUES (1316,71,17662);
INSERT INTO items_applications VALUES (1251,72,17617);
INSERT INTO items_applications VALUES (1274,72,17634);
INSERT INTO items_applications VALUES (1275,72,17635);
INSERT INTO items_applications VALUES (1276,72,17636);
INSERT INTO items_applications VALUES (1277,72,17637);
INSERT INTO items_applications VALUES (1278,72,17638);
INSERT INTO items_applications VALUES (1279,72,17639);
INSERT INTO items_applications VALUES (1280,72,17640);
INSERT INTO items_applications VALUES (1281,72,17641);
INSERT INTO items_applications VALUES (1282,72,17642);
INSERT INTO items_applications VALUES (1252,73,17618);
INSERT INTO items_applications VALUES (1253,74,17619);
INSERT INTO items_applications VALUES (1254,74,17620);
INSERT INTO items_applications VALUES (1283,74,17643);
INSERT INTO items_applications VALUES (1284,74,17644);
INSERT INTO items_applications VALUES (1285,74,17645);
INSERT INTO items_applications VALUES (1287,74,17646);
INSERT INTO items_applications VALUES (1289,74,17647);
INSERT INTO items_applications VALUES (1307,74,17656);
INSERT INTO items_applications VALUES (1309,74,17657);
INSERT INTO items_applications VALUES (1315,74,17661);
INSERT INTO items_applications VALUES (1317,74,17662);
INSERT INTO items_applications VALUES (1318,74,17663);
INSERT INTO items_applications VALUES (1255,75,17621);
INSERT INTO items_applications VALUES (1257,75,17622);
INSERT INTO items_applications VALUES (1259,75,17623);
INSERT INTO items_applications VALUES (1261,75,17624);
INSERT INTO items_applications VALUES (1263,75,17625);
INSERT INTO items_applications VALUES (1265,75,17626);
INSERT INTO items_applications VALUES (1256,76,17621);
INSERT INTO items_applications VALUES (1258,76,17622);
INSERT INTO items_applications VALUES (1260,76,17623);
INSERT INTO items_applications VALUES (1262,76,17624);
INSERT INTO items_applications VALUES (1264,76,17625);
INSERT INTO items_applications VALUES (1266,76,17626);
INSERT INTO items_applications VALUES (1291,76,17648);
INSERT INTO items_applications VALUES (1293,76,17649);
INSERT INTO items_applications VALUES (1295,76,17650);
INSERT INTO items_applications VALUES (1297,76,17651);
INSERT INTO items_applications VALUES (1299,76,17652);
INSERT INTO items_applications VALUES (1301,76,17653);
INSERT INTO items_applications VALUES (1303,76,17654);
INSERT INTO items_applications VALUES (1305,76,17655);
INSERT INTO items_applications VALUES (1267,77,17627);
INSERT INTO items_applications VALUES (1268,77,17628);
INSERT INTO items_applications VALUES (1269,77,17629);
INSERT INTO items_applications VALUES (1270,77,17630);
INSERT INTO items_applications VALUES (1271,77,17631);
INSERT INTO items_applications VALUES (1272,77,17632);
INSERT INTO items_applications VALUES (1273,77,17633);
INSERT INTO items_applications VALUES (1290,78,17648);
INSERT INTO items_applications VALUES (1292,78,17649);
INSERT INTO items_applications VALUES (1294,78,17650);
INSERT INTO items_applications VALUES (1296,78,17651);
INSERT INTO items_applications VALUES (1298,78,17652);
INSERT INTO items_applications VALUES (1300,78,17653);
INSERT INTO items_applications VALUES (1302,78,17654);
INSERT INTO items_applications VALUES (1304,78,17655);
INSERT INTO items_applications VALUES (1310,79,17658);
INSERT INTO items_applications VALUES (1311,79,17659);
INSERT INTO items_applications VALUES (1313,79,17660);
INSERT INTO items_applications VALUES (1325,79,17670);
INSERT INTO items_applications VALUES (1327,79,17671);
INSERT INTO items_applications VALUES (1329,79,17672);
INSERT INTO items_applications VALUES (1331,79,17673);
INSERT INTO items_applications VALUES (1333,79,17674);
INSERT INTO items_applications VALUES (1335,79,17675);
INSERT INTO items_applications VALUES (1337,79,17676);
INSERT INTO items_applications VALUES (1339,79,17677);
INSERT INTO items_applications VALUES (1341,79,17678);
INSERT INTO items_applications VALUES (1343,79,17679);
INSERT INTO items_applications VALUES (1345,79,17680);
INSERT INTO items_applications VALUES (1347,79,17681);
INSERT INTO items_applications VALUES (1349,79,17682);
INSERT INTO items_applications VALUES (1351,79,17683);
INSERT INTO items_applications VALUES (1353,79,17684);
INSERT INTO items_applications VALUES (1355,79,17685);
INSERT INTO items_applications VALUES (1357,79,17686);
INSERT INTO items_applications VALUES (1359,79,17687);
INSERT INTO items_applications VALUES (1361,79,17688);
INSERT INTO items_applications VALUES (1363,79,17689);
INSERT INTO items_applications VALUES (1365,79,17690);
INSERT INTO items_applications VALUES (1367,79,17691);
INSERT INTO items_applications VALUES (1369,79,17692);
INSERT INTO items_applications VALUES (1371,79,17693);
INSERT INTO items_applications VALUES (1373,79,17694);
INSERT INTO items_applications VALUES (1375,79,17695);
INSERT INTO items_applications VALUES (1377,79,17696);
INSERT INTO items_applications VALUES (1379,79,17697);
INSERT INTO items_applications VALUES (1381,79,17698);
INSERT INTO items_applications VALUES (1383,79,17699);
INSERT INTO items_applications VALUES (1385,79,17700);
INSERT INTO items_applications VALUES (1387,79,17701);
INSERT INTO items_applications VALUES (1389,79,17702);
INSERT INTO items_applications VALUES (1391,79,17703);
INSERT INTO items_applications VALUES (1393,79,17704);
INSERT INTO items_applications VALUES (1395,79,17705);
INSERT INTO items_applications VALUES (1397,79,17706);
INSERT INTO items_applications VALUES (1399,79,17707);
INSERT INTO items_applications VALUES (1401,79,17708);
INSERT INTO items_applications VALUES (1403,79,17709);
INSERT INTO items_applications VALUES (1405,79,17710);
INSERT INTO items_applications VALUES (1407,79,17711);
INSERT INTO items_applications VALUES (1409,79,17712);
INSERT INTO items_applications VALUES (1411,79,17713);
INSERT INTO items_applications VALUES (1413,79,17714);
INSERT INTO items_applications VALUES (1415,79,17715);
INSERT INTO items_applications VALUES (1417,79,17716);
INSERT INTO items_applications VALUES (1419,79,17717);
INSERT INTO items_applications VALUES (1312,80,17659);
INSERT INTO items_applications VALUES (1326,80,17670);
INSERT INTO items_applications VALUES (1328,80,17671);
INSERT INTO items_applications VALUES (1330,80,17672);
INSERT INTO items_applications VALUES (1332,80,17673);
INSERT INTO items_applications VALUES (1334,80,17674);
INSERT INTO items_applications VALUES (1336,80,17675);
INSERT INTO items_applications VALUES (1338,80,17676);
INSERT INTO items_applications VALUES (1340,80,17677);
INSERT INTO items_applications VALUES (1342,80,17678);
INSERT INTO items_applications VALUES (1344,80,17679);
INSERT INTO items_applications VALUES (1346,80,17680);
INSERT INTO items_applications VALUES (1348,80,17681);
INSERT INTO items_applications VALUES (1350,80,17682);
INSERT INTO items_applications VALUES (1352,80,17683);
INSERT INTO items_applications VALUES (1354,80,17684);
INSERT INTO items_applications VALUES (1356,80,17685);
INSERT INTO items_applications VALUES (1358,80,17686);
INSERT INTO items_applications VALUES (1360,80,17687);
INSERT INTO items_applications VALUES (1362,80,17688);
INSERT INTO items_applications VALUES (1364,80,17689);
INSERT INTO items_applications VALUES (1366,80,17690);
INSERT INTO items_applications VALUES (1368,80,17691);
INSERT INTO items_applications VALUES (1370,80,17692);
INSERT INTO items_applications VALUES (1372,80,17693);
INSERT INTO items_applications VALUES (1374,80,17694);
INSERT INTO items_applications VALUES (1376,80,17695);
INSERT INTO items_applications VALUES (1378,80,17696);
INSERT INTO items_applications VALUES (1380,80,17697);
INSERT INTO items_applications VALUES (1382,80,17698);
INSERT INTO items_applications VALUES (1384,80,17699);
INSERT INTO items_applications VALUES (1386,80,17700);
INSERT INTO items_applications VALUES (1388,80,17701);
INSERT INTO items_applications VALUES (1390,80,17702);
INSERT INTO items_applications VALUES (1392,80,17703);
INSERT INTO items_applications VALUES (1394,80,17704);
INSERT INTO items_applications VALUES (1396,80,17705);
INSERT INTO items_applications VALUES (1398,80,17706);
INSERT INTO items_applications VALUES (1400,80,17707);
INSERT INTO items_applications VALUES (1402,80,17708);
INSERT INTO items_applications VALUES (1404,80,17709);
INSERT INTO items_applications VALUES (1406,80,17710);
INSERT INTO items_applications VALUES (1408,80,17711);
INSERT INTO items_applications VALUES (1410,80,17712);
INSERT INTO items_applications VALUES (1319,81,17664);
INSERT INTO items_applications VALUES (1320,81,17665);
INSERT INTO items_applications VALUES (1321,81,17666);
INSERT INTO items_applications VALUES (1322,81,17667);
INSERT INTO items_applications VALUES (1323,81,17668);
INSERT INTO items_applications VALUES (1324,81,17669);
INSERT INTO items_applications VALUES (1412,82,17713);
INSERT INTO items_applications VALUES (1414,82,17714);
INSERT INTO items_applications VALUES (1416,82,17715);
INSERT INTO items_applications VALUES (1418,82,17716);
INSERT INTO items_applications VALUES (1420,82,17717);
INSERT INTO items_applications VALUES (1421,83,17718);
INSERT INTO items_applications VALUES (1457,83,17748);
INSERT INTO items_applications VALUES (1459,83,17749);
INSERT INTO items_applications VALUES (1477,83,17758);
INSERT INTO items_applications VALUES (1479,83,17759);
INSERT INTO items_applications VALUES (1485,83,17763);
INSERT INTO items_applications VALUES (1487,83,17764);
INSERT INTO items_applications VALUES (1422,84,17719);
INSERT INTO items_applications VALUES (1445,84,17736);
INSERT INTO items_applications VALUES (1446,84,17737);
INSERT INTO items_applications VALUES (1447,84,17738);
INSERT INTO items_applications VALUES (1448,84,17739);
INSERT INTO items_applications VALUES (1449,84,17740);
INSERT INTO items_applications VALUES (1450,84,17741);
INSERT INTO items_applications VALUES (1451,84,17742);
INSERT INTO items_applications VALUES (1452,84,17743);
INSERT INTO items_applications VALUES (1453,84,17744);
INSERT INTO items_applications VALUES (1423,85,17720);
INSERT INTO items_applications VALUES (1424,86,17721);
INSERT INTO items_applications VALUES (1425,86,17722);
INSERT INTO items_applications VALUES (1454,86,17745);
INSERT INTO items_applications VALUES (1455,86,17746);
INSERT INTO items_applications VALUES (1456,86,17747);
INSERT INTO items_applications VALUES (1458,86,17748);
INSERT INTO items_applications VALUES (1460,86,17749);
INSERT INTO items_applications VALUES (1478,86,17758);
INSERT INTO items_applications VALUES (1480,86,17759);
INSERT INTO items_applications VALUES (1486,86,17763);
INSERT INTO items_applications VALUES (1488,86,17764);
INSERT INTO items_applications VALUES (1489,86,17765);
INSERT INTO items_applications VALUES (1426,87,17723);
INSERT INTO items_applications VALUES (1428,87,17724);
INSERT INTO items_applications VALUES (1430,87,17725);
INSERT INTO items_applications VALUES (1432,87,17726);
INSERT INTO items_applications VALUES (1434,87,17727);
INSERT INTO items_applications VALUES (1436,87,17728);
INSERT INTO items_applications VALUES (1427,88,17723);
INSERT INTO items_applications VALUES (1429,88,17724);
INSERT INTO items_applications VALUES (1431,88,17725);
INSERT INTO items_applications VALUES (1433,88,17726);
INSERT INTO items_applications VALUES (1435,88,17727);
INSERT INTO items_applications VALUES (1437,88,17728);
INSERT INTO items_applications VALUES (1462,88,17750);
INSERT INTO items_applications VALUES (1464,88,17751);
INSERT INTO items_applications VALUES (1466,88,17752);
INSERT INTO items_applications VALUES (1468,88,17753);
INSERT INTO items_applications VALUES (1470,88,17754);
INSERT INTO items_applications VALUES (1472,88,17755);
INSERT INTO items_applications VALUES (1474,88,17756);
INSERT INTO items_applications VALUES (1476,88,17757);
INSERT INTO items_applications VALUES (1438,89,17729);
INSERT INTO items_applications VALUES (1439,89,17730);
INSERT INTO items_applications VALUES (1440,89,17731);
INSERT INTO items_applications VALUES (1441,89,17732);
INSERT INTO items_applications VALUES (1442,89,17733);
INSERT INTO items_applications VALUES (1443,89,17734);
INSERT INTO items_applications VALUES (1444,89,17735);
INSERT INTO items_applications VALUES (1461,90,17750);
INSERT INTO items_applications VALUES (1463,90,17751);
INSERT INTO items_applications VALUES (1465,90,17752);
INSERT INTO items_applications VALUES (1467,90,17753);
INSERT INTO items_applications VALUES (1469,90,17754);
INSERT INTO items_applications VALUES (1471,90,17755);
INSERT INTO items_applications VALUES (1473,90,17756);
INSERT INTO items_applications VALUES (1475,90,17757);
INSERT INTO items_applications VALUES (1481,91,17760);
INSERT INTO items_applications VALUES (1482,91,17761);
INSERT INTO items_applications VALUES (1484,91,17762);
INSERT INTO items_applications VALUES (1496,91,17772);
INSERT INTO items_applications VALUES (1498,91,17773);
INSERT INTO items_applications VALUES (1500,91,17774);
INSERT INTO items_applications VALUES (1502,91,17775);
INSERT INTO items_applications VALUES (1504,91,17776);
INSERT INTO items_applications VALUES (1506,91,17777);
INSERT INTO items_applications VALUES (1508,91,17778);
INSERT INTO items_applications VALUES (1510,91,17779);
INSERT INTO items_applications VALUES (1512,91,17780);
INSERT INTO items_applications VALUES (1514,91,17781);
INSERT INTO items_applications VALUES (1516,91,17782);
INSERT INTO items_applications VALUES (1518,91,17783);
INSERT INTO items_applications VALUES (1520,91,17784);
INSERT INTO items_applications VALUES (1522,91,17785);
INSERT INTO items_applications VALUES (1524,91,17786);
INSERT INTO items_applications VALUES (1526,91,17787);
INSERT INTO items_applications VALUES (1528,91,17788);
INSERT INTO items_applications VALUES (1530,91,17789);
INSERT INTO items_applications VALUES (1532,91,17790);
INSERT INTO items_applications VALUES (1534,91,17791);
INSERT INTO items_applications VALUES (1536,91,17792);
INSERT INTO items_applications VALUES (1538,91,17793);
INSERT INTO items_applications VALUES (1540,91,17794);
INSERT INTO items_applications VALUES (1542,91,17795);
INSERT INTO items_applications VALUES (1544,91,17796);
INSERT INTO items_applications VALUES (1546,91,17797);
INSERT INTO items_applications VALUES (1548,91,17798);
INSERT INTO items_applications VALUES (1550,91,17799);
INSERT INTO items_applications VALUES (1552,91,17800);
INSERT INTO items_applications VALUES (1554,91,17801);
INSERT INTO items_applications VALUES (1556,91,17802);
INSERT INTO items_applications VALUES (1558,91,17803);
INSERT INTO items_applications VALUES (1560,91,17804);
INSERT INTO items_applications VALUES (1562,91,17805);
INSERT INTO items_applications VALUES (1564,91,17806);
INSERT INTO items_applications VALUES (1566,91,17807);
INSERT INTO items_applications VALUES (1568,91,17808);
INSERT INTO items_applications VALUES (1570,91,17809);
INSERT INTO items_applications VALUES (1572,91,17810);
INSERT INTO items_applications VALUES (1574,91,17811);
INSERT INTO items_applications VALUES (1576,91,17812);
INSERT INTO items_applications VALUES (1578,91,17813);
INSERT INTO items_applications VALUES (1580,91,17814);
INSERT INTO items_applications VALUES (1582,91,17815);
INSERT INTO items_applications VALUES (1584,91,17816);
INSERT INTO items_applications VALUES (1586,91,17817);
INSERT INTO items_applications VALUES (1588,91,17818);
INSERT INTO items_applications VALUES (1590,91,17819);
INSERT INTO items_applications VALUES (1483,92,17761);
INSERT INTO items_applications VALUES (1497,92,17772);
INSERT INTO items_applications VALUES (1499,92,17773);
INSERT INTO items_applications VALUES (1501,92,17774);
INSERT INTO items_applications VALUES (1503,92,17775);
INSERT INTO items_applications VALUES (1505,92,17776);
INSERT INTO items_applications VALUES (1507,92,17777);
INSERT INTO items_applications VALUES (1509,92,17778);
INSERT INTO items_applications VALUES (1511,92,17779);
INSERT INTO items_applications VALUES (1513,92,17780);
INSERT INTO items_applications VALUES (1515,92,17781);
INSERT INTO items_applications VALUES (1517,92,17782);
INSERT INTO items_applications VALUES (1519,92,17783);
INSERT INTO items_applications VALUES (1521,92,17784);
INSERT INTO items_applications VALUES (1523,92,17785);
INSERT INTO items_applications VALUES (1525,92,17786);
INSERT INTO items_applications VALUES (1527,92,17787);
INSERT INTO items_applications VALUES (1529,92,17788);
INSERT INTO items_applications VALUES (1531,92,17789);
INSERT INTO items_applications VALUES (1533,92,17790);
INSERT INTO items_applications VALUES (1535,92,17791);
INSERT INTO items_applications VALUES (1537,92,17792);
INSERT INTO items_applications VALUES (1539,92,17793);
INSERT INTO items_applications VALUES (1541,92,17794);
INSERT INTO items_applications VALUES (1543,92,17795);
INSERT INTO items_applications VALUES (1545,92,17796);
INSERT INTO items_applications VALUES (1547,92,17797);
INSERT INTO items_applications VALUES (1549,92,17798);
INSERT INTO items_applications VALUES (1551,92,17799);
INSERT INTO items_applications VALUES (1553,92,17800);
INSERT INTO items_applications VALUES (1555,92,17801);
INSERT INTO items_applications VALUES (1557,92,17802);
INSERT INTO items_applications VALUES (1559,92,17803);
INSERT INTO items_applications VALUES (1561,92,17804);
INSERT INTO items_applications VALUES (1563,92,17805);
INSERT INTO items_applications VALUES (1565,92,17806);
INSERT INTO items_applications VALUES (1567,92,17807);
INSERT INTO items_applications VALUES (1569,92,17808);
INSERT INTO items_applications VALUES (1571,92,17809);
INSERT INTO items_applications VALUES (1573,92,17810);
INSERT INTO items_applications VALUES (1575,92,17811);
INSERT INTO items_applications VALUES (1577,92,17812);
INSERT INTO items_applications VALUES (1579,92,17813);
INSERT INTO items_applications VALUES (1581,92,17814);
INSERT INTO items_applications VALUES (1490,93,17766);
INSERT INTO items_applications VALUES (1491,93,17767);
INSERT INTO items_applications VALUES (1492,93,17768);
INSERT INTO items_applications VALUES (1493,93,17769);
INSERT INTO items_applications VALUES (1494,93,17770);
INSERT INTO items_applications VALUES (1495,93,17771);
INSERT INTO items_applications VALUES (1583,94,17815);
INSERT INTO items_applications VALUES (1585,94,17816);
INSERT INTO items_applications VALUES (1587,94,17817);
INSERT INTO items_applications VALUES (1589,94,17818);
INSERT INTO items_applications VALUES (1591,94,17819);
INSERT INTO items_applications VALUES (1592,95,17820);
INSERT INTO items_applications VALUES (1628,95,17850);
INSERT INTO items_applications VALUES (1630,95,17851);
INSERT INTO items_applications VALUES (1648,95,17860);
INSERT INTO items_applications VALUES (1650,95,17861);
INSERT INTO items_applications VALUES (1656,95,17865);
INSERT INTO items_applications VALUES (1658,95,17866);
INSERT INTO items_applications VALUES (1593,96,17821);
INSERT INTO items_applications VALUES (1616,96,17838);
INSERT INTO items_applications VALUES (1617,96,17839);
INSERT INTO items_applications VALUES (1618,96,17840);
INSERT INTO items_applications VALUES (1619,96,17841);
INSERT INTO items_applications VALUES (1620,96,17842);
INSERT INTO items_applications VALUES (1621,96,17843);
INSERT INTO items_applications VALUES (1622,96,17844);
INSERT INTO items_applications VALUES (1623,96,17845);
INSERT INTO items_applications VALUES (1624,96,17846);
INSERT INTO items_applications VALUES (1594,97,17822);
INSERT INTO items_applications VALUES (1595,98,17823);
INSERT INTO items_applications VALUES (1596,98,17824);
INSERT INTO items_applications VALUES (1625,98,17847);
INSERT INTO items_applications VALUES (1626,98,17848);
INSERT INTO items_applications VALUES (1627,98,17849);
INSERT INTO items_applications VALUES (1629,98,17850);
INSERT INTO items_applications VALUES (1631,98,17851);
INSERT INTO items_applications VALUES (1649,98,17860);
INSERT INTO items_applications VALUES (1651,98,17861);
INSERT INTO items_applications VALUES (1657,98,17865);
INSERT INTO items_applications VALUES (1659,98,17866);
INSERT INTO items_applications VALUES (1660,98,17867);
INSERT INTO items_applications VALUES (1597,99,17825);
INSERT INTO items_applications VALUES (1599,99,17826);
INSERT INTO items_applications VALUES (1601,99,17827);
INSERT INTO items_applications VALUES (1603,99,17828);
INSERT INTO items_applications VALUES (1605,99,17829);
INSERT INTO items_applications VALUES (1607,99,17830);
INSERT INTO items_applications VALUES (1598,100,17825);
INSERT INTO items_applications VALUES (1600,100,17826);
INSERT INTO items_applications VALUES (1602,100,17827);
INSERT INTO items_applications VALUES (1604,100,17828);
INSERT INTO items_applications VALUES (1606,100,17829);
INSERT INTO items_applications VALUES (1608,100,17830);
INSERT INTO items_applications VALUES (1633,100,17852);
INSERT INTO items_applications VALUES (1635,100,17853);
INSERT INTO items_applications VALUES (1637,100,17854);
INSERT INTO items_applications VALUES (1639,100,17855);
INSERT INTO items_applications VALUES (1641,100,17856);
INSERT INTO items_applications VALUES (1643,100,17857);
INSERT INTO items_applications VALUES (1645,100,17858);
INSERT INTO items_applications VALUES (1647,100,17859);
INSERT INTO items_applications VALUES (1609,101,17831);
INSERT INTO items_applications VALUES (1610,101,17832);
INSERT INTO items_applications VALUES (1611,101,17833);
INSERT INTO items_applications VALUES (1612,101,17834);
INSERT INTO items_applications VALUES (1613,101,17835);
INSERT INTO items_applications VALUES (1614,101,17836);
INSERT INTO items_applications VALUES (1615,101,17837);
INSERT INTO items_applications VALUES (1632,102,17852);
INSERT INTO items_applications VALUES (1634,102,17853);
INSERT INTO items_applications VALUES (1636,102,17854);
INSERT INTO items_applications VALUES (1638,102,17855);
INSERT INTO items_applications VALUES (1640,102,17856);
INSERT INTO items_applications VALUES (1642,102,17857);
INSERT INTO items_applications VALUES (1644,102,17858);
INSERT INTO items_applications VALUES (1646,102,17859);
INSERT INTO items_applications VALUES (1652,103,17862);
INSERT INTO items_applications VALUES (1653,103,17863);
INSERT INTO items_applications VALUES (1655,103,17864);
INSERT INTO items_applications VALUES (1667,103,17874);
INSERT INTO items_applications VALUES (1669,103,17875);
INSERT INTO items_applications VALUES (1671,103,17876);
INSERT INTO items_applications VALUES (1673,103,17877);
INSERT INTO items_applications VALUES (1675,103,17878);
INSERT INTO items_applications VALUES (1677,103,17879);
INSERT INTO items_applications VALUES (1679,103,17880);
INSERT INTO items_applications VALUES (1681,103,17881);
INSERT INTO items_applications VALUES (1683,103,17882);
INSERT INTO items_applications VALUES (1685,103,17883);
INSERT INTO items_applications VALUES (1687,103,17884);
INSERT INTO items_applications VALUES (1689,103,17885);
INSERT INTO items_applications VALUES (1691,103,17886);
INSERT INTO items_applications VALUES (1693,103,17887);
INSERT INTO items_applications VALUES (1695,103,17888);
INSERT INTO items_applications VALUES (1697,103,17889);
INSERT INTO items_applications VALUES (1699,103,17890);
INSERT INTO items_applications VALUES (1701,103,17891);
INSERT INTO items_applications VALUES (1703,103,17892);
INSERT INTO items_applications VALUES (1705,103,17893);
INSERT INTO items_applications VALUES (1707,103,17894);
INSERT INTO items_applications VALUES (1709,103,17895);
INSERT INTO items_applications VALUES (1711,103,17896);
INSERT INTO items_applications VALUES (1713,103,17897);
INSERT INTO items_applications VALUES (1715,103,17898);
INSERT INTO items_applications VALUES (1717,103,17899);
INSERT INTO items_applications VALUES (1719,103,17900);
INSERT INTO items_applications VALUES (1721,103,17901);
INSERT INTO items_applications VALUES (1723,103,17902);
INSERT INTO items_applications VALUES (1725,103,17903);
INSERT INTO items_applications VALUES (1727,103,17904);
INSERT INTO items_applications VALUES (1729,103,17905);
INSERT INTO items_applications VALUES (1731,103,17906);
INSERT INTO items_applications VALUES (1733,103,17907);
INSERT INTO items_applications VALUES (1735,103,17908);
INSERT INTO items_applications VALUES (1737,103,17909);
INSERT INTO items_applications VALUES (1739,103,17910);
INSERT INTO items_applications VALUES (1741,103,17911);
INSERT INTO items_applications VALUES (1743,103,17912);
INSERT INTO items_applications VALUES (1745,103,17913);
INSERT INTO items_applications VALUES (1747,103,17914);
INSERT INTO items_applications VALUES (1749,103,17915);
INSERT INTO items_applications VALUES (1751,103,17916);
INSERT INTO items_applications VALUES (1753,103,17917);
INSERT INTO items_applications VALUES (1755,103,17918);
INSERT INTO items_applications VALUES (1757,103,17919);
INSERT INTO items_applications VALUES (1759,103,17920);
INSERT INTO items_applications VALUES (1761,103,17921);
INSERT INTO items_applications VALUES (1654,104,17863);
INSERT INTO items_applications VALUES (1668,104,17874);
INSERT INTO items_applications VALUES (1670,104,17875);
INSERT INTO items_applications VALUES (1672,104,17876);
INSERT INTO items_applications VALUES (1674,104,17877);
INSERT INTO items_applications VALUES (1676,104,17878);
INSERT INTO items_applications VALUES (1678,104,17879);
INSERT INTO items_applications VALUES (1680,104,17880);
INSERT INTO items_applications VALUES (1682,104,17881);
INSERT INTO items_applications VALUES (1684,104,17882);
INSERT INTO items_applications VALUES (1686,104,17883);
INSERT INTO items_applications VALUES (1688,104,17884);
INSERT INTO items_applications VALUES (1690,104,17885);
INSERT INTO items_applications VALUES (1692,104,17886);
INSERT INTO items_applications VALUES (1694,104,17887);
INSERT INTO items_applications VALUES (1696,104,17888);
INSERT INTO items_applications VALUES (1698,104,17889);
INSERT INTO items_applications VALUES (1700,104,17890);
INSERT INTO items_applications VALUES (1702,104,17891);
INSERT INTO items_applications VALUES (1704,104,17892);
INSERT INTO items_applications VALUES (1706,104,17893);
INSERT INTO items_applications VALUES (1708,104,17894);
INSERT INTO items_applications VALUES (1710,104,17895);
INSERT INTO items_applications VALUES (1712,104,17896);
INSERT INTO items_applications VALUES (1714,104,17897);
INSERT INTO items_applications VALUES (1716,104,17898);
INSERT INTO items_applications VALUES (1718,104,17899);
INSERT INTO items_applications VALUES (1720,104,17900);
INSERT INTO items_applications VALUES (1722,104,17901);
INSERT INTO items_applications VALUES (1724,104,17902);
INSERT INTO items_applications VALUES (1726,104,17903);
INSERT INTO items_applications VALUES (1728,104,17904);
INSERT INTO items_applications VALUES (1730,104,17905);
INSERT INTO items_applications VALUES (1732,104,17906);
INSERT INTO items_applications VALUES (1734,104,17907);
INSERT INTO items_applications VALUES (1736,104,17908);
INSERT INTO items_applications VALUES (1738,104,17909);
INSERT INTO items_applications VALUES (1740,104,17910);
INSERT INTO items_applications VALUES (1742,104,17911);
INSERT INTO items_applications VALUES (1744,104,17912);
INSERT INTO items_applications VALUES (1746,104,17913);
INSERT INTO items_applications VALUES (1748,104,17914);
INSERT INTO items_applications VALUES (1750,104,17915);
INSERT INTO items_applications VALUES (1752,104,17916);
INSERT INTO items_applications VALUES (1661,105,17868);
INSERT INTO items_applications VALUES (1662,105,17869);
INSERT INTO items_applications VALUES (1663,105,17870);
INSERT INTO items_applications VALUES (1664,105,17871);
INSERT INTO items_applications VALUES (1665,105,17872);
INSERT INTO items_applications VALUES (1666,105,17873);
INSERT INTO items_applications VALUES (1754,106,17917);
INSERT INTO items_applications VALUES (1756,106,17918);
INSERT INTO items_applications VALUES (1758,106,17919);
INSERT INTO items_applications VALUES (1760,106,17920);
INSERT INTO items_applications VALUES (1762,106,17921);
INSERT INTO items_applications VALUES (1763,107,17922);
INSERT INTO items_applications VALUES (1799,107,17952);
INSERT INTO items_applications VALUES (1801,107,17953);
INSERT INTO items_applications VALUES (1819,107,17962);
INSERT INTO items_applications VALUES (1821,107,17963);
INSERT INTO items_applications VALUES (1827,107,17967);
INSERT INTO items_applications VALUES (1829,107,17968);
INSERT INTO items_applications VALUES (1764,108,17923);
INSERT INTO items_applications VALUES (1787,108,17940);
INSERT INTO items_applications VALUES (1788,108,17941);
INSERT INTO items_applications VALUES (1789,108,17942);
INSERT INTO items_applications VALUES (1790,108,17943);
INSERT INTO items_applications VALUES (1791,108,17944);
INSERT INTO items_applications VALUES (1792,108,17945);
INSERT INTO items_applications VALUES (1793,108,17946);
INSERT INTO items_applications VALUES (1794,108,17947);
INSERT INTO items_applications VALUES (1795,108,17948);
INSERT INTO items_applications VALUES (1765,109,17924);
INSERT INTO items_applications VALUES (1766,110,17925);
INSERT INTO items_applications VALUES (1767,110,17926);
INSERT INTO items_applications VALUES (1796,110,17949);
INSERT INTO items_applications VALUES (1797,110,17950);
INSERT INTO items_applications VALUES (1798,110,17951);
INSERT INTO items_applications VALUES (1800,110,17952);
INSERT INTO items_applications VALUES (1802,110,17953);
INSERT INTO items_applications VALUES (1820,110,17962);
INSERT INTO items_applications VALUES (1822,110,17963);
INSERT INTO items_applications VALUES (1828,110,17967);
INSERT INTO items_applications VALUES (1830,110,17968);
INSERT INTO items_applications VALUES (1831,110,17969);
INSERT INTO items_applications VALUES (1768,111,17927);
INSERT INTO items_applications VALUES (1770,111,17928);
INSERT INTO items_applications VALUES (1772,111,17929);
INSERT INTO items_applications VALUES (1774,111,17930);
INSERT INTO items_applications VALUES (1776,111,17931);
INSERT INTO items_applications VALUES (1778,111,17932);
INSERT INTO items_applications VALUES (1769,112,17927);
INSERT INTO items_applications VALUES (1771,112,17928);
INSERT INTO items_applications VALUES (1773,112,17929);
INSERT INTO items_applications VALUES (1775,112,17930);
INSERT INTO items_applications VALUES (1777,112,17931);
INSERT INTO items_applications VALUES (1779,112,17932);
INSERT INTO items_applications VALUES (1804,112,17954);
INSERT INTO items_applications VALUES (1806,112,17955);
INSERT INTO items_applications VALUES (1808,112,17956);
INSERT INTO items_applications VALUES (1810,112,17957);
INSERT INTO items_applications VALUES (1812,112,17958);
INSERT INTO items_applications VALUES (1814,112,17959);
INSERT INTO items_applications VALUES (1816,112,17960);
INSERT INTO items_applications VALUES (1818,112,17961);
INSERT INTO items_applications VALUES (1780,113,17933);
INSERT INTO items_applications VALUES (1781,113,17934);
INSERT INTO items_applications VALUES (1782,113,17935);
INSERT INTO items_applications VALUES (1783,113,17936);
INSERT INTO items_applications VALUES (1784,113,17937);
INSERT INTO items_applications VALUES (1785,113,17938);
INSERT INTO items_applications VALUES (1786,113,17939);
INSERT INTO items_applications VALUES (1803,114,17954);
INSERT INTO items_applications VALUES (1805,114,17955);
INSERT INTO items_applications VALUES (1807,114,17956);
INSERT INTO items_applications VALUES (1809,114,17957);
INSERT INTO items_applications VALUES (1811,114,17958);
INSERT INTO items_applications VALUES (1813,114,17959);
INSERT INTO items_applications VALUES (1815,114,17960);
INSERT INTO items_applications VALUES (1817,114,17961);
INSERT INTO items_applications VALUES (1823,115,17964);
INSERT INTO items_applications VALUES (1824,115,17965);
INSERT INTO items_applications VALUES (1826,115,17966);
INSERT INTO items_applications VALUES (1838,115,17976);
INSERT INTO items_applications VALUES (1840,115,17977);
INSERT INTO items_applications VALUES (1842,115,17978);
INSERT INTO items_applications VALUES (1844,115,17979);
INSERT INTO items_applications VALUES (1846,115,17980);
INSERT INTO items_applications VALUES (1848,115,17981);
INSERT INTO items_applications VALUES (1850,115,17982);
INSERT INTO items_applications VALUES (1852,115,17983);
INSERT INTO items_applications VALUES (1854,115,17984);
INSERT INTO items_applications VALUES (1856,115,17985);
INSERT INTO items_applications VALUES (1858,115,17986);
INSERT INTO items_applications VALUES (1860,115,17987);
INSERT INTO items_applications VALUES (1862,115,17988);
INSERT INTO items_applications VALUES (1864,115,17989);
INSERT INTO items_applications VALUES (1866,115,17990);
INSERT INTO items_applications VALUES (1868,115,17991);
INSERT INTO items_applications VALUES (1870,115,17992);
INSERT INTO items_applications VALUES (1872,115,17993);
INSERT INTO items_applications VALUES (1874,115,17994);
INSERT INTO items_applications VALUES (1876,115,17995);
INSERT INTO items_applications VALUES (1878,115,17996);
INSERT INTO items_applications VALUES (1880,115,17997);
INSERT INTO items_applications VALUES (1882,115,17998);
INSERT INTO items_applications VALUES (1884,115,17999);
INSERT INTO items_applications VALUES (1886,115,18000);
INSERT INTO items_applications VALUES (1888,115,18001);
INSERT INTO items_applications VALUES (1890,115,18002);
INSERT INTO items_applications VALUES (1892,115,18003);
INSERT INTO items_applications VALUES (1894,115,18004);
INSERT INTO items_applications VALUES (1896,115,18005);
INSERT INTO items_applications VALUES (1898,115,18006);
INSERT INTO items_applications VALUES (1900,115,18007);
INSERT INTO items_applications VALUES (1902,115,18008);
INSERT INTO items_applications VALUES (1904,115,18009);
INSERT INTO items_applications VALUES (1906,115,18010);
INSERT INTO items_applications VALUES (1908,115,18011);
INSERT INTO items_applications VALUES (1910,115,18012);
INSERT INTO items_applications VALUES (1912,115,18013);
INSERT INTO items_applications VALUES (1914,115,18014);
INSERT INTO items_applications VALUES (1916,115,18015);
INSERT INTO items_applications VALUES (1918,115,18016);
INSERT INTO items_applications VALUES (1920,115,18017);
INSERT INTO items_applications VALUES (1922,115,18018);
INSERT INTO items_applications VALUES (1924,115,18019);
INSERT INTO items_applications VALUES (1926,115,18020);
INSERT INTO items_applications VALUES (1928,115,18021);
INSERT INTO items_applications VALUES (1930,115,18022);
INSERT INTO items_applications VALUES (1932,115,18023);
INSERT INTO items_applications VALUES (1825,116,17965);
INSERT INTO items_applications VALUES (1839,116,17976);
INSERT INTO items_applications VALUES (1841,116,17977);
INSERT INTO items_applications VALUES (1843,116,17978);
INSERT INTO items_applications VALUES (1845,116,17979);
INSERT INTO items_applications VALUES (1847,116,17980);
INSERT INTO items_applications VALUES (1849,116,17981);
INSERT INTO items_applications VALUES (1851,116,17982);
INSERT INTO items_applications VALUES (1853,116,17983);
INSERT INTO items_applications VALUES (1855,116,17984);
INSERT INTO items_applications VALUES (1857,116,17985);
INSERT INTO items_applications VALUES (1859,116,17986);
INSERT INTO items_applications VALUES (1861,116,17987);
INSERT INTO items_applications VALUES (1863,116,17988);
INSERT INTO items_applications VALUES (1865,116,17989);
INSERT INTO items_applications VALUES (1867,116,17990);
INSERT INTO items_applications VALUES (1869,116,17991);
INSERT INTO items_applications VALUES (1871,116,17992);
INSERT INTO items_applications VALUES (1873,116,17993);
INSERT INTO items_applications VALUES (1875,116,17994);
INSERT INTO items_applications VALUES (1877,116,17995);
INSERT INTO items_applications VALUES (1879,116,17996);
INSERT INTO items_applications VALUES (1881,116,17997);
INSERT INTO items_applications VALUES (1883,116,17998);
INSERT INTO items_applications VALUES (1885,116,17999);
INSERT INTO items_applications VALUES (1887,116,18000);
INSERT INTO items_applications VALUES (1889,116,18001);
INSERT INTO items_applications VALUES (1891,116,18002);
INSERT INTO items_applications VALUES (1893,116,18003);
INSERT INTO items_applications VALUES (1895,116,18004);
INSERT INTO items_applications VALUES (1897,116,18005);
INSERT INTO items_applications VALUES (1899,116,18006);
INSERT INTO items_applications VALUES (1901,116,18007);
INSERT INTO items_applications VALUES (1903,116,18008);
INSERT INTO items_applications VALUES (1905,116,18009);
INSERT INTO items_applications VALUES (1907,116,18010);
INSERT INTO items_applications VALUES (1909,116,18011);
INSERT INTO items_applications VALUES (1911,116,18012);
INSERT INTO items_applications VALUES (1913,116,18013);
INSERT INTO items_applications VALUES (1915,116,18014);
INSERT INTO items_applications VALUES (1917,116,18015);
INSERT INTO items_applications VALUES (1919,116,18016);
INSERT INTO items_applications VALUES (1921,116,18017);
INSERT INTO items_applications VALUES (1923,116,18018);
INSERT INTO items_applications VALUES (1832,117,17970);
INSERT INTO items_applications VALUES (1833,117,17971);
INSERT INTO items_applications VALUES (1834,117,17972);
INSERT INTO items_applications VALUES (1835,117,17973);
INSERT INTO items_applications VALUES (1836,117,17974);
INSERT INTO items_applications VALUES (1837,117,17975);
INSERT INTO items_applications VALUES (1925,118,18019);
INSERT INTO items_applications VALUES (1927,118,18020);
INSERT INTO items_applications VALUES (1929,118,18021);
INSERT INTO items_applications VALUES (1931,118,18022);
INSERT INTO items_applications VALUES (1933,118,18023);
INSERT INTO items_applications VALUES (1934,119,18024);
INSERT INTO items_applications VALUES (1970,119,18054);
INSERT INTO items_applications VALUES (1972,119,18055);
INSERT INTO items_applications VALUES (1990,119,18064);
INSERT INTO items_applications VALUES (1992,119,18065);
INSERT INTO items_applications VALUES (1998,119,18069);
INSERT INTO items_applications VALUES (2000,119,18070);
INSERT INTO items_applications VALUES (1935,120,18025);
INSERT INTO items_applications VALUES (1958,120,18042);
INSERT INTO items_applications VALUES (1959,120,18043);
INSERT INTO items_applications VALUES (1960,120,18044);
INSERT INTO items_applications VALUES (1961,120,18045);
INSERT INTO items_applications VALUES (1962,120,18046);
INSERT INTO items_applications VALUES (1963,120,18047);
INSERT INTO items_applications VALUES (1964,120,18048);
INSERT INTO items_applications VALUES (1965,120,18049);
INSERT INTO items_applications VALUES (1966,120,18050);
INSERT INTO items_applications VALUES (1936,121,18026);
INSERT INTO items_applications VALUES (1937,122,18027);
INSERT INTO items_applications VALUES (1938,122,18028);
INSERT INTO items_applications VALUES (1967,122,18051);
INSERT INTO items_applications VALUES (1968,122,18052);
INSERT INTO items_applications VALUES (1969,122,18053);
INSERT INTO items_applications VALUES (1971,122,18054);
INSERT INTO items_applications VALUES (1973,122,18055);
INSERT INTO items_applications VALUES (1991,122,18064);
INSERT INTO items_applications VALUES (1993,122,18065);
INSERT INTO items_applications VALUES (1999,122,18069);
INSERT INTO items_applications VALUES (2001,122,18070);
INSERT INTO items_applications VALUES (2002,122,18071);
INSERT INTO items_applications VALUES (1939,123,18029);
INSERT INTO items_applications VALUES (1941,123,18030);
INSERT INTO items_applications VALUES (1943,123,18031);
INSERT INTO items_applications VALUES (1945,123,18032);
INSERT INTO items_applications VALUES (1947,123,18033);
INSERT INTO items_applications VALUES (1949,123,18034);
INSERT INTO items_applications VALUES (1940,124,18029);
INSERT INTO items_applications VALUES (1942,124,18030);
INSERT INTO items_applications VALUES (1944,124,18031);
INSERT INTO items_applications VALUES (1946,124,18032);
INSERT INTO items_applications VALUES (1948,124,18033);
INSERT INTO items_applications VALUES (1950,124,18034);
INSERT INTO items_applications VALUES (1975,124,18056);
INSERT INTO items_applications VALUES (1977,124,18057);
INSERT INTO items_applications VALUES (1979,124,18058);
INSERT INTO items_applications VALUES (1981,124,18059);
INSERT INTO items_applications VALUES (1983,124,18060);
INSERT INTO items_applications VALUES (1985,124,18061);
INSERT INTO items_applications VALUES (1987,124,18062);
INSERT INTO items_applications VALUES (1989,124,18063);
INSERT INTO items_applications VALUES (1951,125,18035);
INSERT INTO items_applications VALUES (1952,125,18036);
INSERT INTO items_applications VALUES (1953,125,18037);
INSERT INTO items_applications VALUES (1954,125,18038);
INSERT INTO items_applications VALUES (1955,125,18039);
INSERT INTO items_applications VALUES (1956,125,18040);
INSERT INTO items_applications VALUES (1957,125,18041);
INSERT INTO items_applications VALUES (1974,126,18056);
INSERT INTO items_applications VALUES (1976,126,18057);
INSERT INTO items_applications VALUES (1978,126,18058);
INSERT INTO items_applications VALUES (1980,126,18059);
INSERT INTO items_applications VALUES (1982,126,18060);
INSERT INTO items_applications VALUES (1984,126,18061);
INSERT INTO items_applications VALUES (1986,126,18062);
INSERT INTO items_applications VALUES (1988,126,18063);
INSERT INTO items_applications VALUES (1994,127,18066);
INSERT INTO items_applications VALUES (1995,127,18067);
INSERT INTO items_applications VALUES (1997,127,18068);
INSERT INTO items_applications VALUES (2009,127,18078);
INSERT INTO items_applications VALUES (2011,127,18079);
INSERT INTO items_applications VALUES (2013,127,18080);
INSERT INTO items_applications VALUES (2015,127,18081);
INSERT INTO items_applications VALUES (2017,127,18082);
INSERT INTO items_applications VALUES (2019,127,18083);
INSERT INTO items_applications VALUES (2021,127,18084);
INSERT INTO items_applications VALUES (2023,127,18085);
INSERT INTO items_applications VALUES (2025,127,18086);
INSERT INTO items_applications VALUES (2027,127,18087);
INSERT INTO items_applications VALUES (2029,127,18088);
INSERT INTO items_applications VALUES (2031,127,18089);
INSERT INTO items_applications VALUES (2033,127,18090);
INSERT INTO items_applications VALUES (2035,127,18091);
INSERT INTO items_applications VALUES (2037,127,18092);
INSERT INTO items_applications VALUES (2039,127,18093);
INSERT INTO items_applications VALUES (2041,127,18094);
INSERT INTO items_applications VALUES (2043,127,18095);
INSERT INTO items_applications VALUES (2045,127,18096);
INSERT INTO items_applications VALUES (2047,127,18097);
INSERT INTO items_applications VALUES (2049,127,18098);
INSERT INTO items_applications VALUES (2051,127,18099);
INSERT INTO items_applications VALUES (2053,127,18100);
INSERT INTO items_applications VALUES (2055,127,18101);
INSERT INTO items_applications VALUES (2057,127,18102);
INSERT INTO items_applications VALUES (2059,127,18103);
INSERT INTO items_applications VALUES (2061,127,18104);
INSERT INTO items_applications VALUES (2063,127,18105);
INSERT INTO items_applications VALUES (2065,127,18106);
INSERT INTO items_applications VALUES (2067,127,18107);
INSERT INTO items_applications VALUES (2069,127,18108);
INSERT INTO items_applications VALUES (2071,127,18109);
INSERT INTO items_applications VALUES (2073,127,18110);
INSERT INTO items_applications VALUES (2075,127,18111);
INSERT INTO items_applications VALUES (2077,127,18112);
INSERT INTO items_applications VALUES (2079,127,18113);
INSERT INTO items_applications VALUES (2081,127,18114);
INSERT INTO items_applications VALUES (2083,127,18115);
INSERT INTO items_applications VALUES (2085,127,18116);
INSERT INTO items_applications VALUES (2087,127,18117);
INSERT INTO items_applications VALUES (2089,127,18118);
INSERT INTO items_applications VALUES (2091,127,18119);
INSERT INTO items_applications VALUES (2093,127,18120);
INSERT INTO items_applications VALUES (2095,127,18121);
INSERT INTO items_applications VALUES (2097,127,18122);
INSERT INTO items_applications VALUES (2099,127,18123);
INSERT INTO items_applications VALUES (2101,127,18124);
INSERT INTO items_applications VALUES (2103,127,18125);
INSERT INTO items_applications VALUES (1996,128,18067);
INSERT INTO items_applications VALUES (2010,128,18078);
INSERT INTO items_applications VALUES (2012,128,18079);
INSERT INTO items_applications VALUES (2014,128,18080);
INSERT INTO items_applications VALUES (2016,128,18081);
INSERT INTO items_applications VALUES (2018,128,18082);
INSERT INTO items_applications VALUES (2020,128,18083);
INSERT INTO items_applications VALUES (2022,128,18084);
INSERT INTO items_applications VALUES (2024,128,18085);
INSERT INTO items_applications VALUES (2026,128,18086);
INSERT INTO items_applications VALUES (2028,128,18087);
INSERT INTO items_applications VALUES (2030,128,18088);
INSERT INTO items_applications VALUES (2032,128,18089);
INSERT INTO items_applications VALUES (2034,128,18090);
INSERT INTO items_applications VALUES (2036,128,18091);
INSERT INTO items_applications VALUES (2038,128,18092);
INSERT INTO items_applications VALUES (2040,128,18093);
INSERT INTO items_applications VALUES (2042,128,18094);
INSERT INTO items_applications VALUES (2044,128,18095);
INSERT INTO items_applications VALUES (2046,128,18096);
INSERT INTO items_applications VALUES (2048,128,18097);
INSERT INTO items_applications VALUES (2050,128,18098);
INSERT INTO items_applications VALUES (2052,128,18099);
INSERT INTO items_applications VALUES (2054,128,18100);
INSERT INTO items_applications VALUES (2056,128,18101);
INSERT INTO items_applications VALUES (2058,128,18102);
INSERT INTO items_applications VALUES (2060,128,18103);
INSERT INTO items_applications VALUES (2062,128,18104);
INSERT INTO items_applications VALUES (2064,128,18105);
INSERT INTO items_applications VALUES (2066,128,18106);
INSERT INTO items_applications VALUES (2068,128,18107);
INSERT INTO items_applications VALUES (2070,128,18108);
INSERT INTO items_applications VALUES (2072,128,18109);
INSERT INTO items_applications VALUES (2074,128,18110);
INSERT INTO items_applications VALUES (2076,128,18111);
INSERT INTO items_applications VALUES (2078,128,18112);
INSERT INTO items_applications VALUES (2080,128,18113);
INSERT INTO items_applications VALUES (2082,128,18114);
INSERT INTO items_applications VALUES (2084,128,18115);
INSERT INTO items_applications VALUES (2086,128,18116);
INSERT INTO items_applications VALUES (2088,128,18117);
INSERT INTO items_applications VALUES (2090,128,18118);
INSERT INTO items_applications VALUES (2092,128,18119);
INSERT INTO items_applications VALUES (2094,128,18120);
INSERT INTO items_applications VALUES (2003,129,18072);
INSERT INTO items_applications VALUES (2004,129,18073);
INSERT INTO items_applications VALUES (2005,129,18074);
INSERT INTO items_applications VALUES (2006,129,18075);
INSERT INTO items_applications VALUES (2007,129,18076);
INSERT INTO items_applications VALUES (2008,129,18077);
INSERT INTO items_applications VALUES (2096,130,18121);
INSERT INTO items_applications VALUES (2098,130,18122);
INSERT INTO items_applications VALUES (2100,130,18123);
INSERT INTO items_applications VALUES (2102,130,18124);
INSERT INTO items_applications VALUES (2104,130,18125);
INSERT INTO items_applications VALUES (2105,131,18126);
INSERT INTO items_applications VALUES (2141,131,18156);
INSERT INTO items_applications VALUES (2143,131,18157);
INSERT INTO items_applications VALUES (2161,131,18166);
INSERT INTO items_applications VALUES (2163,131,18167);
INSERT INTO items_applications VALUES (2169,131,18171);
INSERT INTO items_applications VALUES (2171,131,18172);
INSERT INTO items_applications VALUES (2106,132,18127);
INSERT INTO items_applications VALUES (2129,132,18144);
INSERT INTO items_applications VALUES (2130,132,18145);
INSERT INTO items_applications VALUES (2131,132,18146);
INSERT INTO items_applications VALUES (2132,132,18147);
INSERT INTO items_applications VALUES (2133,132,18148);
INSERT INTO items_applications VALUES (2134,132,18149);
INSERT INTO items_applications VALUES (2135,132,18150);
INSERT INTO items_applications VALUES (2136,132,18151);
INSERT INTO items_applications VALUES (2137,132,18152);
INSERT INTO items_applications VALUES (2107,133,18128);
INSERT INTO items_applications VALUES (2108,134,18129);
INSERT INTO items_applications VALUES (2109,134,18130);
INSERT INTO items_applications VALUES (2138,134,18153);
INSERT INTO items_applications VALUES (2139,134,18154);
INSERT INTO items_applications VALUES (2140,134,18155);
INSERT INTO items_applications VALUES (2142,134,18156);
INSERT INTO items_applications VALUES (2144,134,18157);
INSERT INTO items_applications VALUES (2162,134,18166);
INSERT INTO items_applications VALUES (2164,134,18167);
INSERT INTO items_applications VALUES (2170,134,18171);
INSERT INTO items_applications VALUES (2172,134,18172);
INSERT INTO items_applications VALUES (2173,134,18173);
INSERT INTO items_applications VALUES (2110,135,18131);
INSERT INTO items_applications VALUES (2112,135,18132);
INSERT INTO items_applications VALUES (2114,135,18133);
INSERT INTO items_applications VALUES (2116,135,18134);
INSERT INTO items_applications VALUES (2118,135,18135);
INSERT INTO items_applications VALUES (2120,135,18136);
INSERT INTO items_applications VALUES (2111,136,18131);
INSERT INTO items_applications VALUES (2113,136,18132);
INSERT INTO items_applications VALUES (2115,136,18133);
INSERT INTO items_applications VALUES (2117,136,18134);
INSERT INTO items_applications VALUES (2119,136,18135);
INSERT INTO items_applications VALUES (2121,136,18136);
INSERT INTO items_applications VALUES (2146,136,18158);
INSERT INTO items_applications VALUES (2148,136,18159);
INSERT INTO items_applications VALUES (2150,136,18160);
INSERT INTO items_applications VALUES (2152,136,18161);
INSERT INTO items_applications VALUES (2154,136,18162);
INSERT INTO items_applications VALUES (2156,136,18163);
INSERT INTO items_applications VALUES (2158,136,18164);
INSERT INTO items_applications VALUES (2160,136,18165);
INSERT INTO items_applications VALUES (2122,137,18137);
INSERT INTO items_applications VALUES (2123,137,18138);
INSERT INTO items_applications VALUES (2124,137,18139);
INSERT INTO items_applications VALUES (2125,137,18140);
INSERT INTO items_applications VALUES (2126,137,18141);
INSERT INTO items_applications VALUES (2127,137,18142);
INSERT INTO items_applications VALUES (2128,137,18143);
INSERT INTO items_applications VALUES (2145,138,18158);
INSERT INTO items_applications VALUES (2147,138,18159);
INSERT INTO items_applications VALUES (2149,138,18160);
INSERT INTO items_applications VALUES (2151,138,18161);
INSERT INTO items_applications VALUES (2153,138,18162);
INSERT INTO items_applications VALUES (2155,138,18163);
INSERT INTO items_applications VALUES (2157,138,18164);
INSERT INTO items_applications VALUES (2159,138,18165);
INSERT INTO items_applications VALUES (2165,139,18168);
INSERT INTO items_applications VALUES (2166,139,18169);
INSERT INTO items_applications VALUES (2168,139,18170);
INSERT INTO items_applications VALUES (2180,139,18180);
INSERT INTO items_applications VALUES (2182,139,18181);
INSERT INTO items_applications VALUES (2184,139,18182);
INSERT INTO items_applications VALUES (2186,139,18183);
INSERT INTO items_applications VALUES (2188,139,18184);
INSERT INTO items_applications VALUES (2190,139,18185);
INSERT INTO items_applications VALUES (2192,139,18186);
INSERT INTO items_applications VALUES (2194,139,18187);
INSERT INTO items_applications VALUES (2196,139,18188);
INSERT INTO items_applications VALUES (2198,139,18189);
INSERT INTO items_applications VALUES (2200,139,18190);
INSERT INTO items_applications VALUES (2202,139,18191);
INSERT INTO items_applications VALUES (2204,139,18192);
INSERT INTO items_applications VALUES (2206,139,18193);
INSERT INTO items_applications VALUES (2208,139,18194);
INSERT INTO items_applications VALUES (2210,139,18195);
INSERT INTO items_applications VALUES (2212,139,18196);
INSERT INTO items_applications VALUES (2214,139,18197);
INSERT INTO items_applications VALUES (2216,139,18198);
INSERT INTO items_applications VALUES (2218,139,18199);
INSERT INTO items_applications VALUES (2220,139,18200);
INSERT INTO items_applications VALUES (2222,139,18201);
INSERT INTO items_applications VALUES (2224,139,18202);
INSERT INTO items_applications VALUES (2226,139,18203);
INSERT INTO items_applications VALUES (2228,139,18204);
INSERT INTO items_applications VALUES (2230,139,18205);
INSERT INTO items_applications VALUES (2232,139,18206);
INSERT INTO items_applications VALUES (2234,139,18207);
INSERT INTO items_applications VALUES (2236,139,18208);
INSERT INTO items_applications VALUES (2238,139,18209);
INSERT INTO items_applications VALUES (2240,139,18210);
INSERT INTO items_applications VALUES (2242,139,18211);
INSERT INTO items_applications VALUES (2244,139,18212);
INSERT INTO items_applications VALUES (2246,139,18213);
INSERT INTO items_applications VALUES (2248,139,18214);
INSERT INTO items_applications VALUES (2250,139,18215);
INSERT INTO items_applications VALUES (2252,139,18216);
INSERT INTO items_applications VALUES (2254,139,18217);
INSERT INTO items_applications VALUES (2256,139,18218);
INSERT INTO items_applications VALUES (2258,139,18219);
INSERT INTO items_applications VALUES (2260,139,18220);
INSERT INTO items_applications VALUES (2262,139,18221);
INSERT INTO items_applications VALUES (2264,139,18222);
INSERT INTO items_applications VALUES (2266,139,18223);
INSERT INTO items_applications VALUES (2268,139,18224);
INSERT INTO items_applications VALUES (2270,139,18225);
INSERT INTO items_applications VALUES (2272,139,18226);
INSERT INTO items_applications VALUES (2274,139,18227);
INSERT INTO items_applications VALUES (2167,140,18169);
INSERT INTO items_applications VALUES (2181,140,18180);
INSERT INTO items_applications VALUES (2183,140,18181);
INSERT INTO items_applications VALUES (2185,140,18182);
INSERT INTO items_applications VALUES (2187,140,18183);
INSERT INTO items_applications VALUES (2189,140,18184);
INSERT INTO items_applications VALUES (2191,140,18185);
INSERT INTO items_applications VALUES (2193,140,18186);
INSERT INTO items_applications VALUES (2195,140,18187);
INSERT INTO items_applications VALUES (2197,140,18188);
INSERT INTO items_applications VALUES (2199,140,18189);
INSERT INTO items_applications VALUES (2201,140,18190);
INSERT INTO items_applications VALUES (2203,140,18191);
INSERT INTO items_applications VALUES (2205,140,18192);
INSERT INTO items_applications VALUES (2207,140,18193);
INSERT INTO items_applications VALUES (2209,140,18194);
INSERT INTO items_applications VALUES (2211,140,18195);
INSERT INTO items_applications VALUES (2213,140,18196);
INSERT INTO items_applications VALUES (2215,140,18197);
INSERT INTO items_applications VALUES (2217,140,18198);
INSERT INTO items_applications VALUES (2219,140,18199);
INSERT INTO items_applications VALUES (2221,140,18200);
INSERT INTO items_applications VALUES (2223,140,18201);
INSERT INTO items_applications VALUES (2225,140,18202);
INSERT INTO items_applications VALUES (2227,140,18203);
INSERT INTO items_applications VALUES (2229,140,18204);
INSERT INTO items_applications VALUES (2231,140,18205);
INSERT INTO items_applications VALUES (2233,140,18206);
INSERT INTO items_applications VALUES (2235,140,18207);
INSERT INTO items_applications VALUES (2237,140,18208);
INSERT INTO items_applications VALUES (2239,140,18209);
INSERT INTO items_applications VALUES (2241,140,18210);
INSERT INTO items_applications VALUES (2243,140,18211);
INSERT INTO items_applications VALUES (2245,140,18212);
INSERT INTO items_applications VALUES (2247,140,18213);
INSERT INTO items_applications VALUES (2249,140,18214);
INSERT INTO items_applications VALUES (2251,140,18215);
INSERT INTO items_applications VALUES (2253,140,18216);
INSERT INTO items_applications VALUES (2255,140,18217);
INSERT INTO items_applications VALUES (2257,140,18218);
INSERT INTO items_applications VALUES (2259,140,18219);
INSERT INTO items_applications VALUES (2261,140,18220);
INSERT INTO items_applications VALUES (2263,140,18221);
INSERT INTO items_applications VALUES (2265,140,18222);
INSERT INTO items_applications VALUES (2174,141,18174);
INSERT INTO items_applications VALUES (2175,141,18175);
INSERT INTO items_applications VALUES (2176,141,18176);
INSERT INTO items_applications VALUES (2177,141,18177);
INSERT INTO items_applications VALUES (2178,141,18178);
INSERT INTO items_applications VALUES (2179,141,18179);
INSERT INTO items_applications VALUES (2267,142,18223);
INSERT INTO items_applications VALUES (2269,142,18224);
INSERT INTO items_applications VALUES (2271,142,18225);
INSERT INTO items_applications VALUES (2273,142,18226);
INSERT INTO items_applications VALUES (2275,142,18227);
INSERT INTO items_applications VALUES (2336,143,18477);
INSERT INTO items_applications VALUES (2338,143,18478);
INSERT INTO items_applications VALUES (2339,143,18479);
INSERT INTO items_applications VALUES (2352,143,18489);
INSERT INTO items_applications VALUES (2354,143,18490);
INSERT INTO items_applications VALUES (2356,143,18491);
INSERT INTO items_applications VALUES (2358,143,18492);
INSERT INTO items_applications VALUES (2360,143,18493);
INSERT INTO items_applications VALUES (2362,143,18494);
INSERT INTO items_applications VALUES (2364,143,18495);
INSERT INTO items_applications VALUES (2366,143,18496);
INSERT INTO items_applications VALUES (2368,143,18497);
INSERT INTO items_applications VALUES (2370,143,18498);
INSERT INTO items_applications VALUES (2372,143,18499);
INSERT INTO items_applications VALUES (2374,143,18500);
INSERT INTO items_applications VALUES (2376,143,18501);
INSERT INTO items_applications VALUES (2378,143,18502);
INSERT INTO items_applications VALUES (2380,143,18503);
INSERT INTO items_applications VALUES (2382,143,18504);
INSERT INTO items_applications VALUES (2384,143,18505);
INSERT INTO items_applications VALUES (2386,143,18506);
INSERT INTO items_applications VALUES (2388,143,18507);
INSERT INTO items_applications VALUES (2390,143,18508);
INSERT INTO items_applications VALUES (2392,143,18509);
INSERT INTO items_applications VALUES (2394,143,18510);
INSERT INTO items_applications VALUES (2396,143,18511);
INSERT INTO items_applications VALUES (2398,143,18512);
INSERT INTO items_applications VALUES (2400,143,18513);
INSERT INTO items_applications VALUES (2402,143,18514);
INSERT INTO items_applications VALUES (2404,143,18515);
INSERT INTO items_applications VALUES (2406,143,18516);
INSERT INTO items_applications VALUES (2408,143,18517);
INSERT INTO items_applications VALUES (2410,143,18518);
INSERT INTO items_applications VALUES (2412,143,18519);
INSERT INTO items_applications VALUES (2414,143,18520);
INSERT INTO items_applications VALUES (2416,143,18521);
INSERT INTO items_applications VALUES (2418,143,18522);
INSERT INTO items_applications VALUES (2420,143,18523);
INSERT INTO items_applications VALUES (2422,143,18524);
INSERT INTO items_applications VALUES (2424,143,18525);
INSERT INTO items_applications VALUES (2426,143,18526);
INSERT INTO items_applications VALUES (2428,143,18527);
INSERT INTO items_applications VALUES (2430,143,18528);
INSERT INTO items_applications VALUES (2432,143,18529);
INSERT INTO items_applications VALUES (2434,143,18530);
INSERT INTO items_applications VALUES (2436,143,18531);
INSERT INTO items_applications VALUES (2438,143,18532);
INSERT INTO items_applications VALUES (2440,143,18533);
INSERT INTO items_applications VALUES (2442,143,18534);
INSERT INTO items_applications VALUES (2444,143,18535);
INSERT INTO items_applications VALUES (2446,143,18536);
INSERT INTO items_applications VALUES (2316,144,18467);
INSERT INTO items_applications VALUES (2318,144,18468);
INSERT INTO items_applications VALUES (2320,144,18469);
INSERT INTO items_applications VALUES (2322,144,18470);
INSERT INTO items_applications VALUES (2324,144,18471);
INSERT INTO items_applications VALUES (2326,144,18472);
INSERT INTO items_applications VALUES (2328,144,18473);
INSERT INTO items_applications VALUES (2330,144,18474);
INSERT INTO items_applications VALUES (2337,145,18478);
INSERT INTO items_applications VALUES (2351,145,18489);
INSERT INTO items_applications VALUES (2353,145,18490);
INSERT INTO items_applications VALUES (2355,145,18491);
INSERT INTO items_applications VALUES (2357,145,18492);
INSERT INTO items_applications VALUES (2359,145,18493);
INSERT INTO items_applications VALUES (2361,145,18494);
INSERT INTO items_applications VALUES (2363,145,18495);
INSERT INTO items_applications VALUES (2365,145,18496);
INSERT INTO items_applications VALUES (2367,145,18497);
INSERT INTO items_applications VALUES (2369,145,18498);
INSERT INTO items_applications VALUES (2371,145,18499);
INSERT INTO items_applications VALUES (2373,145,18500);
INSERT INTO items_applications VALUES (2375,145,18501);
INSERT INTO items_applications VALUES (2377,145,18502);
INSERT INTO items_applications VALUES (2379,145,18503);
INSERT INTO items_applications VALUES (2381,145,18504);
INSERT INTO items_applications VALUES (2383,145,18505);
INSERT INTO items_applications VALUES (2385,145,18506);
INSERT INTO items_applications VALUES (2387,145,18507);
INSERT INTO items_applications VALUES (2389,145,18508);
INSERT INTO items_applications VALUES (2391,145,18509);
INSERT INTO items_applications VALUES (2393,145,18510);
INSERT INTO items_applications VALUES (2395,145,18511);
INSERT INTO items_applications VALUES (2397,145,18512);
INSERT INTO items_applications VALUES (2399,145,18513);
INSERT INTO items_applications VALUES (2401,145,18514);
INSERT INTO items_applications VALUES (2403,145,18515);
INSERT INTO items_applications VALUES (2405,145,18516);
INSERT INTO items_applications VALUES (2407,145,18517);
INSERT INTO items_applications VALUES (2409,145,18518);
INSERT INTO items_applications VALUES (2411,145,18519);
INSERT INTO items_applications VALUES (2413,145,18520);
INSERT INTO items_applications VALUES (2415,145,18521);
INSERT INTO items_applications VALUES (2417,145,18522);
INSERT INTO items_applications VALUES (2419,145,18523);
INSERT INTO items_applications VALUES (2421,145,18524);
INSERT INTO items_applications VALUES (2423,145,18525);
INSERT INTO items_applications VALUES (2425,145,18526);
INSERT INTO items_applications VALUES (2427,145,18527);
INSERT INTO items_applications VALUES (2429,145,18528);
INSERT INTO items_applications VALUES (2431,145,18529);
INSERT INTO items_applications VALUES (2433,145,18530);
INSERT INTO items_applications VALUES (2435,145,18531);
INSERT INTO items_applications VALUES (2276,146,18435);
INSERT INTO items_applications VALUES (2313,146,18465);
INSERT INTO items_applications VALUES (2315,146,18466);
INSERT INTO items_applications VALUES (2333,146,18475);
INSERT INTO items_applications VALUES (2335,146,18476);
INSERT INTO items_applications VALUES (2341,146,18480);
INSERT INTO items_applications VALUES (2343,146,18481);
INSERT INTO items_applications VALUES (2345,147,18483);
INSERT INTO items_applications VALUES (2346,147,18484);
INSERT INTO items_applications VALUES (2347,147,18485);
INSERT INTO items_applications VALUES (2348,147,18486);
INSERT INTO items_applications VALUES (2349,147,18487);
INSERT INTO items_applications VALUES (2350,147,18488);
INSERT INTO items_applications VALUES (2278,148,18437);
INSERT INTO items_applications VALUES (2437,149,18532);
INSERT INTO items_applications VALUES (2439,149,18533);
INSERT INTO items_applications VALUES (2441,149,18534);
INSERT INTO items_applications VALUES (2443,149,18535);
INSERT INTO items_applications VALUES (2445,149,18536);
INSERT INTO items_applications VALUES (2281,150,18440);
INSERT INTO items_applications VALUES (2283,150,18441);
INSERT INTO items_applications VALUES (2285,150,18442);
INSERT INTO items_applications VALUES (2287,150,18443);
INSERT INTO items_applications VALUES (2289,150,18444);
INSERT INTO items_applications VALUES (2291,150,18445);
INSERT INTO items_applications VALUES (2279,151,18438);
INSERT INTO items_applications VALUES (2280,151,18439);
INSERT INTO items_applications VALUES (2309,151,18462);
INSERT INTO items_applications VALUES (2310,151,18463);
INSERT INTO items_applications VALUES (2311,151,18464);
INSERT INTO items_applications VALUES (2312,151,18465);
INSERT INTO items_applications VALUES (2314,151,18466);
INSERT INTO items_applications VALUES (2332,151,18475);
INSERT INTO items_applications VALUES (2334,151,18476);
INSERT INTO items_applications VALUES (2340,151,18480);
INSERT INTO items_applications VALUES (2342,151,18481);
INSERT INTO items_applications VALUES (2344,151,18482);
INSERT INTO items_applications VALUES (2282,152,18440);
INSERT INTO items_applications VALUES (2284,152,18441);
INSERT INTO items_applications VALUES (2286,152,18442);
INSERT INTO items_applications VALUES (2288,152,18443);
INSERT INTO items_applications VALUES (2290,152,18444);
INSERT INTO items_applications VALUES (2292,152,18445);
INSERT INTO items_applications VALUES (2317,152,18467);
INSERT INTO items_applications VALUES (2319,152,18468);
INSERT INTO items_applications VALUES (2321,152,18469);
INSERT INTO items_applications VALUES (2323,152,18470);
INSERT INTO items_applications VALUES (2325,152,18471);
INSERT INTO items_applications VALUES (2327,152,18472);
INSERT INTO items_applications VALUES (2329,152,18473);
INSERT INTO items_applications VALUES (2331,152,18474);
INSERT INTO items_applications VALUES (2277,153,18436);
INSERT INTO items_applications VALUES (2300,153,18453);
INSERT INTO items_applications VALUES (2301,153,18454);
INSERT INTO items_applications VALUES (2302,153,18455);
INSERT INTO items_applications VALUES (2303,153,18456);
INSERT INTO items_applications VALUES (2304,153,18457);
INSERT INTO items_applications VALUES (2305,153,18458);
INSERT INTO items_applications VALUES (2306,153,18459);
INSERT INTO items_applications VALUES (2307,153,18460);
INSERT INTO items_applications VALUES (2308,153,18461);
INSERT INTO items_applications VALUES (2293,154,18446);
INSERT INTO items_applications VALUES (2294,154,18447);
INSERT INTO items_applications VALUES (2295,154,18448);
INSERT INTO items_applications VALUES (2296,154,18449);
INSERT INTO items_applications VALUES (2297,154,18450);
INSERT INTO items_applications VALUES (2298,154,18451);
INSERT INTO items_applications VALUES (2299,154,18452);

--
-- Dumping data for table `actions`
--

INSERT INTO actions VALUES (2,'Auto discovery. Linux servers.',1,0,1);
INSERT INTO actions VALUES (3,'Auto discovery. Windows servers.',1,0,1);

--
-- Dumping data for table `conditions`
--

INSERT INTO conditions VALUES (2,2,10,0,'0');
INSERT INTO conditions VALUES (3,2,8,0,'9');
INSERT INTO conditions VALUES (4,2,12,2,'Linux');
INSERT INTO conditions VALUES (5,3,8,0,'9');
INSERT INTO conditions VALUES (6,3,10,0,'0');
INSERT INTO conditions VALUES (7,3,12,2,'Windows');

--
-- Dumping data for table `operations`
--

INSERT INTO operations VALUES (3,2,6,0,10001,'','');
INSERT INTO operations VALUES (4,2,4,0,2,'','');
INSERT INTO operations VALUES (5,3,4,0,3,'','');
INSERT INTO operations VALUES (6,3,6,0,10002,'','');

--
-- Dumping data for table `drules`
--


INSERT INTO drules VALUES (2,'Local network','192.168.1.1-255',3600,0,1);

--
-- Dumping data for table `dchecks`
--

INSERT INTO dchecks VALUES (2,2,9,'system.uname','','10050');

--
-- Dumping data for table graphs
--

INSERT INTO graphs VALUES (2,'CPU Loads',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (3,'CPU Utilization',900,200,0,0.0000,100.0000,0,1,1,1);
INSERT INTO graphs VALUES (4,'Network utilization',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (5,'Disk usage',900,200,0,0.0000,100.0000,0,1,1,1);
INSERT INTO graphs VALUES (6,'Interface 01 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (7,'Interface 02 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (8,'Interface 03 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (9,'Interface 04 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (10,'Interface 05 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (11,'Interface 06 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (12,'Interface 07 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (13,'Interface 08 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (14,'Interface 09 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (15,'Interface 10 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (16,'Interface 11 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (17,'Interface 12 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (18,'Interface 13 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (19,'Interface 14 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (20,'Interface 15 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (21,'Interface 16 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (22,'Interface 17 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (23,'Interface 18 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (24,'Interface 19 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (25,'Interface 20 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (26,'Interface 21 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (27,'Interface 22 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (28,'Interface 23 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (29,'Interface 24 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (30,'Interface 25 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (31,'Interface 26 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (32,'Interface 27 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (33,'Interface 28 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (34,'Interface 29 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (35,'Interface 30 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (36,'Interface 31 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (37,'Interface 32 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (38,'Interface 33 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (39,'Interface 34 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (40,'Interface 35 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (41,'Interface 36 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (42,'Interface 37 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (43,'Interface 38 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (44,'Interface 39 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (45,'Interface 40 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (46,'Interface 41 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (47,'Interface 42 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (48,'Interface 43 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (49,'Interface 44 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (50,'Interface 45 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (51,'Interface 46      Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (52,'Interface 47 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (53,'Interface 48 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (54,'Interface 49 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (55,'Interface 50 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (56,'Interface 51 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (57,'Interface 52 Bandwidth',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (58,'Network Traffic',900,200,0,0.0000,100.0000,0,1,1,0);
INSERT INTO graphs VALUES (59,'Dell PowerEdge Chassis Temperature',900,200,0,0.0000,100.0000,0,1,1,0);

--
-- Dumping data for table graphs_items
--

INSERT INTO graphs_items VALUES (2,2,18467,0,0,'990000',1,2,0,5);
INSERT INTO graphs_items VALUES (3,2,18468,0,0,'009900',1,2,0,5);
INSERT INTO graphs_items VALUES (4,2,18469,0,0,'999900',1,2,0,5);
INSERT INTO graphs_items VALUES (5,3,18472,1,0,'990000',1,2,0,5);
INSERT INTO graphs_items VALUES (6,3,18470,1,0,'009900',1,2,0,5);
INSERT INTO graphs_items VALUES (7,3,18473,1,0,'999900',1,2,0,5);
INSERT INTO graphs_items VALUES (8,4,18443,0,0,'000099',1,2,0,5);
INSERT INTO graphs_items VALUES (9,4,18440,0,0,'009900',1,2,0,5);
INSERT INTO graphs_items VALUES (10,5,18506,1,0,'990000',1,2,0,5);
INSERT INTO graphs_items VALUES (11,5,18505,1,0,'009900',1,2,0,5);
INSERT INTO graphs_items VALUES (12,6,18576,2,0,'0000CC',1,7,0,5);
INSERT INTO graphs_items VALUES (13,6,18582,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (14,7,18752,0,0,'0000CC',1,7,0,5);
INSERT INTO graphs_items VALUES (15,7,18758,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (16,8,18646,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (17,8,18928,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (18,9,19110,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (19,9,19104,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (20,10,19286,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (21,10,19280,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (22,11,19350,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (23,11,19344,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (24,12,19366,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (25,12,19360,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (26,13,19382,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (27,13,19376,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (28,14,19398,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (29,14,19392,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (30,15,18598,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (31,15,18592,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (32,16,18614,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (33,16,18608,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (34,17,18630,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (35,17,18624,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (36,18,18646,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (37,18,18640,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (38,19,18662,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (39,19,18656,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (40,20,18678,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (41,20,18672,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (42,21,18694,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (43,21,18688,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (44,22,18710,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (45,22,18704,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (46,23,18726,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (47,23,18720,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (48,24,18742,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (49,24,18736,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (50,25,18774,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (51,25,18768,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (52,26,18790,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (53,26,18784,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (54,27,18806,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (55,27,18800,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (56,28,18822,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (57,28,18816,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (58,29,18838,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (59,29,18832,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (60,30,18854,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (61,30,18848,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (62,31,18870,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (63,31,18864,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (64,32,18886,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (65,32,18880,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (66,33,18902,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (67,33,18896,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (68,34,18918,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (69,34,18912,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (70,35,18950,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (71,35,18944,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (72,36,18966,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (73,36,18960,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (74,37,18982,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (75,37,18976,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (76,38,18998,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (77,38,18992,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (78,39,19014,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (79,39,19008,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (80,40,19030,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (81,40,19024,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (82,41,19046,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (83,41,19040,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (84,42,19062,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (85,42,19056,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (86,43,19078,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (87,43,19072,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (88,44,19094,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (89,44,19088,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (90,45,19126,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (91,45,19120,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (92,46,19142,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (93,46,19136,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (94,47,19158,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (95,47,19152,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (96,48,19174,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (97,48,19168,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (98,49,19190,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (99,49,19184,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (100,50,19206,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (101,50,19200,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (102,51,19222,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (103,51,19216,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (104,52,19238,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (105,52,19232,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (106,53,19254,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (107,53,19248,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (108,54,19270,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (109,54,19264,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (110,55,19302,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (111,55,19296,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (112,56,19318,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (113,56,19312,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (114,57,19334,2,0,'009900',1,7,0,5);
INSERT INTO graphs_items VALUES (115,57,19328,2,0,'0000FF',1,7,0,5);
INSERT INTO graphs_items VALUES (116,58,19444,1,1,'009900',1,2,0,5);
INSERT INTO graphs_items VALUES (117,58,19445,2,2,'3333FF',1,2,0,5);
INSERT INTO graphs_items VALUES (118,59,19448,2,0,'FF0000',1,2,0,5);

--
-- Dumping data for table `screens`
--

INSERT INTO screens VALUES (2,'ZABBIX Server',2,3);

--
-- Dumping data for table `screens_items`
--

INSERT INTO screens_items VALUES (2,2,2,2,0,0,0,0,2,0,0,0,0,0,'');
INSERT INTO screens_items VALUES (4,2,0,2,400,100,0,1,0,0,0,0,0,0,'');
INSERT INTO screens_items VALUES (5,2,0,3,400,100,1,1,0,0,0,0,0,0,'');
INSERT INTO screens_items VALUES (6,2,0,4,400,100,0,2,0,0,0,0,0,0,'');
INSERT INTO screens_items VALUES (7,2,0,5,400,100,1,2,0,0,0,0,0,0,'');

--
-- Dumping data for table `sysmaps`
--

INSERT INTO sysmaps VALUES (2,'Local network',980,200,0,2,0);

--
-- Dumping data for table `sysmaps_elements`
--

INSERT INTO sysmaps_elements VALUES (2,2,10017,0,19,19,19,'ZABBIX Server',NULL,100,100,'');
