/* zeitgeist-internal.h generated by valac 0.14.2, the Vala compiler, do not modify */


#ifndef __ZEITGEIST_INTERNAL_H__
#define __ZEITGEIST_INTERNAL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

G_BEGIN_DECLS


#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;
typedef struct _ZeitgeistTimeRangePrivate ZeitgeistTimeRangePrivate;

#define ZEITGEIST_TYPE_RESULT_TYPE (zeitgeist_result_type_get_type ())

#define ZEITGEIST_TYPE_RELEVANT_RESULT_TYPE (zeitgeist_relevant_result_type_get_type ())

#define ZEITGEIST_TYPE_STORAGE_STATE (zeitgeist_storage_state_get_type ())

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;
typedef struct _ZeitgeistEventPrivate ZeitgeistEventPrivate;

#define ZEITGEIST_TYPE_SUBJECT (zeitgeist_subject_get_type ())
#define ZEITGEIST_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject))
#define ZEITGEIST_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))
#define ZEITGEIST_IS_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_IS_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_SUBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))

typedef struct _ZeitgeistSubject ZeitgeistSubject;
typedef struct _ZeitgeistSubjectClass ZeitgeistSubjectClass;
typedef struct _ZeitgeistSubjectPrivate ZeitgeistSubjectPrivate;

#define ZEITGEIST_TYPE_DB_READER (zeitgeist_db_reader_get_type ())
#define ZEITGEIST_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader))
#define ZEITGEIST_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))
#define ZEITGEIST_IS_DB_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_IS_DB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_DB_READER))
#define ZEITGEIST_DB_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReaderClass))

typedef struct _ZeitgeistDbReader ZeitgeistDbReader;
typedef struct _ZeitgeistDbReaderClass ZeitgeistDbReaderClass;
typedef struct _ZeitgeistDbReaderPrivate ZeitgeistDbReaderPrivate;

#define ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP (zeitgeist_sq_lite_table_lookup_get_type ())
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookup))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))

typedef struct _ZeitgeistSQLiteTableLookup ZeitgeistSQLiteTableLookup;
typedef struct _ZeitgeistSQLiteTableLookupClass ZeitgeistSQLiteTableLookupClass;

#define ZEITGEIST_TYPE_WHERE_CLAUSE (zeitgeist_where_clause_get_type ())
#define ZEITGEIST_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClause))
#define ZEITGEIST_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))
#define ZEITGEIST_IS_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_IS_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_WHERE_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))

typedef struct _ZeitgeistWhereClause ZeitgeistWhereClause;
typedef struct _ZeitgeistWhereClauseClass ZeitgeistWhereClauseClass;

#define ZEITGEIST_SQ_LITE_TYPE_DATABASE (zeitgeist_sq_lite_database_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabase))
#define ZEITGEIST_SQ_LITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE))
#define ZEITGEIST_SQ_LITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE, ZeitgeistSQLiteDatabaseClass))

typedef struct _ZeitgeistSQLiteDatabase ZeitgeistSQLiteDatabase;
typedef struct _ZeitgeistSQLiteDatabaseClass ZeitgeistSQLiteDatabaseClass;

#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;
typedef struct _ZeitgeistEnginePrivate ZeitgeistEnginePrivate;

#define ZEITGEIST_TYPE_EXTENSION_STORE (zeitgeist_extension_store_get_type ())
#define ZEITGEIST_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStore))
#define ZEITGEIST_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))
#define ZEITGEIST_IS_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_IS_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_EXTENSION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))

typedef struct _ZeitgeistExtensionStore ZeitgeistExtensionStore;
typedef struct _ZeitgeistExtensionStoreClass ZeitgeistExtensionStoreClass;

#define ZEITGEIST_SQ_LITE_TYPE_EVENT_VIEW_ROWS (zeitgeist_sq_lite_event_view_rows_get_type ())
typedef struct _ZeitgeistSQLiteDatabasePrivate ZeitgeistSQLiteDatabasePrivate;

#define ZEITGEIST_TYPE_VERSION_STRUCT (zeitgeist_version_struct_get_type ())
typedef struct _ZeitgeistVersionStruct ZeitgeistVersionStruct;

#define ZEITGEIST_TYPE_REMOTE_LOG (zeitgeist_remote_log_get_type ())
#define ZEITGEIST_REMOTE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_LOG, ZeitgeistRemoteLog))
#define ZEITGEIST_IS_REMOTE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_LOG))
#define ZEITGEIST_REMOTE_LOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_LOG, ZeitgeistRemoteLogIface))

typedef struct _ZeitgeistRemoteLog ZeitgeistRemoteLog;
typedef struct _ZeitgeistRemoteLogIface ZeitgeistRemoteLogIface;

#define ZEITGEIST_TYPE_REMOTE_LOG_PROXY (zeitgeist_remote_log_proxy_get_type ())

#define ZEITGEIST_TYPE_REMOTE_MONITOR (zeitgeist_remote_monitor_get_type ())
#define ZEITGEIST_REMOTE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR, ZeitgeistRemoteMonitor))
#define ZEITGEIST_IS_REMOTE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR))
#define ZEITGEIST_REMOTE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR, ZeitgeistRemoteMonitorIface))

typedef struct _ZeitgeistRemoteMonitor ZeitgeistRemoteMonitor;
typedef struct _ZeitgeistRemoteMonitorIface ZeitgeistRemoteMonitorIface;

#define ZEITGEIST_TYPE_REMOTE_MONITOR_PROXY (zeitgeist_remote_monitor_proxy_get_type ())

#define ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER (zeitgeist_remote_simple_indexer_get_type ())
#define ZEITGEIST_REMOTE_SIMPLE_INDEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER, ZeitgeistRemoteSimpleIndexer))
#define ZEITGEIST_IS_REMOTE_SIMPLE_INDEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER))
#define ZEITGEIST_REMOTE_SIMPLE_INDEXER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER, ZeitgeistRemoteSimpleIndexerIface))

typedef struct _ZeitgeistRemoteSimpleIndexer ZeitgeistRemoteSimpleIndexer;
typedef struct _ZeitgeistRemoteSimpleIndexerIface ZeitgeistRemoteSimpleIndexerIface;

#define ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER_PROXY (zeitgeist_remote_simple_indexer_proxy_get_type ())

#define ZEITGEIST_TYPE_NETWORK_MANAGER_DBUS (zeitgeist_network_manager_dbus_get_type ())
#define ZEITGEIST_NETWORK_MANAGER_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_NETWORK_MANAGER_DBUS, ZeitgeistNetworkManagerDBus))
#define ZEITGEIST_IS_NETWORK_MANAGER_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_NETWORK_MANAGER_DBUS))
#define ZEITGEIST_NETWORK_MANAGER_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_NETWORK_MANAGER_DBUS, ZeitgeistNetworkManagerDBusIface))

typedef struct _ZeitgeistNetworkManagerDBus ZeitgeistNetworkManagerDBus;
typedef struct _ZeitgeistNetworkManagerDBusIface ZeitgeistNetworkManagerDBusIface;

#define ZEITGEIST_TYPE_NETWORK_MANAGER_DBUS_PROXY (zeitgeist_network_manager_dbus_proxy_get_type ())

#define ZEITGEIST_TYPE_CONNMAN_MANAGER_DBUS (zeitgeist_connman_manager_dbus_get_type ())
#define ZEITGEIST_CONNMAN_MANAGER_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_CONNMAN_MANAGER_DBUS, ZeitgeistConnmanManagerDBus))
#define ZEITGEIST_IS_CONNMAN_MANAGER_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_CONNMAN_MANAGER_DBUS))
#define ZEITGEIST_CONNMAN_MANAGER_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_CONNMAN_MANAGER_DBUS, ZeitgeistConnmanManagerDBusIface))

typedef struct _ZeitgeistConnmanManagerDBus ZeitgeistConnmanManagerDBus;
typedef struct _ZeitgeistConnmanManagerDBusIface ZeitgeistConnmanManagerDBusIface;

#define ZEITGEIST_TYPE_CONNMAN_MANAGER_DBUS_PROXY (zeitgeist_connman_manager_dbus_proxy_get_type ())
typedef struct _ZeitgeistSQLiteTableLookupPrivate ZeitgeistSQLiteTableLookupPrivate;

#define ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA (zeitgeist_sq_lite_database_schema_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchema))
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchemaClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA))
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchemaClass))

typedef struct _ZeitgeistSQLiteDatabaseSchema ZeitgeistSQLiteDatabaseSchema;
typedef struct _ZeitgeistSQLiteDatabaseSchemaClass ZeitgeistSQLiteDatabaseSchemaClass;
typedef struct _ZeitgeistSQLiteDatabaseSchemaPrivate ZeitgeistSQLiteDatabaseSchemaPrivate;
typedef struct _ZeitgeistWhereClausePrivate ZeitgeistWhereClausePrivate;

#define ZEITGEIST_WHERE_CLAUSE_TYPE_TYPE (zeitgeist_where_clause_type_get_type ())

#define ZEITGEIST_TYPE_EXTENSION_COLLECTION (zeitgeist_extension_collection_get_type ())
#define ZEITGEIST_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection))
#define ZEITGEIST_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))
#define ZEITGEIST_IS_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_IS_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_EXTENSION_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))

typedef struct _ZeitgeistExtensionCollection ZeitgeistExtensionCollection;
typedef struct _ZeitgeistExtensionCollectionClass ZeitgeistExtensionCollectionClass;
typedef struct _ZeitgeistExtensionCollectionPrivate ZeitgeistExtensionCollectionPrivate;
typedef struct _ZeitgeistExtensionStorePrivate ZeitgeistExtensionStorePrivate;

struct _ZeitgeistTimeRange {
	GObject parent_instance;
	ZeitgeistTimeRangePrivate * priv;
};

struct _ZeitgeistTimeRangeClass {
	GObjectClass parent_class;
};

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED,
	ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT,
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED,
	ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_ENGINE_ERROR_TOO_MANY_RESULTS
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()
typedef enum  {
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS = 0,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS = 1,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS = 2,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS = 3,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS = 4,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS = 5,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR = 6,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR = 7,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR = 8,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR = 9,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN = 10,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN = 11,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN = 12,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN = 13,
	ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR = 14,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION = 15,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION = 16,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION = 17,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION = 18,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE = 19,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE = 20,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE = 21,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE = 22,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI = 23,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI = 24,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI = 25,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI = 26,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN = 27,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN = 28,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN = 29,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN = 30
} ZeitgeistResultType;

typedef enum  {
	ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT = 0,
	ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED = 1
} ZeitgeistRelevantResultType;

typedef enum  {
	ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE = 0,
	ZEITGEIST_STORAGE_STATE_AVAILABLE = 1,
	ZEITGEIST_STORAGE_STATE_ANY = 2
} ZeitgeistStorageState;

struct _ZeitgeistEvent {
	GObject parent_instance;
	ZeitgeistEventPrivate * priv;
};

struct _ZeitgeistEventClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSubject {
	GObject parent_instance;
	ZeitgeistSubjectPrivate * priv;
};

struct _ZeitgeistSubjectClass {
	GObjectClass parent_class;
};

struct _ZeitgeistDbReader {
	GObject parent_instance;
	ZeitgeistDbReaderPrivate * priv;
	sqlite3* db;
	ZeitgeistSQLiteTableLookup* interpretations_table;
	ZeitgeistSQLiteTableLookup* manifestations_table;
	ZeitgeistSQLiteTableLookup* mimetypes_table;
	ZeitgeistSQLiteTableLookup* actors_table;
};

struct _ZeitgeistDbReaderClass {
	GObjectClass parent_class;
	void (*close) (ZeitgeistDbReader* self);
};

struct _ZeitgeistEngine {
	ZeitgeistDbReader parent_instance;
	ZeitgeistEnginePrivate * priv;
	ZeitgeistExtensionStore* extension_store;
};

struct _ZeitgeistEngineClass {
	ZeitgeistDbReaderClass parent_class;
};

typedef enum  {
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT
} ZeitgeistSQLiteEventViewRows;

typedef void (*ZeitgeistSQLiteDeletionCallback) (const gchar* table, gint64 rowid, void* user_data);
struct _ZeitgeistSQLiteDatabase {
	GObject parent_instance;
	ZeitgeistSQLiteDatabasePrivate * priv;
	sqlite3_stmt* event_insertion_stmt;
	sqlite3_stmt* id_retrieval_stmt;
	sqlite3_stmt* move_handling_stmt;
	sqlite3_stmt* payload_insertion_stmt;
	sqlite3* database;
};

struct _ZeitgeistSQLiteDatabaseClass {
	GObjectClass parent_class;
};

struct _ZeitgeistVersionStruct {
	gint major;
	gint minor;
	gint micro;
};

struct _ZeitgeistRemoteLogIface {
	GTypeInterface parent_iface;
	GVariant* (*delete_events) (ZeitgeistRemoteLog* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
	guint32* (*find_event_ids) (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, int* result_length1, GError** error);
	GVariant* (*find_events) (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, GError** error);
	gchar** (*find_related_uris) (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, GVariant* result_event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, int* result_length1, GError** error);
	GVariant* (*get_events) (ZeitgeistRemoteLog* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
	guint32* (*insert_events) (ZeitgeistRemoteLog* self, GVariant* events, const char* sender, int* result_length1, GError** error);
	void (*install_monitor) (ZeitgeistRemoteLog* self, const char* monitor_path, GVariant* time_range, GVariant* event_templates, const char* owner, GError** error);
	void (*remove_monitor) (ZeitgeistRemoteLog* self, const char* monitor_path, const char* owner, GError** error);
	void (*quit) (ZeitgeistRemoteLog* self, GError** error);
	gchar** (*get_extensions) (ZeitgeistRemoteLog* self, int* result_length1);
	void (*get_version) (ZeitgeistRemoteLog* self, ZeitgeistVersionStruct* value);
};

struct _ZeitgeistRemoteMonitorIface {
	GTypeInterface parent_iface;
	void (*notify_insert) (ZeitgeistRemoteMonitor* self, GVariant* time_range, GVariant* events, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*notify_insert_finish) (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
	void (*notify_delete) (ZeitgeistRemoteMonitor* self, GVariant* time_range, guint32* event_ids, int event_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*notify_delete_finish) (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
};

struct _ZeitgeistRemoteSimpleIndexerIface {
	GTypeInterface parent_iface;
	void (*search) (ZeitgeistRemoteSimpleIndexer* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (ZeitgeistRemoteSimpleIndexer* self, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error);
	void (*search_with_relevancies) (ZeitgeistRemoteSimpleIndexer* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_with_relevancies_finish) (ZeitgeistRemoteSimpleIndexer* self, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error);
};

struct _ZeitgeistNetworkManagerDBusIface {
	GTypeInterface parent_iface;
	guint32 (*state) (ZeitgeistNetworkManagerDBus* self, GError** error);
};

struct _ZeitgeistConnmanManagerDBusIface {
	GTypeInterface parent_iface;
	gchar* (*get_state) (ZeitgeistConnmanManagerDBus* self, GError** error);
};

struct _ZeitgeistSQLiteTableLookup {
	GObject parent_instance;
	ZeitgeistSQLiteTableLookupPrivate * priv;
};

struct _ZeitgeistSQLiteTableLookupClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSQLiteDatabaseSchema {
	GObject parent_instance;
	ZeitgeistSQLiteDatabaseSchemaPrivate * priv;
};

struct _ZeitgeistSQLiteDatabaseSchemaClass {
	GObjectClass parent_class;
};

struct _ZeitgeistWhereClause {
	GObject parent_instance;
	ZeitgeistWhereClausePrivate * priv;
};

struct _ZeitgeistWhereClauseClass {
	GObjectClass parent_class;
};

typedef enum  {
	ZEITGEIST_WHERE_CLAUSE_TYPE_AND,
	ZEITGEIST_WHERE_CLAUSE_TYPE_OR
} ZeitgeistWhereClauseType;

struct _ZeitgeistExtensionCollection {
	GObject parent_instance;
	ZeitgeistExtensionCollectionPrivate * priv;
};

struct _ZeitgeistExtensionCollectionClass {
	GObjectClass parent_class;
};

struct _ZeitgeistExtensionStore {
	GObject parent_instance;
	ZeitgeistExtensionStorePrivate * priv;
};

struct _ZeitgeistExtensionStoreClass {
	GObjectClass parent_class;
};


gint64 zeitgeist_timestamp_now (void);
gint64 zeitgeist_timestamp_from_timeval (GTimeVal* tv);
GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
ZeitgeistTimeRange* zeitgeist_time_range_new (gint64 start_msec, gint64 end_msec);
ZeitgeistTimeRange* zeitgeist_time_range_construct (GType object_type, gint64 start_msec, gint64 end_msec);
ZeitgeistTimeRange* zeitgeist_time_range_new_anytime (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_anytime (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_to_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_to_now (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_now (GType object_type);
GQuark zeitgeist_engine_error_quark (void);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_variant (GVariant* variant, GError** error);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_variant (GType object_type, GVariant* variant, GError** error);
GVariant* zeitgeist_time_range_to_variant (ZeitgeistTimeRange* self);
ZeitgeistTimeRange* zeitgeist_time_range_intersect (ZeitgeistTimeRange* self, ZeitgeistTimeRange* time_range);
gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self);
gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self);
GType zeitgeist_result_type_get_type (void) G_GNUC_CONST;
gboolean zeitgeist_result_type_is_sort_order_asc (ZeitgeistResultType result_type);
GType zeitgeist_relevant_result_type_get_type (void) G_GNUC_CONST;
GType zeitgeist_storage_state_get_type (void) G_GNUC_CONST;
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
gint zeitgeist_event_num_subjects (ZeitgeistEvent* self);
GType zeitgeist_subject_get_type (void) G_GNUC_CONST;
void zeitgeist_event_add_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject);
void zeitgeist_event_take_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject);
ZeitgeistEvent* zeitgeist_event_new_full (const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, ...);
ZeitgeistEvent* zeitgeist_event_construct_full (GType object_type, const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, ...);
ZeitgeistEvent* zeitgeist_event_new_from_variant (GVariant* event_variant, GError** error);
ZeitgeistEvent* zeitgeist_event_construct_from_variant (GType object_type, GVariant* event_variant, GError** error);
GVariant* zeitgeist_event_to_variant (ZeitgeistEvent* self);
void zeitgeist_event_debug_print (ZeitgeistEvent* self);
gboolean zeitgeist_event_matches_template (ZeitgeistEvent* self, ZeitgeistEvent* template_event);
ZeitgeistEvent* zeitgeist_event_new (void);
ZeitgeistEvent* zeitgeist_event_construct (GType object_type);
guint32 zeitgeist_event_get_id (ZeitgeistEvent* self);
void zeitgeist_event_set_id (ZeitgeistEvent* self, guint32 value);
gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self);
void zeitgeist_event_set_timestamp (ZeitgeistEvent* self, gint64 value);
const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self);
void zeitgeist_event_set_origin (ZeitgeistEvent* self, const gchar* value);
const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self);
void zeitgeist_event_set_actor (ZeitgeistEvent* self, const gchar* value);
const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self);
void zeitgeist_event_set_interpretation (ZeitgeistEvent* self, const gchar* value);
const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self);
void zeitgeist_event_set_manifestation (ZeitgeistEvent* self, const gchar* value);
GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self);
void zeitgeist_event_set_subjects (ZeitgeistEvent* self, GPtrArray* value);
GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self);
void zeitgeist_event_set_payload (ZeitgeistEvent* self, GByteArray* value);
GPtrArray* zeitgeist_events_from_variant (GVariant* vevents, GError** error);
GVariant* zeitgeist_events_to_variant (GPtrArray* events);
GVariant* zeitgeist_events_to_variant_with_limit (GPtrArray* events, gsize limit, GError** error);
ZeitgeistSubject* zeitgeist_subject_new_full (const gchar* uri, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* origin, const gchar* text, const gchar* storage, const gchar* current_uri);
ZeitgeistSubject* zeitgeist_subject_construct_full (GType object_type, const gchar* uri, const gchar* interpretation, const gchar* manifestation, const gchar* mimetype, const gchar* origin, const gchar* text, const gchar* storage, const gchar* current_uri);
ZeitgeistSubject* zeitgeist_subject_new_from_variant (GVariant* subject_variant, GError** error);
ZeitgeistSubject* zeitgeist_subject_construct_from_variant (GType object_type, GVariant* subject_variant, GError** error);
GVariant* zeitgeist_subject_to_variant (ZeitgeistSubject* self);
gboolean zeitgeist_subject_matches_template (ZeitgeistSubject* self, ZeitgeistSubject* template_subject);
ZeitgeistSubject* zeitgeist_subject_new (void);
ZeitgeistSubject* zeitgeist_subject_construct (GType object_type);
const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self);
void zeitgeist_subject_set_uri (ZeitgeistSubject* self, const gchar* value);
const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self);
void zeitgeist_subject_set_origin (ZeitgeistSubject* self, const gchar* value);
const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self);
void zeitgeist_subject_set_text (ZeitgeistSubject* self, const gchar* value);
const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self);
void zeitgeist_subject_set_storage (ZeitgeistSubject* self, const gchar* value);
const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self);
void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self, const gchar* value);
const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self);
void zeitgeist_subject_set_mimetype (ZeitgeistSubject* self, const gchar* value);
const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self);
void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self, const gchar* value);
const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self);
void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self, const gchar* value);
GType zeitgeist_db_reader_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_table_lookup_get_type (void) G_GNUC_CONST;
ZeitgeistDbReader* zeitgeist_db_reader_new (GError** error);
ZeitgeistDbReader* zeitgeist_db_reader_construct (GType object_type, GError** error);
ZeitgeistEvent* zeitgeist_db_reader_get_event_from_row (ZeitgeistDbReader* self, sqlite3_stmt* stmt, guint32 event_id, GError** error);
ZeitgeistSubject* zeitgeist_db_reader_get_subject_from_row (ZeitgeistDbReader* self, sqlite3_stmt* stmt, GError** error);
GPtrArray* zeitgeist_db_reader_get_events (ZeitgeistDbReader* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
GType zeitgeist_where_clause_get_type (void) G_GNUC_CONST;
guint32* zeitgeist_db_reader_find_event_ids_for_clause (ZeitgeistDbReader* self, ZeitgeistWhereClause* where, guint max_events, guint result_type, int* result_length1, GError** error);
guint32* zeitgeist_db_reader_find_event_ids (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, int* result_length1, GError** error);
GPtrArray* zeitgeist_db_reader_find_events (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, GError** error);
ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_query (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, GError** error);
gchar** zeitgeist_db_reader_find_related_uris (ZeitgeistDbReader* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, GPtrArray* result_event_templates, guint storage_state, guint max_results, guint result_type, const char* sender, int* result_length1, GError** error);
void zeitgeist_db_reader_close (ZeitgeistDbReader* self);
ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_templates (ZeitgeistDbReader* self, GPtrArray* templates, GError** error);
void zeitgeist_db_reader_assert_no_negation (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error);
void zeitgeist_db_reader_assert_no_noexpand (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error);
void zeitgeist_db_reader_assert_no_wildcard (ZeitgeistDbReader* self, const gchar* field, const gchar* val, GError** error);
ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_for_symbol (ZeitgeistDbReader* self, const gchar* table_name, const gchar* symbol, ZeitgeistSQLiteTableLookup* lookup_table, GError** error);
GType zeitgeist_sq_lite_database_get_type (void) G_GNUC_CONST;
ZeitgeistSQLiteDatabase* zeitgeist_db_reader_get_database (ZeitgeistDbReader* self);
GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_store_get_type (void) G_GNUC_CONST;
ZeitgeistEngine* zeitgeist_engine_new (GError** error);
ZeitgeistEngine* zeitgeist_engine_construct (GType object_type, GError** error);
gchar** zeitgeist_engine_get_extension_names (ZeitgeistEngine* self, int* result_length1);
guint32* zeitgeist_engine_insert_events (ZeitgeistEngine* self, GPtrArray* events, const char* sender, int* result_length1, GError** error);
ZeitgeistTimeRange* zeitgeist_engine_delete_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
GType zeitgeist_sq_lite_event_view_rows_get_type (void) G_GNUC_CONST;
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new (GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct (GType object_type, GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_new_read_only (GError** error);
ZeitgeistSQLiteDatabase* zeitgeist_sq_lite_database_construct_read_only (GType object_type, GError** error);
guint32 zeitgeist_sq_lite_database_get_last_id (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_set_deletion_callback (ZeitgeistSQLiteDatabase* self, ZeitgeistSQLiteDeletionCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
gchar* zeitgeist_sq_lite_database_get_sql_string_from_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1);
ZeitgeistTimeRange* zeitgeist_sq_lite_database_get_time_range_for_event_ids (ZeitgeistSQLiteDatabase* self, guint32* event_ids, int event_ids_length1, GError** error);
void zeitgeist_sq_lite_database_insert_or_ignore_into_table (ZeitgeistSQLiteDatabase* self, const gchar* table_name, GPtrArray* values, GError** error);
void zeitgeist_sq_lite_database_begin_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_end_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_abort_transaction (ZeitgeistSQLiteDatabase* self, GError** error);
void zeitgeist_sq_lite_database_close (ZeitgeistSQLiteDatabase* self);
void zeitgeist_sq_lite_database_assert_query_success (ZeitgeistSQLiteDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error);
void zeitgeist_sq_lite_database_assert_not_corrupt (ZeitgeistSQLiteDatabase* self, gint rc, GError** error);
void zeitgeist_sq_lite_database_update_callback (ZeitgeistSQLiteDatabase* self, int action, const gchar* dbname, const gchar* table, gint64 rowid);
GType zeitgeist_version_struct_get_type (void) G_GNUC_CONST;
ZeitgeistVersionStruct* zeitgeist_version_struct_dup (const ZeitgeistVersionStruct* self);
void zeitgeist_version_struct_free (ZeitgeistVersionStruct* self);
GType zeitgeist_remote_log_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_log_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_log_get_type (void) G_GNUC_CONST;
GVariant* zeitgeist_remote_log_delete_events (ZeitgeistRemoteLog* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
guint32* zeitgeist_remote_log_find_event_ids (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, int* result_length1, GError** error);
GVariant* zeitgeist_remote_log_find_events (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, GError** error);
gchar** zeitgeist_remote_log_find_related_uris (ZeitgeistRemoteLog* self, GVariant* time_range, GVariant* event_templates, GVariant* result_event_templates, guint storage_state, guint num_events, guint result_type, const char* sender, int* result_length1, GError** error);
GVariant* zeitgeist_remote_log_get_events (ZeitgeistRemoteLog* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
guint32* zeitgeist_remote_log_insert_events (ZeitgeistRemoteLog* self, GVariant* events, const char* sender, int* result_length1, GError** error);
void zeitgeist_remote_log_install_monitor (ZeitgeistRemoteLog* self, const char* monitor_path, GVariant* time_range, GVariant* event_templates, const char* owner, GError** error);
void zeitgeist_remote_log_remove_monitor (ZeitgeistRemoteLog* self, const char* monitor_path, const char* owner, GError** error);
void zeitgeist_remote_log_quit (ZeitgeistRemoteLog* self, GError** error);
gchar** zeitgeist_remote_log_get_extensions (ZeitgeistRemoteLog* self, int* result_length1);
void zeitgeist_remote_log_get_version (ZeitgeistRemoteLog* self, ZeitgeistVersionStruct* result);
GType zeitgeist_remote_monitor_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_monitor_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_monitor_get_type (void) G_GNUC_CONST;
void zeitgeist_remote_monitor_notify_insert (ZeitgeistRemoteMonitor* self, GVariant* time_range, GVariant* events, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_monitor_notify_insert_finish (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
void zeitgeist_remote_monitor_notify_delete (ZeitgeistRemoteMonitor* self, GVariant* time_range, guint32* event_ids, int event_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_monitor_notify_delete_finish (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
GType zeitgeist_remote_simple_indexer_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_simple_indexer_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_simple_indexer_get_type (void) G_GNUC_CONST;
void zeitgeist_remote_simple_indexer_search (ZeitgeistRemoteSimpleIndexer* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_simple_indexer_search_finish (ZeitgeistRemoteSimpleIndexer* self, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error);
void zeitgeist_remote_simple_indexer_search_with_relevancies (ZeitgeistRemoteSimpleIndexer* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_simple_indexer_search_with_relevancies_finish (ZeitgeistRemoteSimpleIndexer* self, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error);
GType zeitgeist_network_manager_dbus_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_network_manager_dbus_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_network_manager_dbus_get_type (void) G_GNUC_CONST;
guint32 zeitgeist_network_manager_dbus_state (ZeitgeistNetworkManagerDBus* self, GError** error);
GType zeitgeist_connman_manager_dbus_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_connman_manager_dbus_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_connman_manager_dbus_get_type (void) G_GNUC_CONST;
gchar* zeitgeist_connman_manager_dbus_get_state (ZeitgeistConnmanManagerDBus* self, GError** error);
#define ZEITGEIST_UTILS_DATA_FOLDER "zeitgeist"
#define ZEITGEIST_UTILS_DATABASE_BASENAME "activity.sqlite"
#define ZEITGEIST_UTILS_USER_EXTENSION_PATH ""
#define ZEITGEIST_UTILS_DBUS_INTERFACE ""
#define ZEITGEIST_UTILS_SIG_EVENT "asaasay"
#define ZEITGEIST_UTILS_MAX_DBUS_RESULT_SIZE ((gsize) ((4 * 1024) * 1024))
#define ZEITGEIST_UTILS_CACHE_SIZE ((guint) 0)
const gchar* zeitgeist_utils_get_data_path (void);
gchar* zeitgeist_utils_get_default_data_path (void);
const gchar* zeitgeist_utils_get_database_file_path (void);
const gchar* zeitgeist_utils_get_database_file_backup_path (void);
gchar* zeitgeist_utils_get_database_file_retire_name (void);
const gchar* zeitgeist_utils_get_local_extensions_path (void);
gboolean zeitgeist_utils_using_in_memory_database (void);
void zeitgeist_utils_backup_database (GError** error);
void zeitgeist_utils_retire_database (GError** error);
gboolean zeitgeist_utils_parse_negation (gchar** val);
gboolean zeitgeist_utils_parse_noexpand (gchar** val);
gboolean zeitgeist_utils_parse_wildcard (gchar** val);
gboolean zeitgeist_utils_is_empty_string (const gchar* s);
ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_new (ZeitgeistSQLiteDatabase* database, const gchar* table_name, GError** error);
ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_construct (GType object_type, ZeitgeistSQLiteDatabase* database, const gchar* table_name, GError** error);
gint zeitgeist_sq_lite_table_lookup_id_try_string (ZeitgeistSQLiteTableLookup* self, const gchar* name);
gint zeitgeist_sq_lite_table_lookup_id_for_string (ZeitgeistSQLiteTableLookup* self, const gchar* name, GError** error);
const gchar* zeitgeist_sq_lite_table_lookup_get_value (ZeitgeistSQLiteTableLookup* self, gint id, GError** error);
void zeitgeist_sq_lite_table_lookup_remove (ZeitgeistSQLiteTableLookup* self, gint id);
GType zeitgeist_sq_lite_database_schema_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA "core"
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION 6
void zeitgeist_sq_lite_database_schema_ensure_schema (sqlite3* database, GError** error);
gint zeitgeist_sq_lite_database_schema_get_schema_version (sqlite3* database, GError** error);
gint64 zeitgeist_sq_lite_database_schema_get_creation_date (sqlite3* database);
void zeitgeist_sq_lite_database_schema_set_corruption_flag (sqlite3* database, GError** error);
void zeitgeist_sq_lite_database_schema_create_schema (sqlite3* database, GError** error);
ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_new (void);
ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_construct (GType object_type);
GType zeitgeist_where_clause_type_get_type (void) G_GNUC_CONST;
ZeitgeistWhereClause* zeitgeist_where_clause_new (ZeitgeistWhereClauseType type, gboolean negate);
ZeitgeistWhereClause* zeitgeist_where_clause_construct (GType object_type, ZeitgeistWhereClauseType type, gboolean negate);
void zeitgeist_where_clause_add (ZeitgeistWhereClause* self, const gchar* condition, const gchar* argument);
void zeitgeist_where_clause_add_with_array (ZeitgeistWhereClause* self, const gchar* condition, GPtrArray* args);
void zeitgeist_where_clause_add_match_condition (ZeitgeistWhereClause* self, const gchar* column, gint val, gboolean negation);
void zeitgeist_where_clause_add_text_condition_subquery (ZeitgeistWhereClause* self, const gchar* column, const gchar* val, gboolean negation);
void zeitgeist_where_clause_add_text_condition (ZeitgeistWhereClause* self, const gchar* column, const gchar* val, gboolean negation);
void zeitgeist_where_clause_add_wildcard_condition (ZeitgeistWhereClause* self, const gchar* column, const gchar* needle, gboolean negation);
void zeitgeist_where_clause_extend (ZeitgeistWhereClause* self, ZeitgeistWhereClause* clause);
gboolean zeitgeist_where_clause_is_empty (ZeitgeistWhereClause* self);
gboolean zeitgeist_where_clause_may_have_results (ZeitgeistWhereClause* self);
gchar* zeitgeist_where_clause_get_sql_conditions (ZeitgeistWhereClause* self);
GPtrArray* zeitgeist_where_clause_get_bind_arguments (ZeitgeistWhereClause* self);
gchar* zeitgeist_where_clause_get_right_boundary (const gchar* text);
const gchar* zeitgeist_symbol_get_display_name (const gchar* symbol_uri);
const gchar* zeitgeist_symbol_get_description (const gchar* symbol_uri);
GList* zeitgeist_symbol_get_all_parents (const gchar* symbol_uri);
GList* zeitgeist_symbol_get_all_children (const gchar* symbol_uri);
GList* zeitgeist_symbol_get_children (const gchar* symbol_uri);
GList* zeitgeist_symbol_get_parents (const gchar* symbol_uri);
gboolean zeitgeist_symbol_is_a (const gchar* symbol_uri, const gchar* parent_uri);
#define ZEITGEIST_NCAL_ALARM "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Alarm"
#define ZEITGEIST_NCAL_ATTACHMENT "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Attachment"
#define ZEITGEIST_NCAL_CALENDAR "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Calendar"
#define ZEITGEIST_NCAL_CALENDAR_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#CalendarData" \
"Object"
#define ZEITGEIST_NCAL_EVENT "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Event"
#define ZEITGEIST_NCAL_FREEBUSY "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Freebusy"
#define ZEITGEIST_NCAL_JOURNAL "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Journal"
#define ZEITGEIST_NCAL_TIMEZONE "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Timezone"
#define ZEITGEIST_NCAL_TODO "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Todo"
#define ZEITGEIST_NCO_CONTACT "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#Contact"
#define ZEITGEIST_NCO_CONTACT_GROUP "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactGroup"
#define ZEITGEIST_NCO_CONTACT_LIST "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactList"
#define ZEITGEIST_NCO_CONTACT_LIST_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactListDa" \
"taObject"
#define ZEITGEIST_NCO_ORGANIZATION_CONTACT "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#OrganizationC" \
"ontact"
#define ZEITGEIST_NCO_PERSON_CONTACT "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#PersonContact"
#define ZEITGEIST_NFO_APPLICATION "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Application"
#define ZEITGEIST_NFO_ARCHIVE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Archive"
#define ZEITGEIST_NFO_ARCHIVE_ITEM "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#ArchiveItem"
#define ZEITGEIST_NFO_ATTACHMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Attachment"
#define ZEITGEIST_NFO_AUDIO "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Audio"
#define ZEITGEIST_NFO_BOOKMARK "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Bookmark"
#define ZEITGEIST_NFO_BOOKMARK_FOLDER "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#BookmarkFolde" \
"r"
#define ZEITGEIST_NFO_CURSOR "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Cursor"
#define ZEITGEIST_NFO_DATA_CONTAINER "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DataContainer"
#define ZEITGEIST_NFO_DELETED_RESOURCE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DeletedResour" \
"ce"
#define ZEITGEIST_NFO_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Document"
#define ZEITGEIST_NFO_EMBEDDED_FILE_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#EmbeddedFileD" \
"ataObject"
#define ZEITGEIST_NFO_EXECUTABLE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Executable"
#define ZEITGEIST_NFO_FILESYSTEM "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Filesystem"
#define ZEITGEIST_NFO_FILESYSTEM_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FilesystemIma" \
"ge"
#define ZEITGEIST_NFO_FILE_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FileDataObjec" \
"t"
#define ZEITGEIST_NFO_FOLDER "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Folder"
#define ZEITGEIST_NFO_FONT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Font"
#define ZEITGEIST_NFO_HARD_DISK_PARTITION "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HardDiskParti" \
"tion"
#define ZEITGEIST_NFO_HTML_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HtmlDocument"
#define ZEITGEIST_NFO_ICON "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Icon"
#define ZEITGEIST_NFO_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Image"
#define ZEITGEIST_NFO_MEDIA "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Media"
#define ZEITGEIST_NFO_MEDIA_LIST "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaList"
#define ZEITGEIST_NFO_MEDIA_STREAM "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaStream"
#define ZEITGEIST_NFO_MIND_MAP "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MindMap"
#define ZEITGEIST_NFO_OPERATING_SYSTEM "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#OperatingSyst" \
"em"
#define ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PaginatedText" \
"Document"
#define ZEITGEIST_NFO_PLAIN_TEXT_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PlainTextDocu" \
"ment"
#define ZEITGEIST_NFO_PRESENTATION "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Presentation"
#define ZEITGEIST_NFO_RASTER_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RasterImage"
#define ZEITGEIST_NFO_REMOTE_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemoteDataObj" \
"ect"
#define ZEITGEIST_NFO_REMOTE_PORT_ADDRESS "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemotePortAdd" \
"ress"
#define ZEITGEIST_NFO_SOFTWARE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Software"
#define ZEITGEIST_NFO_SOFTWARE_ITEM "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareItem"
#define ZEITGEIST_NFO_SOFTWARE_SERVICE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareServi" \
"ce"
#define ZEITGEIST_NFO_SOURCE_CODE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SourceCode"
#define ZEITGEIST_NFO_SPREADSHEET "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Spreadsheet"
#define ZEITGEIST_NFO_TEXT_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#TextDocument"
#define ZEITGEIST_NFO_TRASH "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Trash"
#define ZEITGEIST_NFO_VECTOR_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#VectorImage"
#define ZEITGEIST_NFO_VIDEO "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Video"
#define ZEITGEIST_NFO_VISUAL "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Visual"
#define ZEITGEIST_NFO_WEBSITE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Website"
#define ZEITGEIST_NFO_WEB_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#WebDataObject"
#define ZEITGEIST_NIE_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#DataObject"
#define ZEITGEIST_NIE_INFORMATION_ELEMENT "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#InformationEl" \
"ement"
#define ZEITGEIST_NMM_MOVIE "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#Movie"
#define ZEITGEIST_NMM_MUSIC_ALBUM "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicAlbum"
#define ZEITGEIST_NMM_MUSIC_PIECE "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicPiece"
#define ZEITGEIST_NMM_TVSERIES "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVSeries"
#define ZEITGEIST_NMM_TVSHOW "http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVShow"
#define ZEITGEIST_NMO_EMAIL "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Email"
#define ZEITGEIST_NMO_IMMESSAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#IMMessage"
#define ZEITGEIST_NMO_MAILBOX "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Mailbox"
#define ZEITGEIST_NMO_MAILBOX_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MailboxDataOb" \
"ject"
#define ZEITGEIST_NMO_MESSAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Message"
#define ZEITGEIST_NMO_MIME_ENTITY "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MimeEntity"
#define ZEITGEIST_ZG_ACCEPT_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#AcceptEvent"
#define ZEITGEIST_ZG_ACCESS_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#AccessEvent"
#define ZEITGEIST_ZG_CREATE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#CreateEvent"
#define ZEITGEIST_ZG_DELETE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#DeleteEvent"
#define ZEITGEIST_ZG_DENY_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#DenyEvent"
#define ZEITGEIST_ZG_EVENT_INTERPRETATION "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#EventInterpr" \
"etation"
#define ZEITGEIST_ZG_EVENT_MANIFESTATION "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#EventManifes" \
"tation"
#define ZEITGEIST_ZG_EXPIRE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ExpireEvent"
#define ZEITGEIST_ZG_HEURISTIC_ACTIVITY "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#HeuristicAct" \
"ivity"
#define ZEITGEIST_ZG_LEAVE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#LeaveEvent"
#define ZEITGEIST_ZG_MODIFY_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ModifyEvent"
#define ZEITGEIST_ZG_MOVE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#MoveEvent"
#define ZEITGEIST_ZG_RECEIVE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ReceiveEvent"
#define ZEITGEIST_ZG_SCHEDULED_ACTIVITY "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ScheduledAct" \
"ivity"
#define ZEITGEIST_ZG_SEND_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#SendEvent"
#define ZEITGEIST_ZG_SYSTEM_NOTIFICATION "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#SystemNotifi" \
"cation"
#define ZEITGEIST_ZG_USER_ACTIVITY "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#UserActivity"
#define ZEITGEIST_ZG_WORLD_ACTIVITY "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#WorldActivit" \
"y"
void zeitgeist_register_mimetype (const gchar* mimetype, const gchar* interpretation_uri);
void zeitgeist_register_mimetype_regex (const gchar* mimetype_regex, const gchar* interpretation_uri, GError** error);
const gchar* zeitgeist_interpretation_for_mimetype (const gchar* mimetype);
void zeitgeist_register_uri_scheme (const gchar* uri_scheme, const gchar* manifestation_type);
const gchar* zeitgeist_manifestation_for_uri (const gchar* uri);
GType zeitgeist_extension_collection_get_type (void) G_GNUC_CONST;
ZeitgeistExtensionCollection* zeitgeist_extension_collection_new (ZeitgeistEngine* engine);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_construct (GType object_type, ZeitgeistEngine* engine);
gchar** zeitgeist_extension_collection_get_extension_names (ZeitgeistExtensionCollection* self, int* result_length1);
void zeitgeist_extension_collection_call_pre_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
void zeitgeist_extension_collection_call_post_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
guint32* zeitgeist_extension_collection_call_pre_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender, int* result_length1);
void zeitgeist_extension_collection_call_post_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender);
ZeitgeistEngine* zeitgeist_extension_collection_get_engine (ZeitgeistExtensionCollection* self);
ZeitgeistExtensionStore* zeitgeist_extension_store_new (ZeitgeistEngine* engine);
ZeitgeistExtensionStore* zeitgeist_extension_store_construct (GType object_type, ZeitgeistEngine* engine);
ZeitgeistEngine* zeitgeist_extension_store_get_engine (ZeitgeistExtensionStore* self);


G_END_DECLS

#endif
