/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

class Editable
implements Cloneable {
    private boolean _isNew = false;
    private boolean _modified = false;
    private HashMap _removedElements = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    Editable(boolean brandNew) {
        this._isNew = brandNew;
    }

    boolean isNew() {
        return this._isNew;
    }

    boolean isModified() {
        return this._modified;
    }

    void markModified() {
        this._modified = true;
    }

    void commit() {
        this._isNew = false;
        this._modified = false;
        this._removedElements.clear();
    }

    void markNew() {
        this._isNew = true;
    }

    void removeElement(String id, Editable editable, Class forClass) {
        if (!editable.isNew()) {
            TreeSet<String> set = (TreeSet<String>)this._removedElements.get(forClass);
            if (set == null) {
                set = new TreeSet<String>();
                this._removedElements.put(forClass, set);
            }
            set.add(id);
        }
    }

    String[] removedElements(Class forClass) {
        TreeSet set = (TreeSet)this._removedElements.get(forClass);
        if (set == null) {
            return new String[0];
        }
        return set.toArray(new String[0]);
    }

    Editable save() {
        try {
            Editable result = (Editable)this.clone();
            HashMap removedElements = new HashMap();
            Iterator p = result._removedElements.entrySet().iterator();
            while (p.hasNext()) {
                Map.Entry entry = p.next();
                Object val = ((TreeSet)entry.getValue()).clone();
                removedElements.put(entry.getKey(), val);
            }
            result._removedElements = removedElements;
            return result;
        }
        catch (CloneNotSupportedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    void restore(Editable clone) {
        this._isNew = clone._isNew;
        this._modified = clone._modified;
        this._removedElements = clone._removedElements;
    }

    static {
        $assertionsDisabled = !Editable.class.desiredAssertionStatus();
    }
}

