/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.DNSException;
import Ice.SocketException;
import java.net.InetAddress;
import java.net.UnknownHostException;

class InetSocketAddress {
    private InetAddress _addr;
    private int _port;

    InetSocketAddress(String string, int n) {
        try {
            this._addr = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            DNSException dNSException = new DNSException();
            dNSException.host = string;
            dNSException.initCause(unknownHostException);
            throw dNSException;
        }
        catch (RuntimeException runtimeException) {
            SocketException socketException = new SocketException();
            socketException.initCause(runtimeException);
            throw socketException;
        }
        this._port = n;
    }

    InetSocketAddress(InetAddress inetAddress, int n) {
        this._addr = inetAddress;
        this._port = n;
    }

    InetAddress getAddress() {
        return this._addr;
    }

    String getHostName() {
        return this._addr.getHostName();
    }

    int getPort() {
        return this._port;
    }

    public int hashCode() {
        return 5 * this._addr.hashCode() + this._port;
    }

    public String toString() {
        return this._addr.toString() + ":" + this._port;
    }

    public boolean equals(Object object) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
        return this._addr.equals(inetSocketAddress._addr) && this._port == inetSocketAddress._port;
    }
}

