/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Identity;
import Ice.LocalException;
import Ice.Logger;
import Ice.MarshalException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RequestFailedException;
import IceInternal.BasicStream;
import IceInternal.IndirectReference;
import IceInternal.Instance;
import IceInternal.Reference;
import IceInternal.TraceLevels;
import IceUtil.Debug;
import IceUtil.StringUtil;

public final class ProxyFactory {
    private Instance _instance;
    private int[] _retryIntervals;

    public ObjectPrx stringToProxy(String string) {
        Reference reference = this._instance.referenceFactory().create(string);
        return this.referenceToProxy(reference);
    }

    public String proxyToString(ObjectPrx objectPrx) {
        if (objectPrx != null) {
            ObjectPrxHelperBase objectPrxHelperBase = (ObjectPrxHelperBase)objectPrx;
            return objectPrxHelperBase.__reference().toString();
        }
        return "";
    }

    public ObjectPrx streamToProxy(BasicStream basicStream) {
        Identity identity = new Identity();
        identity.__read(basicStream);
        Reference reference = this._instance.referenceFactory().create(identity, basicStream);
        return this.referenceToProxy(reference);
    }

    public void proxyToStream(ObjectPrx objectPrx, BasicStream basicStream) {
        if (objectPrx != null) {
            ObjectPrxHelperBase objectPrxHelperBase = (ObjectPrxHelperBase)objectPrx;
            Reference reference = objectPrxHelperBase.__reference();
            reference.getIdentity().__write(basicStream);
            reference.streamWrite(basicStream);
        } else {
            Identity identity = new Identity();
            identity.name = "";
            identity.category = "";
            identity.__write(basicStream);
        }
    }

    public ObjectPrx referenceToProxy(Reference reference) {
        if (reference != null) {
            ObjectPrxHelperBase objectPrxHelperBase = new ObjectPrxHelperBase();
            objectPrxHelperBase.setup(reference);
            return objectPrxHelperBase;
        }
        return null;
    }

    public int checkRetryAfterException(LocalException localException, Reference reference, int n) {
        Object object;
        if (localException instanceof ObjectNotExistException) {
            try {
                object = (IndirectReference)reference;
                if (((IndirectReference)object).getLocatorInfo() == null) {
                    throw localException;
                }
                ((IndirectReference)object).getLocatorInfo().clearObjectCache((IndirectReference)object);
            }
            catch (ClassCastException classCastException) {
                throw localException;
            }
        } else if (localException instanceof RequestFailedException) {
            throw localException;
        }
        if (localException instanceof MarshalException) {
            throw localException;
        }
        Debug.Assert(++n > 0);
        object = this._instance.traceLevels();
        Logger logger = this._instance.logger();
        if (n > this._retryIntervals.length) {
            if (((TraceLevels)object).retry >= 1) {
                String string = "cannot retry operation call because retry limit has been exceeded\n" + localException.toString();
                logger.trace(((TraceLevels)object).retryCat, string);
            }
            throw localException;
        }
        int n2 = this._retryIntervals[n - 1];
        if (((TraceLevels)object).retry >= 1) {
            String string = "re-trying operation call";
            if (n2 > 0) {
                string = string + " in " + n2 + "ms";
            }
            string = string + " because of exception\n" + localException;
            logger.trace(((TraceLevels)object).retryCat, string);
        }
        if (n2 > 0) {
            try {
                Thread.currentThread();
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return n;
    }

    ProxyFactory(Instance instance) {
        this._instance = instance;
        String string = this._instance.properties().getPropertyWithDefault("Ice.RetryIntervals", "0");
        String[] stringArray = StringUtil.split(string.trim(), " \t\n\r");
        if (stringArray.length > 0) {
            this._retryIntervals = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                try {
                    n = Integer.parseInt(stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (i == 0 && n == -1) {
                    this._retryIntervals = new int[0];
                    break;
                }
                this._retryIntervals[i] = n > 0 ? n : 0;
            }
        } else {
            this._retryIntervals = new int[1];
            this._retryIntervals[0] = 0;
        }
    }
}

