/*
 * Decompiled with CFR 0.152.
 */
import Ice.Communicator;
import Ice.Properties;
import Ice.Util;
import Test.StreamListAdapter;
import java.io.PrintStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

class ConfigurationForm
extends Form
implements CommandListener,
Runnable {
    private MIDlet _parent;
    private Communicator _communicator;
    private Command _okCommand;
    private Command _exitCommand;
    private PrintStream _out;
    private Properties _properties;

    public ConfigurationForm(MIDlet mIDlet, Properties properties) {
        super("Configure");
        this._parent = mIDlet;
        this._properties = properties;
        this._okCommand = new Command("OK", 4, 0);
        this._exitCommand = new Command("Exit", 7, 1);
        this.addCommand(this._exitCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7) {
            Thread thread = new Thread(new Shutdown((TestApplication)this._parent, this._communicator));
            thread.start();
        } else {
            ((TestApplication)this._parent).updateProperties(this._properties);
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void setHost(String string) {
        this._properties.setProperty("Ice.Default.Host", string);
    }

    public void enableOk() {
        this.addCommand(this._okCommand);
    }

    public void run() {
        List list = new List("Standard Output", 1);
        this._out = new PrintStream(new StreamListAdapter(list));
        Display.getDisplay((MIDlet)this._parent).setCurrent((Displayable)list);
        list.addCommand(this._exitCommand);
        list.setCommandListener((CommandListener)this);
        this._communicator = Util.initializeWithProperties(new String[0], this._properties);
        ((TestApplication)this._parent).runTest(this._communicator, this._out);
    }

    public class Shutdown
    implements Runnable {
        Communicator _communicator;
        TestApplication _parent;

        Shutdown(TestApplication testApplication, Communicator communicator) {
            this._parent = testApplication;
            this._communicator = communicator;
        }

        public void run() {
            try {
                if (this._communicator != null) {
                    this._communicator.destroy();
                }
                this._parent.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

