#include <vector>

#include <time.h>

using namespace std;

#include "gtkalbumlist.h"
#include "gtktracklist.h"
#include "gtkmusicbrowser.h"
#include "facontext.h"
#include "preferences.h"
#include "error.h"
#include "cataloginfo.h"

GTKLibrary::GTKAlbumList::GTKAlbumList(GTKLibrary *library)
	: GTKLibraryList(library)
{
	set_list_model_columns(&m_AlbumsCols);
}

void GTKLibrary::GTKAlbumList::set_list_columns()
{
	//Add Columns To List
	m_listMusic.append_column("", m_AlbumsCols.icon);
	m_listMusic.append_column("Album", m_AlbumsCols.album);

	//Set Style For Each Column
	m_listMusic.get_column(1)->set_resizable(true); //Album
}

void GTKLibrary::GTKAlbumList::set_rows_data(std::vector<Gtk::TreeModel::Path> RowPaths)
{
	std::vector<Gtk::TreeModel::Path>::iterator RowPath;
	
	//Set Data For Newly Visible Rows
	for(RowPath = RowPaths.begin(); RowPath != RowPaths.end(); RowPath++) {
		Gtk::TreeModel::Row visible_row = *(m_listmodelMusic->get_iter(*RowPath));
		if((visible_row[m_AlbumsCols.last_refresh] < m_library->m_last_change) || (visible_row[m_AlbumsCols.last_refresh] < last_parent_change)) {
			CatalogInfo *new_info = m_parent->child_item((*RowPath).back());
			visible_row[m_AlbumsCols.icon] = new_info->item_icon();
			visible_row[m_AlbumsCols.album] = new_info->item_text();
			visible_row[m_AlbumsCols.last_refresh] = time(NULL);
			
			//Delete Temp Info
			delete new_info;
		}
	}
}

void GTKLibrary::GTKAlbumList::cursor_changed(Gtk::TreeModel::Path RowPath)
{
	//Display Album Tracks In Track List
	if(m_library->m_TrackList) {
		m_library->m_TrackList->SetParent(m_parent->child_item(RowPath.back()));
	}
}

void GTKLibrary::GTKAlbumList::init_row(Gtk::TreeModel::Row& new_row)
{
	new_row[m_AlbumsCols.last_refresh] = 0;
}
/* arch-tag: ebf2545c-4260-4479-af5f-34c413889ecd */
