/*____________________________________________________________________________

   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

   Copyright (C) 1999 EMusic

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: GTKFont.h,v 1.5 2003/09/16 17:36:23 kgk Exp $
____________________________________________________________________________*/ 

#ifndef INCLUDED_GTKFONT_H__
#define INCLUDED_GTKFONT_H__

#include "config.h"
#include "facontext.h"

#include <string>
#include <gdk/gdk.h>
#include "GTKBitmap.h"

#include "Font.h"

#ifdef HAVE_FREETYPE
#include "ttfont.h"
#endif

enum FontTypeEnum 
{
    kFontTypeGdk,
    kFontTypeGdkFontSet,
    kFontTypeTTF,
    kFontTypeBitmap,
    kFontTypeUnknown
}; 

class GTKFont : public Font
{
    public:

	GTKFont(FAContext *context, std::string &oName, std::string &oFace, 
		std::string &oFile, std::string &oDefault);
	GTKFont(GTKFont &f);

     virtual ~GTKFont(void);

      Error    Load(int iFontHeight, bool bBold, bool bItalic);
      int      GetLength(std::string &oText);
      int      GetHeight(std::string &oText);
      void     Render(Rect &oClipRect, std::string &oText, int iOffset, 
                      const Color &oColor, GTKBitmap *bitmap, bool bUnderline);
      
    protected:
      FAContext *m_context;

    private:

      PangoFontDescription* pfont;
      PangoContext* pango_context;
      PangoLayout* layout;
     std::string   BuildFontString(bool bBold, bool bItalic, int iFontHeight);
      Error    AddFont(std::string &oFontFile);

      bool bold;
      bool italic;
      bool underline;
      int  size;
      bool first;
};

#endif

/* arch-tag: 3aded8f7-211c-4797-89e7-5ac215cd9101
   (do not change this comment) */
