#import "MockCoder.h"

#import "ExpectationCounter.h"
#import "ExpectationGroup.h"
#import "ExpectationList.h"

@implementation MockCoder

- (id)init {
    self = [super init];
    expectations = [[ExpectationGroup alloc] initWithName:@"MockCoder"];
    (void)[expectations addedListWithName:@"encodedObjects"];
    return self;
}

- (void)dealloc {
    [expectations release];
    [decodedObjects release];
    [super dealloc];
}

- (void)addExpectedEncodedObject:(id)object {
    [[expectations listNamed:@"encodedObjects"] addExpectedObject:object];
}

- (void)addDecodedObject:(id)object {
    NSMutableArray *objects = [NSMutableArray array];

    if (decodedObjects != nil) {
        [objects addObjectsFromArray:[decodedObjects allObjects]];
        [decodedObjects release];
    }
    [objects addObject:object];
    decodedObjects = [[objects objectEnumerator] retain];
    [[expectations addedCounterWithName:@"-decodeObject calls"] setExpectedCount:[objects count]];
}

- (void)verify {
    [expectations verify];
}

@end

@implementation MockCoder (Overrides)

- (void)encodeObject:(id)object {
    [[expectations listNamed:@"encodedObjects"] addActualObject:object];
}

- (id)decodeObject {
    [[expectations counterNamed:@"-decodeObject calls"] increment];
    return [decodedObjects nextObject];
}

@end

