/*
 * strsep.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#include <stdio.h>
#include <string.h>
#ifndef HAVE_STRSEP
/*
 * SunOs lacks strsep
 */

char *strsep(char **stringp,__const char *delim)
{
  char *newpos, *oldpos;

  oldpos = *stringp;

  if ( oldpos == NULL )
    return NULL;

  newpos = strpbrk( oldpos, delim);

  if ( newpos ){
    *newpos='\0';
    newpos++;
  }

  *stringp = newpos;
  return oldpos;
}



#endif
