<?xml version='1.0' encoding='UTF-8'?>
<!DOCTYPE config PUBLIC "-//ZoneCheck//DTD Config V1.0//EN" "msgcat.dtd">
<msgcat lang="fr">
<!-- $Id: rootserver.fr,v 1.18 2003/11/12 14:27:58 sdalu Exp $ -->

<!--
# 
# CONTACT     : zonecheck@nic.fr
# AUTHOR      : Stephane D'Alu <sdalu@nic.fr>
#
# CREATED     : 2002/08/02 13:58:17
# REVISION    : $Revision: 1.18 $ 
# DATE        : $Date: 2003/11/12 14:27:58 $
#
# CONTRIBUTORS: (see also CREDITS file)
#
#
# LICENSE     : GPL v2 (or MIT/X11-like after agreement)
# COPYRIGHT   : AFNIC (c) 2003
#
# This file is part of ZoneCheck.
#
# ZoneCheck is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# ZoneCheck is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ZoneCheck; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
-->

  <!-- Shortcuts -->
  <shortcut>
    <explanation name="rootserver_vs_icann">
      <src type="ref" from="rfc" fid="rfc2870#p1">
       <title>IETF RFC2870 (p.1)</title>
       <para>The Internet Corporation for Assigned Names and Numbers
         (ICANN) has become responsible for the operation of the 
         root servers. The ICANN has appointed a Root Server System
         Advisory Committee (RSSAC) to give technical and operational
         advice to the ICANN board. The ICANN and the RSSAC look to the
         IETF to provide engineering standards.</para>
      </src>
    </explanation>
  </shortcut>


  <!-- Checks -->
  <check name="root_servers">
    <name>existence de la liste des root servers</name>
    <success>Les "Root Servers" sont disponibles</success>
    <failure>Les "Root Servers" ne sont pas disponibles</failure>
    <explanation/>
    <details/>
  </check>


  <check name="root_servers_ns_vs_icann">
    <name>liste des Root Servers identique à celle de l'ICANN</name>
    <success>La liste des "Root Servers" est cohérente avec celle de l'ICANN</success>
    <failure>La liste des "Root Servers" est incohérente avec celle de l'ICANN</failure>
    <explanation sameas="shortcut:rootserver_vs_icann"/>
    <details><para>La list des 'root-servers' (<zcvar name="rs_list"/>) 
      n'est pas identique a celle de l'ICANN
      (<zcvar name="ref_list"/>).</para></details>
  </check>


  <check name="root_servers_ip_vs_icann">
    <name>adresses IP des "Root Servers" identiques à celles de l'ICANN</name>
    <success>Les adresses des "Root Servers" sont cohérentes avec celles de l'ICANN</success>
    <failure>Les adresses des "Root Servers" sont incohérentes avec celles de l'ICANN</failure>
    <explanation sameas="shortcut:rootserver_vs_icann"/>
    <details><para>Les addresses (<zcvar name="rs_addr"/>) du 
      "Root Server" <zcvar name="rs"/> ne sont pas les même que celles
      de l'ICANN (<zcvar name="ref_addr"/>).</para></details>
  </check>


  <!-- Local Variables: -->
  <!-- mode: xml        -->
  <!-- End:             -->
</msgcat>
