#!/usr/bin/python
import sys
import os.path
from StructuredText import DocBookChapterWithFigures, DocumentWithImages, Basic

if not sys.argv[1:]:
    print """
Usage: docbook.py <file.stx>...

Converts one or more structured text (.stx) files to docbook xml
(.xml) files.
"""

for filename in sys.argv[1:]:
    xmlfile="%s.xml" % os.path.splitext(filename)[0]
    print "%s -> %s" % (filename, xmlfile)
    f=open(xmlfile, "wb")
    f.write('<!DOCTYPE chapter PUBLIC "-//OASIS//DTD DocBook V4.1//EN">\n')
    f.write(DocBookChapterWithFigures(DocumentWithImages(Basic(open(filename).read()))))
    f.close()

            

