from Products.Archetypes.public import BaseSchema, Schema
from Products.Archetypes.public import StringField, TextField, \
     LinesField, ReferenceField
from Products.Archetypes.public import SelectionWidget, ReferenceWidget, \
     TextAreaWidget
from Products.Archetypes.public import RichWidget, IdWidget, StringWidget
from Products.Archetypes.public import DisplayList
from Products.Archetypes.Widget import TypesWidget

from Products.CMFBibliographyAT.marshall import BibtexMarshaller
from Products.ATExtensions.ateapi import FormattableNamesField, \
     FormattableNamesWidget


HeaderSchema = BaseSchema.copy()
HeaderSchema['id'].widget.macro_edit = "widgets/string"
# XXX ugly hack as long as IdWidget subclasses TypesWidget
HeaderSchema['id'].widget.size = 40
HeaderSchema['id'].widget.maxlength = 255

tmp_title = HeaderSchema['title']
del HeaderSchema['title']

AuthorSchema = Schema((
    ReferenceField('member_publication_authors',
        relationship='authorOf',
        vocabulary='getMembers',
        mutator='setMemberPublicationAuthors',
        languageIndependent=1,
        multiValued=1,
        widget=ReferenceWidget(label='Authors',
            description='',
            visible={'view':'invisible', 'edit':'invisible'},
            condition='python:object.showMemberAuthors()',
            i18n_domain='plone'
            ),
        ),
    FormattableNamesField('authors', # was 'publication_authors',
        searchable=1,
        required=0,
        subfields=('reference','firstnames','lastname', 'homepage'),
        subfield_sizes={'firstnames':20, 'lastname':20, 'homepage':15},
        subfield_vocabularies={'reference':'getSiteMembers'},
        subfield_conditions={'reference':'python:object.showMemberAuthors()'},
        widget=FormattableNamesWidget(label="Authors",
            label_msgid="label_name",
            description="Authors names.",
            description_msgid="help_name",
            i18n_domain="plone",) 
                          ),
    ))

CoreSchema = Schema((
    tmp_title,
    StringField('publication_year',
        searchable=1,
        required=1,
        languageIndependent=1,
        widget=StringWidget(label="Publication Year",
            label_msgid="label_publication_year",
            description_msgid="help_publication_year",
            description="Year of publication.",
            i18n_domain="plone",
            ),
        ),
    StringField('publication_url',
        required=0,
        searchable=0,
##        validators=('isURL',),    # re-enable if it doesn't fail
                                    # for empty values any more
        widget=StringWidget(label_msgid="label_bibref_url",
            label="URL",
            description_msgid="help_bibref_url",
            description="The URL to get to the referenced resource.",
            i18n_domain="plone",
            ),
        ),
    TextField('abstract',
        searchable=1,
        required=0,
        allowable_content_types=('text/plain',
                                 'text/structured',
                                 'text/html',),
        accessor="getAbstract",
        edit_accessor="getAbstract",
        mutator="setAbstract",
        widget=TextAreaWidget(label="Abstract",
            label_msgid="label_bibref_abstract",
            description_msgid="help_bibref_abstract",
            description="An abstract of the referenced publication.",
            i18n_domain="plone",
            ),
        ),
    ))

TrailingSchema = Schema((
    StringField('publication_month',
        searchable=1,
        required=0,
        languageIndependent=1,
        widget=StringWidget(label="Publication Month",
            label_msgid="label_publication_month",
            description_msgid="help_publication_month",
            description="Month of publication.",
            i18n_domain="plone",
            ),
        ),
    TextField('note',
        searchable=1,
        required=0,
        widget=TextAreaWidget(label="Note",
            label_msgid="label_bibref_note",
            description_msgid="help_bibref_note",
            description="Any additionnal note.",
            i18n_domain="plone",
            ),
        ),
    ), marshall = BibtexMarshaller())

