##########################################################################
#                                                                        #
#           copyright (c) 2005 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""
mixin class to support 'bibutils' based transformations

bibutils are written and maintained by Chris Putnam at Scripps
http://www.scripps.edu/~cdputnam/software/bibutils/bibutils.html
"""

import os
from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
from Products.CMFCore  import CMFCorePermissions

commands = {'bib2xml':'bib2xml',
            'copac2xml':'copac2xml',
            'end2xml':'end2xml',
            'isi2xml':'isi2xml',
            'med2xml':'med2xml',
            'ris2xml':'ris2xml',
            'xml2bib':'xml2bib',
            'xml2end':'xml2end',
            'xml2ris':'xml2ris',
            'end2bib':'end2xml | xml2bib ',
            'ris2bib':'ris2xml | xml2bib ',
            'bib2end':'bib2xml | xml2end ',
            'bib2ris':'bib2xml | xml2ris ',
            ## to be continued ...
            }

def _getKey(source_format, target_format):
    return '2'.join([source_format, target_format])

class BibUtils:
    """mixin calss to support bibutils based transformations"""
    
    security = ClassSecurityInfo()

    def __init__(self):
        pass

    security.declareProtected(CMFCorePermissions.View,
                              'transform')
    def transform(self, data, source_format, target_format):
        """
        calling 'bibutils' to transform data from 'source_format'
        to 'target_format'
        """
        key = _getKey(source_format, target_format)
        command = commands.get(key, None)
        if command is None:
            raise ValueError, "No transformation from '%s' to '%s' found." \
                  % (source_format, target_format)

        (fi, fo, fe) = os.popen3(command, 't')
        fi.write(data)
        fi.close()
        result = fo.read()
        fo.close()
        error = fe.read()
        fe.close()
        return result

InitializeClass(BibUtils)

