from Products.ATExtensions.ateapi import FormattableNamesField


def replaceAuthorsField(obj):
    """
    change from the old custom 'publication_authors' field
    to the 'authors' FormattableNamesField from ATExtensions
    """
    try:
        obj.schema.replaceField('publication_authors',
                                FormattableNamesField('authors')
                                )
    except ValueError:
        pass

def migrateAuthorsValue(obj):
    """rename the attribute holding the value

    assumes attribute storage
    FormattableNamesField is clever enough to deal with the type change
    """
    authors = getattr(obj, 'publication_authors', None)
    if authors is not None:
        obj.authors = authors
        del obj.publication_authors
        obj._p_changed = 1
 
def migrateAuthors(obj):
    """
    deal with the renaming of the authors field:
    change the schema abd migrate the value
    """
    replaceAuthorsField(obj)
    migrateAuthorsValue(obj)
    
    

                           
