
import os, sys
from warnings import warn

try:
    import ldap
    hasLdap = True
    del ldap
except:
    hasLdap = False

if hasLdap:
    import FakeLDAP
    if __name__ == '__main__':
        execfile(os.path.join(sys.path[0], 'framework.py'))


    from Testing import ZopeTestCase
    
    externalFields = ('email',)
    lduf_mappings = { 'mail' : { 'ldap_name' : 'mail'
                               , 'friendly_name' : 'Email'
                               , 'public_name' : 'email'
                               , 'multivalued' : ''},
                      'photo' : { 'ldap_name' : 'photo'
                               , 'friendly_name' : 'Portrait'
                               , 'public_name' : 'portrait'
                               , 'multivalued' : ''}                           
                     }
        
    if ZopeTestCase.hasProduct('LDAPUserFolder'):
        ZopeTestCase.installProduct('LDAPUserFolder')
    
        #import Products.LDAPUserFolder.LDAPDelegate
        #Products.LDAPUserFolder.LDAPDelegate.ldap = FakeLDAP
        #from Products.CMFPlone.tests import PloneTestCase
        import CMFMemberTestCase
    
        from Products.GroupUserFolder.tests.Log import *
        from Products.CMFMember.Extensions.Workflow import triggerAutomaticTransitions
        from Products.CMFMember.storages import LDAPUserFolderStorage
        
        # Do some namespace manipulation to make use of FakeLDAP
        # Se LDAPUserFolder tests for more information
        
        # Tests imports
        from config import defaults, alternates, user, manager_user
        ag = alternates.get
        ug = user.get
        dg = defaults.get
        
        class TestLDAPUserFolder(CMFMemberTestCase.CMFMemberTestCase):
            """ We test using LDAPUserFolder as the external Storage 
                for specified fields. """
                
            def grufSetUp(self):
                """ Basic LDAP initialization inside gruf's user source. 
                    Code from GRUF3/tests. """
                # User source replacement
                self.portal.acl_users.replaceUserSource("Users",
                    "manage_addProduct/LDAPUserFolder/manage_addLDAPUserFolder",
                    title = dg('title'),
                    LDAP_server = dg('server'),
                    login_attr = dg('login_attr'),
                    uid_attr = dg('uid_attr'),
                    users_base = dg('users_base'),
                    users_scope = dg('users_scope'),
                    roles= dg('roles'),
                    groups_base = dg('groups_base'),
                    groups_scope = dg('groups_scope'),
                    binduid = dg('binduid'),
                    bindpwd = dg('bindpwd'),
                    binduid_usage = dg('binduid_usage'),
                    rdn_attr = dg('rdn_attr'),
                    local_groups = dg('local_groups'),
                    encryption = dg('encryption'),
                    use_ssl = dg('use_ssl'),
                    read_only=dg('read_only'),
                    )
                # Edit LDAPUF 'cause objectClass cannot be set otherwise :(
                self.portal.acl_users.Users.acl_users.manage_edit(
                    title = dg('title'),
                    login_attr = dg('login_attr'),
                    uid_attr = dg('uid_attr'),
                    users_base = dg('users_base'),
                    users_scope = dg('users_scope'),
                    roles= dg('roles'),
                    obj_classes = 'top,inetOrgPerson',
                    groups_base = dg('groups_base'),
                    groups_scope = dg('groups_scope'),
                    binduid = dg('binduid'),
                    bindpwd = dg('bindpwd'),
                    binduid_usage = dg('binduid_usage'),
                    rdn_attr = dg('rdn_attr'),
                    local_groups = dg('local_groups'),
                    encryption = dg('encryption'),
                    read_only=dg('read_only'),
                    )
                    
                    
            def setupFakeLDAP(self):
                FakeLDAP.clearTree()
                FakeLDAP.addTreeItems(dg('users_base'))
                FakeLDAP.addTreeItems(dg('groups_base'))
                                    
            def afterSetUp(self):
                """ Install LDAPUserFolder by using the FakeLDAP from
                    LDAPUserFolder."""
                if self.portal.portal_quickinstaller.getProductVersion('GroupUserFolder') not in ('3.1.1',):
                    warn ("GroupUserFolder has to be version >= 3"
                          "LDAP tests will fail.")
                else:
                    self.setupFakeLDAP()
                    self.grufSetUp()
                    CMFMemberTestCase.CMFMemberTestCase.afterSetUp(self)
                    self.gruf = self.portal.acl_users
                    self.lduf = self.portal.acl_users.Users.acl_users
                    self.populateMemberDataContainer()
                    import Products.CMFMember.content.member 
        
                    self.ldapStorage = LDAPUserFolderStorage(mappings={'email' : 'mail' })
                    
                
            def populateMemberDataContainer(self):
                """ Create Member objects fromusers in LDAPUserFolder """
                for user in self.gruf.getUserNames():
                    self.membership.getMemberById(user)
                    
            #
            #   Test cases
            #
                
                
            def testAddUser(self):
                ldufStorage = self.ldapStorage
                ldufStorage.setMapping('mail'
                                        , 'Email'
                                        , ''
                                        , 'email'
                                        )
                
                acl = self.lduf
                for role in ug('user_roles'):
                    acl.manage_addGroup(role)
                    acl.manage_addGroupMapping(role, role)
                
                users = len(self.memberdata.contentValues())
                self.membership.addMember('orphanSoon', 'secret',(),[])
                tmpUser = self.membership.getMemberById('orphanSoon')
                
                tmpUser.setEmail(ug('mail'))
                triggerAutomaticTransitions(tmpUser)
                
                self.failUnless( tmpUser )
                self.failUnless( users+1 == len(self.memberdata.contentValues()))
                self.failUnless( self.lduf.getUser('orphanSoon'))
                
                
            def testModifyUser(self):
                self.ldapStorage.setSchemaConfig(lduf_mappings)
                
                acl = self.lduf
                acl.setSchemaConfig(lduf_mappings)
                for role in ug('user_roles'):
                    acl.manage_addGroup(role)
                    acl.manage_addGroupMapping(role, role)
                msg = acl.manage_addUser(REQUEST=None, kwargs=user)
                self.assert_(not msg)
    
                tmpUser = self.membership.getMemberById(ug('cn'))
                self.failUnless(tmpUser)
    
                tmpUser.getField('email').setStorage(tmpUser, self.ldapStorage)
            
                tmpUser.setEmail('foo@bar.com')
                triggerAutomaticTransitions(tmpUser)            
                self.ldapStorage.updateUserObject(tmpUser)
                
                self.failUnless(self.lduf.getUser(ug('cn')).getProperty('mail') == 'foo@bar.com')
                self.failUnless(self.membership.getMemberById(ug('cn')).getEmail() == 'foo@bar.com')
                
    
            def testFieldMappings(self):
                ldufStorage = self.ldapStorage
                ldufStorage.setMapping('mail'
                                        , 'Email'
                                        , ''
                                        , 'email'
                                        )
                                        
                self.failUnless(ldufStorage.getMapping('email') == 'mail')
                ldufStorage.setSchemaConfig(lduf_mappings)
                self.failUnless(ldufStorage.getMapping('email') == 'mail')
                self.failUnless(ldufStorage.getMapping('portrait') == 'photo')
    
    
        if __name__ == '__main__':
        
            framework(verbosity=1)
        else:
            from unittest import TestSuite, makeSuite
            def test_suite():
                suite = TestSuite()
                suite.addTest(makeSuite(TestLDAPUserFolder))
                return suite
    
    
    
    else:
        LDAPUserFolder = False
        print "NOTICE Skipping LDAPUserFolder tests since we couldn't import it "
        print "       If you are a CMFMember developer you should download LDAPUserFolder"
        print "       from http://www.dataflake.org/software/ldapuserfolder to verify that"
        print "       your changes didn't break anything."

else:
    from unittest import TestSuite
    print "NOTICE Couldn't find python-ldap."
    def test_suite():
        """ Empty test suit when running with test.py """
        return TestSuite()
        
sys.stdout.flush()
        
