#
# CatalogTool tests
#

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
import CMFMemberTestCase
from Products.PloneTestCase import ptc

from Products.CMFMember.content import member_schema
from Acquisition import aq_base
from Globals import REPLACEABLE
from sets import Set    
portal_name = CMFMemberTestCase.portal_name

user1  = CMFMemberTestCase.default_user
user2  = 'u2'
group2 = 'g2'

def ismemberindex(index_tuple): 
    if type(tuple()) == type(index_tuple):   
        return len([x for x in index_tuple if x.startswith('member_catalog')])
    return False

class TestIndexes(ZopeTestCase.ZopeTestCase):
    
    def testDisappearingIndexes(self):
        self.folder.manage_addProduct['CMFPlone'].manage_addSite('second', custom_policy=='CMFMember Site')
        accessors = [ field.accessor \
                      for field in member_schema.content_schema.fields() \
                      if ismemberindex(field.index) ]
        
        self.assertEqual(Set(accessors), Set(self.app.second.member_catalog.indexes()))

class TestMemberCatalog(CMFMemberTestCase.CMFMemberTestCase):

    def afterSetUp(self):
        CMFMemberTestCase.CMFMemberTestCase.afterSetUp(self)
        self.catalog = self.portal.member_catalog

    def testMemberLexiconIsZCTextLexicon(self):
        # Lexicon should be a ZCTextIndex lexicon
        self.failUnless(hasattr(aq_base(self.catalog), 'member_lexicon'))
        self.assertEqual(self.catalog.member_lexicon.meta_type, 'ZCTextIndex Lexicon')

    def testSearchableTextIsZCTextIndex(self):
        # SearchableText index should be a ZCTextIndex
        itype = self.catalog.Indexes['SearchableText'].__class__.__name__
        self.assertEqual(itype, 'ZCTextIndex')

    def testSearchableTextIsZCTextIndex(self):
        # SearchableText index should be a ZCTextIndex
        # or a Txidxng
        itype = self.catalog.Indexes['getFullname'].__class__.__name__
        self.assertEqual(itype, 'ZCTextIndex')

    def testRolesAreIndexed(self):
        portal_member = self.membership.getMemberById(self.portal_user.id)
        real_roles = portal_member.getFilteredRoles()
        for role in real_roles:
            mem_brains = self.catalog(getFilteredRoles=role)
            self.failUnless(portal_member.id in [b.id for b in mem_brains])
        real_roles += ('Reviewer',)
        portal_member.setRoles(','.join(real_roles))
        mem_brains = self.catalog(getFilteredRoles='Reviewer')
        self.failUnless(portal_member.id in [b.id for b in mem_brains])

    def testGroupsAreIndexed(self):
        gtool = self.portal.portal_groups
        gname = 'newgroup'
        gtool.addGroup(gname)
        portal_member = self.membership.getMemberById(self.portal_user.id)
        portal_member.setGroups([gname])
        mem_brains = self.catalog(getGroups=gname)
        self.failUnless(len(mem_brains) == 1 and \
                        mem_brains[0].id == portal_member.id)
        
        
def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestMemberCatalog))
    return suite

if __name__ == '__main__':
    framework()
