# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""
$Id: Install.py,v 1.28 2006/07/20 10:01:38 glenfant Exp $
"""
__author__  = ''
__docformat__ = 'restructuredtext'

# Python imports
from StringIO import StringIO

# Zope imports
from Products.ExternalMethod.ExternalMethod import ExternalMethod, manage_addExternalMethod
from Products.StandardCacheManagers import RAMCacheManager

# CMF imports
from Products.CMFCore.utils import getToolByName

# Archetypes imports
from Products.Archetypes import listTypes
from Products.Archetypes.Extensions.utils import installTypes, install_subskin

# Products imports
from Products.PloneArticle.config import GLOBALS, PROJECTNAME, SKINS_DIR, \
     plonearticle_prefs_configlet, HAS_PLONE_2_1
from Products.PloneArticle.PloneArticleTool import PloneArticleTool

def install(self):
    out = StringIO()
    
    # Install types
    typeInfo = listTypes(PROJECTNAME)
    installTypes(self, out,
                 typeInfo,
                 PROJECTNAME)
        
    # Install skin
    install_subskin(self, out, GLOBALS)

    if not HAS_PLONE_2_1:
        # removes plone 2.1 specific templates from layers
        skinstool = getToolByName(self, 'portal_skins')
        for skinname in skinstool.getSkinSelections():
            path = skinstool.getSkinPath(skinname)
            
            path = [i.strip() for i in path.split(',')
                    if i != 'plonearticle_plone21' ]
            
            path = ','.join(path)
            skinstool.addSkinSelection(skinname, path)
    
    # Install tool
    add_tool = self.manage_addProduct[PROJECTNAME].manage_addTool
    article_tool = getattr(self, PloneArticleTool.id, None)
    if article_tool is None:
        add_tool(PloneArticleTool.meta_type)
    else:
        article_tool.initProperties()
    
    # Install configlet
    cptool = getToolByName(self, 'portal_controlpanel')
    try:
        cptool.registerConfiglet(**plonearticle_prefs_configlet)
    except:
        pass
    # Register templates
    registerTemplates(self, typeInfo, out)
    
    # Install ram cache for images
    setupRamCacheManager(self, out)
    
    # Add action icons
    addActionIcon(self,
                  category='plone',
                  action_id='unlock_lock',
                  icon_expr='lock.gif',
                  title="Lock (Currently not locked)",
                  priority=0)
    addActionIcon(self,
                  category='plone',
                  action_id='lock_unlock',
                  icon_expr='unlock.gif',
                  title="Unlock (Currently locked)",
                  priority=0)
    
    provider = getToolByName(self, 'portal_selenium', None)
    if provider:
        # Functional Tests
        action = {'id':PROJECTNAME.lower(),
                  'name':PROJECTNAME,
                  'action':'string:here/get_%s_ftests'%PROJECTNAME.lower(),
                  'condition': '',
                  'permission': 'View',
                  'category':'ftests',
                  'visible': 1}
        provider.addAction(**action)
        print >>out, "Action '%s' added to '%s' action provider" % (str(action['id']), 'portal_selenium')

    out.write('Installation completed.\n')
    return out.getvalue()

def uninstall(self):
    out = StringIO()
    
    # uninstall configlets
    try:
        cptool = getToolByName(self, 'portal_controlpanel')
        cptool.unregisterApplication(PROJECTNAME)
    except:
        pass
    
    out.write('Uninstallation completed.\n')
    return out.getvalue()

def setupRamCacheManager(self, out,):
    meta_type = RAMCacheManager.RAMCacheManager.meta_type
    skinsTool = getToolByName(self, 'portal_skins')
    
    obj =  skinsTool['PloneArticle']
    if 'PloneArticleThumbRAMCache' not in self.objectIds(meta_type):
        out.write('Installing PloneArticleThumbRAMCache\n')
        RAMCacheManager.manage_addRAMCacheManager(self, 'PloneArticleThumbRAMCache')
        """
        obj['getThumbTag'].ZCacheable_setManagerId(self.PloneArticleThumbRAMCache.getId())
        out.write(obj['getThumbTag'].absolute_url() + ' added in PloneArticleThumbRAMCache\n')
        """
    else:
        out.write('PloneArticleThumbRAMCache already installed\n')   

def registerTemplates(self, typeInfo, out):
    """Registers templates in the archetypes tool
    """
    for t in typeInfo:
        klass          = t['klass']
        portal_type    = klass.portal_type
        registerTemplatesForClass(self, klass, portal_type)

def registerTemplatesForClass(self, klass, portal_type):
    atTool       = getToolByName(self, 'archetype_tool')
    default_view = getattr(klass, 'default_view', 'base_view')
    suppl_views  = getattr(klass, 'suppl_views', ())
    views        = ['base_view',]

    if default_view != 'base_view':
        atTool.registerTemplate(default_view)
        views.append(default_view)

    for view in suppl_views:
        atTool.registerTemplate(view)
        views.append(view)

    atTool.bindTemplate(portal_type, views)

def addActionIcon(self, category, action_id, icon_expr, title=None, priority=0):
    # Add the action icon if and only if it's not already here
    ai=getToolByName(self, 'portal_actionicons')
    if ai.queryActionInfo( category, action_id ):
      ai.updateActionIcon(category, action_id, icon_expr, title, priority)
    else:
      ai.addActionIcon(category, action_id, icon_expr, title, priority)
