# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""PloneArticle migration

$Id: testMigration.py,v 1.5 2006/07/20 11:56:00 glenfant Exp $
"""

__author__ = ''
__docformat__ = 'restructuredtext'

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from common import *
from Products.PloneArticle.migration.Migrator import Migrator, ZDummyAttachment

tests = []

class TestMigration(PloneArticleTestCase):

    def importArticleV2(self, container):
        """Import article V2 from zexp
        """
        
        article_id = 'articlev2'
        zexp_path = os.path.join(package_home(GLOBALS), 'tests', '%s.zexp' % article_id)
        container._importObjectFromFile(zexp_path, verify = 1, set_owner = 1)
        return getattr(container, article_id)

    def testPloneArticleMigrationV2ToV3(self):
        self.loginAsPortalOwner()
        
        # Import article in v2.x
        article = self.importArticleV2(self.member_folder)
        article.reindexObject()
        article_id = article.getId()
        
        # Attributes before migration
        article_id = article.getId()
        article_title = article.Title()
        article_description = article.Description()
        article_text = article.getText()
        
        self.failUnless(hasattr(article, 'images_ids'))
        self.failUnless(hasattr(article, 'attachments_ids'))
        image_ids = article.images_ids
        attachment_ids = article.attachments_ids
        content_ids = []
        content_ids.extend(image_ids)
        content_ids.extend(attachment_ids)
        
        # Loop on images
        images = []
        
        for image_id in image_ids:
            image = getattr(article, image_id)
            images.append({
                'title' : image.title_or_id(),
                'size' : len(image.data),
                })
            
        # Loop on attachments
        attachments = []
        
        for attachment_id in attachment_ids:
            attachment = getattr(article, attachment_id)
            attachment_file = attachment.__underlyingFile__
            attachment_file.__module__ = 'ZDummyAttachment'
            title = attachment.title_or_id()
            data = attachment_file.content
            attachments.append({
                'title' : attachment.title,
                'size' : len(data),
                })
                

        for content_id in content_ids:
            self.failUnless(hasattr(article, content_id))
        
        # Migrate to 3.x
        Migrator().migrate(self.portal)
        
        # Attributes after migration
        self.failUnless(not hasattr(article, 'images_ids'))
        self.failUnless(not hasattr(article, 'attachments_ids'))
        
        for content_id in content_ids:
            self.failUnless(not hasattr(article, content_id))
        
        self.assertEquals(article.getId(), article_id)
        self.assertEquals(article.Title(), article_title)
        self.assertEquals(article.Description(), article_description)
        self.assertEquals(article.getText(), article_text)
        
        index = 0
        for brain in article.getImageBrains():
            record = images[index]
            self.assertEquals(brain.Title(), record['title'])
            obj = brain.getObject()
            self.assertEquals(len(obj.data), record['size'])
            index += 1
        
        index = 0
        for brain in article.getAttachmentBrains():
            record = attachments[index]
            self.assertEquals(brain.Title(), record['title'])
            obj = brain.getObject()
            self.assertEquals(len(obj.data), record['size'])
            index += 1
        
        self.logout()
        

tests.append(TestMigration)

if __name__ == '__main__':
    framework()
else:
    # While framework.py provides its own test_suite()
    # method the testrunner utility does not.
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        for test in tests:
            suite.addTest(unittest.makeSuite(test))
        return suite
