# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is RDFGrabber version 1.0.
#
# The Initial Developer of the Original Code is European Environment
# Agency (EEA).  Portions created by EEA are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Soren Roug, EEA
#

import string

resources_dict = {}
literal_dict = {}

def resource(uri, anonymous=None):
    if uri==None:
        r = None
    elif resources_dict.has_key(uri):
        r = resources_dict[uri]
    else:
        r = resources_dict[uri] = Resource(uri, anonymous)
    return r

# fixme: What should happen if two different languages happen
# to use the same word?
def literal(value,lang):
    if value==None:
        r = None
    elif literal_dict.has_key((value,lang)):
        r = literal_dict[(value,lang)]
    else:
        r = literal_dict[(value,lang)] = Literal(value,lang)
    return r


class Resource:
    def __init__(self, uri, anonymous):
        self.uri = uri
        self.anonymous = anonymous

    def __str__(self):
        return self.uri

    def is_literal(self):
        return None

    def is_resource(self):
        return 1

    def is_anonymous(self):
        return self.anonymous

class Literal:
    def __init__(self, value,lang):
        self.value = value
	self.lang = lang

    def __str__(self):
        return self.value

    def is_literal(self):
        return 1

    def is_resource(self):
        return None

    def is_anonymous(self):
        return None
