##############################################################################
#
# Copyright (c) 2002 Zope Corporation and Contributors. All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
__doc__="""Patch of PermissionRole.

This patch exposes the permission name for a role computation.

$Id: PermissionRolePatch.py,v 1.4 2004/06/17 02:38:44 shane Exp $
"""

import sys
from ExtensionClass import Base
from AccessControl.PermissionRole \
     import PermissionRole, _what_not_even_god_should_do
from zLOG import LOG, ERROR


try:
    # Patch PermissionRole.

    def __of__(self, parent):
        r = imPermissionRole()
        r._p = self._p
        r._pa = parent
        r._d = self._d
        p = getattr(parent, 'aq_inner', None)
        if p is not None:
            return r.__of__(p)
        else:
            return r

    PermissionRole.__of__ = __of__

except:
    LOG('VerboseSecurity', ERROR, "Unable to patch PermissionRole.",
        error=sys.exc_info())


class imPermissionRole(Base):
    """Implement permission-based roles"""

    def __of__(self, parent):
        obj = parent
        n = self._p
        # The next line includes the permission name
        # in the allowable roles.
        r = [n]
        while 1:
            if hasattr(obj, n):
                roles = getattr(obj, n)

                if roles is None:
                    return 'Anonymous',

                t = roles.__class__

                if t is tuple:
                    # If we get a tuple, then we don't acquire
                    if r is None:
                        return roles
                    return r + list(roles)

                if issubclass(t, basestring):
                    # We found roles set to a name.  Start over
                    # with the new permission name.  If the permission
                    # name is '', then treat as private!
                    if roles:
                        if roles != n:
                            n = roles
                        # If we find a name that is the same as the
                        # current name, we just ignore it.
                        roles = None
                    else:
                        return _what_not_even_god_should_do

                elif roles:
                    if r is None: r = list(roles)
                    else: r = r + list(roles)

            obj = getattr(obj, 'aq_inner', None)
            if obj is None:
                break
            obj = obj.aq_parent

        if r is None or len(r) < 2:
            r = self._d

        return r

    # The following methods are needed in the unlikely case that an unwrapped
    # object is accessed:
    def __getitem__(self, i):
        try:
            v = self._v
        except:
            v = self._v = self.__of__(self._pa)
            del self._pa

        return v[i]

    def __len__(self):
        try:
            v = self._v
        except:
            v = self._v = self.__of__(self._pa)
            del self._pa

        return len(v)

