import unittest
import simpletestrunner
from Products.ZWiki import ZWikiPage

class TestZWikiPageMisc(simpletestrunner.TestCase):

    def setUp( self ):
        get_transaction().begin()
        
    def tearDown( self ):
        del self.ZopeContext            # needed ?
        get_transaction().abort()       # not sure if this is useful
                                        # doesn't seem to keep leftovers
                                        # out of catalog, for instance

    def testZMIAddPageForm(self):
        "test the 'add zwiki page' form"
        zc = self.ZopeContext
        ZWikiPage.manage_addZWikiPageForm(client=zc,
                                          REQUEST=zc.REQUEST)

    def testPageCreation(self):
        """test basic zwiki page creation"""
        p = ZWikiPage.ZWikiPage()
        assert p.parents == []
        assert p.page_type == ZWikiPage.DEFAULT_PAGE_TYPE

    def testPageAddDel(self):
        "test adding & deleting zwiki pages via the ZMI"
        zc = self.ZopeContext
        # sure this is the best way to get at manage_add ?
        zc.manage_addProduct['ZWiki'].manage_addZWikiPage('TestPageB', \
                                                           title='test page', \
                                                           file='blah blah')
        assert hasattr(zc,'TestPageB'), 'page not created'
        assert zc.TestPageB.text() == 'blah blah', 'wrong text'
        assert zc.TestPageB.page_type == 'structuredtext', \
               'wrong default page type'
        zc.manage_delObjects(['TestPageB'])
        assert not hasattr(zc,'TestPageB'), 'page not deleted'

#from Products.ZCatalog import ZCatalog,Vocabulary
#from Products.ZCatalog.Catalog import Catalog,CatalogError

class TestZWikiPageCatalog(simpletestrunner.TestCase):
    # cf /usr/lib/zope/lib/python/Products/ZCatalog/tests/testCatalog.py
    #
    # we have various ZMI and zwiki methods
    # for adding, deleting, editing etc.
    # Easier to write doctests method by method ?
    #
    # these assume a default catalog is present and being used
    # (requires that the DTMLDocumentExt product be installed,
    # since I haven't get CatalogAwareness working)
    # beware of existing catalog data screwing things up, maybe
    # we can create our own (& set SITE_CATALOG) in zc

    def setUp(self):
        pass
    
    def tearDown(self):
        pass

    def testOkWithoutCatalog(self):
        """
        """
        pass

    def testOkWithoutSiteCatalogProperty(self):
        """
        """
        pass

    def testAutoCatalogingWithZMIMethods(self):
        """
        shag this, let's go with doctest
        it's easier to see what we're actually getting

        even so there is a slight dilemma:
        - use assert and get meaningful messages, or
        - use the style below and always see what you got ?
        nice to find an economical way to do both

        now I tell you what might also be nice - the ability to inline
        doctests with real code, and have them executed along with the
        rest when python is run in debug mode.

        XXX not currently doc-tested - see CatalogAwareness.py

        >>> # the doctest setup/teardown creates & destroys TestPage -
        >>> # use another in case of confusion
        >>> # check everything is clean before we start
        >>> zc.Catalog(id='CatalogTestPage')
        []
        >>> zc.Catalog(PrincipiaSearchSource="blah")
        []
        >>> zc.Catalog(PrincipiaSearchSource="blob")
        []
        >>> # add a page via ZMI
        >>> ZWiki.manage_addZWikiPage('CatalogTestPage',title='test page',\
                                      file='blah')
        ''
        >>> zc.Catalog(id='CatalogTestPage')[0][0]
        'CatalogTestPage'
        >>> zc.Catalog(PrincipiaSearchSource="blah")[0][0]
        'CatalogTestPage'
        >>> zc.Catalog(PrincipiaSearchSource="blob")
        []
        >>> # edit a page via ZMI
        >>> zc.CatalogTestPage.manage_edit('blob','')
        >>> zc.Catalog(PrincipiaSearchSource="blah")
        []
        >>> zc.Catalog(PrincipiaSearchSource="blob")[0][0]
        'CatalogTestPage'
        >>> # delete a page via ZMI
        >>> zc.manage_delObjects(['CatalogTestPage'])
        >>> zc.Catalog(id='CatalogTestPage')
        []
        >>> # who cleans this up if we don't ?
        """
        pass
        
    def testAutoCatalogingWithZWikiMethods(self):
        """
        try this one in zunit
        as noted above, these really expect to start with a clean Catalog
        """
        zc = self.ZopeContext
        assert not zc.Catalog(id='CatalogTestPage'), \
               'uncreated page found in the catalog'
        
        zc.manage_addProduct['ZWiki'].manage_addZWikiPage('CatalogTestPage1')
        zc.CatalogTestPage1.edit(page='CatalogTestPage',text='bleh')
        assert zc.Catalog(id='CatalogTestPage'), \
               'page not found in catalog after creation by edit'
        assert zc.Catalog(PrincipiaSearchSource="bleh"), \
               'page text not found in catalog after creation by edit'
        assert not zc.Catalog(PrincipiaSearchSource="blib"), \
               'dummy text found in catalog after creation by edit'

        zc.CatalogTestPage.append(text='blib')
        assert zc.Catalog(PrincipiaSearchSource="blib"), \
               'new text not found in catalog after append'

        # not working 
        #zc.CatalogTestPage.edit(text='DeleteMe')
        #assert not hasattr(zc,'CatalogTestPage'), 'ack! page not deleted'
        #assert not zc.Catalog(id='CatalogTestPage'), \
        #       'page still found in catalog after DeleteMe edit'
        

def test_suite():
    ts = (
        simpletestrunner.makeSuite(TestZWikiPageMisc),
        simpletestrunner.makeSuite(TestZWikiPageCatalog)
    )
    return simpletestrunner.TestSuite(ts)

def main():
    unittest.TextTestRunner().run(test_suite())

if __name__ == '__main__':
    main()
