/****************************************************************************
**
** Copyright (C) 2004-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef CHECKOUT_H
#define CHECKOUT_H

#include <qiconset.h>

#include "config/config.h"
#include "CommandInterface.h"
#include "directory.h"
#include "cvslistview.h"

class Checkout : public QObject, CommandInterface
{ 
   Q_OBJECT

 signals:
   void deleteObject(QObject *);
   void checkTree(DirBase*);
   void showInfo(const QString&,const QString&);
   void showWarning(const QString&,const QString&);
   void addCheckedOutProject(QString,QString,int);

 public:
   static Checkout * checkoutProject(const QIconSet &, QWidget *, CvsDirListView *);
   static Checkout * exportProject(const QIconSet &, QWidget *, CvsDirListView *);
   virtual ~Checkout();

   void afterCall(int,CvsBuffer *,bool);

 protected:
   void cvsCallStarted();
   void cvsCallFinished();

 private slots:
   void acceptCvs();
   void reject();

 private:
   static Checkout * setup(const QIconSet &, QWidget *, CvsDirListView *, int);

   static QString s_lastProfile;

   enum Type { NOOP = 4 };
   enum Mode { CHECKOUT, EXPORT };

   Checkout(const QIconSet &, QWidget *, CvsDirListView *, int);
   QIconSet m_whatsThisIconSet;
   QWidget * m_parent;
   CvsDirListView * m_workBench;
   QWidget * m_dlg;
   int m_mode;


   QString m_localDirectory;
   QString m_module;
   int m_sshAccess;

};

#endif

