/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#ifndef __DEAL_H__
#define __DEAL_H__

/* from the famous saying, "0neb neb0 eb0n b0ne" */
#define ONEB(x) oneb[(x) & 15]
extern int oneb[];
extern char *seattostring[];
extern char seattochar[];
extern char card_to_char[];

char suit_to_char(int s);
int inverse_card_to_char(char c);

void deal(int *deck, int verbose, int num, int dealer, int vul, int decksize);
void sortdeal(int *deck, int decksize, int cardsperhand);

#define NStab 17
#define Etab 30
#define Wtab 0
#define EW 0
#define Nonevul 1
#define Both 2
#define NS 3
#define True 1
#define False 0
#define White 0
#define Red 3
#define Fav 1
#define Unfav 4
#define Noseat -1
#define North 0
#define East 1
#define South 2
#define West 3
#define rightyseat(s) (((s) + 3) % 4)
#define leftyseat(s) (((s) + 1) % 4)
#define Clubs 0
#define Diamonds 1
#define Hearts 2
#define Spades 3
#define Notrump 4
#define SUITLOOP(i) for (i=Spades; i>=Clubs; i--)

#define whatsuit(card) ((card)/13)
#define whatcard(card) ((card)%13)

#define DEALNO_TO_DEALER(x) (((x) + disnumplayers - 1) % disnumplayers)
#define DEALNO_TO_DEALERx(x,y) (((x) + (y) - 1) % (y))
#define DEALNO_TO_DEALER4(x) (((x) + 3) % 4)

char *makeseed(char *seed, int dealindex);
void setseed(char *seed);
char *getseed(void);
void reseed(char *t, int i);
char *makerndseed(void);

int char_to_strain(char);

#endif
