/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#include "floater.h"
#include "tickler.h"
#include "floatcmd.h"

extern char *helpdescriptions;
extern char *helpcommands;

/* find the text in helpdescriptions that starts with a tab character followed
   by the given string, and ends with a tab character */
static void lookuphelp(char *s)
{
  char *t = helpdescriptions;
  int len = strlen(s);

  for (;;) {
    while (*t != '\0' && *t != '\t') t++;
    if (*t == '\0') {
      helpmsg3("No help available for `", s, "'");
      return;
    }
    t++; /* advance over tab */
    if (strncasecmp(s, t, len) == 0) {
      /* found it */
      s = t = TEMPCOPY(t);
      while (*t != '\n') t++;
      *t = '\0';
      helpmsg3("`", s, "'");
      s = t = t + 1;
      while (*t != '\0') {
	if (*t == '\t') {
	  *t = '\0';
	  goto done;
	}
	if (*t == '\n') {
	  *t = ' ';
	}
	t++;
      }
    done:
      helpmsg(s);
      return;
    }
  }
}

static void dumphelpable(void)
{
/*
  helpmsg("What follows is a list of commands for which hand written descriptions are available.  For a complete list of commands, use `commands.'");
*/
  helpmsg("What follows is a list of commands for which hand written descriptions are available.  For example, for help on the claim command, do `help claim.' See the Floater WWW page for more information.");
  talkmsg(helpcommands);
}

/* a request for help on s */
void help(char *s)
{
  if (*s == '\0' || strcaseeq(s, "help")) {
    /* no arguments: just print out all commands for which we have help */
    dumphelpable();
    return;
  }

  if ((s = helpstring_to_command(s)) == NULL) return;

  lookuphelp(s);
}
