
global floater_version
tryset about_text "version [lrange $floater_version 1 end]\nCopyright (c) 1996-1999 Geoff Pike\nhttp:\/\/www.floater.org/\nThis is free software."


#ifdef TEXT
proc about {{timeout 0}} {
    global about_text
    talkmsg "About Floater:\n$about_text"
}
#else
proc about {{timeout 0}} {
    global logofilename about_text

    toplevel .welcome -bg black

    set f "*-times-medium-r-normal--*-180-*-*-*-*-*-*"
    set c "catch {destroy .welcome}"

    if [catch {
	tryset logofilename \
		[file join [file dirname [info nameofexecutable]] Floaterlogo.gif]
	if [catch {image create photo im -file $logofilename}] \
		{image create photo im -file [file rootname $logofilename]}
	label .welcome.l -image im
    }] then { label .welcome.l -text Floater }

    label .welcome.b -justify center -text "$about_text\nPlaying card bitmaps courtesy of\nJohn Heidemann and Gary Sager."

    foreach w {.welcome.l .welcome.b} {
	$w config -border 0 -font $f -bg black -fg white \
		-highlightthickness 0 -relief flat
	bind $w <1> $c
    }

    pack .welcome.l .welcome.b

    if {$timeout > 0} { after $timeout {catch {destroy .welcome}} }
}

#ifndef TEST
after 2000 {about 10000}
#endif

#endif /* not TEXT */

