/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
proc query_have_seen {name set} {
    set x "$name $set"
    global $x
    array names $x
}

/* a_h_s is short for assert_have_seen */
proc a_h_s {name set num} {
    global "have_seen_sets_$name"
    eval "set \"have_seen_sets_$name\($set)\" 1"

    set x "$name $set"
    global $x
    eval "set \{$x\($num)\} 1"
}

proc have_seen_sets {name} {
    global "have_seen_sets_$name"
    array names "have_seen_sets_$name"
}

proc discard_data_except_from {date} {
    global nameset

    foreach name $nameset {
	global "have_seen_sets_$name"
	foreach set [have_seen_sets $name] {
	    if ![string match *$date* $set] {
		set x "$name $set"
		global $x
		unset $x
//		puts "removed \"$x\""
		eval "unset \"have_seen_sets_$name\($set)\""
//		puts "removed have_seen_sets_$name\($set)"
	    }
	}
    }
}

/////////////////////////////////////////////////////////////////////////////

set to_be_sent_n 0

proc want_to_send {name set num} {
    global to_be_sent_n to_be_sent

//  talkmsg "want_to_send $name $set $num"
    set to_be_sent([incr to_be_sent_n]) $name
    set to_be_sent([incr to_be_sent_n]) $set
    set to_be_sent([incr to_be_sent_n]) $num
}

// Append everything to be sent together, separating fields with tab.
// This is probably an O(n^2) algorithm.  Could be done in O(n).
proc what_to_send {} {
    global to_be_sent_n to_be_sent

    if {$to_be_sent_n == 0} {return ""}
    set s $to_be_sent(1)
    for {set i 2} {$i <= $to_be_sent_n} {incr i} {
	set s "$s	$to_be_sent($i)"
	unset to_be_sent($i)
    }
    set to_be_sent_n 0
    return $s
}
