/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#include "the_texts.deq"
proc display_text {name s} {
    global fixedfont
    // Replace all occurences of "slashslash" with "//"
    set slash /
    regsub -all slashslash $s $slash$slash text
#ifdef TEXT
    talkmsg $text
#else
    global display_text_N

    if ![info exists display_text_N] {set display_text_N 0}
    set w .display_text[incr display_text_N]
    toplevel $w
    wm title $w $name
    set f [frame $w.f]
    text $f.text -relief raised -yscrollcommand "$f.scroll set" \
	    -width 77 -font $fixedfont
    $f.text insert end $text
    pack [scrollbar $f.scroll -command "$f.text yview"] \
	    -side right -fill y
    pack $f.text -side left -fill both -expand y
    button $w.b -text "Dismiss" -command "destroy $w"
    pack $w.b -side bottom -pady 2
    pack $f -side top -fill both -expand y
#endif /* TEXT */
}
