/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalUtil;
import java.util.Iterator;
import java.util.List;

public class IntervalFilter
implements SamRecordFilter {
    private final Iterator<Interval> intervals;
    private final SAMFileHeader samHeader;
    private Interval currentInterval;
    private int currentSequenceIndex;

    public IntervalFilter(List<Interval> intervals, SAMFileHeader samHeader) {
        this.samHeader = samHeader;
        IntervalUtil.assertOrderedNonOverlapping(intervals.iterator(), samHeader.getSequenceDictionary());
        this.intervals = intervals.iterator();
        this.advanceInterval();
    }

    @Override
    public boolean filterOut(SAMRecord record) {
        while (this.currentInterval != null && (this.currentSequenceIndex < record.getReferenceIndex() || this.currentSequenceIndex == record.getReferenceIndex() && this.currentInterval.getEnd() < record.getAlignmentStart())) {
            this.advanceInterval();
        }
        return this.currentInterval == null || this.currentSequenceIndex != record.getReferenceIndex() || this.currentInterval.getStart() > record.getAlignmentEnd();
    }

    private void advanceInterval() {
        if (this.intervals.hasNext()) {
            this.currentInterval = this.intervals.next();
            this.currentSequenceIndex = this.samHeader.getSequenceIndex(this.currentInterval.getSequence());
        } else {
            this.currentInterval = null;
        }
    }

    @Override
    public boolean filterOut(SAMRecord first, SAMRecord second) {
        throw new UnsupportedOperationException("Paired IntervalFilter filter not implemented!");
    }
}

