/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.classfile.Clazz;
import proguard.evaluation.value.ArrayReferenceValueFactory;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class ParticularValueFactory
extends BasicValueFactory
implements ValueFactory {
    static final IntegerValue INTEGER_VALUE_M1 = new ParticularIntegerValue(-1);
    static final IntegerValue INTEGER_VALUE_0 = new ParticularIntegerValue(0);
    static final IntegerValue INTEGER_VALUE_1 = new ParticularIntegerValue(1);
    static final IntegerValue INTEGER_VALUE_2 = new ParticularIntegerValue(2);
    static final IntegerValue INTEGER_VALUE_3 = new ParticularIntegerValue(3);
    static final IntegerValue INTEGER_VALUE_4 = new ParticularIntegerValue(4);
    static final IntegerValue INTEGER_VALUE_5 = new ParticularIntegerValue(5);
    static final LongValue LONG_VALUE_0 = new ParticularLongValue(0L);
    static final LongValue LONG_VALUE_1 = new ParticularLongValue(1L);
    static final FloatValue FLOAT_VALUE_0 = new ParticularFloatValue(0.0f);
    static final FloatValue FLOAT_VALUE_1 = new ParticularFloatValue(1.0f);
    static final FloatValue FLOAT_VALUE_2 = new ParticularFloatValue(2.0f);
    static final DoubleValue DOUBLE_VALUE_0 = new ParticularDoubleValue(0.0);
    static final DoubleValue DOUBLE_VALUE_1 = new ParticularDoubleValue(1.0);
    private static int POS_ZERO_FLOAT_BITS = Float.floatToIntBits(0.0f);
    private static long POS_ZERO_DOUBLE_BITS = Double.doubleToLongBits(0.0);
    private final ValueFactory referenceValueFactory;

    public ParticularValueFactory() {
        this(new ArrayReferenceValueFactory());
    }

    public ParticularValueFactory(ValueFactory valueFactory) {
        this.referenceValueFactory = valueFactory;
    }

    @Override
    public IntegerValue createIntegerValue(int n) {
        switch (n) {
            case -1: {
                return INTEGER_VALUE_M1;
            }
            case 0: {
                return INTEGER_VALUE_0;
            }
            case 1: {
                return INTEGER_VALUE_1;
            }
            case 2: {
                return INTEGER_VALUE_2;
            }
            case 3: {
                return INTEGER_VALUE_3;
            }
            case 4: {
                return INTEGER_VALUE_4;
            }
            case 5: {
                return INTEGER_VALUE_5;
            }
        }
        return new ParticularIntegerValue(n);
    }

    @Override
    public LongValue createLongValue(long l) {
        return l == 0L ? LONG_VALUE_0 : (l == 1L ? LONG_VALUE_1 : new ParticularLongValue(l));
    }

    @Override
    public FloatValue createFloatValue(float f) {
        return f == 0.0f && Float.floatToIntBits(f) == POS_ZERO_FLOAT_BITS ? FLOAT_VALUE_0 : (f == 1.0f ? FLOAT_VALUE_1 : (f == 2.0f ? FLOAT_VALUE_2 : new ParticularFloatValue(f)));
    }

    @Override
    public DoubleValue createDoubleValue(double d) {
        return d == 0.0 && Double.doubleToLongBits(d) == POS_ZERO_DOUBLE_BITS ? DOUBLE_VALUE_0 : (d == 1.0 ? DOUBLE_VALUE_1 : new ParticularDoubleValue(d));
    }

    @Override
    public ReferenceValue createReferenceValue() {
        return this.referenceValueFactory.createReferenceValue();
    }

    @Override
    public ReferenceValue createReferenceValueNull() {
        return this.referenceValueFactory.createReferenceValueNull();
    }

    @Override
    public ReferenceValue createReferenceValue(String string, Clazz clazz, boolean bl, boolean bl2) {
        return this.referenceValueFactory.createReferenceValue(string, clazz, bl, bl2);
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String string, Clazz clazz, IntegerValue integerValue) {
        return this.referenceValueFactory.createArrayReferenceValue(string, clazz, integerValue);
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String string, Clazz clazz, IntegerValue integerValue, Value value) {
        return this.referenceValueFactory.createArrayReferenceValue(string, clazz, integerValue, value);
    }
}

