/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int AFupdHead (AFILE *AFp)

Purpose:
  Update the header for an audio file

Description:
  This routine updates the header for an audio file opened for write.

Parameters:
  <-  int AFupdHead
      Error code, 0 for no error
   -> AFILE *AFp
      Audio file pointer for the audio file

Author / revision:
  P. Kabal  Copyright (C) 1998
  $Revision: 1.5 $  $Date: 1998/06/13 02:11:27 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFupdHead.c 1.5 1998/06/13 libtsp-v3r0 $";

#include <assert.h>

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFdataio.h>
#include <libtsp/AFheader.h>
#include <libtsp/AFmsg.h>
#include <libtsp/AFpar.h>


int
AFupdHead (AFp)

     AFILE *AFp;

{
  long int pos;
  int (*AF_upd)p_((AFILE *AFp));

  assert (AFp->Op == FO_WO);
  assert (! AFp->Error);

  /* Set up the appropriate routine */
  AF_upd = NULL;
  switch (AFp->Ftype) {
  case FT_AU:
    AF_upd = AFupdAUhead;
    break;
  case FT_WAVE:
    AF_upd = AFupdWVhead;
    break;
  case FT_AIFF_C:
    AF_upd = AFupdAIhead;
    break;
  }

  /* Save the file position, update the header, restore the position */
  if (AF_upd != NULL && FLseekable (AFp->fp)) {
    pos = AFtell (AFp->fp, &AFp->Error);
    if (! AFp->Error) {
      AFp->Error = (*AF_upd) (AFp);
      AFseek (AFp->fp, pos, &AFp->Error);
    }
  }

  if (AFp->Error)
    UTwarn ("AFupdHead: %s", AFM_UpdHeadErr);

  return AFp->Error;
}
