/*
 *   wtt.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#if !defined(MWWTTBL_WTT_H)
#define MWWTTBL_WTT_H 1
/**/
/*-----------------------------------------------------------------------------*/
/*  This header file defines the WT Table.  Details for these settings are*/
/*  documented in the Mwave WT Table Editor's help file.*/
/**/
/*  Define formats:*/
/**/
/*    Block tags are used for finding the block within the WT Table.*/
/*    Blocks are defined by WTBLOCK_... defines.*/
/*    Parameter offsets within blocks are defined by WTPARAM_... defines.*/
/*    Field starting offsets within blocks are defined by WTFIELD_... defines.*/
/*    Field lengths defined by this header file are defined by WTLENGTH_... defines.*/
/*    The length of the entire block are also listed as WTLENGTH_... defines,*/
/*    however, block lengths could change so the WTT_QueryBlockLength function should*/
/*    be used to determine the current block length for memory allocations.*/
/**/
/*    Information with each parameter is defined immediately following the*/
/*    WTPARAM_... define.*/
/**/
/**/
/*  Example:  The ath1 not allowed control in the WTTAF parameter would*/
/*            be resolved using:*/
/**/
/*                WTBLOCK_WTITCB, WTPARAM_WTTAF, WTLENGTH_ONEPARAM,*/
/*                ATH1_NOT_ALLOWED*/
/**/
/*  Example:  The 16 locations for the FAX Tx Power Level array is:*/
/*                WTBLOCK_INSTALLATION_CTRL, WTFIELD_FAX_TX_LVLS,*/
/*                WTLENGTH_FAX_TX_LVLS*/
/**/
/**/
/**/
/**/
/*------------ Single word parameter length define -------*/
#define WTLENGTH_ONEPARAM     1


/*------------ Block Tags ---------------------------------*/
#define WTBLOCK_BLACKLIST                       0x4B42
#define WTBLOCK_WTITCB                          0x4154
#define WTBLOCK_PLATFORM_SPECIFIC               0x5350
#define WTBLOCK_VOICE_CTRL                      0x4356
#define WTBLOCK_CALL_PROG_DATA                  0x5043



/*------------ Call Progress Data defines -----------------*/
#define WTFIELD_CALLPROGDATA_BLOCK                   0           /*DAK01*/



/*------------ Blacklist defines ---------------------------*/
   #define WTFIELD_BLACKLIST_BLOCK                   0
#define WTPARAM_FSUC                                     0
   #define FSUC_INHIBIT                         0x8000
   #define FSUC_COUNT                           0x7F00
   #define FSUC_MAX_COUNT                       20       /*DAK04, the maximum count allowed by the blacklist lib*/
   #define FSUC_DELAY                           0x00FF

#define WTPARAM_SSUC                                     1
   #define SSUC_INHIBIT                         0x8000
   #define SSUC_COUNT                           0x7F00
   #define SSUC_MAX_COUNT                       20       /*DAK04, the maximum count allowed by the blacklist lib*/
   #define SSUC_DELAY                           0x00FF

#define WTPARAM_FSSD                                     2

#define WTPARAM_BLCTRL                                   3
   #define BLCTRL_RESERVED_1020                 0xFFF0        /*DAK03 Starting with WTTversion=1020 tables*/
   #define BLCTRL_RESERVED                      0xFFF0        /*DAK03*/
   #define USE_SPECIAL_ALGORITHM                0x0008        /*DAK03*/
   #define USE_TWINDOW                          0x0004
   #define GROUP_ALL_NUMBERS                    0x0002
   #define ABORT_IS_UNSUCCESSFUL                0x0001

#define WTPARAM_CALLDLY                                  4
#define WTPARAM_FIRSTDLY                                 5
#define WTPARAM_TWINDOW                                  6


#define WTLENGTH_BLACKLIST_BLOCK  7  /*Number of words defined for the*/
                                     /*blacklist block.*/


/*------------ WTITCB defines ------------------------------*/
   #define WTFIELD_WTITCB_BLOCK                      0

#define WTPARAM_WTTCID                                   0

#define WTPARAM_WTTAF                                    1
   #define WTTAF_RESERVED_1007                  0xF806        /*begining with WTTversion=1007 tables*/
   #define WTTAF_RESERVED_1009                  0xF8F6        /*begining with WTTversion=1009 tables*/
   #define WTTAF_RESERVED                       0xF8F6
   #define USE_WTTFH                            0x0400
   #define TONE_TO_PULSE_NOT_ALLOWED            0x0200
   #define FLASH_HOOK_NOT_ALLOWED               0x0100
   #define USE_WTTRNGS                          0x0080
   #define USE_WTTBDWT_WTTBDWTX                 0x0040
   #define USE_WTTCW_WTTCWX                     0x0020
   #define USE_WTTLCW_WTTLCWX                   0x0010
   #define USE_WTTDTSD_WTTDTIDD                 0x0008
   #define ATH1_NOT_ALLOWED                     0x0001

#define WTPARAM_WTTAF2                                   2
   #define WTTAF2_RESERVED_1001                 0x80FF     /* Starting with WTTversion=1001 tables.*/
   #define WTTAF2_RESERVED                      0x80FF
   #define GUARD_TONE_REQUIRED                  0x4000
   #define GUARD_TONE_NOT_ALLOWED               0x2000
   #define CALLING_TONE_REQUIRED                0x1000
   #define USE_DIAL_LOOP                        0x0800
   #define RX_AND_TX_INACTIVITY_TIMER           0x0400
   #define ATA_ONLY_WITH_RING                   0x0100

#define WTPARAM_WTTG3FAX                                 3
   #define DISALLOW_CALLERID                    0x0008     /* DAK04*/

#define WTPARAM_WTTDTADS                                 4
   #define DTMF_NOT_ALLOWED                     0xFFFF
   #define KEYPAD_ONLY                          0x000B
   #define ALL_16_DTMF                          0x000F


#define WTPARAM_WTTCPM                                   5
   #define WTTCPM_RESERVED                      0x00C0
   #define DIALTONE_REQUIRED                    0x8000
   #define ANSWERTONE_REQUIRED                  0x4000
   #define BUSYTONE_REQUIRED                    0x2000
   #define NETWORKBUSYTONE_REQUIRED             0x1000
   #define RINGBACKTONE_REQUIRED                0x0800
   #define SECONDDIALTONE_REQUIRED              0x0400
   #define DIALTONE_NOT_PREFERRED               0x0200
   #define BUSYTONE_NOT_PREFERRED               0x0100
   #define IGNORE_DIALTONE_AFTER_DIAL           0x0020
   #define NETWORKBUSYTONE_VALID                0x0010
   #define BUSYTONE_VALID                       0x0008
   #define RINGBACKTONE_VALID                   0x0004
   #define SECONDDIALTONE_VALID                 0x0002
   #define DIALTONE_VALID                       0x0001

#define WTPARAM_WTTRNGS                                  6
   #define MIN_RINGS_MASK                       0x00FF
   #define MAX_RINGS_MASK                       0xFF00
   #define NO_RINGS_RESTRICTIONS                0xFF01

#define WTPARAM_WTTDMODE                                 7
   #define WTTDMODE_RESERVED                    0xFFFC
   #define WTTDMODE_OFF                         0x0000
   #define WTTDMODE_N_PULSES                         1        /*DAK11*/
   #define WTTDMODE_N_PLUS_1_PULSES                  2        /*DAK11*/
   #define WTTDMODE_10_MINUS_N_PULSES                3        /*DAK11*/

#define WTPARAM_WTTBDWT                                  8
   #define WTTBDWT_MIN_DEFAULT                    2000              /*DAK10*/
#define WTPARAM_WTTDTWT                                  9
#define WTPARAM_WTTCW                                   10
   #define CW_MIN_ALLOWED                         0001              /*DAK10*/
#define WTPARAM_WTTAMD                                  11
#define WTPARAM_WTTLCW                                  12
   #define LCW_MIN_ALLOWED                        0001              /*DAK10*/
#define WTPARAM_WTTFDXL                                 13
#define WTPARAM_WTTHDXL                                 14
#define WTPARAM_WTTVXL                                  15
#define WTPARAM_WTTHDTM                                 16
#define WTPARAM_WTTLDTM                                 17
#define WTPARAM_WTTACD                                  18
#define WTPARAM_WTTPDMD                                 19
#define WTPARAM_WTTPDBD                                 20
#define WTPARAM_WTTPDIDD                                21
#define WTPARAM_WTTPDT1                                 22
#define WTPARAM_WTTPDT2                                 23
#define WTPARAM_WTTPDT3                                 24
#define WTPARAM_WTTPDT4                                 25
#define WTPARAM_WTTFH                                   26
#define WTPARAM_WTTDTSD                                 27
#define WTPARAM_WTTDTIDD                                28
#define WTPARAM_WTTRDNP                                 29
#define WTPARAM_WTTRDXP                                 30
#define WTPARAM_WTTRDSPD                                31
#define WTPARAM_WTTRDSAD                                32
#define WTPARAM_WTTCIND                                 33
#define WTPARAM_WTTCIRN                                 34
#define WTPARAM_WTTCIRX                                 35
#define WTPARAM_WTTCIXD                                 36
#define WTPARAM_WTTBDWTX                                37
   #define WTTBDWTX_MAX_ALLOWED                 0x7FFF
#define WTPARAM_WTTCWX                                  38
   #define WTTCWX_MAX_ALLOWED                      255

#define WTPARAM_WTTLCWX                                 39
   #define WTTLCWX_MAX_ALLOWED                     255

#define WTPARAM_WTTVQL                                  40
#define WTPARAM_WTTVQT                                  41
#define WTPARAM_WTTMXL                                  42
#define WTPARAM_WTTGDT                                  43
#define WTPARAM_WTTV34XL                                44
#define WTPARAM_WTTCFSR                                 45
   #define WTTCFSR_RESERVED                     0xFF80

   #define DISABLE_ASYMMETRIC_SYMBOL_RATES      0x0040       /*DAK03*/
   #define DISABLE_3429_SYMBOL_BAUD             0x0020       /*DAK03*/
   #define DISABLE_3200_SYMBOL_BAUD             0x0010       /*DAK03*/
   #define DISABLE_3000_SYMBOL_BAUD             0x0008       /*DAK03*/
   #define DISABLE_2800_SYMBOL_BAUD             0x0004       /*DAK03*/
   #define DISABLE_2743_SYMBOL_BAUD             0x0002       /*DAK03*/
   #define DISABLE_2400_SYMBOL_BAUD             0x0001       /*DAK03*/


#define WTPARAM_WTT34FBR                                46
   #define WTT34FBR_RESERVED_1001               0xE0FC       /*DAK03 Starting with WTTversion=1001 tables*/
   #define WTT34FBR_RESERVED_1020               0xE0F0       /*DAK03 Starting with WTTversion=1020 tables*/
   #define WTT34FBR_RESERVED_1040               0x8000       /*DAK14 Starting with WTTversion=1040 tables*/
   #define WTT34FBR_RESERVED                    0xE0FC       //DAK03 /*DAK14*/


   #define X2_SPECTRAL_SHAPE_BIT1               0x4000       /*DAK14*/
   #define X2_SPECTRAL_SHAPE_BIT0               0x2000       /*DAK14*/
   #define DISABLE_PRECODING                    0x1000       /*DAK03*/

   #define DISABLE_CONSTELLATION_SHAPING        0x0800       /*DAK03*/
   #define DISABLE_CONSTELLATION_WARPING        0x0400       /*DAK03*/
   #define DISABLE_PREEMPHASIS                  0x0200       /*DAK03*/
   #define DISABLE_POWER_REDUCTION              0x0100       /*DAK03*/

   #define PCM_CODING_ALAW                      0x0080       /*DAK14*/
   #define DISABLE_V_PCM                        0x0040       /*DAK14*/
   #define DISABLE_K56_FLEX                     0x0020       /*DAK14*/
   #define DISABLE_X2                           0x0010       /*DAK14*/

   #define DISABLE_ERR_CORRECT_PROTOCOL         0x0008       /*DAK03*/
   #define DISABLE_SPEEDS_ABOVE_28_8            0x0004       /*DAK03*/
   #define DISABLE_AUX_CHANNEL                  0x0002       /*DAK03*/
   #define DISABLE_ASYMMETRIC_RATES             0x0001       /*DAK03*/


#define WTPARAM_WTBPFQ                                  47
#define WTPARAM_WTBPON                                  48
#define WTPARAM_WTBPOFF                                 49
#define WTPARAM_WTBPPWR                                 50
#define WTPARAM_WTCBPFQ                                 51
#define WTPARAM_WTCBPON                                 52
#define WTPARAM_WTCBPOFF                                53
#define WTPARAM_WTCBPPWR                                54
#define WTPARAM_WTDTRMEH                                55
#define WTPARAM_WTDTRMEL                                56
#define WTPARAM_WTDTRMOD                                57
#define WTPARAM_WTDTRMFD                                58
#define WTPARAM_WTTBDWTD                                59
   #define WTTBDWTD_DEFAULT                       2000             /*DAK10*/
#define WTPARAM_WTTMCNGT                                60
#define WTPARAM_WTTFCNGT                                61
#define WTPARAM_WTTDIDX                                 62
   #define WTTDIDX_MAX_ALLOWED                     120             /*DAK10*/
#define WTPARAM_WTTGNT                                  63
#define WTPARAM_WTTDTWTX                                64
   #define WTTDTWTX_MAX_ALLOWED                 0x7FFF
   #define WTTDTWTX_USA_DEFAULT                   8000             /*DAK10*/
#define WTPARAM_WTTC8BLT                                65

#define WTPARAM_WTTRDNSP                                66  /*DAK02*/
#define WTPARAM_WTTRDXSP                                67  /*DAK02*/
#define WTPARAM_WTTRDNSA                                68  /*DAK02*/
#define WTPARAM_WTTRDXSA                                69  /*DAK02*/
#define WTPARAM_WTTRDNV                                 70  /*DAK02*/
#define WTPARAM_WTTUDAAC                                71  /*DAK02*/
   #define WTTUDAAC_RESERVED                    0xE3F0      /*DAK05*/
   #define WTTUDAAC_COMPLEX                     0x1000      /*DAK08*/
   #define WTTUDAAC_50MA                        0x0800      /*DAK05*/
   #define WTTUDAAC_350_OHM                     0x0400      //DAK05 //DAK07 /*DAK09*/
   #define WTTUDAAC_PD_MAKE_350_OHM             0x0008      //DAK08 /*DAK09*/
   #define WTTUDAAC_PD_MAKE_NO_MUTE             0x0004      /*DAK08*/
   #define WTTUDAAC_PD_BREAK_350_OHM            0x0002      //DAK08 /*DAK09*/
   #define WTTUDAAC_PD_BREAK_USE_MUTE           0x0001      /*DAK08*/

#define WTPARAM_WTTOCDLY                                72  /*DAK06*/
#define WTPARAM_WTTCWD                                  73  /*DAK12*/
#define WTPARAM_WTTV34RL                                74  /*DAK15*/
#define WTPARAM_WTTRSV39                                75
#define WTPARAM_WTTRSV40                                76
#define WTPARAM_WTTRSV41                                77
#define WTPARAM_WTTRSV42                                78
#define WTPARAM_WTTRSV43                                79
#define WTPARAM_WTTRSV44                                80
#define WTPARAM_WTTRSV45                                81
#define WTPARAM_WTTRSV46                                82
#define WTPARAM_WTTRSV47                                83
#define WTPARAM_WTTRSV48                                84
#define WTPARAM_WTTRSV49                                85
#define WTPARAM_WTTRSV50                                86
#define WTPARAM_WTTRSV51                                87
#define WTPARAM_WTTRSV52                                88
#define WTPARAM_WTTRSV53                                89
#define WTPARAM_WTTSAF_N                                90
#define WTPARAM_WTTSAF_X                                91
#define WTPARAM_WTTAANT                                 92
#define WTPARAM_WTTRSV57                                93
   #define WTTRSV57_EXPECTED_VALUE              0x0000

#define WTPARAM_WTTHDCON                                94
#define WTPARAM_WTTHDCOF                                95
#define WTPARAM_WTTFDCON                                96
#define WTPARAM_WTTFDCOF                                97
#define WTPARAM_WTTFSCON                                98
#define WTPARAM_WTTFSCOF                                99

#define WTPARAM_WTTRSV64                               100   /*former WTTA2DM*/
   #define WTTRSV64_EXPECTED_VALUE              0x7FFF

#define WTPARAM_WTTRSV65                               101   /*former WTTD2AM*/
   #define WTTRSV65_EXPECTED_VALUE              0x7FFF

#define WTPARAM_WTTTONM                                102
#define WTPARAM_WTTTONX                                103
#define WTPARAM_WTTDLST                                104


#define WTLENGTH_WTITCB_BLOCK   105  /* Number of words defined for the*/
                                     /* WTITCB block.*/


/*------------ Platform Specific defines ----------------------*/
#define WTFIELD_PLATFORM_SPECIFIC_BLOCK                  0



/* Platform Specific Data from former PS Block*/
#define WTPARAM_PS1                                      0

#define WTPARAM_PS_VER                                   1

#define WTPARAM_USER_AF                                  2
   #define USER_AF_RESERVED                     0xFE00
   #define USER_PULSE_DIAL_ADJUST_ALLOWED       0x0100
   #define SPEAKER_VOLUME_ADJUST_ALLOWED        0x0080
   #define MICROPHONE_GAINS_ADJUST_ALLOWED      0x0040
   #define GREETING_MESSAGES_ADJUST_ALLOWED     0x0020
   #define SPEAKERPHONE_TX_PWR_ADJUST_ALLOW     0x0010
   #define FAX_TX_PWR_ADJUST_ALLOWED            0x0008
   #define MODEM_TX_PWR_ADJUST_ALLOWED          0x0004
   #define TONES_TX_PWR_ADJUST_ALLOWED          0x0002
   #define DTMF_TX_PWR_ADJUST_ALLOWED           0x0001


/* define the maximum power selectable*/
#define WTPARAM_MAX_PWR                                  3
   #define MAX_PWR_DEFAULT                           0     /* limits the maximum power level*/

#define WTPARAM_DTMFHIGH                                 4 /* sets WTTHDTM*/
#define WTPARAM_DTMFLOW                                  5 /* sets WTTLDTM*/

#define WTPARAM_TONES_TX                                 6 /* sets WTTTONX*/
#define WTPARAM_TAM_BEEP                                 7 /* sets WTTBPPWR*/
#define WTPARAM_CONVBEEP                                 8 /* sets WTTCPPWR*/
#define WTPARAM_TONE_ERR                                 9 /* used in Calling Tones, DTMF, TAM and Conversation beeps*/
                                                           /* tx pwr lvl calculations to adjust from ideal*/

#define WTPARAM_MODEM_TX                                10 /* sets WTTFDXL*/
#define WTPARAM_MODEMERR                                11 /* used in modem tx pwr lvl calculations to adjust from ideal*/
#define WTPARAM_V34_ERR                                 12 /* used in V.34 tx pwr lvl calculations to adjust from ideal*/

#define WTPARAM_FAX_TX                                  13 /* sets WTTHDXL*/
#define WTPARAM_FAX_ERR                                 14 /* used in fax tx pwr lvl calculations to adjust from ideal*/

#define WTPARAM_SPKR_TX                                 15 /* sets WTTVXL*/
#define WTPARAM_GREET_TX                                16 /* sets WTTMXL*/

#define WTPARAM_UDAARDNV                                17 // sets WTTRDNV - this the voltage part                /*DAK06*/
#define WTPARAM_UDAARDVM                                18 // sets WTTRDNV - this is the hardware dependent part  /*DAK06*/


#define WTLENGTH_PS_BLOCK_1020                      17      //DAK06 /*DAK13*/
#define WTLENGTH_PLATFORM_SPECIFIC_BLOCK            19      /*DAK06*/



/*------------ Voice Control defines ------------------------------*/

#define WTFIELD_VC_BLOCK                             0

#define WTPARAM_VC_VER                                   0
#define WTPARAM_FLAGS_LO                                 1
   #define FLAGS_LO_RESERVED                    0x8000

   #define US_GAIN_CHANGE_NOT_ALLOWED           0x0001  /* US_ is unsigned short to*/
   #define US_GAIN_CHANGE_NOT_ALLOWED_OFFHOOK   0x0002  /* avoid duplicates with*/
   #define US_LIMIT_MAX_VOLUME                  0x0004  /* voicectl.h*/
   #define US_LIMIT_GREETING_LENGTH             0x0008
   #define US_LIMIT_GREETING_LENGTH_NO_RECORD   0x0010
   #define US_DISALLOW_GREETING_WITH_NO_RECORD  0x0020
   #define US_LIMIT_MESSAGE_RECORD_LENGTH       0x0040
   #define US_REMOTE_GREETING_RECORD_REVIEW     0x0080
   #define US_LIMIT_MAX_MSG_RETRIEVE_LENGTH     0x0100
   #define US_NEVER_ANSWER_SILENT               0x0200
   #define US_TAM_NOT_ALLOWED_IN_COUNTRY        0x0400
   #define US_SPK_PHONE_NOT_ALLOWED_IN_COUNTRY  0x0800
   #define US_AUTODISCRIM_TAM_NOT_ALLOWED       0x1000
   #define US_AUTODISCRIM_FAX_NOT_ALLOWED       0x2000
   #define US_AUTODISCRIM_MODEM_NOT_ALLOWED     0x4000


#define WTPARAM_FLAGS_HI                                 2
   #define FLAGS_HI_RESERVED                    0x01FF
   #define FLAGS_HI_AUTO_SET                    0xFC00

#define WTPARAM_GAINMAX1                                 3
#define WTPARAM_GAINMIN1                                 4
#define WTPARAM_GAINNOM1                                 5
#define WTPARAM_GAINMAX2                                 6
#define WTPARAM_GAINMIN2                                 7
#define WTPARAM_GAINNOM2                                 8
#define WTPARAM_MAXVOL1                                  9
   #define MAXVOL_INIT_VALUE                    0xFFFF
#define WTPARAM_MAXVOL2                                 10
#define WTPARAM_MAXGREET                                11
   #define MAXGREET_INIT_VALUE                  0xFFFF
#define WTPARAM_MAXINFO                                 12
   #define MAXINFO_INIT_VALUE                   0xFFFF
#define WTPARAM_MAXREC                                  13
   #define MAXREC_INIT_VALUE                    0xFFFF
#define WTPARAM_MAXRTRV                                 14
   #define MAXRTRV_INIT_VALUE                   0xFFFF
#define WTPARAM_MWAVECC                                 15
#define WTPARAM_MINRINGS                                16
#define WTPARAM_MAXRINGS                                17
#define WTPARAM_MAXRETRY                                18
#define WTPARAM_MINTIME                                 19


#define WTLENGTH_VOICE_CONTROL_BLOCK  20  /* Number of words defined in the*/
                                          /* Voice Control block.*/


#endif


