/*
 *   mwmparse.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <port_types.h>
#include <port_functions.h>
#include <unidiags.h>

/*****************************************************************************/
/* Amount of PP Buffer space required by each command.                       */
/*****************************************************************************/
#define   PP_S_REG_CMD_SPACE       4
#define   PP_A_CMD_SPACE           1
#define   PP_B_CMD_SPACE           PP_S_REG_CMD_SPACE
/* C Command needs 0 PP words */
#define   PP_D_CMD_SPACE           AT_CMD_BUFFER_SIZE+ 10 + 2
#define   PP_E_CMD_SPACE           PP_S_REG_CMD_SPACE
/* F Command needs 0 PP words */
#define   PP_H_CMD_SPACE           2
#define   PP_L_CMD_SPACE           PP_S_REG_CMD_SPACE
#define   PP_M_CMD_SPACE           PP_S_REG_CMD_SPACE
#define   PP_O_CMD_SPACE           1
#define   PP_P_CMD_SPACE           PP_S_REG_CMD_SPACE
#define   PP_Q_CMD_SPACE           PP_S_REG_CMD_SPACE
/* S Command needs 0 PP words */
#define   PP_T_CMD_SPACE           PP_S_REG_CMD_SPACE
#define   PP_V_CMD_SPACE           PP_S_REG_CMD_SPACE
#define   PP_X_CMD_SPACE           PP_S_REG_CMD_SPACE
#define   PP_Y_CMD_SPACE           PP_S_REG_CMD_SPACE

#define   PP_COMMA_CMD_SPACE       1
#define   PP_QUESTION_CMD_SPACE    2
#define   PP_EQUAL_CMD_SPACE       PP_S_REG_CMD_SPACE

#define   PP_AMP_C_CMD_SPACE       PP_S_REG_CMD_SPACE
#define   PP_AMP_D_CMD_SPACE       PP_S_REG_CMD_SPACE
#define   PP_AMP_G_CMD_SPACE       PP_S_REG_CMD_SPACE
#define   PP_AMP_N_CMD_SPACE       2                                 // PTR 592
#define   PP_AMP_P_CMD_SPACE       PP_S_REG_CMD_SPACE
#define   PP_AMP_S_CMD_SPACE       PP_S_REG_CMD_SPACE
#define   PP_AMP_T_CMD_SPACE       PP_S_REG_CMD_SPACE
#define   PP_AMP_U_CMD_SPACE       PP_S_REG_CMD_SPACE

#define   PP_DASH_J_CMD_SPACE      2                                 // DCR 2823
#define   PP_DASH_SSE_CMD_SPACE    2

#define   PP_SLASH_A_CMD_SPACE     4
#define   PP_SLASH_B_CMD_SPACE     1
#define   PP_SLASH_K_CMD_SPACE     3
#define   PP_SLASH_L_CMD_SPACE     3
#define   PP_SLASH_N_CMD_SPACE     2
#define   PP_SLASH_O_CMD_SPACE     1
#define   PP_SLASH_Q_CMD_SPACE     2
#define   PP_SLASH_T_CMD_SPACE     3
#define   PP_SLASH_U_CMD_SPACE     1
#define   PP_SLASH_V_CMD_SPACE     PP_S_REG_CMD_SPACE
#define   PP_SLASH_Y_CMD_SPACE     1
#define   PP_SLASH_Z_CMD_SPACE     2


#define   PP_STAR_TH_CMD_SPACE     2

#define   PP_PERCENT_A_CMD_SPACE   2
#define   PP_PERCENT_C_CMD_SPACE   2
#define   PP_PERCENT_E_CMD_SPACE   2
#define   PP_PERCENT_TT_CMD_SPACE  2

#define   PP_QUOTE_H_CMD_SPACE     2
#define   PP_QUOTE_N_CMD_SPACE     2
#define   PP_QUOTE_O_CMD_SPACE     2

#define   PP_FAA_CMD_SPACE                 2
#define   PP_FBOR_CMD_SPACE                2
#define   PP_FCLASS_CMD_SPACE              5
#define   PP_FCLASSQUESTION_CMD_SPACE      1
#define   PP_FCR_CMD_SPACE                 2
#define   PP_FDCC_CMD_SPACE                5
#define   PP_FDIS_CMD_SPACE                5
#define   PP_FDT_CMD_SPACE                 2
#define   PP_FET_CMD_SPACE                 2
#define   PP_FK_CMD_SPACE                  1
#define   PP_FLID_CMD_SPACE               22
#define   PP_FDR_CMD_SPACE                 1

#define   PP_XON_XOFF_CMD_SPACE            3

#define   PP_A8E_CMD_SPACE                 2     //$2 do not need space now/may need later???
#define   PP_ES_CMD_SPACE                  5     //$2
#define   PP_ESA_CMD_SPACE                 0     //$1
#define   PP_ITF_CMD_SPACE                 0     //$1
#define   PP_IBC_CMD_SPACE                 0     //$1


/*****************************************************************************/
/* usParserStatus Return Flags                                               */
/*****************************************************************************/
#define   MWM_ATCMD_ERROR          1
#define   MWM_GET_MORE_BUFFERS     2
#define   MWM_NO_MORE_COMMANDS     4
#define   MWM_ATCMD_BUSY           8


/*****************************************************************************/
/* Commands...These commands are those that possibly fill the PP Buffer.     */
/* One of these constants is placed into the STATEINFO.usCurrentCommand var. */
/*****************************************************************************/
#define   MWM_AMP_V_CMD              1
#define   MWM_I_COMMAND              2
#define   MWM_LOAD_SPECIFIC_PROFILE  3
#define   MWM_INITIALIZE_MODEM       4
#define   MWM_CONTINUE_AT_BUFFER     5
#define   MWM_AMP_F_CMD              6  //  PTR 2356
#define   MWM_PND_UD_CMD             8




typedef struct
{
  HDSP   hDSP;
  HMTASK hMCTL;
  ULONG  dspaddrATCMDBUF;
  ULONG  dspaddrATRLCBUF;   // Class 2 Response Buffer...
  ULONG  dspaddrPP_CMD;
  ULONG  dspaddrCNTLSTAT;
  ULONG  dspaddrDRVRSTAT;
  ULONG  dspaddrSREGS;
  ULONG  dspaddrOTHRREGS;
  ULONG  dspaddrDCS;        // MTS 4285
  ULONG  dspaddrHKSTAT;        // MTS 4473
  ULONG  dspaddrMNPITCB;
  ULONG  dspaddrV42ITCB;
  ULONG  dspaddrRAMMITCB;
  ULONG  dspaddrFCLASS;
  ULONG  dspaddrIGNORES10;
  ULONG  dspaddrMDMSTAT;
  ULONG  dspaddrNEGCNTL;
  USHORT bCapability;                    /* caller ID support in hardware */
  ULONG  ulDSPAddrCallerIDLength;       /* caller ID support */
  ULONG  ulDSPAddrCallerIDData;         /* caller ID support */
  ULONG  dspaddrSUBCLASS;               /*$4*/
  ULONG  dspaddrPSV8ITCB;
  USHORT bDRingCapability;              /* distinctive ring support */
  ULONG  dspaddrCAPBUFF;
  ULONG  dspaddrMYID;
  ULONG  dspaddrMYCIG;
  ULONG  dspaddrADPCMindexval;
  ULONG  dspaddrADPCMstepsize;
  ULONG  dspaddrADPCMnewSample;
} DSPINFO, *PDSPINFO;

/* Class 2 Capabilities Buffer */
#define   FMINSP_OFFSET         16
#define   FCR_OFFSET            18
#define   FCQ_OFFSET            20
#define   FPTS_OFFSET           22
#define   FSPL_OFFSET           24
#define   FLPL_OFFSET           26
#define   FPHCTO_OFFSET         28

typedef struct
{
  USHORT  usVR;
  USHORT  usBR;
  USHORT  usWD;
  USHORT  usLN;
  USHORT  usDF;
  USHORT  usEC;
  USHORT  usBF;
  USHORT  usST;
  USHORT  usFMINSP;
  USHORT  usFCR;
  USHORT  usFCQ;
  USHORT  usFPTS;
  USHORT  usFSPL;
  USHORT  usFLPL;
  USHORT  usFPHCTO;
} CLASS2CAPBUFF, *PCLASS2CAPBUFF;

/*****************************************************************************/
/* When the interrupt handler requests a new buffer from MDMCTL, this        */
/* structure is updated with the current state.                              */
/* MDMCTL will interrupt the parser again with CNTLSTAT 2.  The action will  */
/* be determined by the state of this structure.                             */
/*****************************************************************************/
typedef struct
{
  char          achModemVersion[MWM_VERSION_STRING_LENGTH];         // MTS 2944
  char          achOEMVersion[MWM_VERSION_STRING_LENGTH];           // MTS 4581
  char          achIDString[MWM_VERSION_STRING_LENGTH];
  char          achPCMString[MWM_SPEED_STRING_LENGTH];
  char          ach336String[MWM_SPEED_STRING_LENGTH];
  char          ach288String[MWM_SPEED_STRING_LENGTH];
  char          ach144String[MWM_SPEED_STRING_LENGTH];
  char          ach2400String[MWM_SPEED_STRING_LENGTH];
  USHORT        usCurrentCommand;
  USHORT        usSubCommandInfo;
  USHORT        usSavedCommandParameter;
  char          achCommandBuffer[AT_CMD_BUFFER_SIZE];
  USHORT        usNextATIndex;
  USHORT        ausPPcmdBuffer[PP_CMD_BUFFER_SIZE];
  USHORT        usNextPPIndex;
  /***************************************************************************/
  /* S Register to use in next "set" operation.  This value is set by the    */
  /* ATS command.  It is used by the AT? and AT= commands                    */
  /***************************************************************************/
  USHORT         usSelectedSRegister;

  HWND           ulMainWindowHandle;// Here is a WRONG Hungarian notation because
                                    // we are interested in changing the code
                                    // as less as possible

  char           achNumberDialed[AT_CMD_BUFFER_SIZE]; /* DCR 3444 */
  ULONG          ulHINI; /* Handle to INI file...OS/2 only. */
  char           achINIFileName[MWM_MAX_FILENAME_LENGTH];  
  char           achMemoryFileName[MWM_MAX_FILENAME_LENGTH];
  DSPINFO        dsp;
  MODEMMEMORY    ModemMemory;
  MWMERROR       mwmError;
  ULONG          ulFeaturesToLoad; /* Which modem options are to be loaded. */
  ULONG          ulInstalledFeatures; /* which options are installed. */
  USHORT         usParserMode;  /* FAX mode, or REGULAR MODEM Mode....    */
  USHORT         usSuspendFlag; /* DCR 2456 Power Management. */
  USHORT         usWTChangeFlag; /* flag if country change occured during ATDT, ATH1, ATA */
  USHORT         usWTChangeDRVRSTAT; /* value for DRVRSTAT after a country change. */
  MWM_WTPARMS    wt;
  USHORT         usCNFGBUF1;     /* Default CNFGBUF Settings from INI file. */
  USHORT         usCNFGBUF2;     /* .. */
  USHORT         usAmpFReturnToDataMode;

  HWND           usDebugWindow;/* Here is a WRONG Hungarian notation because */
                               /* we are interested in changing the code */
                               /* as less as possible */

  USHORT         usLeaveClass2Loaded;
  USHORT         usS37Value;
  USHORT         usS32Value;
  USHORT         usS33Value;
  USHORT         usS60Value;
  USHORT         usWValue;
  char           achClass1Capabilities[60];
  /* 12/09/96 Class 2 Rewrite Changes */
  CLASS2CAPBUFF  Class2Capabilities;    /* For +FDCC, the Capabilities buffer */
  CLASS2CAPBUFF  TempClass2Capabilities;/* For +FDIS */
  char           achFLIDString[30];     /* For +FLID, the Local ID */
  char           achFCIGString[30];     /* For +FCIG, the Local Polling ID */
  USHORT         usFAXERR;              /* Last fax error received */
  /* 12/09/96 End of Class 2 Rewrite Changes */
  USHORT         usAllowA8EActionCommand;
  USHORT         usClass0RestoreV80State;
  USHORT         usV80StateSaved;
  USHORT         ausStoredESRegs[PLUS_ES_PARMS_SUPPORTED];
  USHORT         usForce512WordDictionary;   /* Added to force "N0 03/11/97 DR */
  USHORT         usShowTimeStamp;
  BOOL           bVoiceModeEntered;
  UNIDIAG        CallStatus;
  BOOL           bPoundUDDecimal;
  USHORT         usV80THValue;
} STATEINFO, *PSTATEINFO;


/*****************************************************************************/
/* Declare a global pointer to the State Information structure.              */
/*****************************************************************************/
extern PSTATEINFO psi;

#define UD_BUFFER_SIZE 1024
extern char ud_buffer[UD_BUFFER_SIZE];
extern int  ud_next;

USHORT mwmAmpCommand(STATEINFO *psi);
USHORT mwmAmpCCommand(STATEINFO *psi);
USHORT mwmAmpDCommand(STATEINFO *psi);
USHORT mwmAmpGCommand(STATEINFO *psi);
USHORT mwmAmpNCommand(STATEINFO *psi, USHORT usSlashAParm);   /* PTR 592 */
USHORT mwmAmpPCommand(STATEINFO *psi);
USHORT mwmAmpSCommand(STATEINFO *psi);
USHORT mwmAmpTCommand(STATEINFO *psi);
USHORT mwmAmpUCommand(STATEINFO *psi);
USHORT mwmAmpVPhoneNumberLine(STATEINFO *psi, USHORT usLine, PSZ pszOutputLine);
USHORT mwmAmpVProfileLine(STATEINFO *psi, USHORT usProfile, USHORT usLine, PSZ pszOutputLine);
USHORT mwmAmpVCommand(STATEINFO *psi);
USHORT mwmAmpWCommand(STATEINFO *psi);
USHORT mwmAmpYCommand(STATEINFO *psi);
USHORT mwmAmpZCommand(STATEINFO *psi);

/*****************************************************************************/
/* The following function(s) can be found in mwmplus.c                       */
/*****************************************************************************/
USHORT mwmPlusCommand(STATEINFO *psi);
USHORT mwmPlusFCLASSCommand(STATEINFO *psi);
USHORT mwmPlusFCLASSQuestionCommand(STATEINFO *psi);

/*****************************************************************************/
/* The following function(s) can be found in mwmclss1.c                      */
/*****************************************************************************/
USHORT  mwmClss1FTSCommand(STATEINFO *psi);
USHORT  mwmClss1FRSCommand(STATEINFO *psi);
USHORT  mwmClss1FTMCommand(STATEINFO *psi);
USHORT  mwmClss1FRMCommand(STATEINFO *psi);
USHORT  mwmClss1FTHCommand(STATEINFO *psi);
USHORT  mwmClss1FRHCommand(STATEINFO *psi);

/*****************************************************************************/
/* The following function(s) can be found in mwmClss2.c                      */
/*****************************************************************************/
USHORT mwmClss2FAACommand(STATEINFO *psi);
USHORT mwmClss2FBORCommand(STATEINFO *psi);
USHORT mwmClss2FBUFCommand(STATEINFO *psi);
USHORT mwmClss2FCRCommand(STATEINFO *psi);
USHORT mwmClss2FDVPSCommand(STATEINFO *psi);
USHORT mwmClss2FETCommand(STATEINFO *psi);
USHORT mwmClss2FDCCCommand(STATEINFO *psi);
USHORT mwmClss2FDCCQuestionCommand(STATEINFO *psi);
USHORT mwmClss2FDCSCommand(STATEINFO *psi);
USHORT mwmClss2FDISCommand(STATEINFO *psi);
USHORT mwmClss2FDISQuestionCommand(STATEINFO *psi);
USHORT mwmClss2FDRCommand(STATEINFO *psi);
USHORT mwmClss2FDTCommand(STATEINFO *psi);
USHORT mwmClss2FKCommand(STATEINFO *psi);
USHORT mwmClss2FLIDCommand(STATEINFO *psi);
USHORT mwmClss2FMFRCommand(STATEINFO *psi);
USHORT mwmClss2FREVCommand(STATEINFO *psi);
USHORT mwmClss2FSPLCommand(STATEINFO *psi);
USHORT mwmClss2FLPLCommand(STATEINFO *psi);
USHORT mwmClss2FPTSCommand(STATEINFO *psi);
USHORT mwmClss2FCIGCommand(STATEINFO *psi);
USHORT mwmClss2FCQCommand(STATEINFO *psi);
USHORT mwmClss2FMINSPCommand(STATEINFO *psi);
USHORT mwmClss2FAXERRCommand(STATEINFO *psi);
USHORT mwmClss2WriteTaskData( STATEINFO *psi, ULONG ulDSPAddress, PVOID pData,
                              USHORT usNumWords, char *szFilename, USHORT usLine);

/*****************************************************************************/
/* The following function(s) can be found in mwmCls80.c                      */
/*****************************************************************************/
USHORT mwmDashCommand(STATEINFO *psi);
USHORT mwmDashJCommand(STATEINFO *psi, USHORT usParm);
USHORT mwmDashSSECommand(STATEINFO *psi, USHORT usParm);

/*****************************************************************************/
/* The following general purpose routines are kept in mwmparse.c             */
/*****************************************************************************/
USHORT mwmParseEchoString(STATEINFO *psi,PSZ achString);
USHORT mwmParseGetArgFromATString ( char *pchATString, USHORT *pusCurrentIndex );
USHORT mwmParseInitializeModem(STATEINFO *psi, USHORT usProfileToLoad);
ULONG  mwmParseReadATStringFromDSP( STATEINFO *psi );
void   mwmParseSetSRegister(USHORT *pusPPBuffer, USHORT *pusPPIndex,
                            USHORT usSReg, USHORT usAndMask, USHORT usOrMask);
void   mwmParseWriteCmdToDSP(STATEINFO *psi,USHORT usParserStatus);


ULONG mwmParseQuerySpeaker(PUSHORT pusSpeakerSetting, PUSHORT pusSpeakerOnOff);
// MTS6384 new procedure
void  mwmParseSetDisconnectTime(STATEINFO *psi, USHORT usDisconnectSeconds);

char *mwmParseGetNextArgument( char *pArgumentList, USHORT *pusParmNumber );
void mwmParseMoveATIndex( STATEINFO *psi, char *achString );

USHORT  mwmParseConvertProfile(STATEINFO *psi);                   /*$1*/

/*****************************************************************************/
/* The following functions can be found in mwmPerc.c                         */
/* These are the functions which handle the "%" commands.                    */
/*****************************************************************************/
USHORT mwmPercentCommand(STATEINFO *psi);
USHORT mwmPercentACommand(STATEINFO *psi, USHORT usParm);
USHORT mwmPercentCCommand(STATEINFO *psi, USHORT usParm);
USHORT mwmPercentECommand(STATEINFO *psi, USHORT usParm);
USHORT mwmPercentTTCommand(STATEINFO *psi);


/*****************************************************************************/
/* The following functions can be found in mwmPound.c                        */
/* These are the functions which handle the "%" commands.                    */
/*****************************************************************************/
USHORT mwmPoundCommand(STATEINFO *psi);
USHORT mwmPoundUDEchoBuffer(STATEINFO *psi);



/*****************************************************************************/
/* The following functions can be found in mwmslash.c                        */
/* These are the functions to handle parsing the backslash commands.         */
/*****************************************************************************/
USHORT mwmSlashCommand(STATEINFO *psi);
USHORT mwmSlashACommand(STATEINFO *psi, USHORT usSlashAParm);
USHORT mwmSlashKCommand(STATEINFO *psi, USHORT usSlashAParm);
USHORT mwmSlashLCommand(STATEINFO *psi, USHORT usSlashAParm);
USHORT mwmSlashNCommand(STATEINFO *psi, USHORT usSlashAParm);
USHORT mwmSlashQCommand(STATEINFO *psi, USHORT usParm);
USHORT mwmSlashTCommand(STATEINFO *psi, USHORT usSlashAParm);
USHORT mwmSlashVCommand(STATEINFO *psi, USHORT usSlashAParm);
USHORT mwmSlashZCommand(STATEINFO *psi, USHORT usSlashAParm);




/*****************************************************************************/
/* The following functions can be found in mwmcmd.c                          */
/* These are all of the single letter command functions.                     */
/*****************************************************************************/
USHORT mwmCmdParseATcmd(STATEINFO *siStateInfo);
USHORT mwmCmdACommand(STATEINFO *psi);
USHORT mwmCmdBCommand(STATEINFO *psi);
USHORT mwmCmdDCommand(STATEINFO *psi);
USHORT mwmCmdDSCommand(STATEINFO *psi,
                       char  *achValidDialDigits,
                       USHORT *pusNumDialedIndex,
                       BOOL *pbDigitsFound);
USHORT mwmCmdDirectPPCommand(STATEINFO *psi);
USHORT mwmCmdECommand(STATEINFO *psi);
USHORT mwmCmdEqualCommand(STATEINFO *psi);
USHORT mwmCmdHCommand(STATEINFO *psi);
USHORT mwmCmdICommand(STATEINFO *psi);
USHORT mwmCmdI0Command(STATEINFO *psi);
USHORT mwmCmdI1Command(STATEINFO *psi);
USHORT mwmCmdI2Command(STATEINFO *psi);
USHORT mwmCmdI3Command(STATEINFO *psi);
USHORT mwmCmdI4Command(STATEINFO *psi);
USHORT mwmCmdICommandCallback(STATEINFO *psi);
USHORT mwmCmdLCommand(STATEINFO *psi);
USHORT mwmCmdMCommand(STATEINFO *psi);
USHORT mwmCmdOCommand(STATEINFO *psi);
USHORT mwmCmdPCommand(STATEINFO *psi);
USHORT mwmCmdQCommand(STATEINFO *psi);
USHORT mwmCmdSCommand(STATEINFO *psi);
USHORT mwmCmdTCommand(STATEINFO *psi);
USHORT mwmCmdVCommand(STATEINFO *psi);
USHORT mwmCmdWCommand(STATEINFO *psi);
USHORT mwmCmdXCommand(STATEINFO *psi);
USHORT mwmCmdYCommand(STATEINFO *psi);
USHORT mwmCmdZCommand(STATEINFO *psi);



USHORT  mwmQuoteCommand(STATEINFO *psi);
USHORT  mwmQuoteHCommand(STATEINFO *psi, USHORT usParm);
USHORT  mwmQuoteNCommand(STATEINFO *psi, USHORT usParm);
USHORT  mwmQuoteOCommand(STATEINFO *psi, USHORT usParm);


USHORT mwmStarCommand(STATEINFO *psi);
USHORT mwmStarTHCommand(STATEINFO *psi, USHORT usParm);


USHORT mwmDLECommand(STATEINFO *psi);

/* prototypes for non-exported caller ID procedures in mwmcidp.c */
USHORT mwmCidpParseCID(STATEINFO *psi);
USHORT mwmCidpCIDQuery(STATEINFO *psi);
USHORT mwmCidpCIDCommand(STATEINFO *psi);
USHORT mwmCidpPoundCIDCommand(STATEINFO *psi, USHORT usParm);
USHORT mwmCidpDashSDRCommandSet(STATEINFO *psi, USHORT usParm);
USHORT mwmCidpDashSDRCommand(STATEINFO *psi);
USHORT mwmCidpDRingQuery(STATEINFO *psi);

USHORT  mwmv80PA8ECommand(STATEINFO *psi,USHORT * PlusA8E);  //$1
USHORT  mwmv80PESCommand(STATEINFO *psi,USHORT * PlusES, BOOL bSwitchClass); //$1
USHORT  mwmv80PESACommand(STATEINFO *psi,USHORT * PlusESA);  //$1
USHORT  mwmv80PITFCommand(STATEINFO *psi,USHORT * PlusITF);  //$1
USHORT  mwmv80PIBCCommand(STATEINFO *psi,USHORT * PlusIBC);  //$1

/*****************************************************************************/
/* The following function(s) can be found in mwmIPC1.c                       */
/*****************************************************************************/
void mwmIPCHandleError( char *achFile, SHORT sLine, PMWMERROR pmwmError,
                        ULONG ulPrimaryCode, ULONG ulSecondaryCode );

/*****************************************************************************/
/* The following function(s) can be found in mwmIPC1.c                       */
/*****************************************************************************/
  int   FAR PASCAL mwmIPC1InterruptHandler(void);

  
#ifdef DEBUG
   void    dprintf(char *szFormat, ...);
   #define DPF  dprintf
   
#else
   #define DPF ((void)0)
#endif


