// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Aspect_RectangularGrid_HeaderFile
#define _Aspect_RectangularGrid_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Aspect_RectangularGrid_HeaderFile
#include <Handle_Aspect_RectangularGrid.hxx>
#endif

#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Aspect_Grid_HeaderFile
#include <Aspect_Grid.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_NegativeValue;
class Standard_NullValue;
class Standard_NumericError;



class Aspect_RectangularGrid : public Aspect_Grid {

public:
 // Methods PUBLIC
 // 

//! creates a new grid. By default this grid is not <br>
//!          active. <br>
//!          The first angle is given relatively to the horizontal. <br>
//!          The second angle is given relatively to the vertical. <br>
Standard_EXPORT Aspect_RectangularGrid(const Quantity_Length aXStep,const Quantity_Length aYStep,const Quantity_Length anXOrigin = 0,const Quantity_Length anYOrigin = 0,const Quantity_PlaneAngle aFirstAngle = 0,const Quantity_PlaneAngle aSecondAngle = 0,const Quantity_PlaneAngle aRotationAngle = 0);

//! defines the x step of the grid. <br>
Standard_EXPORT   void SetXStep(const Quantity_Length aStep) ;

//! defines the y step of the grid. <br>
Standard_EXPORT   void SetYStep(const Quantity_Length aStep) ;

//! defines the angle of the second network <br>
//!          the fist angle is given relatively to the horizontal. <br>
//!          the second angle is given relatively to the vertical. <br>
Standard_EXPORT   void SetAngle(const Quantity_PlaneAngle anAngle1,const Quantity_PlaneAngle anAngle2) ;


Standard_EXPORT   void SetGridValues(const Quantity_Length XOrigin,const Quantity_Length YOrigin,const Quantity_Length XStep,const Quantity_Length YStep,const Quantity_PlaneAngle RotationAngle) ;

//! returns the point of the grid the closest to the point X,Y <br>
Standard_EXPORT   void Compute(const Quantity_Length X,const Quantity_Length Y,Quantity_Length& gridX,Quantity_Length& gridY) const;

//! returns the x step of the grid. <br>
Standard_EXPORT   Quantity_Length XStep() const;

//! returns the x step of the grid. <br>
Standard_EXPORT   Quantity_Length YStep() const;

//! returns the x Angle of the grid, relatively to the horizontal. <br>
Standard_EXPORT   Quantity_PlaneAngle FirstAngle() const;

//! returns the y Angle of the grid, relatively to the vertical. <br>
Standard_EXPORT   Quantity_PlaneAngle SecondAngle() const;


Standard_EXPORT   void Init() ;
//Standard_EXPORT ~Aspect_RectangularGrid();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Boolean CheckAngle(const Quantity_PlaneAngle alpha,const Quantity_PlaneAngle beta) const;


 // Fields PRIVATE
 //
Quantity_Length myXStep;
Quantity_Length myYStep;
Quantity_PlaneAngle myFirstAngle;
Quantity_PlaneAngle mySecondAngle;
Standard_Real a1;
Standard_Real b1;
Standard_Real c1;
Standard_Real a2;
Standard_Real b2;
Standard_Real c2;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
