// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_SSInterference_HeaderFile
#define _BOPTools_SSInterference_HeaderFile

#ifndef _BOPTools_ListOfPaveBlock_HeaderFile
#include <BOPTools_ListOfPaveBlock.hxx>
#endif
#ifndef _BOPTools_PaveSet_HeaderFile
#include <BOPTools_PaveSet.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _BOPTools_SequenceOfCurves_HeaderFile
#include <BOPTools_SequenceOfCurves.hxx>
#endif
#ifndef _IntTools_SequenceOfPntOn2Faces_HeaderFile
#include <IntTools_SequenceOfPntOn2Faces.hxx>
#endif
#ifndef _TColStd_ListOfInteger_HeaderFile
#include <TColStd_ListOfInteger.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOPTools_IndexedDataMapOfIntegerState_HeaderFile
#include <BOPTools_IndexedDataMapOfIntegerState.hxx>
#endif
#ifndef _BOPTools_ShapeShapeInterference_HeaderFile
#include <BOPTools_ShapeShapeInterference.hxx>
#endif
class IntTools_SequenceOfCurves;
class IntTools_SequenceOfPntOn2Faces;
class BOPTools_PaveBlock;
class BOPTools_ListOfPaveBlock;
class BOPTools_PaveSet;
class BOPTools_SequenceOfCurves;
class BOPTools_IndexedDataMapOfIntegerState;
class TColStd_ListOfInteger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! class for storing a Face/Face interference <br>
//!         Each  F/F interference  contains  information  about <br>
//!         1.  myPBs   - PaveBlocks (made from edges from the faces <br>
//!             that are IN-2D or ON-2D; <br>
//!         2.  myCurves- Sequence of curves of intersection; <br>
//!         3.  myTangentFacesFlag  - The BOOL flag indicates that <br>
//!             the  faces are SD in terms of the F/F Intersector. <br>
//!         4.  mySenseFlag  - value that is equal +1 or -1 depending <br>
//!             on scalar product between normals to each face.  This <br>
//!             valie is valid for the SDF only. <br>
//!         5.  myAlonePnts  - contains 3D-points that are place <br>
//!             of  intersection between the two faces <br>
//!         6.  myAloneVertices   - contains indices of vertices <br>
//!             that correspond to the points  myAlonePnts; <br>
class BOPTools_SSInterference  : public BOPTools_ShapeShapeInterference {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
Standard_EXPORT BOPTools_SSInterference();


//! Constructor <br>
//! anIndex1, <br>
//! anIndex2 see BOPTools_ShapeShapeInterference for details <br>
//! aTolR3D  - value of tolerance to reach in 3D-space <br>
//! aTolR2D  - value of tolerance to reach in 2D-space <br>
//! aCurves  see  IntTools_Curve  for details,  please <br>
Standard_EXPORT BOPTools_SSInterference(const Standard_Integer anIndex1,const Standard_Integer anIndex2,const Standard_Real aTolR3D,const Standard_Real aTolR2D,const IntTools_SequenceOfCurves& aCurves,const IntTools_SequenceOfPntOn2Faces& aPnts);


//! Modifier <br>
Standard_EXPORT   void AppendBlock(const BOPTools_PaveBlock& aPB) ;


//! Selector <br>
Standard_EXPORT  const BOPTools_ListOfPaveBlock& PaveBlocks() const;


//! Selector <br>
Standard_EXPORT   BOPTools_PaveSet& NewPaveSet() ;


//! Selector <br>
Standard_EXPORT   Standard_Real TolR3D() const;


//! Selector <br>
Standard_EXPORT   Standard_Real TolR2D() const;


//! Selector <br>
Standard_EXPORT   BOPTools_SequenceOfCurves& Curves() ;


//! Modifier <br>
Standard_EXPORT   void SetTangentFacesFlag(const Standard_Boolean aFlag) ;


//! Selector <br>
Standard_EXPORT   Standard_Boolean IsTangentFaces() const;


//! Modifier <br>
Standard_EXPORT   void SetSenseFlag(const Standard_Integer aFlag) ;


//! Selector <br>
Standard_EXPORT   Standard_Integer SenseFlag() const;


//! Modifier <br>
Standard_EXPORT   void SetStatesMap(const BOPTools_IndexedDataMapOfIntegerState& aStatesMap) ;


//! Selector <br>
Standard_EXPORT  const BOPTools_IndexedDataMapOfIntegerState& StatesMap() const;


//! Modifier <br>
Standard_EXPORT   void SetAlonePnts(const IntTools_SequenceOfPntOn2Faces& aPnts) ;


//! Selector <br>
Standard_EXPORT  const IntTools_SequenceOfPntOn2Faces& AlonePnts() const;


//! Selector <br>
//! <br>
Standard_EXPORT   TColStd_ListOfInteger& AloneVertices() ;


//! Modifier <br>
//! <br>
Standard_EXPORT   void SetSharedEdges(const TColStd_ListOfInteger& aLS) ;


//! Selector <br>
//! <br>
Standard_EXPORT  const TColStd_ListOfInteger& SharedEdges() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
BOPTools_ListOfPaveBlock myPBs;
BOPTools_PaveSet myNewPaveSet;
Standard_Real myTolR3D;
Standard_Real myTolR2D;
BOPTools_SequenceOfCurves myCurves;
IntTools_SequenceOfPntOn2Faces myAlonePnts;
TColStd_ListOfInteger myAloneVertices;
Standard_Boolean myTangentFacesFlag;
Standard_Integer mySenseFlag;
BOPTools_IndexedDataMapOfIntegerState myStatesMap;
TColStd_ListOfInteger mySharedEdges;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
