// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Bisector_Inter_HeaderFile
#define _Bisector_Inter_HeaderFile

#ifndef _IntRes2d_Intersection_HeaderFile
#include <IntRes2d_Intersection.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_Bisector_BisecCC_HeaderFile
#include <Handle_Bisector_BisecCC.hxx>
#endif
#ifndef _Handle_Geom2d_Line_HeaderFile
#include <Handle_Geom2d_Line.hxx>
#endif
class Standard_ConstructionError;
class Bisector_Bisec;
class IntRes2d_Domain;
class Geom2d_Curve;
class Bisector_BisecCC;
class Geom2d_Line;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Intersection between two <Bisec> from Bisector. <br>
class Bisector_Inter  : public IntRes2d_Intersection {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Bisector_Inter();

//! Intersection between 2 curves. <br>
//!          C1 separates the element A and B. <br>
//!          C2 separates the elements C et D. <br>
//!          If B an C have the same geometry. <ComunElement> <br>
//!          Has to be True. <br>
//!          It Permits an optimiztion of the computation. <br>
Standard_EXPORT Bisector_Inter(const Bisector_Bisec& C1,const IntRes2d_Domain& D1,const Bisector_Bisec& C2,const IntRes2d_Domain& D2,const Standard_Real TolConf,const Standard_Real Tol,const Standard_Boolean ComunElement);

//! Intersection between 2 curves. <br>
//!          C1 separates the element A and B. <br>
//!          C2 separates the elements C et D. <br>
//!          If B an C have the same geometry. <ComunElement> <br>
//!          Has to be True. <br>
//!          It Permits an optimiztion of the computation. <br>
Standard_EXPORT   void Perform(const Bisector_Bisec& C1,const IntRes2d_Domain& D1,const Bisector_Bisec& C2,const IntRes2d_Domain& D2,const Standard_Real TolConf,const Standard_Real Tol,const Standard_Boolean ComunElement) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Intersection between 2 curves. <br>
Standard_EXPORT   void SinglePerform(const Handle(Geom2d_Curve)& C1,const IntRes2d_Domain& D1,const Handle(Geom2d_Curve)& C2,const IntRes2d_Domain& D2,const Standard_Real TolConf,const Standard_Real Tol,const Standard_Boolean ComunElement) ;


Standard_EXPORT   void NeighbourPerform(const Handle(Bisector_BisecCC)& C1,const IntRes2d_Domain& D1,const Handle(Bisector_BisecCC)& C2,const IntRes2d_Domain& D2,const Standard_Real Tol) ;


Standard_EXPORT   void TestBound(const Handle(Geom2d_Line)& C1,const IntRes2d_Domain& D1,const Handle(Geom2d_Curve)& C2,const IntRes2d_Domain& D2,const Standard_Real Tol,const Standard_Boolean Reverse) ;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
