// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _DrawDim_HeaderFile
#define _DrawDim_HeaderFile

#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TopoDS_Shape;
class Draw_Interpretor;
class gp_Pnt;
class TopoDS_Edge;
class gp_Lin;
class gp_Circ;
class TopoDS_Face;
class gp_Pln;
class DrawDim_Dimension;
class DrawDim_Angle;
class DrawDim_Distance;
class DrawDim_Radius;
class DrawDim_PlanarDimension;
class DrawDim_PlanarAngle;
class DrawDim_PlanarDistance;
class DrawDim_PlanarRadius;
class DrawDim_PlanarDiameter;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This package provides Drawable Dimensions. <br>
//! <br>
//!          The classes PlanarDimension and subclasses provide <br>
//!            services  to  build  drawable dimensions between <br>
//!          point line and circle in a given 3d plane. <br>
//! <br>
//!           The   classes  Dimension and   subclasses provide <br>
//!            services  to build  drawable  dimensions between <br>
//!          plane and cylindrical surfaces. <br>
class DrawDim  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT static  void DrawShapeName(const TopoDS_Shape& ashape,const Standard_CString aname) ;


Standard_EXPORT static  void AllCommands(Draw_Interpretor& I) ;

//! tools <br>
//!          ===== <br>
Standard_EXPORT static  void PlanarDimensionCommands(Draw_Interpretor& I) ;


Standard_EXPORT static  gp_Pnt Nearest(const TopoDS_Shape& aShape,const gp_Pnt& apoint) ;


Standard_EXPORT static  Standard_Boolean Lin(const TopoDS_Edge& e,gp_Lin& l,Standard_Boolean& infinite,Standard_Real& first,Standard_Real& last) ;


Standard_EXPORT static  Standard_Boolean Circ(const TopoDS_Edge& e,gp_Circ& l,Standard_Real& first,Standard_Real& last) ;


Standard_EXPORT static  Standard_Boolean Pln(const TopoDS_Face& f,gp_Pln& p) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class DrawDim_Dimension;
friend class DrawDim_Angle;
friend class DrawDim_Distance;
friend class DrawDim_Radius;
friend class DrawDim_PlanarDimension;
friend class DrawDim_PlanarAngle;
friend class DrawDim_PlanarDistance;
friend class DrawDim_PlanarRadius;
friend class DrawDim_PlanarDiameter;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
