// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Expr_UnaryExpression_HeaderFile
#define _Expr_UnaryExpression_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Expr_UnaryExpression_HeaderFile
#include <Handle_Expr_UnaryExpression.hxx>
#endif

#ifndef _Handle_Expr_GeneralExpression_HeaderFile
#include <Handle_Expr_GeneralExpression.hxx>
#endif
#ifndef _Expr_GeneralExpression_HeaderFile
#include <Expr_GeneralExpression.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Expr_NamedUnknown_HeaderFile
#include <Handle_Expr_NamedUnknown.hxx>
#endif
class Expr_GeneralExpression;
class Standard_OutOfRange;
class Standard_NumericError;
class Expr_InvalidOperand;
class Expr_NamedUnknown;



class Expr_UnaryExpression : public Expr_GeneralExpression {

public:
 // Methods PUBLIC
 // 
//! Returns the operand used <br>
 const Handle_Expr_GeneralExpression& Operand() const;

//! Sets the operand used <br>
//!          Raises InvalidOperand if <exp> contains <me>. <br>
Standard_EXPORT   void SetOperand(const Handle(Expr_GeneralExpression)& exp) ;

//! Returns the number of sub-expressions contained <br>
//!          in <me> ( >= 0) <br>
Standard_EXPORT   Standard_Integer NbSubExpressions() const;

//! Returns the <I>-th sub-expression of <me>. <br>
//!          Raises OutOfRange if <I> > NbSubExpressions(me) <br>
Standard_EXPORT  const Handle_Expr_GeneralExpression& SubExpression(const Standard_Integer I) const;

//! Does <me> contains NamedUnknown ? <br>
Standard_EXPORT   Standard_Boolean ContainsUnknowns() const;

//! Tests if <exp> is contained in <me>. <br>
Standard_EXPORT   Standard_Boolean Contains(const Handle(Expr_GeneralExpression)& exp) const;

//! Replaces all occurences of <var> with <with> in <me> <br>
//!          Raises InvalidOperand if <with> contains <me>. <br>
Standard_EXPORT   void Replace(const Handle(Expr_NamedUnknown)& var,const Handle(Expr_GeneralExpression)& with) ;

//! Returns a GeneralExpression after replacement of <br>
//!          NamedUnknowns by an associated expression, and after <br>
//!          values computation. <br>
Standard_EXPORT   Handle_Expr_GeneralExpression Simplified() const;
//Standard_EXPORT ~Expr_UnaryExpression();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Sets the operand used during creation <br>
Standard_EXPORT   void CreateOperand(const Handle(Expr_GeneralExpression)& exp) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Expr_GeneralExpression myOperand;


};


#include <Expr_UnaryExpression.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
