// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _FairCurve_Newton_HeaderFile
#define _FairCurve_Newton_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _math_NewtonMinimum_HeaderFile
#include <math_NewtonMinimum.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class math_MultipleVarFunctionWithHessian;
class math_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Algorithme of Optimization used to make "FairCurve" <br>
class FairCurve_Newton  : public math_NewtonMinimum {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! -- Given the  starting   point  StartingPoint, <br>
//!            The tolerance  required on  the  solution is given  by <br>
//!            Tolerance. <br>
//!             Iteration are  stopped if <br>
//!             (!WithSingularity)  and H(F(Xi)) is not definite <br>
//!             positive  (if the smaller eigenvalue of H < Convexity) <br>
//!             or IsConverged() returns True for 2 successives Iterations. <br>
//!  Warning: Obsolete Constructor (because IsConverged can not be redefined <br>
//!           with this. ) <br>
Standard_EXPORT FairCurve_Newton(math_MultipleVarFunctionWithHessian& F,const math_Vector& StartingPoint,const Standard_Real SpatialTolerance = 1.0e-7,const Standard_Real CriteriumTolerance = 1.0e-2,const Standard_Integer NbIterations = 40,const Standard_Real Convexity = 1.0e-6,const Standard_Boolean WithSingularity = Standard_True);


//!            The tolerance  required on  the  solution is given  by <br>
//!            Tolerance. <br>
//!             Iteration are  stopped if <br>
//!             (!WithSingularity)  and H(F(Xi)) is not definite <br>
//!             positive  (if the smaller eigenvalue of H < Convexity) <br>
//!            or IsConverged() returns True for 2 successives Iterations. <br>
//!  Warning: This constructor do not computation <br>
Standard_EXPORT FairCurve_Newton(math_MultipleVarFunctionWithHessian& F,const Standard_Real SpatialTolerance = 1.0e-7,const Standard_Real Tolerance = 1.0e-7,const Standard_Integer NbIterations = 40,const Standard_Real Convexity = 1.0e-6,const Standard_Boolean WithSingularity = Standard_True);

//!  This method is  called    at the end  of   each <br>
//!          iteration to  check the convergence : <br>
//!          || Xi+1 - Xi || < SpatialTolerance/100 Or <br>
//!          || Xi+1 - Xi || < SpatialTolerance and <br>
//!          |F(Xi+1) - F(Xi)| < CriteriumTolerance * |F(xi)| <br>
//!          It can be redefined in a sub-class to implement a specific test. <br>
Standard_EXPORT virtual  Standard_Boolean IsConverged() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real mySpTol;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
