// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GProp_VelGProps_HeaderFile
#define _GProp_VelGProps_HeaderFile

#ifndef _GProp_GProps_HeaderFile
#include <GProp_GProps.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class gp_Cylinder;
class gp_Pnt;
class gp_Cone;
class gp_Sphere;
class gp_Torus;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  Computes the global properties of a geometric solid <br>
//!  (3D closed region of space) <br>
//!  The solid can be elementary(definition in the gp package) <br>
class GProp_VelGProps  : public GProp_GProps {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT GProp_VelGProps();


Standard_EXPORT GProp_VelGProps(const gp_Cylinder& S,const Standard_Real Alpha1,const Standard_Real Alpha2,const Standard_Real Z1,const Standard_Real Z2,const gp_Pnt& VLocation);


Standard_EXPORT GProp_VelGProps(const gp_Cone& S,const Standard_Real Alpha1,const Standard_Real Alpha2,const Standard_Real Z1,const Standard_Real Z2,const gp_Pnt& VLocation);


Standard_EXPORT GProp_VelGProps(const gp_Sphere& S,const Standard_Real Teta1,const Standard_Real Teta2,const Standard_Real Alpha1,const Standard_Real Alpha2,const gp_Pnt& VLocation);


Standard_EXPORT GProp_VelGProps(const gp_Torus& S,const Standard_Real Teta1,const Standard_Real Teta2,const Standard_Real Alpha1,const Standard_Real Alpha2,const gp_Pnt& VLocation);


Standard_EXPORT   void SetLocation(const gp_Pnt& VLocation) ;


Standard_EXPORT   void Perform(const gp_Cylinder& S,const Standard_Real Alpha1,const Standard_Real Alpha2,const Standard_Real Z1,const Standard_Real Z2) ;


Standard_EXPORT   void Perform(const gp_Cone& S,const Standard_Real Alpha1,const Standard_Real Alpha2,const Standard_Real Z1,const Standard_Real Z2) ;


Standard_EXPORT   void Perform(const gp_Sphere& S,const Standard_Real Teta1,const Standard_Real Teta2,const Standard_Real Alpha1,const Standard_Real Alpha2) ;


Standard_EXPORT   void Perform(const gp_Torus& S,const Standard_Real Teta1,const Standard_Real Teta2,const Standard_Real Alpha1,const Standard_Real Alpha2) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
