// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom_Parabola_HeaderFile
#define _Geom_Parabola_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom_Parabola_HeaderFile
#include <Handle_Geom_Parabola.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Geom_Conic_HeaderFile
#include <Geom_Conic.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom_Geometry_HeaderFile
#include <Handle_Geom_Geometry.hxx>
#endif
class Standard_ConstructionError;
class Standard_RangeError;
class gp_Parab;
class gp_Ax2;
class gp_Ax1;
class gp_Pnt;
class gp_Vec;
class gp_Trsf;
class Geom_Geometry;


//! Describes a parabola in 3D space. <br>
//! A parabola is defined by its focal length (i.e. the <br>
//! distance between its focus and its apex) and is <br>
//! positioned in space with a coordinate system <br>
//! (gp_Ax2 object) where: <br>
//! - the origin is the apex of the parabola, <br>
//! - the "X Axis" defines the axis of symmetry; the <br>
//!   parabola is on the positive side of this axis, <br>
//! - the origin, "X Direction" and "Y Direction" define the <br>
//!   plane of the parabola. <br>
//!   This coordinate system is the local coordinate <br>
//! system of the parabola. <br>
//! The "main Direction" of this coordinate system is a <br>
//! vector normal to the plane of the parabola. The axis, <br>
//! of which the origin and unit vector are respectively the <br>
//! origin and "main Direction" of the local coordinate <br>
//! system, is termed the "Axis" or "main Axis" of the parabola. <br>
//! The "main Direction" of the local coordinate system <br>
//! gives an explicit orientation to the parabola, <br>
//! determining the direction in which the parameter <br>
//! increases along the parabola. <br>
//! The Geom_Parabola parabola is parameterized as follows: <br>
//! P(U) = O + U*U/(4.*F)*XDir + U*YDir <br>
//! where: <br>
//! - P is the point of parameter U, <br>
//! - O, XDir and YDir are respectively the origin, "X <br>
//!   Direction" and "Y Direction" of its local coordinate system, <br>
//! - F is the focal length of the parabola. <br>
//!  The parameter of the parabola is therefore its Y <br>
//! coordinate in the local coordinate system, with the "X <br>
//! Axis" of the local coordinate system defining the origin <br>
//! of the parameter. <br>
//! The parameter range is ] -infinite, +infinite [. <br>
class Geom_Parabola : public Geom_Conic {

public:
 // Methods PUBLIC
 // 

//! Creates a parabola from a non transient one. <br>
Standard_EXPORT Geom_Parabola(const gp_Parab& Prb);


//!  Creates a parabola with its local coordinate system "A2" <br>
//!  and it's focal length "Focal". <br>
//!  The XDirection of A2 defines the axis of symmetry of the <br>
//!  parabola. The YDirection of A2 is parallel to the directrix <br>
//!  of the parabola. The Location point of A2 is the vertex of <br>
//!  the parabola <br>//! Raised if Focal < 0.0 <br>
Standard_EXPORT Geom_Parabola(const gp_Ax2& A2,const Standard_Real Focal);


//!  D is the directrix of the parabola and F the focus point. <br>
//!  The symmetry axis (XAxis) of the parabola is normal to the <br>
//!  directrix and pass through the focus point F, but its <br>
//!  location point is the vertex of the parabola. <br>
//!  The YAxis of the parabola is parallel to D and its location <br>
//!  point is the vertex of the parabola. The normal to the plane <br>
//!  of the parabola is the cross product between the XAxis and the <br>
//!  YAxis. <br>
Standard_EXPORT Geom_Parabola(const gp_Ax1& D,const gp_Pnt& F);

//! Assigns the value Focal to the focal distance of this parabola. <br>
//! Exceptions Standard_ConstructionError if Focal is negative. <br>
Standard_EXPORT   void SetFocal(const Standard_Real Focal) ;

//! Converts the gp_Parab parabola Prb into this parabola. <br>
Standard_EXPORT   void SetParab(const gp_Parab& Prb) ;


//!  Returns the non transient parabola from gp with the same <br>
//!  geometric properties as <me>. <br>
Standard_EXPORT   gp_Parab Parab() const;

//! Computes the parameter on the reversed parabola, <br>
//! for the point of parameter U on this parabola. <br>
//! For a parabola, the returned value is: -U. <br>
Standard_EXPORT   Standard_Real ReversedParameter(const Standard_Real U) const;

//! Returns the value of the first or last parameter of this <br>
//! parabola. This is, respectively: <br>
//! - Standard_Real::RealFirst(), or <br>
//! - Standard_Real::RealLast(). <br>
Standard_EXPORT   Standard_Real FirstParameter() const;

//! Returns the value of the first or last parameter of this <br>
//! parabola. This is, respectively: <br>
//! - Standard_Real::RealFirst(), or <br>
//! - Standard_Real::RealLast(). <br>
Standard_EXPORT   Standard_Real LastParameter() const;

//! Returns False <br>
Standard_EXPORT   Standard_Boolean IsClosed() const;

//! Returns False <br>
Standard_EXPORT   Standard_Boolean IsPeriodic() const;

//! Computes the directrix of this parabola. <br>
//! This is a line normal to the axis of symmetry, in the <br>
//! plane of this parabola, located on the negative side <br>
//! of its axis of symmetry, at a distance from the apex <br>
//! equal to the focal length. <br>
//! The directrix is returned as an axis (gp_Ax1 object), <br>
//! where the origin is located on the "X Axis" of this parabola. <br>
Standard_EXPORT   gp_Ax1 Directrix() const;

//! Returns 1. (which is the eccentricity of any parabola). <br>
Standard_EXPORT   Standard_Real Eccentricity() const;

//! Computes the focus of this parabola. The focus is on the <br>
//! positive side of the "X Axis" of the local coordinate <br>
//! system of the parabola. <br>
Standard_EXPORT   gp_Pnt Focus() const;

//! Computes the focal distance of this parabola <br>
//!  The focal distance is the distance between the apex <br>
//! and the focus of the parabola. <br>
Standard_EXPORT   Standard_Real Focal() const;

//! Computes the parameter of this parabola which is the <br>
//! distance between its focus and its directrix. This <br>
//! distance is twice the focal length. <br>
//! If P is the parameter of the parabola, the equation of <br>
//! the parabola in its local coordinate system is: Y**2 = 2.*P*X. <br>
Standard_EXPORT   Standard_Real Parameter() const;

//! Returns in P the point of parameter U. <br>
//!  If U = 0 the returned point is the origin of the XAxis and <br>
//!  the YAxis of the parabola and it is the vertex of the parabola. <br>
//!  P = S + F * (U * U * XDir +  * U * YDir) <br>
//!  where S is the vertex of the parabola, XDir the XDirection and <br>
//!  YDir the YDirection of the parabola's local coordinate system. <br>
Standard_EXPORT   void D0(const Standard_Real U,gp_Pnt& P) const;


//!  Returns the point P of parameter U and the first derivative V1. <br>
Standard_EXPORT   void D1(const Standard_Real U,gp_Pnt& P,gp_Vec& V1) const;


//!  Returns the point P of parameter U, the first and second <br>
//!  derivatives V1 and V2. <br>
Standard_EXPORT   void D2(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2) const;


//!  Returns the point P of parameter U, the first second and third <br>
//!  derivatives V1 V2 and V3. <br>
Standard_EXPORT   void D3(const Standard_Real U,gp_Pnt& P,gp_Vec& V1,gp_Vec& V2,gp_Vec& V3) const;

//! For the point of parameter U of this parabola, <br>
//! computes the vector corresponding to the Nth derivative. <br>
//! Exceptions Standard_RangeError if N is less than 1. <br>
Standard_EXPORT   gp_Vec DN(const Standard_Real U,const Standard_Integer N) const;

//! Applies the transformation T to this parabola. <br>
Standard_EXPORT   void Transform(const gp_Trsf& T) ;

//! Returns the  parameter on the  transformed  curve for <br>
//!          the transform of the point of parameter U on <me>. <br>
//! <br>
//!          me->Transformed(T)->Value(me->TransformedParameter(U,T)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          me->Value(U).Transformed(T) <br>
//! <br>
//!          This methods returns <U> * T.ScaleFactor() <br>
Standard_EXPORT   Standard_Real TransformedParameter(const Standard_Real U,const gp_Trsf& T) const;

//! Returns a  coefficient to compute the parameter on <br>
//!          the transformed  curve  for  the transform  of the <br>
//!          point on <me>. <br>
//! <br>
//!          Transformed(T)->Value(U * ParametricTransformation(T)) <br>
//! <br>
//!          is the same point as <br>
//! <br>
//!          Value(U).Transformed(T) <br>
//! <br>
//!          This methods returns T.ScaleFactor() <br>
Standard_EXPORT   Standard_Real ParametricTransformation(const gp_Trsf& T) const;

//! Creates a new object which is a copy of this parabola. <br>
Standard_EXPORT   Handle_Geom_Geometry Copy() const;
//Standard_EXPORT ~Geom_Parabola();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real focalLength;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
