// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom_SweptSurface_HeaderFile
#define _Geom_SweptSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom_SweptSurface_HeaderFile
#include <Handle_Geom_SweptSurface.hxx>
#endif

#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _gp_Dir_HeaderFile
#include <gp_Dir.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Geom_Surface_HeaderFile
#include <Geom_Surface.hxx>
#endif
class Geom_Curve;
class gp_Dir;


//! Describes the common behavior for surfaces <br>
//! constructed by sweeping a curve with another curve. <br>
//! The Geom package provides two concrete derived <br>
//! surfaces: surface of revolution (a revolved surface), <br>
//! and surface of linear extrusion (an extruded surface). <br>
class Geom_SweptSurface : public Geom_Surface {

public:
 // Methods PUBLIC
 // 


//!  returns the continuity of the surface : <br>
//!  C0 : only geometric continuity, <br>
//!  C1 : continuity of the first derivative all along the surface, <br>
//!  C2 : continuity of the second derivative all along the surface, <br>
//!  C3 : continuity of the third derivative all along the surface, <br>
//!  G1 : tangency continuity all along the surface, <br>
//!  G2 : curvature continuity all along the surface, <br>
//!  CN : the order of continuity is infinite. <br>
Standard_EXPORT   GeomAbs_Shape Continuity() const;


//!  Returns the reference direction of the swept surface. <br>
//!  For a surface of revolution it is the direction of the <br>
//!  revolution axis, for a surface of linear extrusion it is <br>
//!  the direction of extrusion. <br>
Standard_EXPORT  const gp_Dir& Direction() const;


//!  Returns the referenced curve of the surface. <br>
//!  For a surface of revolution it is the revolution curve, <br>
//!  for a surface of linear extrusion it is the extruded curve. <br>
Standard_EXPORT   Handle_Geom_Curve BasisCurve() const;
//Standard_EXPORT ~Geom_SweptSurface();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Handle_Geom_Curve basisCurve;
gp_Dir direction;
GeomAbs_Shape smooth;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
