// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Hatch_Line_HeaderFile
#define _Hatch_Line_HeaderFile

#ifndef _gp_Lin2d_HeaderFile
#include <gp_Lin2d.hxx>
#endif
#ifndef _Hatch_LineForm_HeaderFile
#include <Hatch_LineForm.hxx>
#endif
#ifndef _Hatch_SequenceOfParameter_HeaderFile
#include <Hatch_SequenceOfParameter.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Hatch_Hatcher;
class gp_Lin2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Stores a Line in the Hatcher. Represented by : <br>
//! <br>
//!          * A Lin2d from gp, the geometry of the line. <br>
//! <br>
//!          * Bounding parameters for the line. <br>
//! <br>
//!          * A sorted List  of Parameters, the  intersections <br>
//!          on the line. <br>
class Hatch_Line  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Hatch_Line();


Standard_EXPORT Hatch_Line(const gp_Lin2d& L,const Hatch_LineForm T);

//! Insert a new intersection in the sorted list. <br>
Standard_EXPORT   void AddIntersection(const Standard_Real Par1,const Standard_Boolean Start,const Standard_Integer Index,const Standard_Real Par2,const Standard_Real theToler) ;


friend class Hatch_Hatcher;



protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Lin2d myLin;
Hatch_LineForm myForm;
Hatch_SequenceOfParameter myInters;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
