// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_SelectEntityNumber_HeaderFile
#define _IFSelect_SelectEntityNumber_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_SelectEntityNumber_HeaderFile
#include <Handle_IFSelect_SelectEntityNumber.hxx>
#endif

#ifndef _Handle_IFSelect_IntParam_HeaderFile
#include <Handle_IFSelect_IntParam.hxx>
#endif
#ifndef _IFSelect_SelectBase_HeaderFile
#include <IFSelect_SelectBase.hxx>
#endif
class IFSelect_IntParam;
class Interface_EntityIterator;
class Interface_Graph;
class TCollection_AsciiString;


//! A SelectEntityNumber gets in an InterfaceModel (through a <br>
//!           Graph), the Entity which has a specified Number (its rank of <br>
//!           adding into the Model) : there can be zero (if none) or one. <br>
//!           The Number is not directly defined as an Integer, but as a <br>
//!           Parameter, which can be externally controled <br>
class IFSelect_SelectEntityNumber : public IFSelect_SelectBase {

public:
 // Methods PUBLIC
 // 

//! Creates a SelectEntityNumber, initially with no specified Number <br>
Standard_EXPORT IFSelect_SelectEntityNumber();

//! Sets Entity Number to be taken (initially, none is set : 0) <br>
Standard_EXPORT   void SetNumber(const Handle(IFSelect_IntParam)& num) ;

//! Returns specified Number (as a Parameter) <br>
Standard_EXPORT   Handle_IFSelect_IntParam Number() const;

//! Returns the list of selected entities : the Entity having the <br>
//!           specified Number (this result assures naturally uniqueness) <br>
Standard_EXPORT   Interface_EntityIterator RootResult(const Interface_Graph& G) const;

//! Returns a text defining the criterium : "Entity Number ..." <br>
Standard_EXPORT   TCollection_AsciiString Label() const;
//Standard_EXPORT ~IFSelect_SelectEntityNumber();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IFSelect_IntParam thenum;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
