// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntSurf_InteriorPoint_HeaderFile
#define _IntSurf_InteriorPoint_HeaderFile

#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _gp_Vec2d_HeaderFile
#include <gp_Vec2d.hxx>
#endif
class gp_Pnt;
class gp_Vec;
class gp_Vec2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Definition of a point solution of the <br>
//!          intersection between an implicit an a <br>
//!          parametrised surface. These points are <br>
//!          passing points on the intersection lines, <br>
//!          or starting points for the closed lines <br>
//!          on the parametrised surface. <br>
class IntSurf_InteriorPoint  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT IntSurf_InteriorPoint();


Standard_EXPORT IntSurf_InteriorPoint(const gp_Pnt& P,const Standard_Real U,const Standard_Real V,const gp_Vec& Direc,const gp_Vec2d& Direc2d);


Standard_EXPORT   void SetValue(const gp_Pnt& P,const Standard_Real U,const Standard_Real V,const gp_Vec& Direc,const gp_Vec2d& Direc2d) ;
//! Returns the 3d coordinates of the interior point. <br>
 const gp_Pnt& Value() const;
//! Returns the parameters of the interior point on the <br>
//!          parametric surface. <br>
  void Parameters(Standard_Real& U,Standard_Real& V) const;
//! Returns the first parameter of the interior point on the <br>
//!          parametric surface. <br>
  Standard_Real UParameter() const;
//! Returns the second parameter of the interior point on the <br>
//!          parametric surface. <br>
  Standard_Real VParameter() const;
//! Returns the tangent at the intersection in 3d space <br>
//!          associated to the interior point. <br>
 const gp_Vec& Direction() const;
//! Returns the tangent at the intersection in the parametric <br>
//!          space of the parametric surface. <br>
 const gp_Vec2d& Direction2d() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Pnt point;
Standard_Real paramu;
Standard_Real paramv;
gp_Vec direc;
gp_Vec2d direc2d;


};


#include <IntSurf_InteriorPoint.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
