// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MMgt_StackManager_HeaderFile
#define _MMgt_StackManager_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_OutOfMemory;
class Standard_ProgramError;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!   The class <StackManager> provides primitive facilities for managing <br>
//!   stack-based storage. <br>
//! <br>
class MMgt_StackManager  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!   Constructs a StackManager with an empty free stack. <br>
Standard_EXPORT MMgt_StackManager();


//!   Returns the address of a storage of the given size located on <br>
//!   the top of the free stack. <br>
Standard_EXPORT   Standard_Address Allocate(const Standard_Integer size) ;


//!   Deallocates the storage of the given size from the free stack <br>
//!   and nullify the address. <br>
Standard_EXPORT   void Free(Standard_Address& aStack,const Standard_Integer aSize) ;


//!   There is no way to have a "ShallowCopy" of a "StackManager" <br>
Standard_EXPORT   MMgt_StackManager ShallowCopy() const;


//!   Prints the contents of <me> on the stream <s>. <br>
Standard_EXPORT   void ShallowDump(Standard_OStream& S) const;


//!    Deallocates the storage associated to stack. <br>
//!    Delete <me>. <br>
Standard_EXPORT   void Destructor() ;
~MMgt_StackManager()
{
  Destructor();
}






protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


//!   Deallocates the storage associated to stack. <br>
Standard_EXPORT   void Purge() ;


 // Fields PRIVATE
 //
Standard_Integer myFreeListSize;
Standard_Address myFreeList;


};





// other Inline functions and methods (like "C++: function call" methods)
//
inline MMgt_StackManager ShallowCopy(const MMgt_StackManager& me) {
 return me.ShallowCopy();
}

inline void ShallowDump(const MMgt_StackManager& me,Standard_OStream& S) {
 me.ShallowDump(S);
}



#endif
