// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _SelectBasics_SortAlgo_HeaderFile
#define _SelectBasics_SortAlgo_HeaderFile

#ifndef _Bnd_Box2d_HeaderFile
#include <Bnd_Box2d.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Bnd_BoundSortBox2d_HeaderFile
#include <Bnd_BoundSortBox2d.hxx>
#endif
#ifndef _TColStd_MapOfInteger_HeaderFile
#include <TColStd_MapOfInteger.hxx>
#endif
#ifndef _TColStd_MapIteratorOfMapOfInteger_HeaderFile
#include <TColStd_MapIteratorOfMapOfInteger.hxx>
#endif
#ifndef _Handle_Bnd_HArray1OfBox2d_HeaderFile
#include <Handle_Bnd_HArray1OfBox2d.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Bnd_Box2d;
class Bnd_HArray1OfBox2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Quickly selection of a rectangle in a set of rectangles <br>
class SelectBasics_SortAlgo  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty rectangle selector. <br>
Standard_EXPORT SelectBasics_SortAlgo();

//! Creates a initialized selector. <br>
Standard_EXPORT SelectBasics_SortAlgo(const Bnd_Box2d& ClippingRectangle,const Standard_Real sizeOfSensitiveArea,const Handle(Bnd_HArray1OfBox2d)& theRectangles);

//! Clears and initializes the selector. <br>
Standard_EXPORT   void Initialize(const Bnd_Box2d& ClippingRectangle,const Standard_Real sizeOfSensitiveArea,const Handle(Bnd_HArray1OfBox2d)& theRectangles) ;

//! Searchs the items on this position. <br>
Standard_EXPORT   void InitSelect(const Standard_Real x,const Standard_Real y) ;

//! Searchs the items in this rectangle. <br>
Standard_EXPORT   void InitSelect(const Bnd_Box2d& rect) ;

//! Returns true if there is something selected. <br>
Standard_EXPORT   Standard_Boolean More() const;

//! Sets value on the next selected item. <br>
Standard_EXPORT   void Next() ;

//! Returns the index of the selected rectangle. <br>
Standard_EXPORT   Standard_Integer Value() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Bnd_Box2d clipRect;
Standard_Real sizeArea;
Bnd_BoundSortBox2d sortedRect;
TColStd_MapOfInteger myMap;
TColStd_MapIteratorOfMapOfInteger curResult;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
